#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        trackermngr.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/03/03
# RCS-ID:      $Id: trackermngr.py,v 1.1 2005/06/09 16:37:53 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     MIT
#-----------------------------------------------------------------------------
import wx
from urlparse import urlparse
from BitTorrent.bencode import bdecode
from g3listctrl import G3ListCtrl
from wx.lib.mixins.listctrl import ColumnSorterMixin, ListCtrlAutoWidthMixin
from traceback import print_exc
from images import Images


class TrackerListCtrl(G3ListCtrl, ListCtrlAutoWidthMixin):
    def __init__(self, parent, btconfig, images):
        G3ListCtrl.__init__(self, parent, btconfig, "TrackerMngr")
        ListCtrlAutoWidthMixin.__init__(self)
        
        cols = [ [True, _("Tracker URL"), wx.LIST_FORMAT_LEFT, 300],
                ]
        self.InsertColumns(cols)
    
class TrackerDlg(wx.Frame):
    def __init__(self, parent, id, btconfig, images, seturllistfunc, pollfunc):
        wx.Frame.__init__(self, parent, -1, 'Tracker Manager', size=(450,350))
        self.id = id
        self.btconfig = btconfig
        self.images = images
        self.SetUrlListCmd = seturllistfunc
        self.PollTrackerCmd = pollfunc
        self.itemDataMap = {}
        
        panel = wx.Panel(self, -1)
        
        self.edit1 = wx.TextCtrl(panel, -1)
        addbut = wx.Button(panel, -1, _("Add"), size=(60,-1))
        rembut = wx.Button(panel, -1, _("Remove"), size=(60,-1))
        okbut = wx.Button(panel, -1, _("Ok"), size=(60,-1))
        canbut = wx.Button(panel, -1, _("Cancel"), size=(60,-1))

        wx.EVT_BUTTON(self, okbut.GetId(), self.Ok)
        wx.EVT_BUTTON(self, canbut.GetId(), self.Close)
        wx.EVT_BUTTON(self, addbut.GetId(), self.OnAddItem)
        wx.EVT_BUTTON(self, rembut.GetId(), self.OnRemoveItem)
                
        self.list = TrackerListCtrl(panel, btconfig, images)
       
        boxer = wx.BoxSizer(wx.VERTICAL)
        tall = wx.FlexGridSizer(cols = 1)
        
        editsizer = wx.FlexGridSizer(cols = 5)
        editsizer.Add(self.edit1 , 1, wx.EXPAND)
        editsizer.Add(addbut, 1, wx.EXPAND)
        editsizer.Add(rembut, 1, wx.EXPAND)
        editsizer.Add(okbut, 1, wx.EXPAND)
        editsizer.Add(canbut, 1, wx.EXPAND)
        editsizer.AddGrowableCol(0)
        
        
        tall.Add(editsizer, 1, wx.EXPAND)
        tall.Add(self.list, 1, wx.EXPAND)
        tall.AddGrowableRow(1)
        tall.AddGrowableCol(0)
        
        boxer.Add(tall, 1, wx.EXPAND | wx.ALL, 2) 
        
        panel.SetSizer(boxer)
        panel.Layout()
        self.SetIcon(images.GetImage('rufus.ico'))               

        wx.EVT_CLOSE(self, self.Close)
        wx.EVT_LIST_ITEM_SELECTED(self.list, -1, self.OnFocusChange)
        wx.EVT_COMMAND_RIGHT_CLICK(self, -1, self.OnRightClick) # wxMSW
        wx.EVT_RIGHT_UP(self, self.OnRightClick) # wxGTK     
        self.Show(True)
    
    def OnRightClick(self, event):
        if not hasattr(self, "popupID1"):   
            self.popupID1 = wx.NewId()
            wx.EVT_MENU(self, self.popupID1, self.OnPollTracker)

        menu = wx.Menu()
        menu.Append(self.popupID1, _("Poll this tracker"), _("Manual polling of this tracker"), True)

        self.PopupMenu(menu, self.ScreenToClient(wx.GetMousePosition()))
        menu.Destroy()
        
        
    def OnPollTracker(self, event):
        selected = self.list.GetFirstSelected()
        url = self.itemDataMap[ self.list.GetItemData(selected) ][0]
        print url
        self.PollTrackerCmd(self.id, url)
    
    def OnRemoveItem(self, event):
        selected = self.list.GetFirstSelected()
        key = self.list.GetItemData(selected)
        
        if self.itemDataMap.has_key(key):
            self.list.DeleteItem(selected)
            del self.itemDataMap[ key ]
            self.list.Refresh(True)
            self.list.Update()

    def OnAddItem(self, event):
        url = self.edit1.GetValue()
        key = hash(url)
        item_idx = self.list.InsertRow(key, [url])
        self.itemDataMap[key] = [url]

    def OnFocusChange(self, event):
        url = self.itemDataMap[ self.list.GetItemData(event.m_itemIndex) ][0]
        self.edit1.SetValue(url)

    def Populate(self, list = []):
        self.itemDataMap = {}
        for url in list:
            key = hash(url)
            item_idx = self.list.InsertRow(key, [url])
            self.itemDataMap[key] = [url]
        
    def Ok(self, event):
        list = []
        for key, item in self.itemDataMap.items():
            print item
            list.append(item[0])
        if self.SetUrlListCmd and len(list) > 0:
            self.SetUrlListCmd(list)
        self.Close()
        
    def Close(self, event=None):
        self.Destroy()
        
        
if __name__ == "__main__":
    _ = lambda x: x # needed for gettext
    urllist = ["httpasdfasdfasdf", "asdfasdfaf2323", "asdfaf2"]
    app = wx.PySimpleApp()
    mngr = TrackerDlg(None, 0, None, None, None, lambda x: x)
    app.SetTopWindow(mngr)
    mngr.Populate(urllist)
    mngr.Show()
    app.MainLoop()
