#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        statuspanel.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/01/02
# RCS-ID:      $Id: statuspanel.py,v 1.2 2005/08/27 16:05:30 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     MIT
#-----------------------------------------------------------------------------

import wx
from peerlist import PeerList
from p2pgauge import *

class StatusPanel(wx.Panel):
    #I2P: removed "dnsfunc", because we don't support Reverse-Dns anymore
    def __init__(self, parent, btconfig, images, friendfunc, colclickfunc):
        wx.Panel.__init__(self, parent, -1, size=(100,100))

        self.btconfig = btconfig

        sizer = wx.BoxSizer(wx.VERTICAL)
        colsizer = wx.FlexGridSizer(cols = 1, hgap = 2, vgap = 2)

        # Add p2p gauge
        self.pppgauge = P2P_Gauge(self, self.btconfig, (-1, 27))
        self.pppgauge.SetValueUnknown()
        colsizer.Add(self.pppgauge, 1, wx.EXPAND)
        
        # Add peer list ctl
        #I2P: removed "dnsfunc"
        self.peerlist = PeerList(self, btconfig, bmps=images, friendfunc=friendfunc, colclickfunc=colclickfunc)
        #/I2P
        colsizer.Add(self.peerlist, 1, wx.EXPAND)
        
        colsizer.AddGrowableCol(0)
        colsizer.AddGrowableRow(1)
        colsizer.AddGrowableCol(1)
        
        sizer.Add(colsizer, 1, wx.EXPAND | wx.ALL, 0)
        
        self.SetSizer(sizer)
        self.Layout()

