#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        scrape.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/03/03
# RCS-ID:      $Id: scrape.py,v 1.3 2005/09/16 07:41:31 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     MIT
#-----------------------------------------------------------------------------
import wx
import httplib
import socket
from threading import Thread
#I2P: don't import urlopen
from BitTorrent.zurllib import URLError, Request
#/I2P
from os.path import split, join
from urlparse import urlparse
from BitTorrent.bencode import bdecode
from g3listctrl import G3ListCtrl
from wx.lib.mixins.listctrl import ColumnSorterMixin, ListCtrlAutoWidthMixin
from traceback import print_exc
#I2P
from BitTorrent.eep import urlopen
import time
#/I2P
import gzip
from cStringIO import StringIO


class ScrapeListCtrl(G3ListCtrl, ListCtrlAutoWidthMixin):
    def __init__(self, parent, btconfig, images):
        G3ListCtrl.__init__(self, parent, btconfig, "ScrapeList")
        ListCtrlAutoWidthMixin.__init__(self)
        
        cols = [ [True, "Filename", wx.LIST_FORMAT_LEFT, 160],
                 [True, "Seeds", wx.LIST_FORMAT_RIGHT, 60],
                 [True, "Peers", wx.LIST_FORMAT_RIGHT, 60],
                 [True, "Downloads", wx.LIST_FORMAT_LEFT, wx.LIST_AUTOSIZE_USEHEADER],
                ]
        self.InsertColumns(cols)
    
    def Populate(self, data):
        pass
    
class ScrapeDlg(wx.Frame):
    def __init__(self, parent, btconfig, images, id=-1, invokefunc=None):
        wx.Frame.__init__(self, parent, -1, 'Scrape', size=(400,300))
        self.btconfig = btconfig
        self.images = images
        self.InvokeLater = invokefunc
        
        okbut_id = wx.NewId()
        
        panel = wx.Panel(self, -1)
        self.list = ScrapeListCtrl(panel, btconfig, images)
        self.edit1 = wx.TextCtrl(panel, -1, "")
        okbut = wx.Button(panel, okbut_id, "OK")

        
        colsizer = wx.FlexGridSizer(2, 1, 0, 0)
        colsizer.AddGrowableRow(0)
        colsizer.AddGrowableCol(0)

        buttsizer = wx.FlexGridSizer(1, 2, 0, 0)
        buttsizer.AddGrowableCol(0)

        buttsizer.Add(self.edit1, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
        buttsizer.Add(okbut, 0, wx.FIXED_MINSIZE, 0)

        colsizer.Add(self.list, 1, wx.EXPAND, 0)
        colsizer.Add(buttsizer, 1, wx.EXPAND, 0)
        panel.SetAutoLayout(True)
        panel.SetSizer(colsizer)

        wx.EVT_BUTTON(self, okbut_id , self.Scrape)                
        wx.EVT_CLOSE(self, self.Close)
        self.Show(True)

    #I2P: added "proxy"
    def Scrape(self, url, proxy):
        url = self.edit1.GetValue()
        #I2P: added "proxy"
        t = T_Scrape(self.PostScrape, "", url, proxy)
        t.start()

    def PostScrape(self, params, data):
        files = data[1]
        if files == None:
            return
        
        i=0
        for hash, data in files.items():
            if data.get('name') == None: 
                name = "No name field"
            else:
                name = "%s" % data.get('name')
            downloaded = "%d" % data.get('downloaded')
            complete = "%d" % data.get('complete')
            incomplete = "%d" % data.get('incomplete')
            
            self.list.InsertRow(i, [name,complete,incomplete,downloaded] ) 
            i += 1
        
    def Close(self, event=None):
        self.Destroy()



class T_Scrape(Thread):

    #I2P: added "proxy"
    def __init__(self, invokelater, callback, url_liste, proxy, doneflag, infohash=None):

        Thread.__init__(self)
        self.infohash = infohash

        self.success = False

        self.Callback = callback
        self.InvokeLater = invokelater
        self.url_liste = url_liste
        #I2P
        self.proxy = proxy
        self.doneflag = doneflag
        #/I2P
     
        
    def run(self):
        url_count = 0
        time_count = 1200
        set_time = 1200
        all_failed = False
        while not self.doneflag.isSet():
            if time_count < set_time:
                #Rawn: really ugly, but how the heck should I else get the threads fast killed, if the programm exits?
                time_count += 1
                time.sleep(1)
            else:
                time_count = 0
                #I2PDebug
                #print 'URL "'+self.url_liste[count][0:10]+'"'
                #print 'PROXY "'+self.proxy+'2'
                try:
                    h = urlopen(self.url_liste[url_count], self.proxy)
                    self.success = True
                except (IOError, URLError, socket.error, httplib.HTTPException), e:
                    #print "ERROR: urlopen(%s) failed" % self.url_liste[url_count]
                    #print str(e)
                    pass

                data = None
                if self.success == True:
                    r = h.read()

                    try:
                        #Rawn: Workaround for the Azureus Tracker. Should get unnecessary with I2P 0.6.1.6
                        #      Basically the Azureus Tracker sends back a gziped response, which gets decoded here
                        s_file = StringIO(r)
                        decod = gzip.GzipFile(fileobj = s_file)
                        r = decod.read()
                    except:
                        pass
                
                    try:
                        data = bdecode( r )
                        data = data['files']
                        if self.infohash:
                            data = data[self.infohash]
                    except:
                        self.success = False

                if self.success == True:
                    url_count = 0
                    all_failed = False
                    set_time = 1200
                else:
                    url_count = url_count + 1
                    set_time = 240
                    if url_count>=len(self.url_liste):
                        url_count = 0
                        all_failed = True
                    
                try:
                    self.InvokeLater(self.Callback, (self.success, data, False, all_failed))
                except wx.PyDeadObjectError:
                    #return False
                    pass
        #return True


def dummy_callback(params1, params2):
    print params1, params2
    
    data = params2[2]

if __name__ == "__main__":
##    t = T_Scrape(dummy_callback, "", "http://tracker4.slash0.org:6969/scrape")
##    t.start()
    
    app = wx.PySimpleApp()
    frame = ScrapeDlg(None, None, None, None)
    app.SetTopWindow(frame)
    frame.Show()
    app.MainLoop()
        
