#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        peerlistdns.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/11/02
# RCS-ID:      $Id: peerlistdns.py,v 1.3 2005/09/11 19:08:59 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE.TXT
#-----------------------------------------------------------------------------
from threading import Timer, Lock
from socket import gethostbyaddr, error
from traceback import print_exc
from time import time

class PeerListDNS:
    def __init__(self, doneflag):
        self.doneflag = doneflag
        self.counter = 0
        self.address_db = {}
        self.lock = Lock()
      
    def GetAddress(self, ip):
        address = None
        if self.lock.acquire(False):
            if self.address_db.has_key(ip):
                self.address_db[ip][1] = time()
                address = self.address_db[ip][0]
            else:
                self.address_db[ip] = [None, time()]
                
            self.lock.release()
            
        if address:
            return address
        else:
            return ip

    def Stop(self):
        print 'stopping'
        self.timer.cancel()
    
    def Start(self):
        self.timer = Timer(5, self.OnTimer)
        self.timer.start()
        
    def OnTimer(self):
        if self.doneflag.isSet():
            print "TIMER: dns timer ending s0"
            return False
        
        self.counter += 1    
        ip_list = []
        
        self.lock.acquire(True)
        # every 15 mins, purge items from address db that have not been accessed for 60mins
        if not (self.counter % 180):
            for ip, [address, set_time] in self.address_db.items():
                if (set_time + (60*60)) < time():
                    self.address_db.pop(ip)
        
        # collect list of unresolved ips
        for key, value in self.address_db.items():
            if value[0] == None: 
                ip_list.append(key)
        self.lock.release()
        
        for ip in ip_list:
            if self.doneflag.isSet():
                break
            address = self.get_address(ip)
            
            self.lock.acquire(True)
            self.address_db[ip] = [address, time()]
            self.lock.release()       
                    
        if self.doneflag.isSet():
            print "TIMER: dns timer ending s1"
            return False

        self.Start()
            

    def get_address(self, ip):
#I2P: We don't want to try to reserve DNS destinations...
#        try:
#            return gethostbyaddr(ip)[0]
#        except error:
#            return ip
#/I2P
#I2P: simply always return the ip again
        return ip
#/I2P
