#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        optiondlg.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/30/01
# RCS-ID:      $Id: optiondlg.py,v 1.10 2005/09/16 14:50:26 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE.TXT
#-----------------------------------------------------------------------------

import wx

from wx.lib.masked import IpAddrCtrl, TextCtrl
from wx.lib.masked import NumCtrl

from traceback import print_exc
from images import Images
from btconfig import BTConfig
from os.path import join
from time import strftime, gmtime
from BitTorrent import version
from threading import Thread
from g3widgets import BMSpinCtrl
import sys
import socket
import random
from md5 import md5

if sys.platform == "win32":   
    win32_flag = True
else:
    win32_flag = False

if win32_flag:
    from _winreg import *
    from webbrowser import open_new
else:
    from leoxv import open_new

Widget_H = 20

class About_Box(wx.Frame):
    def __init__(self, parent, btconfig, images, pos = (-1,-1)):
#I2P: Changed the y-size of about
        wx.Frame.__init__(self, parent, -1, _("About"), pos, size = (350,370))
#/I2P
        panel = wx.Panel(self, -1)
        
        self.btconfig = btconfig        

#I2P: Changed "Rufus" to "I2PRufus" and added the ported comment
        about_text1 = wx.StaticText(panel, -1,
                                  ("I2PRufus version: %s " % version)
                                    + "\nPorted by:"
                                    + "\n\tdefnax"
                                    + "\n\tRawn"
                                    + "\n\t"
                                    + "\nfrom Rufus 0.6.5 by:"
                                    + "\n\td0c 54v4g3"
                                    + "\n\tbwobones"
                                    + "\n\tleoXV"
                                    + "\n\tWillaken\n")
#I2P: Theres no Homepage for I2PRufus, so this should be removed                            
#        about_text2 = wx.StaticText(panel, -1, _("Home Page: "))
#        url_text = wx.StaticText(panel, -1, "http://forum.i2p")
#        url_text.SetForegroundColour('Blue')
#/I2P
#I2P: Some minor changes to clarify, that these guys shouldn't be asked about I2PRufus   
        about_text3 = wx.StaticText(panel, -1,  
                                  "Based on g3torrent written by Jeremy Arendt"
                                + "\n\nLinux version of Rufus by Jukka Lehtomaki"
                                + "\nContact: jukka.lehtomaki@gmail.com"                              
                                + "\n\nBitTorrent was written by Bram Cohen "
                                + "\nand Myers Carpenter"
                                + "\n\nBitTorrent is a trademark of Bram Cohen\n")
#/I2P
                                
        about_text4 = wx.StaticText(panel, -1, "Python %s\nwxWidgets %s" %
                                (sys.version.split('(')[0], wx.VERSION_STRING))
        
        logo = wx.StaticBitmap(panel, -1, images.GetImage('rufus.bmp'))
        
        okbut = wx.Button(panel, -1, 
                random.choice([_("Marvelous!"), _("OK!"), _("Werd!"), _("Yay!"), _("Booya!"), _("Niice!")]))
        
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
#I2P: double is not needed anymore without a link
#        double = wx.FlexGridSizer(cols = 2)
#/I2P
        boxer = wx.FlexGridSizer(cols = 2)

#I2P: about_text2 was removed      
#       double.Add(about_text2)
#       double.Add(url_text)
#       tall.Add((-1,10)) # spacer
#/I2P
        tall.Add(about_text1)
#I2P: double is not needed anymore without a link
#        tall.Add(double)
#/I2P
        tall.Add(about_text3)
        tall.Add(about_text4)
        
        tall.Add(okbut, 1, wx.ALIGN_RIGHT)
        tall.AddGrowableCol(0)
        boxer.AddGrowableCol(1)
        
        boxer.Add(logo, 1, wx.ALL, 4)
        boxer.Add(tall, 1, wx.EXPAND | wx.ALL, 4)
        panel.SetSizer(boxer)
        panel.Layout()
#I2P: the link was removed
#        wx.EVT_LEFT_DOWN(url_text, self.OnUrlClick)
#/I2P
        wx.EVT_CLOSE(self, self.Close)
        wx.EVT_BUTTON(self, okbut.GetId(), self.Close)
        wx.EVT_KEY_DOWN(okbut, self.Close)
        
        self.SetIcon( images.GetImage('rufus.ico') )
        self.Show(True)

    def _OpenUrl(self):
        open_new('http://forum.i2p')
            
    def OnUrlClick(self, event):
        Thread(target = self._OpenUrl).start()
    
    def Close(self, event):
        self.Destroy()

#-----------------------------------------------------------------------------

class Options_Fold_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("Folder Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        doublewide = wx.FlexGridSizer(cols = 3, vgap = 2, hgap = 4)
        
        self.chk_id1 = wx.NewId()
        self.chk_id2 = wx.NewId()
        self.chk_id3 = wx.NewId()
        self.chk_id4 = wx.NewId()
        self.chk_id5 = wx.NewId()
        
        label1 = wx.StaticText(self, -1, _("Incoming downloads go here:"))
        self.check1 = wx.CheckBox(self, self.chk_id1, "", wx.Point(0, 0), wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.edit1 = wx.TextCtrl(self, -1, "", size=(-1, Widget_H))
        self.button1 = wx.Button(self, 100, "...", size=(25,Widget_H))
        self.edit1.SetValue(btconfig.Get('download_dir').decode('utf-8'))
        
        label2 = wx.StaticText(self, -1, _(".torrent metafiles get stored here:"))
        self.check2 = wx.CheckBox(self, self.chk_id2, "", wx.Point(0, 0), wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.edit2 = wx.TextCtrl(self, -1, "", size=(-1, Widget_H))
        self.button2 = wx.Button(self, 101, "...", size=(25,Widget_H))
        self.edit2.SetValue(btconfig.Get('torrent_dir').decode('utf-8'))
        
        label3 = wx.StaticText(self, -1, _("Move completed downloads here:"))
        self.check3 = wx.CheckBox(self, self.chk_id3, "", wx.Point(0, 0), wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.edit3 = wx.TextCtrl(self, -1, "", size=(-1, Widget_H))
        self.button3 = wx.Button(self, 102, "...", size=(25,Widget_H))
        self.edit3.SetValue(btconfig.Get('completed_dl_dir').decode('utf-8'))

        label4 = wx.StaticText(self, -1, _("Move completed .torrent folder here:"))
        self.check4 = wx.CheckBox(self, self.chk_id4, "", wx.Point(0, 0), wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.edit4 = wx.TextCtrl(self, -1, "", size=(-1, Widget_H))
        self.button4 = wx.Button(self, 103, "...", size=(25,Widget_H))
        self.edit4.SetValue(btconfig.Get('completed_tor_dir').decode('utf-8'))
        
        self.check5 = wx.CheckBox(self, self.chk_id5, _("Scan and load unloaded .torrents every"), wx.Point(0, 0), wx.Size(-1, Widget_H), wx.NO_BORDER)
        label5 = wx.StaticText(self, -1, _("mins"))
        self.spin1 = wx.SpinCtrl(self, -1, "", size=(50,Widget_H))
        self.spin1.SetValue(btconfig.Get('tdir_scan')/60)
        self.spin1.SetRange(0,100)
        
        scanizer = wx.FlexGridSizer(cols=3, hgap=2)
        scanizer.Add(self.check5)
        scanizer.Add(self.spin1)
        scanizer.Add(label5, 1, wx.NORTH, 4)
        
        if btconfig.Get('tdir_scan') > 0:
            self.check5.SetValue(True)
        
        if btconfig.Get('use_download_dir'):
            self.check1.SetValue(True)
            if btconfig.Get('download_dir') == btconfig.Get('completed_dl_dir'):
                self.check3.SetValue(False)
            else:
                self.check3.SetValue(True)
        else:
            self.check1.SetValue(False)
            self.check3.SetValue(False)
            
        if btconfig.Get('use_torrent_dir'):
            self.check2.SetValue(True)
            if btconfig.Get('torrent_dir') == btconfig.Get('completed_tor_dir'):
                self.check4.SetValue(False)
            else:
                self.check4.SetValue(True)
        else:
            self.check2.SetValue(False)
            self.check4.SetValue(False)
        
        wx.EVT_CHECKBOX(self, self.chk_id1, self.OnCheck) 
        wx.EVT_CHECKBOX(self, self.chk_id2, self.OnCheck) 
        wx.EVT_CHECKBOX(self, self.chk_id3, self.OnCheck) 
        wx.EVT_CHECKBOX(self, self.chk_id4, self.OnCheck)
        wx.EVT_CHECKBOX(self, self.chk_id5, self.OnCheck)
        
        # if seperate tooltip objs are not created, wxwindows will crash!
        tt = wx.ToolTip(_("Files will download into this folder"))
        self.edit1.SetToolTip(tt)
        tt = wx.ToolTip(_("Files will download into this folder"))
        self.check1.SetToolTip(tt)
        tt = wx.ToolTip(_("*.torrent metafiles will be copied to this folder"))
        self.edit2.SetToolTip(tt)
        tt = wx.ToolTip(_("*.torrent metafiles will be copied to this folder"))
        self.check2.SetToolTip(tt)
        tt = wx.ToolTip(_("When a download completes, the file will be moved here"))
        self.edit3.SetToolTip(tt)
        tt = wx.ToolTip(_("When a download completes, the file will be moved here"))
        self.check3.SetToolTip(tt)
        tt = wx.ToolTip(_("When a download completes, the *.torrent metafile will be moved here"))
        self.edit4.SetToolTip(tt)
        tt = wx.ToolTip(_("When a download completes, the *.torrent metafile will be moved here"))
        self.check4.SetToolTip(tt)
        tt = wx.ToolTip(_("Requires that the torrents and incoming folders be enabled"))
        self.check5.SetToolTip(tt)
        
        wx.EVT_BUTTON(self, 100, self.OnButton)
        wx.EVT_BUTTON(self, 101, self.OnButton)
        wx.EVT_BUTTON(self, 102, self.OnButton)
        wx.EVT_BUTTON(self, 103, self.OnButton)

        doublewide.AddGrowableCol(1)
        
        doublewide.Add( (-1,-1) )
        doublewide.Add(label1, 1, wx.EXPAND)
        doublewide.Add( (-1,-1) )
        doublewide.Add(self.check1, 1, wx.EXPAND)
        doublewide.Add(self.edit1, 1, wx.EXPAND)
        doublewide.Add(self.button1, 1, wx.EXPAND)
        
        doublewide.Add( (-1,-1) )
        doublewide.Add(label2, 1, wx.EXPAND)
        doublewide.Add( (-1,-1) )
        doublewide.Add(self.check2, 1, wx.EXPAND)
        doublewide.Add(self.edit2, 1, wx.EXPAND)
        doublewide.Add(self.button2, 1, wx.EXPAND)
        
        doublewide.Add( (-1,-1) )
        doublewide.Add(label3, 1, wx.EXPAND)
        doublewide.Add( (-1,-1) )
        doublewide.Add(self.check3, 1, wx.EXPAND)
        doublewide.Add(self.edit3, 1, wx.EXPAND)
        doublewide.Add(self.button3, 1, wx.EXPAND)

        doublewide.Add( (-1,-1) )
        doublewide.Add(label4, 1, wx.EXPAND)
        doublewide.Add( (-1,-1) )
        doublewide.Add(self.check4, 1, wx.EXPAND)
        doublewide.Add(self.edit4, 1, wx.EXPAND)
        doublewide.Add(self.button4, 1, wx.EXPAND)
        
        notebox1 = wx.StaticBox(self, -1, _("Note"))
        noteboxer1 = wx.StaticBoxSizer(notebox1, wx.VERTICAL)
        self.notelabel = wx.StaticText(self, -1, _("Leave these checkboxes are unchecked if you rather \n")
                                               + _("be queried for the location at runtime.")
                                               + _("\n\nChanges to paths will not affect any \n")
                                               + _("existing downloads still in progress."))
        noteboxer1.Add(self.notelabel, 1, wx.EXPAND)

        tall.Add((-1,10)) # spacer
        tall.Add(doublewide, 1, wx.EXPAND)
        tall.Add((-1,10)) # spacer
        tall.Add(scanizer, 1, wx.EXPAND)
        tall.Add(noteboxer1, 1, wx.EXPAND)
        
        tall.AddGrowableRow(4)
        tall.AddGrowableCol(0)
        boxer.Add(tall, 1, flag = wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()
        
        self.OnCheck(self.check1)
        self.OnCheck(self.check2)
        self.OnCheck(self.check3)
        self.OnCheck(self.check4)
        self.OnCheck(self.check5)
        

    def OnCheck(self, event):
        id = event.GetId()
        cbox = event
        
        if id == self.chk_id1:
            self.edit1.Enable( cbox.IsChecked() )
            self.button1.Enable( cbox.IsChecked() )
                
            if not cbox.IsChecked():
                self.check3.SetValue(False)
                self.edit3.Enable( False )
                self.button3.Enable( False )
                self.check5.SetValue( False )
                self.spin1.Enable( False )
            
        if id == self.chk_id2:
            self.edit2.Enable( cbox.IsChecked() )
            self.button2.Enable( cbox.IsChecked() )
        
            if not cbox.IsChecked():
                self.check4.SetValue(False)
                self.edit4.Enable( False )
                self.button4.Enable( False )
                self.check5.SetValue( False )
                self.spin1.Enable( False )
                
        if id == self.chk_id3:
            self.edit3.Enable( cbox.IsChecked() )
            self.button3.Enable( cbox.IsChecked() )
            
            if cbox.IsChecked():
                self.check1.SetValue(True)
                self.edit1.Enable( True )
                self.button1.Enable( True )
        
        if id == self.chk_id4:
            self.edit4.Enable( cbox.IsChecked() )
            self.button4.Enable( cbox.IsChecked() )
            
            if cbox.IsChecked():
                self.check2.SetValue(True)
                self.edit2.Enable( True )
                self.button2.Enable( True )

        if id == self.chk_id5:
            if cbox.IsChecked():
                self.check1.SetValue(True)
                self.edit1.Enable( True )
                self.button1.Enable( True )
                self.check2.SetValue(True)
                self.edit2.Enable( True )
                self.button2.Enable( True )

            self.spin1.Enable( cbox.IsChecked() )
            
    
    def OnButton(self, event):
        idx = event.GetId()

        dlg = wx.DirDialog(self, _("Choose a directory:"),
                          style=wx.DD_DEFAULT_STYLE|wx.DD_NEW_DIR_BUTTON)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            if idx == 100:
                self.edit1.SetValue(path)
            elif idx == 101:
                self.edit2.SetValue(path)
            elif idx == 102:
                self.edit3.SetValue(path)
            elif idx == 103:
                self.edit4.SetValue(path)
        dlg.Destroy()
        
    def SaveSettings(self):
        import os.path
        self.btconfig.Set("use_download_dir", self.check1.IsChecked())
        self.btconfig.Set("use_torrent_dir", self.check2.IsChecked())
        

        if self.check1.IsChecked():
            self.btconfig.Set("download_dir", str(self.edit1.GetValue().encode('utf-8')))
        
        if self.check2.IsChecked():
            self.btconfig.Set("torrent_dir", str(self.edit2.GetValue().encode('utf-8')))
            
        if self.check3.IsChecked():
            self.btconfig.Set("completed_dl_dir", str(self.edit3.GetValue().encode('utf-8')))
        else:
            self.btconfig.Set("completed_dl_dir", str(self.edit1.GetValue().encode('utf-8')))
            
        if self.check4.IsChecked():
            self.btconfig.Set("completed_tor_dir", str(self.edit4.GetValue().encode('utf-8')))
        else:
            self.btconfig.Set("completed_tor_dir", str(self.edit2.GetValue().encode('utf-8')))
        
        if self.check5.IsChecked():
            self.btconfig.Set("tdir_scan", max(60, self.spin1.GetValue()*60))
        else:
            self.btconfig.Set("tdir_scan", 0)
        
        self.btconfig.UpdateOptions()
        
    
#-----------------------------------------------------------------------------

class Options_Choker_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        self.Freeze()

        # combo -> choke_multiplier value
        self.mval = {0:32768, 1:65536, 2:131072, 3:262144, 4:524288, 5:1048576, 6:2097152, 7:4194304}
        # choke_multiplier value -> combo
        self.rev_mval = {32768:0, 65536:1, 131072:2, 262144:3, 524288:4, 1048576:5, 2097152:6, 4194304:7}
        
        box = wx.StaticBox(self, -1, _("Choker Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
       
        choker_select = [_("g3torrent - Customizable strategy"),
                         _("Standard strategy from BitTorrent 3.4.2"),
                         _("LeoXV - Anti-Leecher strategy")]
        
        RBOX1 = wx.NewId()
        self.radio1 = wx.RadioBox(self, RBOX1, _("Select a predefined choking strategy:"),
                        wx.DefaultPosition, wx.DefaultSize,
                        choker_select, 1, wx.RA_SPECIFY_COLS)
        self.radio1.SetSelection(btconfig.Get('choker'))
        wx.EVT_RADIOBOX(self, RBOX1, self.OnRadio) 
        
        notebox1 = wx.StaticBox(self, -1, _("Customize"))
        noteboxer1 = wx.StaticBoxSizer(notebox1, wx.VERTICAL)
        triplewide = wx.FlexGridSizer(cols = 3, vgap = 3, hgap = 2)
        actsizer = wx.FlexGridSizer(1, 4, 0, 0)

        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(50, Widget_H))
        self.spin1.SetRange(1, 360)
        self.spin1.SetValue(btconfig.Get('choke_period'))

        self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(50, Widget_H))
        self.spin2.SetRange(1, 1080)
        self.spin2.SetValue(btconfig.Get('opt_choke_period'))

        self.floatctrl = NumCtrl(self, size = (20, Widget_H), 
                groupDigits=False, allowNegative=False, integerWidth=4, fractionWidth=2)
        self.floatctrl.SetBounds(0.00, 9999.99)
        try:
            self.floatctrl.SetValue(btconfig.Get('choke_minrate'))
        except ValueError:
            self.floatctrl.SetValue(0)
            
        self.floatctrl2 = NumCtrl(self, size = (20, Widget_H), 
        groupDigits=False, allowNegative=False, integerWidth=4, fractionWidth=2)
        self.floatctrl2.SetBounds(0.00, 9999.99)
        
        try:
            self.floatctrl2.SetValue(btconfig.Get('choke_udban'))
        except ValueError:
            self.floatctrl2.SetValue(3)

        self.choices=["32KB", "64KB", "128KB", "256KB", "512KB", "1MB", "2MB", "4MB"]
        self.combo1 = wx.ComboBox(self, -1, size = wx.Size(-1, Widget_H),
                choices=self.choices,
                style=wx.CB_READONLY)
        try:
            self.combo1.SetValue(self.choices[self.rev_mval[btconfig.Get('choke_activate')]])
            self.combo1.SetSelection(self.rev_mval[btconfig.Get('choke_activate')])
        except (ValueError, KeyError):
            self.combo1.SetValue(self.choices[0])
            self.combo1.SetSelection(0)

        self.spin3 = wx.SpinCtrl(self, -1, size = wx.Size(50, Widget_H))
        self.spin3.SetRange(1, 100)
        try:
            self.spin3.SetValue(btconfig.Get('choke_multiplier'))
        except ValueError:
            self.spin3.SetValue(1)
        
        self.label1 = wx.StaticText(self, -1, _("Run choker every"))
        self.label2 = wx.StaticText(self, -1, _("Rotate optimistic unchoke target every"))
        self.label3 = wx.StaticText(self, -1, _("Min Upload Rate"))
        self.label5 = wx.StaticText(self, -1, _("secs"))
        self.label6 = wx.StaticText(self, -1, _("secs"))
        self.label7 = wx.StaticText(self, -1, _("KB/s"))
        self.label8 = wx.StaticText(self, -1, _("Peer Max U/D Ratio (0 = unlimited)"))
        self.label9 = wx.StaticText(self, -1, _("DL Threshold to start choker.  Piece size: "))
        self.label10 = wx.StaticText(self, -1, _(" Multiplier: "))

        triplewide.Add(self.label1, 1, wx.EXPAND)
        triplewide.Add(self.spin1, 1, wx.EXPAND)
        triplewide.Add(self.label5, 1, wx.EXPAND)
        
        triplewide.Add(self.label2, 1, wx.EXPAND)
        triplewide.Add(self.spin2, 1, wx.EXPAND)
        triplewide.Add(self.label6, 1, wx.EXPAND)
        
        triplewide.Add(self.label3, 1, wx.EXPAND)
        triplewide.Add(self.floatctrl, 1, wx.EXPAND)
        triplewide.Add(self.label7, 1, wx.EXPAND)
        
        triplewide.Add(self.label8, 1, wx.EXPAND)
        triplewide.Add(self.floatctrl2, 1, wx.EXPAND)
        triplewide.Add((-1,-1)) #spacer
        
        actsizer.Add(self.label9, 0, wx.TOP|wx.BOTTOM|wx.FIXED_MINSIZE, 4)
        actsizer.Add(self.combo1, 0, wx.FIXED_MINSIZE, 0)
        actsizer.Add((-1,-1)) #spacer
        actsizer.Add(self.label10, 0, wx.TOP|wx.BOTTOM|wx.ALIGN_RIGHT|wx.FIXED_MINSIZE, 4)

        actsizer.AddGrowableCol(2)

        triplewide.Add(actsizer, 1, wx.EXPAND, 0)
        triplewide.Add(self.spin3, 0, wx.FIXED_MINSIZE, 0)
        triplewide.Add((-1,-1))
        
        triplewide.AddGrowableCol(0)
        noteboxer1.Add(triplewide, 1, wx.EXPAND)

        notebox2 = wx.StaticBox(self, -1, _("Note"))
        noteboxer2 = wx.StaticBoxSizer(notebox2, wx.VERTICAL)
        self.notelabel = wx.StaticText(self, -1, "")
        noteboxer2.Add(self.notelabel, 1, wx.EXPAND)
        
        tall.Add(self.radio1, 1, wx.EXPAND)
        tall.Add(noteboxer1, 1, wx.EXPAND)
        tall.Add(noteboxer2, 1, wx.EXPAND)
        
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(2)
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)        
        self.Layout()
        self.Thaw()
        self.OnSelected(btconfig.Get('choker'))
        

    def OnSelected(self, selection):
        if selection == 0:
            self.notelabel.SetLabel(_("g3torrent - Customizable choker allows advanced control over\n")
                                  + _("which pieces get choked. Note: The Choker is the mechanism that\n")
                                  + _("determines which peer you will upload to. This choker has the\n")
                                  + _("ability to reject (not upload to) peers who in turn do not\n")
                                  + _("meet a MIN upload requirement"))

            self.spin1.Enable(True)
            self.spin2.Enable(True)
            self.floatctrl.Enable(True)
            self.floatctrl2.Enable(False)
            self.combo1.Enable(False)
            self.spin3.Enable(False)

        elif selection == 1:
            self.notelabel.SetLabel(_("Like the g3torrent Customizable choker, this algorithm attempts\n")
                                  + _("to keep connections open to the best connections (based who\n")
                                  + _("currently has the highest upload rate) by giving them upload\n")
                                  + _("preference. One new connection is optimistically picked from\n")
                                  + _("a queue and unchoked in the hope they will reciprocate.\n")
                                  + _("Friend/Foe functionaly will not work in this mode"))

            self.spin1.Enable(False)
            self.spin2.Enable(False)
            self.floatctrl.Enable(False)
            self.floatctrl2.Enable(False)
            self.combo1.Enable(False)
            self.spin3.Enable(False)

        elif selection == 2:
            self.notelabel.SetLabel(
                                    _("LeoXV - Anti-Leecher - Customizable choker allows advanced\n")
                                  + _("control over which pieces get choked. Note: The Choker is \n")
                                  + _("the mechanism that determines which peer you will upload to.\n")
                                  + _("This choker has the ability to reject (not upload to) \n")
                                  + _("peers who in turn do not meet a MIN upload requirement\n\n"))

            self.spin1.Enable(True)
            self.spin2.Enable(True)
            self.floatctrl.Enable(True)
            self.floatctrl2.Enable(True)
            self.combo1.Enable(True)
            self.spin3.Enable(True)

        self.Layout()
        
    def OnRadio(self, event):
        self.OnSelected(event.GetSelection())
            
    def SaveSettings(self):
        self.btconfig.Set('choker', self.radio1.GetSelection())
        if self.spin1.GetValue() < 360 and self.spin1.GetValue() > 0:
            self.btconfig.Set('choke_period', self.spin1.GetValue())
        if self.spin2.GetValue() < 1080 and self.spin2.GetValue() > 0:
            self.btconfig.Set('opt_choke_period', self.spin2.GetValue())
        self.btconfig.Set('choke_minrate', self.floatctrl.GetValue())
        self.btconfig.Set('choke_udban', self.floatctrl2.GetValue())
        self.btconfig.Set('choke_activate', int(self.mval[self.combo1.GetSelection()]))
        self.btconfig.Set('choke_multiplier', self.spin3.GetValue())
        self.btconfig.UpdateOptions()

#-----------------------------------------------------------------------------

class Options_Net_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        

        # Controls
        #I2P: We don't need min and max ports and neither IP binding/reporting
        #label1 = wx.StaticText(self, -1, _("Minimum port:"))
        #label2 = wx.StaticText(self, -1, _("Maximum port:"))
        #label3 = wx.StaticText(self, -1, _("IP to bind to locally:"))
        #label4 = wx.StaticText(self, -1, _("IP to report to tracker:"))
        #/I2P
        label5 = wx.StaticText(self, -1, _("Download capacity:"))
        label6 = wx.StaticText(self, -1, _("Upload capacity:"))
        #I2P: unneeded
        #notelabel = wx.StaticText(self, -1, 
        #          _("NOTE: Changing the port range requires a restart\n\n")
        #        + _("Download/Upload capacity values are only used to determine limits \n")
        #        + _("for the graphs. To set an actual upload rate limit, go to Transfer \n")
        #        + _("Options. Do not enter anything where it says \"IP to bind to locally\" \n")
        #        + _("unless you know exactly what you are doing."))
        notelabel = wx.StaticText(self, -1, 
                  _("Download/Upload capacity values are only used to determine limits \n")
                + _("for the graphs. To set an actual upload rate limit, go to Transfer \n")
                + _("Options."))

        #I2P: unneeded
        #self.ip_field1 = IpAddrCtrl(self, -1, style = wx.TE_PROCESS_TAB)
        #if btconfig.Get('bind_address') != None:
        #    self.ip_field1.SetValue(btconfig.Get('bind_address'))
        #
        #tt = wx.ToolTip(_("Leave this field empty unless you have special needs"))
        #self.ip_field1.SetToolTip(tt)
        #
        #self.ip_field2 = IpAddrCtrl(self, -1, style = wx.TE_PROCESS_TAB)
        #if btconfig.Get('ip_2report') != None:
        #    self.ip_field2.SetValue(btconfig.Get('ip_2report'))
        #
        #tt = wx.ToolTip(_("Leave this field empty unless you have special needs"))
        #self.ip_field2.SetToolTip(tt)
        #
        #self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        #self.spin1.SetRange(0, 65535)
        #self.spin1.SetValue(btconfig.Get('minport'))
        #
        #self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        #self.spin2.SetRange(0, 65535)
        #self.spin2.SetValue(btconfig.Get('maxport'))
        #/I2P
        self.spin3 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        self.spin3.SetRange(0, 65535)
        self.spin3.SetValue(btconfig.Get('net_max_downrate') / 1024 )

        self.spin4 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        self.spin4.SetRange(0, 65535)
        self.spin4.SetValue(btconfig.Get('net_max_uprate') / 1024 )

        # Sizers
        box = wx.StaticBox(self, -1, _("Network Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        #I2P: unneeded
        #double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        #double1 = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        #/I2P
        rateboxer = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        capbox = wx.StaticBox(self, -1, _("Transfer Rate"))
        capboxer = wx.StaticBoxSizer(capbox, wx.VERTICAL)
        #I2P: unneeded
        #portbox = wx.StaticBox(self, -1, _("Port Range"))
        #portboxer = wx.StaticBoxSizer(portbox, wx.VERTICAL)
        #/I2P
        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        #I2P: unneeded
        #double.AddGrowableCol(0)
        #double1.AddGrowableCol(0)
        #/I2P
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(7)
        
        rateboxer.Add(label5, 1, wx.EXPAND)
        rateboxer.Add(self.spin3, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        rateboxer.Add(label6, 1, wx.EXPAND)
        rateboxer.Add(self.spin4, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        rateboxer.AddGrowableCol(0)
        capboxer.Add(rateboxer, 1, wx.EXPAND)

        #I2P: unneeded
        #double1.Add(label3, 1, wx.EXPAND)
        #double1.Add(self.ip_field1, 1, wx.EXPAND)
        #
        #double1.Add(label4, 1, wx.EXPAND)
        #double1.Add(self.ip_field2, 1, wx.EXPAND)
        #
        #
        #portboxer.Add(double, 1, wx.EXPAND)
        #
        #double.Add(label1, 1, wx.EXPAND) 
        #double.Add(self.spin1, 1, wx.EXPAND | wx.ALIGN_RIGHT) 
        #double.Add(label2, 1, wx.EXPAND) 
        #double.Add(self.spin2, 1, wx.EXPAND | wx.ALIGN_RIGHT) 
        #/I2P
        noteboxer.Add(notelabel, 1, wx.EXPAND)

        tall.Add((10,10)) # spacer
        tall.Add(capboxer, 1, wx.EXPAND)      
        tall.Add((10,10)) # spacer
        #I2P: unneeded
        #tall.Add(portboxer, 1, wx.EXPAND)
        #tall.Add((10,10)) # spacer
        #tall.Add(double1, 1, wx.EXPAND)
        #tall.Add((10,10)) # spacer
        #/I2P
        tall.Add(noteboxer, 1, wx.EXPAND)
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

    def SaveSettings(self):
        #I2P: unneeded
        #self.btconfig.Set('minport', self.spin1.GetValue())
        #self.btconfig.Set('maxport', self.spin2.GetValue())
        #/I2P
        self.btconfig.Set('net_max_downrate', self.spin3.GetValue() * 1024)
        self.btconfig.Set('net_max_uprate', self.spin4.GetValue() * 1024)

        #I2P: unneeded
        #if self.ip_field1.GetPlainValue() == "" or not self.ip_field1.IsValid():
        #    self.btconfig.Set('bind_address', None)
        #else:
        #    self.btconfig.Set('bind_address', self.ip_field1.GetValue())
        #    
        #if self.ip_field2.GetPlainValue() == "" or not self.ip_field2.IsValid():
        #    self.btconfig.Set('ip_2report', None)
        #else:
        #    ip = self.ip_field2.GetValue().replace(' ','')
        #    self.btconfig.Set('ip_2report', ip)
        #/I2P
        self.btconfig.UpdateOptions()

#-----------------------------------------------------------------------------

class Options_WebI_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        

        # Controls
        self.check1 = wx.CheckBox(self, -1, _("Enable Web Interface"))
        self.check1.SetValue( btconfig['use_web_interface'] )

        if win32_flag:
            self.check2 = wx.CheckBox(self, -1, _("Don't Show Rufus on Add URL"))
            self.check2.SetValue( btconfig['show_add_URL'] )

        label1 = wx.StaticText(self, -1, _("Password:"))
        self.edit1  = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD)
        try:
            self.edit1.SetValue( str(btconfig.Get('web_interface_pass')))    
        except TypeError:
            self.edit1.SetValue("password")

        label2 = wx.StaticText(self, -1, _("Port (1-65535):"))
        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        self.spin1.SetRange(0, 65535)
        try:
            self.spin1.SetValue( btconfig.Get('web_interface_port'))
        except TypeError:
            self.spin1.SetValue(7007)
        
        try:
            self.myip = socket.gethostbyaddr(socket.gethostname())[2][0]
        except socket.error:
            self.myip = "127.0.0.1"
        
        notelabel1 = wx.StaticText(self, -1, _("The Web Interface allows you to view progress and status of your torrent \n")
                                           + _("downloads from a remote location. It also gives you the ability to start, stop \n")
                                           + _("and add new torrents remotely.\n\n")
                                           + _("If you choose to have it running, you can connect to it from ")
                                           + _("your browser at:"))

        self.addrlabel = wx.StaticText(self, -1, "http://%s:%s/" % (self.myip, btconfig.Get('web_interface_port')) ) 
        self.addrlabel.SetForegroundColour('Blue')
        wx.EVT_LEFT_DOWN(self.addrlabel, self.OnUrlClick)

        notelabel2 = wx.StaticText(self, -1, _("\n\nNote: Changing the port value requires a program restart\n\n\n"))

        # Sizers
        box = wx.StaticBox(self, -1, _("Web Interface"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        optbox = wx.StaticBox(self, -1, _("Options"))
        optboxer = wx.StaticBoxSizer(optbox, wx.VERTICAL)
        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
               
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(6)
        double.AddGrowableCol(1)
        
        double.Add(label1, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.edit1, 1, wx.EXPAND)
        double.Add(label2, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin1, 1) 
        optboxer.Add(double, 1, wx.EXPAND)
        noteboxer.Add(notelabel1, 1, wx.EXPAND)
        noteboxer.Add(self.addrlabel, 0, wx.EXPAND)
        noteboxer.Add(notelabel2, 0, wx.EXPAND)

        tall.Add((10,10)) # spacer
        tall.Add(self.check1, 1, wx.EXPAND)
        if win32_flag:
            tall.Add(self.check2, 1, wx.EXPAND)
        tall.Add((10,10)) # spacer
        tall.Add(optboxer, 1, wx.EXPAND)
        tall.Add((10,10)) # spacer
        tall.Add(noteboxer, 1, wx.EXPAND)

        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

    def _OpenUrl(self):
        try:
            open_new(self.addrlabel.GetLabel())
        except:
            pass

            
    def OnUrlClick(self, event):
        Thread(target = self._OpenUrl).start()
        
    def SaveSettings(self):
        self.btconfig.Set('use_web_interface', self.check1.GetValue())
        if win32_flag:
            self.btconfig.Set('show_add_URL', self.check2.GetValue())
        self.btconfig.Set('web_interface_pass', self.edit1.GetValue().encode('utf-8'))
        self.btconfig.Set('web_interface_port', self.spin1.GetValue())

        self.btconfig.UpdateOptions()
            
#-----------------------------------------------------------------------------

#I2P: config dialog for Sam/eep
class Options_I2P_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        

        ## Controls
        #self.check1 = wx.CheckBox(self, -1, _("Enable Web Interface"))
        #self.check1.SetValue( btconfig['use_web_interface'] )

        #if win32_flag:
        #    self.check2 = wx.CheckBox(self, -1, _("Don't Show Rufus on Add URL"))
        #    self.check2.SetValue( btconfig['show_add_URL'] )

        
        
        label1 = wx.StaticText(self, -1, _("Sam IP:"))
        self.ip_field1 = IpAddrCtrl(self, -1, style = wx.TE_PROCESS_TAB)
        tt = wx.ToolTip(_("Enter the IP address of the Sam bridge here"))
        self.ip_field1.SetToolTip(tt)
        try:
            self.ip_field1.SetValue( btconfig.Get('sam_ip'))    
        except TypeError:
            pass

        label2 = wx.StaticText(self, -1, _("Port (1-65535):"))
        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Enter the port of the Sam bridge here"))
        self.spin1.SetToolTip(tt)
        self.spin1.SetRange(0, 65535)
        try:
            self.spin1.SetValue( btconfig.Get('sam_port'))
        except TypeError:
            self.spin1.SetValue(7656)

        label3 = wx.StaticText(self, -1, _("Sessionname:"))
        tt = wx.ToolTip(_("This name will appear in your local destinations overview; changing it will also change the used destination."))
        self.nameedit = wx.TextCtrl(self, -1, "", size=(80, -1))
        self.nameedit.SetToolTip(tt)
        try:
            self.nameedit.SetValue(unicode(self.btconfig.Get('sessionname')))
        except:
            self.nameedit.SetValue('I2PRufus')
            # DEBUG: I think some non english names are crashing the options
            #print_exc()

        label4 = wx.StaticText(self, -1, _("concurrent connection attempts"))
        self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Controls how many connection attempts will be done at the same time. Leave it at the default if you aren't sure about the consequences!"))
        self.spin2.SetToolTip(tt)
        self.spin2.SetRange(1, 11)
        try:
            self.spin2.SetValue( btconfig.Get('sim_conn_attempts'))
        except TypeError:
            self.spin2.SetValue(1)

        label5 = wx.StaticText(self, -1, _("eep-proxy IP:"))
        self.ip_field2 = IpAddrCtrl(self, -1, style = wx.TE_PROCESS_TAB)
        tt = wx.ToolTip(_("Enter the IP address of the eep-proxy here"))
        self.ip_field2.SetToolTip(tt)
        try:
            self.ip_field2.SetValue( btconfig.Get('eep_ip'))    
        except TypeError:
            pass

        label6 = wx.StaticText(self, -1, _("Port (1-65535):"))
        self.spin3 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Enter the port of the eep-proxy here"))
        self.spin3.SetToolTip(tt)
        self.spin3.SetRange(0, 65535)
        try:
            self.spin3.SetValue( btconfig.Get('eep_port'))
        except TypeError:
            self.spin3.SetValue(4444)

        # Sizers
        box = wx.StaticBox(self, -1, _("I2P"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        double2 = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        sambox = wx.StaticBox(self, -1, _("Sam"))
        samboxer = wx.StaticBoxSizer(sambox, wx.VERTICAL)
        eepbox = wx.StaticBox(self, -1, _("eep-proxy"))
        eepboxer = wx.StaticBoxSizer(eepbox, wx.VERTICAL)
               
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(6)
        double.AddGrowableCol(1)
        
        double.Add(label1, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.ip_field1, 1)
        double.Add(label2, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin1, 1)
        double.Add((10,10))# spacer
        double.Add((10,10))# spacer
        double.Add(label3, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.nameedit, 1) 
        double.Add(label4, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin2, 1) 
        samboxer.Add(double, 1, wx.EXPAND)
        
        double2.Add(label5, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.ip_field2, 1)
        double2.Add(label6, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.spin3, 1) 
        eepboxer.Add(double2, 1, wx.EXPAND)
        
        tall.Add((10,10)) # spacer
        tall.Add(samboxer, 1, wx.EXPAND)
        tall.Add((10,10)) # spacer
        tall.Add(eepboxer, 1, wx.EXPAND)

        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()
        
    def SaveSettings(self):
        if self.ip_field1.GetPlainValue() == "" or not self.ip_field1.IsValid():
            self.btconfig.Set('sam_ip', "127.  0.  0.  1")
        else:
            self.btconfig.Set('sam_ip', self.ip_field1.GetValue())
            
        self.btconfig.Set('sam_port', self.spin1.GetValue())

        self.btconfig.Set('sessionname', self.nameedit.GetValue())
        
        self.btconfig.Set('sim_conn_attempts', self.spin2.GetValue())

        if self.ip_field2.GetPlainValue() == "" or not self.ip_field2.IsValid():
            self.btconfig.Set('eep_ip', "127.  0.  0.  1")
        else:
            self.btconfig.Set('eep_ip', self.ip_field2.GetValue())
            
        self.btconfig.Set('eep_port', self.spin3.GetValue())

        self.btconfig.UpdateOptions()

#/I2P        
#-----------------------------------------------------------------------------
#I2P:

class Options_Tunnel_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        

        ## Controls
        #self.check1 = wx.CheckBox(self, -1, _("Enable Web Interface"))
        #self.check1.SetValue( btconfig['use_web_interface'] )

        #if win32_flag:
        #    self.check2 = wx.CheckBox(self, -1, _("Don't Show Rufus on Add URL"))
        #    self.check2.SetValue( btconfig['show_add_URL'] )

        label0 = wx.StaticText(self, -1, _("Zero Hops:"))
        self.check1 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
        tt = wx.ToolTip(_("Allow Zero Hops?"))
        self.check1.SetToolTip(tt)
        try:
            self.check1.SetValue(btconfig.Get('inb_allowZero'))
        except TypeError:
            self.check1.SetValue(True)

        label1 = wx.StaticText(self, -1, _("Quantity:"))
        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Number of tunnels"))
        self.spin1.SetToolTip(tt)
        self.spin1.SetRange(1, 3)
        try:
            self.spin1.SetValue( btconfig.Get('inb_quantity'))
        except TypeError:
            self.spin1.SetValue(2)

        label2 = wx.StaticText(self, -1, _("Backup-Quantity:"))
        self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Number of backup tunnels"))
        self.spin2.SetToolTip(tt)
        self.spin2.SetRange(0, 2)
        try:
            self.spin2.SetValue( btconfig.Get('inb_backQuan'))
        except TypeError:
            self.spin2.SetValue(0)

        label3 = wx.StaticText(self, -1, _("Length:"))
        self.spin3 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Depth of tunnels"))
        self.spin3.SetToolTip(tt)
        self.spin3.SetRange(0, 3)
        try:
            self.spin3.SetValue( btconfig.Get('inb_length'))
        except TypeError:
            self.spin3.SetValue(2)

        label4 = wx.StaticText(self, -1, _("Length Variance:"))
        self.spin4 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Controls how much the length of the tunnels is randomly changed. If negative, the tunnel length varies +/- the set value, else only + the set value."))
        self.spin4.SetToolTip(tt)
        self.spin4.SetRange(-2, 2)
        try:
            self.spin4.SetValue( btconfig.Get('inb_lengthVar'))
        except TypeError:
            self.spin4.SetValue(-1)

        label5 = wx.StaticText(self, -1, _("Zero Hops:"))
        self.check2 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
        tt = wx.ToolTip(_("Allow Zero Hops?"))
        self.check2.SetToolTip(tt)
        try:
            self.check2.SetValue(btconfig.Get('out_allowZero'))
        except TypeError:
            self.check2.SetValue(True)

        label6 = wx.StaticText(self, -1, _("Quantity:"))
        self.spin6 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Number of tunnels"))
        self.spin6.SetToolTip(tt)
        self.spin6.SetRange(1, 3)
        try:
            self.spin6.SetValue( btconfig.Get('out_quantity'))
        except TypeError:
            self.spin6.SetValue(2)

        label7 = wx.StaticText(self, -1, _("Backup-Quantity:"))
        self.spin7 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Number of backup tunnels"))
        self.spin7.SetToolTip(tt)
        self.spin7.SetRange(0, 2)
        try:
            self.spin7.SetValue( btconfig.Get('out_backQuan'))
        except TypeError:
            self.spin7.SetValue(0)

        label8 = wx.StaticText(self, -1, _("Length:"))
        self.spin8 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Depth of tunnels"))
        self.spin8.SetToolTip(tt)
        self.spin8.SetRange(0, 3)
        try:
            self.spin8.SetValue( btconfig.Get('out_length'))
        except TypeError:
            self.spin8.SetValue(2)

        label9 = wx.StaticText(self, -1, _("Length Variance:"))
        self.spin9 = wx.SpinCtrl(self, -1, size = wx.Size(80, Widget_H))
        tt = wx.ToolTip(_("Controls how much the length of the tunnels is randomly changed. If negative, the tunnel length varies +/- the set value, else only + the set value."))
        self.spin9.SetToolTip(tt)
        self.spin9.SetRange(-2, 2)
        try:
            self.spin9.SetValue( btconfig.Get('out_lengthVar'))
        except TypeError:
            self.spin9.SetValue(-1)


        # Sizers
        box = wx.StaticBox(self, -1, _("Tunnel"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        double2 = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        sambox = wx.StaticBox(self, -1, _("Inbound"))
        samboxer = wx.StaticBoxSizer(sambox, wx.VERTICAL)
        eepbox = wx.StaticBox(self, -1, _("Outbound"))
        eepboxer = wx.StaticBoxSizer(eepbox, wx.VERTICAL)
               
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(6)
        double.AddGrowableCol(1)
        double2.AddGrowableCol(1)

        double.Add(label0, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.check1, 1)
        double.Add((10,10))# spacer
        double.Add((10,10))# spacer
        double.Add(label1, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin1, 1)
        double.Add(label2, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin2, 1)
        double.Add((10,10))# spacer
        double.Add((10,10))# spacer
        double.Add(label3, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin3, 1) 
        double.Add(label4, 1, wx.EXPAND |wx.NORTH, 4)
        double.Add(self.spin4, 1) 
        samboxer.Add(double, 1, wx.EXPAND)

        double2.Add(label5, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.check2, 1)
        double2.Add((10,10))# spacer
        double2.Add((10,10))# spacer
        double2.Add(label6, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.spin6, 1)
        double2.Add(label7, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.spin7, 1)
        double2.Add((10,10))# spacer
        double2.Add((10,10))# spacer
        double2.Add(label8, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.spin8, 1) 
        double2.Add(label9, 1, wx.EXPAND |wx.NORTH, 4)
        double2.Add(self.spin9, 1) 
        eepboxer.Add(double2, 1, wx.EXPAND)
        
        tall.Add((10,10)) # spacer
        tall.Add(samboxer, 1, wx.EXPAND)
        tall.Add((10,10)) # spacer
        tall.Add(eepboxer, 1, wx.EXPAND)

        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()
        
    def SaveSettings(self):
        self.btconfig.Set('inb_allowZero', self.check1.GetValue())
        self.btconfig.Set('inb_quantity', self.spin1.GetValue())        
        self.btconfig.Set('inb_backQuan', self.spin2.GetValue())
        self.btconfig.Set('inb_length', self.spin3.GetValue())
        self.btconfig.Set('inb_lengthVar', self.spin4.GetValue())

        self.btconfig.Set('out_allowZero', self.check2.GetValue())
        self.btconfig.Set('out_quantity', self.spin6.GetValue())        
        self.btconfig.Set('out_backQuan', self.spin7.GetValue())
        self.btconfig.Set('out_length', self.spin8.GetValue())
        self.btconfig.Set('out_lengthVar', self.spin9.GetValue())

        self.btconfig.UpdateOptions()

#/I2P        
#-----------------------------------------------------------------------------
class Options_Error_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        
        label1 = wx.StaticText(self, -1, _("Ban peer after N bad pieces:"))
        label2 = wx.StaticText(self, -1, _("Auto Pause Torrent after N failures:"))

        label3 = wx.StaticText(self, -1, _("Popup error messages:"))
        self.check1 = wx.CheckBox(self, 100, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
        self.check1.SetValue(btconfig.Get('popup_errors'))
        
        notelabel = wx.StaticText(self, -1,
              _("Occasionally, Peers will send pieces that fail the hash check and must \n")
            + _("be downloaded agan. Even good peers have been known to occasionally \n")
            + _("send a bad piece or two. Don't set this value too low if you want to\n")
            + _("avoid banning helpfull peers. Torrents will get paused automatically if \n")
            + _("they cannot connect to the tracker. But only if it is not currently \n")
            + _("connected to peers and is transfering data.\n"))
        
        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(50, Widget_H))
        self.spin1.SetRange(1, 999)
        self.spin1.SetValue(btconfig.Get('max_hashflunks'))
        
        self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(50, Widget_H))
        self.spin2.SetRange(1, 999)
        self.spin2.SetValue(btconfig.Get('max_trkrflunks'))

        box = wx.StaticBox(self, -1, _("Error Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)

        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        noteboxer.Add(notelabel, 1, wx.EXPAND)
        
        double.AddGrowableCol(0)
        double.Add(label1, 1, wx.EXPAND) 
        double.Add(self.spin1, 1, wx.EXPAND | wx.ALIGN_RIGHT) 
        double.Add(label2, 1, wx.EXPAND) 
        double.Add(self.spin2, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        double.Add(label3, 1, wx.EXPAND)
        double.Add(self.check1, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(3)
        tall.Add((10,10)) # spacer
        tall.Add(double, 1, wx.EXPAND | wx.ALL)
        tall.Add((10,10)) # spacer
        tall.Add(noteboxer, 1, wx.EXPAND)
        
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

    def SaveSettings(self):
        self.btconfig.Set('max_hashflunks', self.spin1.GetValue())
        self.btconfig.Set('max_trkrflunks', self.spin2.GetValue())
        self.btconfig.Set('popup_errors', self.check1.GetValue())
        self.btconfig.UpdateOptions()
    
#------------------------------------------------------------------------------

class Options_OnFin_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("On Completion"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)

        after_dl = [_("Keep sharing, unless downloads are in queue"),
                    _("Keep sharing, until custom condition is met"),
                    _("Keep sharing")]

        #ratio choices for combo
        cb_ratios = range(0,20)
        for i in cb_ratios:
            cb_ratios[i] = "1:" + str(i+1)
        
        
        RBOX1 = wx.NewId()
        self.radio1 = wx.RadioBox(self, RBOX1, _("When a download completes:"),
                        wx.DefaultPosition, wx.DefaultSize,
                        after_dl, 1, wx.RA_SPECIFY_COLS)
        self.radio1.SetSelection(btconfig.Get('on_complete'))
        wx.EVT_RADIOBOX(self, RBOX1, self.OnRadio)

        self.check1 = wx.CheckBox(self, -1, _("Upload till I have uploaded N%"))
        self.check2 = wx.CheckBox(self, -1, _("Upload till bytes down:up ratio"))
        self.check3 = wx.CheckBox(self, -1, _("Only upload for another Hours:Mins"))

        self.spin1 = BMSpinCtrl(self, -1, size = wx.Size(70, Widget_H), lower=-1, upper=100)
        self.spin1.SetRange(100, 1000)
        self.spin1.SetValue(100)

        self.combo1 = wx.ComboBox(self, -1, choices=cb_ratios, style=wx.CB_DROPDOWN|wx.CB_READONLY, size = wx.Size(70, Widget_H))
        self.edit1 = TextCtrl(self, -1, '00:00', mask='##:##', formatcodes='r>', size=(53,Widget_H))

        self.check4 = wx.CheckBox(self, -1, _("Upload at this new rate (KB/s)"))
        self.spin2 = BMSpinCtrl(self, -1, size = wx.Size(70, Widget_H), lower=0, upper=3)
        self.spin2.SetRange(0, 10000)

        self.spin2.SetValue(btconfig.Get('end_newrate')/1024)
        self.check1.SetValue(btconfig.Get('end_on_percent'))
        self.check2.SetValue(btconfig.Get('end_on_ratio'))
        self.check3.SetValue(btconfig.Get('end_on_timelimit'))
        self.check4.SetValue(btconfig.Get('end_on_newrate'))
        
        end_ratio = btconfig.Get('end_ratio')
        end_percent = btconfig.Get('end_percent')
        end_timelimit = btconfig.Get('end_timelimit')

        try:
            self.spin1.SetValue(int(100*end_percent))
            self.combo1.SetSelection(end_ratio-1)
            self.edit1.SetValue("%s" % strftime("%H:%M", gmtime(end_timelimit)))
        except:
            print_exc()
            print "ERROR: could not set values"

        self.custbox = wx.StaticBox(self, -1, _("Custom Condition"))
        custboxer = wx.StaticBoxSizer(self.custbox, wx.VERTICAL)
        custboxer.Add(double, 1, wx.EXPAND)
        self.custboxer = custboxer

        self.OnSelected(self.radio1.GetSelection())
        
        double.Add((-1,5))
        double.Add((-1,5))
        double.Add(self.check1, 1, wx.EXPAND)
        double.Add(self.spin1, 1)
        double.Add(self.check2, 1, wx.EXPAND)
        double.Add(self.combo1, 1)
        double.Add(self.check3, 1, wx.EXPAND)
        double.Add(self.edit1, 1)
        
        double.Add(self.check4, 1, wx.EXPAND)
        double.Add(self.spin2, 1)
        double.AddGrowableCol(0)

        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        label5 = wx.StaticText(self, -1, _("Try to keep files seeded as long as possible. ")
                                + _("This is what Brian Boitano would do\n\n")
                                + _("Upload Rate of 0 = unlimited\n"))
        noteboxer.Add(label5, 1, wx.EXPAND)

        tall.Add((0,5)) # spacer
        tall.Add(self.radio1, 1, wx.EXPAND)
        tall.Add(custboxer, 1, wx.EXPAND)
        tall.Add(noteboxer, 1, wx.EXPAND)
        tall.AddGrowableRow(3)
        
        tall.AddGrowableCol(0)
        self.tall = tall
        
        boxer.Add(tall, 1, flag = wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()
        
    def ToggleCustBox(self, value):
        self.custbox.Enable(value)
        self.check1.Enable(value)
        self.check2.Enable(value)
        self.check3.Enable(value)
        self.spin1.Enable(value)
        self.combo1.Enable(value)
        self.edit1.Enable(value)
        self.check4.Enable(value)
        self.spin2.Enable(value)
        
    def OnSelected(self, selection):
        if selection == 1:
            self.ToggleCustBox(True)
        else:
            self.ToggleCustBox(False)
    
    def OnRadio(self, event):
        self.OnSelected(event.GetSelection())

    def SaveSettings(self):
        self.btconfig.Set('on_complete', self.radio1.GetSelection())
        
        self.btconfig.Set('end_on_percent', self.check1.GetValue())
        self.btconfig.Set('end_on_ratio', self.check2.GetValue())
        self.btconfig.Set('end_on_timelimit', self.check3.GetValue())
        self.btconfig.Set('end_on_newrate', self.check4.GetValue())
                
        #this is moronic... but some users perfer ratio others percent
        ratio1 = self.spin1.GetValue() 
        ratio1 = float(ratio1) / 100
        ratio2 = int( self.combo1.GetValue()[2:] )

        try:
            timelimit = int(self.edit1.GetValue()[:2])*3600 + int(self.edit1.GetValue()[3:])*60
            self.btconfig.Set('end_timelimit', timelimit)       
        except ValueError:
            pass
        
        self.btconfig.Set('end_percent', ratio1)
        self.btconfig.Set('end_ratio', ratio2)
        self.btconfig.Set('end_newrate', self.spin2.GetValue()*1024)

        self.btconfig.UpdateOptions()
    
#-----------------------------------------------------------------------------

class Options_Gen_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("General"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 20)
        
        
        label0 = wx.StaticText(self, -1, _("Nickname (max length 9):"))
        self.nameedit = wx.TextCtrl(self, -1, "", size=(80, -1))
        try:
            self.nameedit.SetValue(unicode(self.btconfig.Get('nickname')))
        except:
            self.nameedit.SetValue('Anonymous')
            # DEBUG: I think some non english names are crashing the options
            print_exc()
        
        label3 = wx.StaticText(self, -1, _("Max simultaneous torrents:"))
        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(50, Widget_H))
        self.spin1.SetRange(0, 100)
        self.spin1.SetValue(btconfig.Get('max_sessions'))
        
        label8 = wx.StaticText(self, -1, _("Update GUI every:"))
        
        self.combo1 = wx.ComboBox(self, -1, size = wx.Size(50, Widget_H),
                choices=["500 ms", "1000 ms", "1500 ms", "2000 ms", "5000 ms"],
                style=wx.CB_READONLY)
        self.combo1.SetValue( "%d ms" % (btconfig.Get('gui_update_rate')*1000) )
        
        label2 = wx.StaticText(self, -1, _("Load completed torrents on start:"))
        self.check2 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
        self.check2.SetValue(btconfig.Get('load_completed'))

        if win32_flag:
            label6 = wx.StaticText(self, -1, _("Minimize to system tray:"))
            self.check3 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
            self.check3.SetValue(btconfig.Get('usesystray'))

            label10 = wx.StaticText(self, -1, _("Fixed tray icon:"))
            self.check4 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
            self.check4.SetValue(btconfig.Get('fixedtrayicon'))

        label7 = wx.StaticText(self, -1, _("Confirmation on exit:"))
        self.check5 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
        self.check5.SetValue(btconfig.Get('confirmexit'))
                        
        label9 = wx.StaticText(self, -1, _("Skip hash check on 100% files:"))
        self.check6 = wx.CheckBox(self, 101, "", wx.Point(100, 0), wx.Size(150, 20), wx.NO_BORDER)
        self.check6.SetValue(not btconfig.Get('always_check_hashes'))        

        if win32_flag:        
            label4 = wx.StaticText(self, -1, _("Associate with .torrent files:"))
            b_id = wx.NewId()
            ass_butt = wx.Button(self, b_id, _("Associate"))

            wx.EVT_BUTTON(self, b_id, self.Register)
        

        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        label5 = wx.StaticText(self, -1, 
                                  _("The Min simultaneous torrents setting sets a limit on the \n")
                                + _("number of torrents the client will automatically start. \n")
                                + _("This  will not limit the number of torrents a user can \n")
                                + _("manually start. Your nickname can only been seen by those \n")
                                + _("using the Rufus client."))
        noteboxer.Add(label5, 1, wx.EXPAND)
        
        
        double.Add(label0, 1, wx.EXPAND)
        double.Add(self.nameedit, 1, wx.EXPAND)
                
        double.Add(label3, 1, wx.EXPAND)
        double.Add(self.spin1, 1, wx.EXPAND | wx.ALIGN_RIGHT)

        double.Add(label8, 1, wx.EXPAND)
        double.Add(self.combo1, 1, wx.EXPAND | wx.ALIGN_RIGHT)

        double.Add(label2, 1, wx.EXPAND)
        double.Add(self.check2, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        
        if win32_flag:
            double.Add(label6, 1, wx.EXPAND)
            double.Add(self.check3, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        
            double.Add(label10, 1, wx.EXPAND)
            double.Add(self.check4, 1, wx.EXPAND | wx.ALIGN_RIGHT)

        double.Add(label7, 1, wx.EXPAND)
        double.Add(self.check5, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        
        double.Add(label9, 1, wx.EXPAND)
        double.Add(self.check6, 1, wx.EXPAND | wx.ALIGN_RIGHT)

        if win32_flag:       
            double.Add(label4, 1, wx.EXPAND)
            double.Add(ass_butt, 1, wx.EXPAND | wx.ALIGN_RIGHT)
        
        double.AddGrowableCol(0)

        tall.Add((0,5)) # spacer
        tall.Add(double, 1, wx.EXPAND | wx.ALL, 4) # spacer
        tall.Add((0,5)) # spacer
        tall.Add(noteboxer, 1, wx.EXPAND)
        tall.AddGrowableRow(3)
        
        
        tall.AddGrowableCol(0)        
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

        
    def Register(self, event):
        if not win32_flag:
            return
            
        print "Attempting register"
        path = self.btconfig.Get('path')
        exe_name = join(path, 'rufus.exe')
        print exe_name
        
        reg_str = [
                    [ HKEY_CLASSES_ROOT, ".torrent", "", "bittorrent", 0 ],
                    [ HKEY_CLASSES_ROOT, ".torrent", "Content Type", "application/x-bittorrent", 0 ],
                    [ HKEY_CLASSES_ROOT, "MIME\\Database\\Content Type\\application/x-bittorrent", "Extension", ".torrent", 0 ],
                    [ HKEY_CLASSES_ROOT, "bittorrent", "", "TORRENT File", 0 ],
                    [ HKEY_CLASSES_ROOT, "bittorrent", "EditFlags", "\0\0\0\0\0\1\0\0", 1 ],
                    [ HKEY_CLASSES_ROOT, "bittorrent\\shell", "", "open", 0 ],
                    [ HKEY_CLASSES_ROOT, "bittorrent\\shell\\open\\command", "", ('"%s"' % exe_name) + '"%1"', 0 ]
                ]

        for key in reg_str:
            try:
                print 'opening'
                reg = OpenKey(key[0], key[1], 0, KEY_SET_VALUE)
            except EnvironmentError:
                print 'creating'
                try:
                    reg = CreateKey(key[0], key[1])
                except:
                    print "Unable to create key!" + "key[0]" + key[1]
                    return

            if key[4] == 0:
                SetValue(reg, key[2], REG_SZ, key[3])
            elif key[4] == 1:
                SetValueEx(reg, key[2], 0, REG_BINARY, key[3])
                
            CloseKey(reg)

        print "registered!" 
        
        
    def SaveSettings(self):
        self.btconfig.Set('max_sessions', self.spin1.GetValue())
        self.btconfig.Set('load_completed', self.check2.GetValue())
        if win32_flag:
            self.btconfig.Set('usesystray', self.check3.GetValue())
            self.btconfig.Set('fixedtrayicon', self.check4.GetValue())
        self.btconfig.Set('confirmexit', self.check5.GetValue())
        self.btconfig.Set('always_check_hashes', not self.check6.GetValue())
        
        name = self.nameedit.GetValue()
        self.btconfig.Set('nickname', name[:9])
        
        update_rate = self.combo1.GetValue()
        if update_rate == '500 ms':
            self.btconfig.Set('gui_update_rate', 0.50)
        elif update_rate == '1000 ms':
            self.btconfig.Set('gui_update_rate', 1)
        elif update_rate == '1500 ms':
            self.btconfig.Set('gui_update_rate', 1.5)
        elif update_rate == '2000 ms':
            self.btconfig.Set('gui_update_rate', 2)
        elif update_rate == '5000 ms':
            self.btconfig.Set('gui_update_rate', 5)
            
            
        self.btconfig.UpdateOptions()

#-----------------------------------------------------------------------------
#I2P:
class Options_Log_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("Logging"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 20)
                
        label1 = wx.StaticText(self, -1, _("Loglevel:"))
        
        self.combo1 = wx.ComboBox(self, -1, size = wx.Size(75, Widget_H),
                choices=["Error", "Warning", "Normal", "Info", "Debug"],
                style=wx.CB_READONLY)
        loglv = btconfig.Get('loglevel')
        choices = ['Debug', 'Info', 'Normal', 'Warning', 'Error']
        self.combo1.SetValue(choices[(loglv-1)])
        
        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        labe2 = wx.StaticText(self, -1, 
                                  _("For normal users the loglevel Normal to Error are appropriate. \n")
                                + _("Info already leads to a little bit more logmessages, while     \n")
                                + _("Debug will result in mayor debug output, which is really only  \n")
                                + _("usefull for developpers/debuggers. In the near future, you will\n")
                                + _("be able to define the loglevel for single classes here, too.   \n"))
        noteboxer.Add(labe2, 1, wx.EXPAND)
        
        double.Add(label1, 1, wx.EXPAND)
        double.Add(self.combo1, 1, wx.EXPAND | wx.ALIGN_RIGHT)

        tall.Add((0,5)) # spacer
        tall.Add(double, 1, wx.EXPAND | wx.ALL, 4) # spacer
        tall.Add((0,5)) # spacer
        tall.Add(noteboxer, 1, wx.EXPAND)
        tall.AddGrowableRow(3)
        
        tall.AddGrowableCol(0)        
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

    def SaveSettings(self):     
        loglv = self.combo1.GetValue()
        loglv = loglv.upper()
        choices = ['DEBUG', 'INFO', 'NORMAL', 'WARNING', 'ERROR']
        self.btconfig.Set('loglevel', (choices.index(loglv)+1))
#/I2P  
#-----------------------------------------------------------------------------

class Options_PL_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("Default Peer/Torrent List Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        peerdouble = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 20)
        torrentdouble = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 20)

        box = wx.StaticBox(self, -1, _("Peer List"), size = psize)
        peerboxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)

        box = wx.StaticBox(self, -1, _("Torrent List"), size = psize)
        torrentboxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)

        self.check1 = wx.CheckBox(self, -1, _("  Keep Sorted"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.check1.SetValue(btconfig.Get('sort_list'))

        #I2P: not supported anymore:
        #self.check2 = wx.CheckBox(self, -1, _("  Reverse DNS"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)
        #self.check2.SetValue(btconfig.Get('reverse_dns'))
        #
        #self.check3 = wx.CheckBox(self, -1, _("  Show Country Flags"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)
        #self.check3.SetValue(btconfig.Get('country_flags'))
        #/I2P
        self.check4 = wx.CheckBox(self, -1, _("  Status list Mini-Progress bar shows percentage instead of pieces"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)        
        self.check4.SetValue(btconfig.Get('p_gauge_type'))

        self.check5 = wx.CheckBox(self, -1, _("  Disable move torrent on Resume"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.check5.SetValue(btconfig.Get('resume_move'))
        
        self.check6 = wx.CheckBox(self, -1, _("  Disable move torrent on Pause"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.check6.SetValue(btconfig.Get('pause_move'))

        self.check7 = wx.CheckBox(self, -1, _("  Torrent list Mini-Progress bar shows percentage instead of pieces"), wx.DefaultPosition, wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.check7.SetValue(btconfig.Get('t_gauge_type'))  

        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        label5 = wx.StaticText(self, -1, _("The 'Keep Sorted' option incures a small cpu hit \n"
                                         "because it tends to keep the list constantly in motion."))
        noteboxer.Add(label5, 1, wx.EXPAND)

        peerdouble.AddGrowableCol(1)        
        peerdouble.Add(self.check1, 1, wx.EXPAND)
        #I2P: reverseDNS/Flags aren't supported anymore
        #peerdouble.Add(self.check2, 1, wx.EXPAND)
        #peerdouble.Add(self.check3, 1, wx.EXPAND)
        #/I2P
        peerdouble.Add(self.check4, 1, wx.EXPAND)
        peerboxer.Add(peerdouble, 1, wx.EXPAND)

        torrentdouble.AddGrowableCol(1)        
        torrentdouble.Add(self.check5, 1, wx.EXPAND)
        torrentdouble.Add(self.check6, 1, wx.EXPAND)
        torrentdouble.Add(self.check7, 1, wx.EXPAND)
        torrentboxer.Add(torrentdouble, 1, wx.EXPAND)

        tall.AddGrowableCol(0)
        tall.Add((0,5)) # spacer
        tall.Add(peerboxer, 1, wx.EXPAND | wx.ALL, 4)
        tall.Add((0,5)) # spacer
        tall.Add(torrentboxer, 1, wx.EXPAND | wx.ALL, 4)
        tall.Add((0,5)) # spacer
        tall.Add(noteboxer, 1, wx.EXPAND)
        tall.AddGrowableRow(5)
   
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()
    
 
    def SaveSettings(self):
        self.btconfig.Set('sort_list', self.check1.GetValue())
        #I2P: not supported anymore
        #self.btconfig.Set('reverse_dns',  self.check2.GetValue())
        #self.btconfig.Set('country_flags', self.check3.GetValue())
        #/I2P
        self.btconfig.Set('p_gauge_type', self.check4.GetValue())
        self.btconfig.Set('resume_move', self.check5.GetValue())
        self.btconfig.Set('pause_move', self.check6.GetValue())
        self.btconfig.Set('t_gauge_type', self.check7.GetValue())
        self.btconfig.UpdateOptions()
    
#-----------------------------------------------------------------------------

class Options_Conn_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig
                
        label1 = wx.StaticText(self, -1, _("Max Connections - Total:"))
        label2 = wx.StaticText(self, -1, _("Max Connections - Local (Outbound):"))
        
        self.spin1 = wx.SpinCtrl(self, -1, size = wx.Size(70, Widget_H))
        self.spin1.SetRange(0, 1000)
        try:
            self.spin1.SetValue(self.btconfig.Get('max_connections'))
        except:
            self.spin1.SetValue(55)
            
        self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(70, Widget_H))
        self.spin2.SetRange(0, 1000)
        try:
            self.spin2.SetValue(self.btconfig.Get('max_initiate'))
        except:
            self.spin1.SetValue(35)
        
        box = wx.StaticBox(self, -1, _("Connection Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double1 = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        connsbox = wx.StaticBox(self, -1, _("Max Connections Per Torrent"))
        connsboxer = wx.StaticBoxSizer(connsbox, wx.HORIZONTAL)
        double1.AddGrowableCol(0)
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(2)
        
        double1.Add(label1, 1, wx.ALIGN_LEFT | wx.ALL, 4)
        double1.Add(self.spin1, 1, wx.ALIGN_RIGHT)
        double1.Add(label2, 1, wx.ALIGN_LEFT | wx.ALL, 4)
        double1.Add(self.spin2, 1, wx.ALIGN_RIGHT)
        connsboxer.Add(double1, 1, wx.EXPAND)

        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        label5 = wx.StaticText(self, -1,
                  _("Max Connections - Total is number of connections to allow total,\n")
                + _("after this any new incoming connections will be immediately \n")
                + _("closed\n\n")
                + _("Max Local Connections is the number of connection the client \n") 
                + _("will open locally. Remote connections will still be accepted \n")
                + _("untill Max Connections - Total is reached.\n\n")
                + _("Default: 55 Total, 35 Local.\n\n"))

        noteboxer.Add(label5, 1, wx.EXPAND | wx.ALL, 4)
        
        tall.Add((-1,5)) # spacer
        tall.Add(connsboxer, 1, wx.EXPAND)
        tall.Add(noteboxer, 1, wx.EXPAND)
        boxer.Add(tall, 1, wx.EXPAND)
        
        self.SetSizer(boxer)
        self.Layout()

    def SaveSettings(self):
        self.btconfig.Set('max_connections', self.spin1.GetValue())
        self.btconfig.Set('max_initiate', self.spin2.GetValue())
        self.btconfig.UpdateOptions()
        
#------------------------------------------------------------------------------

class Options_Rate_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig
                
        chk_Id1 = wx.NewId()
        self.check1 = wx.CheckBox(self, chk_Id1, _("Use a global setting"), wx.Point(0, 0), wx.Size(-1, Widget_H), wx.NO_BORDER)
        self.check1.SetValue(btconfig.Get('use_global_urate'))
        wx.EVT_CHECKBOX(self, chk_Id1, self.OnCheck)

        label4 = wx.StaticText(self, -1, _("Global Max Upload Rate (KB/s):"))
        label5 = wx.StaticText(self, -1, _("Avg Upload Rate per peer (KB/s):"))
        self.spin4 = BMSpinCtrl(self, -1, size = wx.Size(70, Widget_H), lower=0, upper=3)
        self.spin4.SetRange(0, 100000)
        self.spin4.SetValue(self.btconfig.Get('total_max_uprate')/1024)
        self.spin5 = wx.SpinCtrl(self, -1, size = wx.Size(70, Widget_H))
        self.spin5.SetRange(0, 1000)
        self.spin5.SetValue(self.btconfig.Get('avg_peer_urate'))
        
        label1 = wx.StaticText(self, -1, _("Max Upload Rate (KB/s):"))
        label2 = wx.StaticText(self, -1, _("Max Uploads:"))
        
        self.spin1 = BMSpinCtrl(self, -1, size = wx.Size(70, Widget_H), lower=0, upper=3)
        self.spin1.SetRange(0, 100000)
        self.spin1.SetValue(self.btconfig.Get('maxupspeed'))

        self.spin2 = wx.SpinCtrl(self, -1, size = wx.Size(70, Widget_H))
        self.spin2.SetRange(0, 10000)
        self.spin2.SetValue(self.btconfig.Get('maxuploads'))        

        box = wx.StaticBox(self, -1, _("Rate Options"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        double1 = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        double2 = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
        globalbox = wx.StaticBox(self, -1, _("Global torrent options"))
        globalboxer = wx.StaticBoxSizer(globalbox, wx.HORIZONTAL)
        sessionbox = wx.StaticBox(self, -1, _("Per torrent options"))
        sessionboxer = wx.StaticBoxSizer(sessionbox, wx.HORIZONTAL)
        double1.AddGrowableCol(0)
        double2.AddGrowableCol(0)
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(5)
        
        double1.Add(label4, 1, wx.ALIGN_LEFT)
        double1.Add(self.spin4, 1, wx.ALIGN_RIGHT)
        double1.Add(label5, 1, wx.ALIGN_LEFT)
        double1.Add(self.spin5, 1, wx.ALIGN_RIGHT)
        globalboxer.Add(double1, 1, wx.EXPAND)
        
        
        double2.Add(label1, 1, wx.ALIGN_LEFT)
        double2.Add(self.spin1, 1, wx.ALIGN_RIGHT)
        double2.Add(label2, 1, wx.ALIGN_LEFT)
        double2.Add(self.spin2, 1, wx.ALIGN_RIGHT)
        sessionboxer.Add(double2, 1, wx.EXPAND)


        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        label5 = wx.StaticText(self, -1,
                                         _("You can select between a global total upload speed, or a unique \n")
                                       + _("setting for a particular torrent. Upload Rate of 0 = unlimited.\n")
                                       + _("Leave the Upload Rate at 0 or as high as possible for best results.\n"))
        noteboxer.Add(label5, 1, wx.EXPAND)
        
        tall.Add((-1,5)) # spacer
        tall.Add(self.check1) # spacer
        tall.Add((-1,5)) # spacer
        tall.Add(globalboxer, 1, wx.EXPAND)
        tall.Add(sessionboxer, 1, wx.EXPAND)
        tall.Add(noteboxer, 1, wx.EXPAND)
        boxer.Add(tall, 1, wx.EXPAND)
        
        self.OnCheck(self.check1)
        self.SetSizer(boxer)
        self.Layout()
        

    def OnCheck(self, event):
        if not event.IsChecked():
            self.spin4.Enable(False)
            self.spin5.Enable(False)
            self.spin1.Enable(True)
            self.spin2.Enable(True)
        else:
            self.spin5.Enable(True)
            self.spin4.Enable(True)
            self.spin1.Enable(False)
            self.spin2.Enable(False)
            

    def SaveSettings(self):
        self.btconfig.Set('maxupspeed', self.spin1.GetValue())
        self.btconfig.Set('maxuploads', self.spin2.GetValue())
        
        self.btconfig.Set('use_global_urate', self.check1.GetValue())
        self.btconfig.Set('total_max_uprate', self.spin4.GetValue() * 1024)
        self.btconfig.Set('avg_peer_urate', self.spin5.GetValue())

        self.btconfig.UpdateOptions()

#---------------------------------------------------------------------------

class Options_LVC_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("Main List View"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        sizer = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 10)

        notebox = wx.StaticBox(self, -1, _("Color Settings"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        tall.Add((-1,10)) # spacer
        noteboxer.Add((-1,5))
        noteboxer.Add(sizer, 1, wx.EXPAND)
        
        labels = [0] * 6
        labels[0] = wx.StaticText(self, -1, _("  Checking:"))
        labels[1] = wx.StaticText(self, -1, _("  Complete:"))
        labels[2] = wx.StaticText(self, -1, _("  Seeding:"))
        labels[3] = wx.StaticText(self, -1, _("  Paused:"))
        labels[4] = wx.StaticText(self, -1, _("  Stopped:"))
        labels[5] = wx.StaticText(self, -1, _("  Downloading:"))
        
        colors = [
                    'ml_checking',
                    'ml_complete',
                    'ml_seeding',
                    'ml_paused',
                    'ml_stopped',
                    'ml_downloading',
                ]
        
        self.buttons = []
        col_default = True
        for i in range(len(labels)):
            b_id = wx.NewId()
            butt = wx.Button(self, b_id, "")
            butt.SetBackgroundColour(self.btconfig.g_colors[ colors[i] ])
            b = [b_id, butt, colors[i]] 
            self.buttons.append(b)

            sizer.Add(labels[i], 1, wx.EXPAND | wx.ALIGN_LEFT)
            sizer.Add(b[1], 1, wx.ALIGN_RIGHT)

            #check to see if colours are default
            if self.btconfig.g_colors[ colors[i] ] != self.btconfig.g_colors[ "def_" + colors[i] ]:
                col_default = False

            wx.EVT_BUTTON(self, b[0], self.ChangeColor)

        reset_id = wx.NewId() 
        self.resetButton = wx.Button(self, reset_id, _("Reset to defaults"))
        if col_default:
            self.resetButton.Enable(False)
        sizer.Add(self.resetButton, 1)
        tall.AddGrowableCol(0)
        sizer.AddGrowableCol(0)
        sizer.AddGrowableCol(1)        
        
        tall.Add(noteboxer, 1, wx.EXPAND)
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

        wx.EVT_BUTTON(self, reset_id, self.ResetColor)

    def GetColor(self, color = wx.Color(0,0,0)):
        data = None
        c_dlg = wx.ColourDialog(self)
        c_dlg.GetColourData().SetChooseFull(True)
        c_dlg.GetColourData().SetColour(color)
        if c_dlg.ShowModal() == wx.ID_OK:
            data = c_dlg.GetColourData()
        c_dlg.Destroy()
        if data != None:
            return data.GetColour()
        else:
            return None
    
    def ChangeColor(self, event):
        for b in self.buttons:
            if b[0] == event.GetId():
                current_color = b[1].GetBackgroundColour()
                color = self.GetColor(current_color)
                if color != None:
                    b[1].SetBackgroundColour(color)
                    self.btconfig.g_colors[ b[2] ] = color
                break
        self.resetButton.Enable(True)

    def ResetColor(self, event):
        for b in self.buttons:
            b[1].SetBackgroundColour(self.btconfig.g_colors[ "def_"+ b[2] ])
            self.btconfig.g_colors[ b[2] ] = self.btconfig.g_colors[ "def_"+ b[2] ]
        self.resetButton.Enable(False)
        
    def SaveSettings(self):
        self.btconfig.UpdateOptions()

#---------------------------------------------------------------------------
        
class Options_GRAPH_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("Graph"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        sizer = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 10)

        notebox = wx.StaticBox(self, -1, _("Color Settings"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        tall.Add((-1,10)) # spacer
        noteboxer.Add((-1,5))
        noteboxer.Add(sizer, 1, wx.EXPAND)
        
        labels = [0] * 8
        labels[0] = wx.StaticText(self, -1, _("  Background:"))
        labels[1] = wx.StaticText(self, -1, _("  Graph area foreground:"))
        labels[2] = wx.StaticText(self, -1, _("  Graph area background:"))
        labels[3] = wx.StaticText(self, -1, _("  Grid lines:"))
        labels[4] = wx.StaticText(self, -1, _("  Total Down Rate:"))
        labels[5] = wx.StaticText(self, -1, _("  Total Up Rate:"))
        labels[6] = wx.StaticText(self, -1, _("  Selected Down Rate:"))
        labels[7] = wx.StaticText(self, -1, _("  Selected Up Rate:"))
        
        colors = [
                    'gp_bgcolor',
                    'gp_grapharea_f',
                    'gp_grapharea_b',
                    'gp_hbars',
                    'gp_total_drate1',
                    'gp_total_urate1',
                    'gp_sel_drate1',
                    'gp_sel_urate1',
                ]
        
        self.buttons = []
        col_default = True
        for i in range(len(labels)):
            b_id = wx.NewId()
            butt = wx.Button(self, b_id, "")
            butt.SetBackgroundColour(self.btconfig.g_colors[ colors[i] ])
            b = [b_id, butt, colors[i]] 
            self.buttons.append(b)

            sizer.Add(labels[i], 1, wx.EXPAND | wx.ALIGN_LEFT)
            sizer.Add(b[1], 1, wx.ALIGN_RIGHT)

            #check to see if colours are default
            if self.btconfig.g_colors[ colors[i] ] != self.btconfig.g_colors[ "def_" + colors[i] ]:
                col_default = False

            wx.EVT_BUTTON(self, b[0], self.ChangeColor)
        
        reset_id = wx.NewId()
        self.resetButton = wx.Button(self, reset_id, _("Reset to defaults"))
        if col_default:
            self.resetButton.Enable(False)
        sizer.Add(self.resetButton, 1)
        tall.AddGrowableCol(0)
        sizer.AddGrowableCol(0)
        sizer.AddGrowableCol(1)
               
        tall.Add(noteboxer, 1, wx.EXPAND)
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

        wx.EVT_BUTTON(self, reset_id, self.ResetColor)

    def GetColor(self, color = wx.Color(0,0,0)):
        data = None
        c_dlg = wx.ColourDialog(self)
        c_dlg.GetColourData().SetChooseFull(True)
        c_dlg.GetColourData().SetColour(color)
        if c_dlg.ShowModal() == wx.ID_OK:
            data = c_dlg.GetColourData()
        c_dlg.Destroy()
        if data != None:
            return data.GetColour()
        else:
            return None
    
    def ChangeColor(self, event):
        for b in self.buttons:
            if b[0] == event.GetId():
                current_color = b[1].GetBackgroundColour()
                color = self.GetColor(current_color)
                if color != None:
                    b[1].SetBackgroundColour(color)
                    self.btconfig.g_colors[ b[2] ] = color
                break
        self.resetButton.Enable(True)

    def ResetColor(self, event):
        for b in self.buttons:
            b[1].SetBackgroundColour(self.btconfig.g_colors[ "def_"+ b[2] ])
            self.btconfig.g_colors[ b[2] ] = self.btconfig.g_colors[ "def_"+ b[2] ]
        self.resetButton.Enable(False)
        
    def SaveSettings(self):
        self.btconfig.UpdateOptions()
        
#---------------------------------------------------------------------------
        
class Options_PG_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig        
        box = wx.StaticBox(self, -1, _("Progress Gauge"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        sizer = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 10)

        notebox = wx.StaticBox(self, -1, _("Color Settings"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        tall.Add((-1,10)) # spacer
        noteboxer.Add((-1,5))
        noteboxer.Add(sizer, 1, wx.EXPAND)
        
        labels = [0] * 6
        labels[0] = wx.StaticText(self, -1, _("  Parts already downloaded:"))
#        labels[1] = wx.StaticText(self, -1, _("  Parts requested:"))
        labels[1] = wx.StaticText(self, -1, _("  Parts not yet downloaded:"))
        labels[2] = wx.StaticText(self, -1, _("  Overall Progress:"))
        labels[3] = wx.StaticText(self, -1, _("  Text color:"))
        labels[4] = wx.StaticText(self, -1, _("  Tasbar Icon Up color:"))
        labels[5] = wx.StaticText(self, -1, _("  Tasbar Icon Down color:"))
        
        colors = [
                    'g_have_color',
 #                   'g_requested_color',
                    'g_nothave_color',
                    'g_overall_color',
                    'g_text_color',
                    'tb_up_color',
                    'tb_down_color',
                ]
        
        self.buttons = []
        col_default = True
        for i in range(len(labels)):
            b_id = wx.NewId()
            butt = wx.Button(self, b_id, "")
            butt.SetBackgroundColour(self.btconfig.g_colors[ colors[i] ])
            b = [b_id, butt, colors[i]] 
            self.buttons.append(b)

            sizer.Add(labels[i], 1, wx.EXPAND | wx.ALIGN_LEFT)
            sizer.Add(b[1], 1, wx.ALIGN_RIGHT)

            #check to see if colours are default
            if self.btconfig.g_colors[ colors[i] ] != self.btconfig.g_colors[ "def_" + colors[i] ]:
                col_default = False

            wx.EVT_BUTTON(self, b[0], self.ChangeColor)

        reset_id = wx.NewId()         
        self.resetButton = wx.Button(self, reset_id, _("Reset to defaults"))
        if col_default:
            self.resetButton.Enable(False)
        sizer.Add(self.resetButton, 1)
        tall.AddGrowableCol(0)
        sizer.AddGrowableCol(0)
        sizer.AddGrowableCol(1)
               
        tall.Add(noteboxer, 1, wx.EXPAND)
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)
        self.Layout()

        wx.EVT_BUTTON(self, reset_id, self.ResetColor)

    def GetColor(self, color = wx.Color(0,0,0)):
        data = None
        c_dlg = wx.ColourDialog(self)
        c_dlg.GetColourData().SetChooseFull(True)
        c_dlg.GetColourData().SetColour(color)
        if c_dlg.ShowModal() == wx.ID_OK:
            data = c_dlg.GetColourData()
        c_dlg.Destroy()
        if data != None:
            return data.GetColour()
        else:
            return None
    
    def ChangeColor(self, event):
        for b in self.buttons:
            if b[0] == event.GetId():
                current_color = b[1].GetBackgroundColour()
                color = self.GetColor(current_color)
                if color != None:
                    b[1].SetBackgroundColour(color)
                    self.btconfig.g_colors[ b[2] ] = color
                break
        self.resetButton.Enable(True)

    def ResetColor(self, event):
        for b in self.buttons:
            b[1].SetBackgroundColour(self.btconfig.g_colors[ "def_"+ b[2] ])
            self.btconfig.g_colors[ b[2] ] = self.btconfig.g_colors[ "def_"+ b[2] ]
        self.resetButton.Enable(False)    

    def SaveSettings(self):
        self.btconfig.UpdateOptions()

#-----------------------------------------------------------------------------

#I2P: This is the option dialog for version checking, we don't need it
#class Options_Update_Panel(wx.Panel):
#    def __init__(self, parent, psize, btconfig):
#        wx.Panel.__init__(self, parent, -1, size = psize)
#        self.btconfig = btconfig  
#       
#        self.check1 = wx.CheckBox(self, -1, _("Check for updates on startup"))
#        self.check1.SetValue(btconfig.Get('ud_on_start'))
#        self.check2 = wx.CheckBox(self, -1, _("Check for updates every N Hours:"))
#        self.check2.SetValue(btconfig.Get('ud_hourly'))
#        self.spin1 = wx.SpinCtrl(self, -1, "", min=4, style=wx.SP_ARROW_KEYS, size=(50,Widget_H))
#        self.spin1.SetValue(btconfig.Get('ud_rate'))
#
#        box = wx.StaticBox(self, -1, _("Update Options"), size = psize)
#        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
#        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
#        col = wx.FlexGridSizer(cols = 2, vgap = 2, hgap = 2)
#
#        notebox = wx.StaticBox(self, -1, _("Note"))
#        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
#        self.notelabel = wx.StaticText(self, -1, _("This option will allow Rufus to connect to the\n")
#                              + _("Sourceforge server and check if a new version is available.\n")
#                              + _("If a new version is available a popup box will appear prompting\n")
#                              + _("you to download the new version.  If the popup is closed it will\n")
#                              + _("not re-appear until the next time Rufus is started\n")
#                              )
#        noteboxer.Add(self.notelabel, 1, wx.EXPAND | wx.ALL, 4)
#        
#        tall.Add((-1,5)) # spacer
#        col.Add(self.check1, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
#        col.Add((-1,-1)) # spacer
#        col.Add(self.check2, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
#        col.Add(self.spin1, 0, wx.FIXED_MINSIZE, 0)
#        tall.Add(col, 1, wx.EXPAND)
#        tall.Add((-1,5)) # spacer
#        tall.Add(noteboxer, 1, wx.EXPAND)
#        
#        tall.AddGrowableCol(0)
#        tall.AddGrowableRow(3)
#        boxer.Add(tall, 1, wx.EXPAND)
#        self.SetSizer(boxer)        
#        self.Layout()
#       
#    def SaveSettings(self):
#        self.btconfig.Set('ud_on_start', self.check1.GetValue())
#        self.btconfig.Set('ud_hourly', self.check2.GetValue())
#        self.btconfig.Set('ud_rate', self.spin1.GetValue())
#        self.btconfig.UpdateOptions()
#
#/I2P
#---------------------------------------------------------------------------
        
class Tray_Settings_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig 
        self.cleared = False
        self.currentpass = str(btconfig.Get('tray_pass'))

        self.check1 = wx.CheckBox(self, -1, _("Tray password enabled"))
        self.check1.SetValue(btconfig.Get('tray_pass_enabled'))
        wx.EVT_CHECKBOX(self, self.check1.GetId(), self.OnCheck)

        self.label1 = wx.StaticText(self, -1, _("Password:"), size = (80,-1), style=wx.ALIGN_RIGHT)
        self.edit1  = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD)
        wx.EVT_LEFT_DOWN(self.edit1, self.OnTextCtrlClick)        
        
        self.label2 = wx.StaticText(self, -1, _(" Confirm:"), size = (80,-1), style=wx.ALIGN_RIGHT)
        self.edit2  = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD)
        wx.EVT_LEFT_DOWN(self.edit2, self.OnTextCtrlClick)

        try:
            if self.currentpass != "None":
                #just for display purposes so that user realises password is set
                self.edit1.SetValue(self.currentpass) 
                self.edit2.SetValue(self.currentpass)
        except:
            pass

            
        try: #enables/disables password entry depending on btconfig
            value = btconfig.Get('tray_pass_enabled')
            self.label1.Enable(value)
            self.edit1.Enable(value)
            self.label2.Enable(value)
            self.edit2.Enable(value)
        except:
            pass


        box = wx.StaticBox(self, -1, _("Tray Icon Password"), size = psize)
        boxer = wx.StaticBoxSizer(box, wx.HORIZONTAL)
        tall = wx.FlexGridSizer(cols = 1, vgap = 2, hgap = 2)
        col = wx.FlexGridSizer(cols = 3, vgap = 2, hgap = 2)

        notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(notebox, wx.VERTICAL)
        self.notelabel = wx.StaticText(self, -1, _("This option allows you to password protect the Rufus tray icon\n")
                                               + _("meaning that you can stop people easily looking at what you are\n")
                                               + _("downloading - NOTE: They could always just check your downloads folder\n")
                              )
        noteboxer.Add(self.notelabel, 1, wx.EXPAND | wx.ALL, 4)
        
        tall.Add((-1,5)) # spacer
        tall.Add(self.check1, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        tall.Add((-1,5)) # spacer
        col.Add(self.label1, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        col.Add(self.edit1, 0, wx.ALL|wx.EXPAND, 4)
        col.Add((50,5)) # spacer
        col.Add(self.label2, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        col.Add(self.edit2, 0, wx.ALL|wx.EXPAND, 4)
        col.Add((50,5)) # spacer
        tall.Add(col, 1, wx.EXPAND)
        tall.Add(noteboxer, 1, wx.EXPAND)
        col.AddGrowableCol(1)
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(3)
        boxer.Add(tall, 1, wx.EXPAND)
        self.SetSizer(boxer)        
        self.Layout()
       
    def SaveSettings(self):

        def repr_md5(str):
            return "%02x"*len(str) % tuple(map(ord, str)) 

        if not self.currentpass == self.edit1.GetValue():
            if self.edit1.GetValue() == self.edit2.GetValue():       
                if self.edit1.GetValue() == "":
                    self.btconfig.Set('tray_pass', None)
                else:
                    self.btconfig.Set('tray_pass', repr_md5(md5(self.edit1.GetValue().encode('utf-8')).digest()))
                    self.btconfig.Set('show_add_URL', True)
            else:
                dlg = wx.MessageDialog(self, _("Passwords did not match - tray password NOT changed!"), _("Error"), wx.OK | wx.ICON_ERROR)
                dlg.ShowModal()
                dlg.Destroy()

        self.btconfig.Set('tray_pass_enabled', self.check1.GetValue())
        self.btconfig.UpdateOptions()

    def OnTextCtrlClick(self, event):
        if self.currentpass == self.edit1.GetValue() and event.GetId() == self.edit1.GetId():
            self.edit1.Clear()
        elif self.currentpass == self.edit2.GetValue() and event.GetId() == self.edit2.GetId():
            self.edit2.Clear()
        event.Skip()

    def OnCheck(self, event):
        if event.GetId() == self.check1.GetId():
            self.label1.Enable(event.IsChecked())
            self.edit1.Enable(event.IsChecked())
            self.label2.Enable(event.IsChecked())
            self.edit2.Enable(event.IsChecked())
                
#---------------------------------------------------------------------------
        
class FastResume_Settings_Panel(wx.Panel):
    def __init__(self, parent, psize, btconfig):
        wx.Panel.__init__(self, parent, -1, size = psize)
        self.btconfig = btconfig 

        self.box = wx.StaticBox(self, -1, _("Fast Resume Options"))
        boxer = wx.StaticBoxSizer(self.box, wx.HORIZONTAL)

        self.notebox = wx.StaticBox(self, -1, _("Note"))
        noteboxer = wx.StaticBoxSizer(self.notebox, wx.VERTICAL)

        tall = wx.FlexGridSizer(4, 1, 2, 2)
        tall.AddGrowableRow(3)
        tall.AddGrowableCol(0)

        triplesizer = wx.FlexGridSizer(2, 3, 0, 0)
        triplesizer.AddGrowableCol(1)

        self.chk_id1 = wx.NewId()
        self.check1 = wx.CheckBox(self, self.chk_id1, _("Enable Fast Resume"))
        self.check1.SetValue(btconfig.Get('use_resume_dir'))
        wx.EVT_CHECKBOX(self, self.chk_id1, self.OnCheck) 
        tall.Add(self.check1, 0, wx.ALL|wx.FIXED_MINSIZE, 4)

        triplesizer.Add((-1,-1))

        self.label1 = wx.StaticText(self, -1, _("Fast Resume data is stored here:"))
        triplesizer.Add(self.label1, 0, wx.ALL|wx.FIXED_MINSIZE, 4)

        triplesizer.Add((-1,-1))
        triplesizer.Add((-1,-1))

        self.edit1 = wx.TextCtrl(self, -1, "", size=(-1, Widget_H))
        self.edit1.SetValue(btconfig.Get('resume_data_dir').decode('utf-8'))
        triplesizer.Add(self.edit1, 0, wx.LEFT|wx.EXPAND|wx.FIXED_MINSIZE, 4)

        self.button1 = wx.Button(self, 100, "...", size=(25,Widget_H))
        wx.EVT_BUTTON(self, 100, self.OnButton)
        triplesizer.Add(self.button1, 0, wx.RIGHT|wx.FIXED_MINSIZE, 4)

        tall.Add(triplesizer, 1, wx.EXPAND, 0)

        tall.Add((-1, 10))

        txt = wx.StaticText(self, -1, _("Fast resume allows you to close Rufus and \n")
                                   + _("then restart without needing to rehash all of \n")
                                   + _("your downloading torrents.  Rufus records which \n")
                                   + _("pieces you have already downloaded and saves this \n")
                                   + _("information to a resume file. Then when you \n")
                                   + _("restart a torrent the information is loaded back into \n")
                                   + _("Rufus. "))

        noteboxer.Add(txt, 0, wx.EXPAND|wx.FIXED_MINSIZE, 4)
        tall.Add(noteboxer, 1, wx.EXPAND, 0)

        boxer.Add(tall, 1, wx.ALL|wx.EXPAND, 2)
        self.SetAutoLayout(True)
        self.SetSizer(boxer)
        boxer.Fit(self)
        boxer.SetSizeHints(self)

        self.OnCheck(self.check1)

    def OnCheck(self, event):
        id = event.GetId()
        cbox = event
        
        if id == self.chk_id1:
            self.edit1.Enable( cbox.IsChecked() )
            self.button1.Enable( cbox.IsChecked() )

    def OnButton(self, event):
        idx = event.GetId()

        dlg = wx.DirDialog(self, _("Choose a directory:"),
                          style=wx.DD_DEFAULT_STYLE|wx.DD_NEW_DIR_BUTTON)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            if idx == 100:
                self.edit1.SetValue(path)
        dlg.Destroy()
        
    def SaveSettings(self):
        self.btconfig.Set("use_resume_dir", self.check1.IsChecked())
        self.btconfig.Set("resume_data_dir", str(self.edit1.GetValue().encode('utf-8')))

#---------------------------------------------------------------------------
class Options(wx.Frame):
    def __init__(self, parent = None, pos = wx.DefaultPosition, btconfig = None, bmps=None,
                    cfg_visflag = None, syncfunc = None):
        wx.Frame.__init__(self, None, -1, _("Preferences"), pos = pos, size = wx.Size(580, 400),
                          style = wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP )
        self.CentreOnScreen()
        self.btconfig = btconfig
        panel = wx.Panel(self, -1)
        panel.SetSize(self.GetClientSize())
        self.panel = panel
        self.rightpanel_size = (-1,-1)
        self.SyncFunc = syncfunc
        self.cfg_visflag = cfg_visflag
        
        if cfg_visflag != None:
            cfg_visflag.set()
        
        treeID = wx.NewId()
        self.tree = wx.TreeCtrl(panel, treeID, size = wx.Size(130,-1), style =  wx.TR_DEFAULT_STYLE | wx.TR_HIDE_ROOT | wx.TR_HAS_BUTTONS  | wx.TR_SINGLE )
        butID1 = wx.NewId()
        butID2 = wx.NewId()
        self.apply_but = wx.ToggleButton(panel, butID2, _("Apply to existing torrents"))
        self.close_but = wx.Button(panel, butID1, _("Close"))
        tt = wx.ToolTip(_("Click to apply options to all existing torrents"))
        self.apply_but.SetToolTip(tt)
        tt = wx.ToolTip(_("Click to apply options to future torrents"))
        self.close_but.SetToolTip(tt)

        
        border = wx.BoxSizer(wx.VERTICAL)
        splitter = wx.FlexGridSizer(cols = 2, hgap = 4)
        leftpane = wx.FlexGridSizer(cols = 1, vgap = 4)
        self.rightpane = wx.BoxSizer(wx.VERTICAL)

        border.Add(splitter, 1, wx.EXPAND | wx.ALL, 4)
        splitter.AddGrowableRow(0)
        splitter.AddGrowableCol(1)
        splitter.Add(leftpane, 1, wx.EXPAND)
        splitter.Add(self.rightpane, 1, wx.EXPAND)
                
        leftpane.AddGrowableRow(0)
        leftpane.Add(self.tree, 1, wx.EXPAND)
        leftpane.Add(self.apply_but, 1, wx.EXPAND)
        leftpane.Add(self.close_but, 1, wx.EXPAND)
        
        self.rightpane_panel = Options_Gen_Panel(panel, self.rightpanel_size, btconfig)
        self.rightpane.Add(self.rightpane_panel, 1, wx.EXPAND | wx.ALL)

        self.PopulateTree()       
        panel.SetSizer(border)
        panel.Layout()

        if bmps != None:
            self.SetIcon(bmps.GetImage('rufus.ico'))
        
        wx.EVT_TREE_SEL_CHANGED(panel, treeID, self.OnSelChanged)
        wx.EVT_BUTTON(self, butID1, self.Cleanup)
        wx.EVT_CLOSE(self, self.Cleanup)
        wx.EVT_ERASE_BACKGROUND(self, self.AntiFlicker)
        wx.EVT_SIZE(self, self.OnSize)
        wx.EVT_KEY_DOWN(self.tree, self.OnKeyDown)
        self.Show()
        
    def OnKeyDown(self, event):
        if event.GetKeyCode() == 27: #ESC key hit
            self.Cleanup()
        else:
            event.Skip()
        
    def OnSize(self, event=None):
        fsize = self.GetClientSize()
        self.panel.SetSize(fsize)
        psize = self.panel.GetClientSize()
        self.rightpanel_size = (psize[0] - (self.tree.GetSize()[0] + 10), psize[1]-9)
        self.rightpane_panel.SetSize(self.rightpanel_size)
        
    def AntiFlicker(self, event):
        pass
    
    def OnSelChanged(self, event):
        self.panel.Freeze()
        item = event.GetItem()
        self.rightpane_panel.SaveSettings()
        self.rightpane_panel.Destroy()

        if self.tree.GetItemText(item) == "General Options":
            self.rightpane_panel = Options_Gen_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Peer/Torrent List":
            self.rightpane_panel = Options_PL_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Logging":
            self.rightpane_panel = Options_Log_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Transfer Options":
            self.rightpane_panel = Options_Rate_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "On Completion":
            self.rightpane_panel = Options_OnFin_Panel(self.panel, self.rightpanel_size, self.btconfig)    
        elif self.tree.GetItemText(item) == "Folder Options":
            self.rightpane_panel = Options_Fold_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Network Options":
            self.rightpane_panel = Options_Net_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "I2P Options":
            self.rightpane_panel = Options_I2P_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Tunnel Options":
            self.rightpane_panel = Options_Tunnel_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Choker Options":
            self.rightpane_panel = Options_Choker_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Connections":
            self.rightpane_panel = Options_Conn_Panel(self.panel, self.rightpanel_size, self.btconfig)            
        elif self.tree.GetItemText(item) == "Error Options":
            self.rightpane_panel = Options_Error_Panel(self.panel, self.rightpanel_size, self.btconfig)            
        elif self.tree.GetItemText(item) == "Color Options":
            self.rightpane_panel = Options_PG_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Main View":
            self.rightpane_panel = Options_LVC_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Progress Bar":
            self.rightpane_panel = Options_PG_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Graph":
            self.rightpane_panel = Options_GRAPH_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Web Interface":
            self.rightpane_panel = Options_WebI_Panel(self.panel, self.rightpanel_size, self.btconfig)
        #I2P: We don't support version checking, so we don't need the option dialog
        #elif self.tree.GetItemText(item) == "Update Options":
        #    self.rightpane_panel = Options_Update_Panel(self.panel, self.rightpanel_size, self.btconfig)
        #/I2P
        elif self.tree.GetItemText(item) == "Tray Password":
            self.rightpane_panel = Tray_Settings_Panel(self.panel, self.rightpanel_size, self.btconfig)
        elif self.tree.GetItemText(item) == "Fast Resume":
            self.rightpane_panel = FastResume_Settings_Panel(self.panel, self.rightpanel_size, self.btconfig)
        else:
            self.rightpane_panel = Options_Gen_Panel(self.panel, self.rightpanel_size, self.btconfig)

        self.rightpane.Add(self.rightpane_panel, 1, wx.EXPAND)
        self.panel.Layout()
        self.panel.Thaw()
        #self.rightpane_panel.SetSize(self.rightpanel_size)
        
        
    def Cleanup(self, *event):
        try:
            self.rightpane_panel.SaveSettings()
            self.btconfig.SaveOptions()
        except:
            print_exc()

        if self.SyncFunc != None:
            if self.apply_but.GetValue() and self.SyncFunc != None:
                self.SyncFunc(True)
            else:
                #Call with False to toggle some widgets in the main GUI
                self.SyncFunc(False)
        if self.cfg_visflag != None:
            self.cfg_visflag.clear()
        self.Destroy()
        
    def PopulateTree(self):
        root = self.tree.AddRoot("r3wt")

        c1 = self.tree.AppendItem(root, "General Options")
        c1a = self.tree.AppendItem(c1, "Peer/Torrent List")
        c1b = self.tree.AppendItem(c1, "Logging")
        c2 = self.tree.AppendItem(root, "Folder Options")
        c11 = self.tree.AppendItem(root, "Fast Resume")
        c4 = self.tree.AppendItem(root, "Network Options")
        c5 = self.tree.AppendItem(root, "I2P Options")
        c5a = self.tree.AppendItem(c5, "Tunnel Options")
        c9 = self.tree.AppendItem(root, "Error Options")
        c3 = self.tree.AppendItem(root, "Transfer Options")
        c3a = self.tree.AppendItem(c3, "On Completion")
        c3b = self.tree.AppendItem(c3, "Choker Options")
        c3c = self.tree.AppendItem(c3, "Connections")
        c6 = self.tree.AppendItem(root, "Color Options")
        c6a = self.tree.AppendItem(c6, "Main View")
        c6b = self.tree.AppendItem(c6, "Progress Bar")
        c6c = self.tree.AppendItem(c6, "Graph")
        c7 = self.tree.AppendItem(root, "Web Interface")
        #I2P: We don't support version checking, so we should not display any options for it
        #c8 = self.tree.AppendItem(root, "Update Options")
        #/I2P
        c10 = self.tree.AppendItem(root, "Tray Password")
        self.tree.Expand(c1)
        self.tree.Expand(c3)
        self.tree.Expand(c5)
        self.tree.Expand(c6)
        self.tree.SelectItem(c1)
        
        
        
#---------------------------------------------------------------------------
    
class OptionsPopup(wx.Frame):
    def __init__(self, parent, pos, btconfig):
        wx.Frame.__init__(self, parent, -1, _("Options Popup"), pos, (280,155), wx.SIMPLE_BORDER | wx.FRAME_NO_TASKBAR )
        panel = wx.Panel(self, -1)
        panel.SetSize( self.GetClientSize())
        self.SetSize(panel.GetSize())        
        panel.SetBackgroundColour(wx.SystemSettings_GetColour( wx.SYS_COLOUR_MENU  ))
        self.btconfig = btconfig

        colSizer = wx.FlexGridSizer(cols = 1, vgap = 5)
        gridSizer = wx.FlexGridSizer(cols = 2, vgap = 3, hgap = 2)

        label1 = wx.StaticText(panel, -1, _("Upload Rate (KB/s):"))
        label2 = wx.StaticText(panel, -1, _("Max Uploads:"))
        label3 = wx.StaticText(panel, -1, _("Max Initiate:"))
        label4 = wx.StaticText(panel, -1, _("  Note: Upload Rate of 0 = unlimited\n")
                                        + _("  Changes made here are specific to\n")
                                        + _("  this DL only"),
                                        size = wx.Size(140, 50))
        
        self.spin1 = wx.SpinCtrl(panel, -1, "", wx.Point(-1, -1), wx.Size(50, Widget_H))
        self.spin1.SetRange(0, 1000)
        self.spin1.SetValue(self.btconfig.Get('maxupspeed'))

        self.spin2 = wx.SpinCtrl(panel, -1, "", wx.Point(-1, -1), wx.Size(50, Widget_H))
        self.spin2.SetRange(0, 100)
        self.spin2.SetValue(self.btconfig.Get('maxuploads'))

        self.spin3 = wx.SpinCtrl(panel, -1, "", wx.Point(-1, -1), wx.Size(50, Widget_H))
        self.spin3.SetRange(0, 1000)
        self.spin3.SetValue(self.btconfig.Get('max_initiate'))
                
        gridSizer.Add(label1, 1, wx.EXPAND | wx.BOTTOM)
        gridSizer.Add(self.spin1, 1, wx.ALIGN_RIGHT)
        gridSizer.Add(label2, 1, wx.EXPAND | wx.BOTTOM)
        gridSizer.Add(self.spin2, 1, wx.ALIGN_RIGHT)
        gridSizer.Add(label3, 1, wx.EXPAND | wx.BOTTOM)
        gridSizer.Add(self.spin3, 1, wx.ALIGN_RIGHT)
        
        gridSizer.AddGrowableCol(0)

        colSizer.Add(gridSizer, 1, wx.EXPAND | wx.ALL, 6)
        colSizer.Add(wx.StaticLine(panel, -1, size = (self.GetClientSize()[0], 1),  style = wx.LI_HORIZONTAL), 1, wx.EXPAND)
        colSizer.Add(label4, 1, wx.EXPAND)
        
        self.SetSizer(colSizer)
        self.Layout()
        self.visible = True

        wx.EVT_ACTIVATE(self, self.OnLeaveWin)
        self.Show(True)
        
    def SaveSettings(self):
        self.btconfig.Set('maxupspeed', self.spin1.GetValue())
        self.btconfig.Set('maxuploads', self.spin2.GetValue())
        self.btconfig.Set('max_initiate', self.spin3.GetValue())
        
    def OnLeaveWin(self, evt):
        if evt.GetActive() == False and self.visible:
            self.Show(False)
            self.visible = False
            self.SaveSettings()
            self.btconfig.SyncOptions()
            self.optionsVisible = False
            self.Destroy()
        
    def EvtCheckBox(self, evt):
        if evt.IsChecked() == True:
            print 'checkbox checked'
        else:
            print 'checkbox unchecked'

    def ProcessLeftDown(self, evt):
        return False

#---------------------------------------------------------------------------


class RemoveTorrentDlg(wx.Dialog):
    def __init__(self, parent = None, pos = wx.DefaultPosition, btconfig = None, 
                    bmps = None, cfg_visflag = None):
        wx.Dialog.__init__(self, None, -1, _("Remove Torrent"), pos = pos, size = (250, 200),
                          style = wx.DEFAULT_DIALOG_STYLE | wx.STAY_ON_TOP )
        self.btconfig = btconfig
        panel = wx.Panel(self, -1)
        self.panel = panel
        self.cfg_visflag = cfg_visflag
        
        if cfg_visflag != None:
            cfg_visflag.set()

        choices = [_("Don't delete anything"),
                   _("Delete .torrent file"),
                   _("Delete data file"),
                   _("Delete .torrent and data file"),
                   ]
        
        RBOX1 = wx.NewId()
        self.radio1 = wx.RadioBox(panel, RBOX1, "",
                        wx.DefaultPosition, wx.DefaultSize,
                        choices, 1, wx.RA_SPECIFY_COLS)
        #EVT_RADIOBOX(self, RBOX1, self.OnRadio) 
            
        self.apply2all = wx.CheckBox(panel, -1, _("Apply to all selected"))
        
        butID1 = wx.NewId()
        butID2 = wx.NewId()
        self.apply_but = wx.Button(panel, butID1, "OK")
        self.cancel_but = wx.Button(panel, butID2, "Cancel")
        
        border = wx.BoxSizer(wx.VERTICAL)
        tall = wx.FlexGridSizer(cols = 1, hgap = 4)
        butgrid = wx.FlexGridSizer(cols = 2, hgap = 4)
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(0)
        butgrid.AddGrowableCol(0)
        butgrid.AddGrowableCol(1)
        
        butgrid.Add(self.apply_but, 1, wx.EXPAND)
        butgrid.Add(self.cancel_but, 1, wx.EXPAND)
        
        tall.Add(self.radio1, 1, wx.EXPAND)
        tall.Add(butgrid, 1, wx.EXPAND)
        tall.Add((-1,5))
        tall.Add(self.apply2all, 1, wx.EXPAND)
        
        border.Add(tall, 1, wx.EXPAND | wx.ALL, 4)
        
        panel.SetSizer(border)
        panel.Layout()

        if bmps != None:
            self.SetIcon(bmps.GetImage('rufus.ico'))
        
        wx.EVT_BUTTON(self, butID1, self.Ok)
        wx.EVT_BUTTON(self, butID2, self.Cancel)
        wx.EVT_SIZE(self, self.OnSize)
        self.OnSize(0)

    def Apply2All(self):
        return self.apply2all.GetValue()

        
    def Ok(self, event):
        self.EndModal(self.radio1.GetSelection())

    
    def Cancel(self, event):
        self.EndModal(wx.ID_CANCEL) 
    
    
    def OnSize(self, event):
        fsize = self.GetClientSize()
        self.panel.SetSize(fsize)
        psize = self.panel.GetClientSize()

#---------------------------------------------------------------------------

class SingleOption(wx.Frame):
    def __init__(self, parent = None, pos = wx.DefaultPosition, btconfig = None, 
                    panel_class = None, bmps = None, cfg_visflag = None):
        wx.Frame.__init__(self, None, -1, _("Change Options"), pos = pos, size = wx.DefaultSize,
                          style = wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP | wx.FRAME_NO_TASKBAR | wx.FRAME_TOOL_WINDOW )
        self.btconfig = btconfig
        panel = wx.Panel(self, -1)
        self.panel = panel
        self.cfg_visflag = cfg_visflag
        
        if cfg_visflag != None:
            cfg_visflag.set()
               
        butID1 = wx.NewId()
        butID2 = wx.NewId()
        self.apply_but = wx.Button(panel, butID1, _("Apply"))
        self.cancel_but = wx.Button(panel, butID2, _("Cancel"))

        panel_size = (400, 430)
        if panel_class == "Choker":
            self.option_panel = Options_Choker_Panel(panel, (-1,-1), btconfig)
            self.SetSize(panel_size)
        elif panel_class == "OnFin":
            self.option_panel = Options_OnFin_Panel(panel, (-1,-1), btconfig)
            self.SetSize(panel_size)
        elif panel_class == "Rate":
            self.option_panel = Options_Rate_Panel(panel, (-1,-1), btconfig)
            self.SetSize(panel_size)
        elif panel_class == "Conn":
            self.option_panel = Options_Conn_Panel(panel, (-1,-1), btconfig)
            self.SetSize(panel_size)
        else:
            self.option_panel = Options_Rate_Panel(panel, (-1,-1), btconfig)
            self.SetSize(panel_size)
            
        border = wx.FlexGridSizer(1, 1, hgap = 4)
        border.AddGrowableRow(0)
        border.AddGrowableCol(0)
        tall = wx.FlexGridSizer(cols = 1, hgap = 4)
        butgrid = wx.FlexGridSizer(cols = 2, hgap = 4)
        
        butgrid.Add(self.apply_but, 1, wx.EXPAND|wx.ALL, 2)
        butgrid.Add(self.cancel_but, 1, wx.EXPAND|wx.ALL, 2)
        tall.Add(self.option_panel, 1, wx.EXPAND)
        tall.Add(butgrid)
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(0)
        border.Add(tall, 1, wx.EXPAND | wx.ALL, 4)
        
        panel.SetSizer(border)
        panel.Layout()

        if bmps != None:
            self.SetIcon(bmps.GetImage('rufus.ico'))
        
        wx.EVT_BUTTON(self, butID1, self.Apply)
        wx.EVT_BUTTON(self, butID2, self.Cleanup)
        wx.EVT_CLOSE(self, self.Cleanup)
        wx.EVT_SIZE(self, self.OnSize)
        self.Show()
        
    def OnSize(self, event):
        fsize = self.GetClientSize()
        self.panel.SetSize(fsize)
        psize = self.panel.GetClientSize()

    def Apply(self, event):
        self.option_panel.SaveSettings()
        self.btconfig.SyncOptions()
        self.Cleanup()
        
    def Cleanup(self, event=None):
        if self.cfg_visflag != None:
            self.cfg_visflag.clear()
        self.Destroy()
        
        
#---------------------------------------------------------------------------
#I2P: Rawn: unneeded? Will check later, but with nearly 100% certainty, yes.
class UpdateDlg(wx.Dialog):
    def __init__(self, parent = None, pos = wx.DefaultPosition, btconfig = None, 
                    bmps = None, cfg_visflag = None, ver = None, new_ver = None):
        wx.Dialog.__init__(self, None, -1, _("New Version Available!!"), pos = pos, size = (210, 160),
                          style = wx.DEFAULT_DIALOG_STYLE | wx.STAY_ON_TOP )
        self.btconfig = btconfig
        panel = wx.Panel(self, -1)
        self.panel = panel
        self.cfg_visflag = cfg_visflag
        
        if cfg_visflag != None:
            cfg_visflag.set()

        self.label1 = wx.StaticText(self, -1, _("Current version:\t") + str(ver) + _("\nLatest version:\t") + str(new_ver) + "\n")
        self.label2 = wx.StaticText(self, -1, _("Click 'OK' to open the Rufus downloads\npage in your default web browser."))

        self.check1 = wx.CheckBox(panel, -1, _("Never check for an update"))
        
        butID1 = wx.NewId()
        butID2 = wx.NewId()
        self.ok_but = wx.Button(panel, butID1, "OK")
        self.close_but = wx.Button(panel, butID2, "Close")
        
        border = wx.BoxSizer(wx.VERTICAL)
        tall = wx.FlexGridSizer(cols = 1, hgap = 4)
        butgrid = wx.FlexGridSizer(cols = 2, hgap = 4)
        tall.AddGrowableCol(0)
        tall.AddGrowableRow(1)
        butgrid.AddGrowableCol(0)
        butgrid.AddGrowableCol(1)
        
        butgrid.Add(self.ok_but, 1, wx.EXPAND)
        butgrid.Add(self.close_but, 1, wx.EXPAND)
        
        tall.Add(self.label1, 1, wx.EXPAND)
        tall.Add(self.label2, 1, wx.EXPAND)
        tall.Add(butgrid, 1, wx.EXPAND)
        tall.Add((-1,5))
        tall.Add(self.check1, 1, wx.EXPAND)
        
        border.Add(tall, 1, wx.EXPAND | wx.ALL, 4)
        
        panel.SetSizer(border)
        panel.Layout()

        if bmps != None:
            self.SetIcon(bmps.GetImage('rufus.ico'))
        
        wx.EVT_BUTTON(self, butID1, self.Ok)
        wx.EVT_BUTTON(self, butID2, self.Close)
        wx.EVT_SIZE(self, self.OnSize)
        self.OnSize(0)
            
    def Ok(self, event):
        self.EndModal(wx.ID_OK) 

    def Close(self, event):
        self.EndModal(wx.ID_CANCEL) 

    def DisableUpdate(self):
        return self.check1.GetValue()

    def OnSize(self, event):
        fsize = self.GetClientSize()
        self.panel.SetSize(fsize)
        psize = self.panel.GetClientSize()

#---------------------------------------------------------------------------

if __name__ == "__main__":   
    _ = lambda x: x # needed for gettext
    app = wx.PySimpleApp()

#    ppp = About_Box(None, BTConfig(), Images())
#    ppp = OptionsPopup(None, (0,0), BTConfig())
    ppp = Options(None, btconfig = BTConfig())
#    ppp = SingleOption(None, btconfig = BTConfig(), panel_class = "Choker")
##    ppp = UpdateDlg(None, btconfig = BTConfig())
##    ppp = RemoveTorrentDlg(None, btconfig = BTConfig())
##    if ppp.ShowModal() != wx.ID_CANCEL:
##        print ppp.GetReturnCode()
##    ppp.Destroy()
    app.SetTopWindow(ppp)
    app.MainLoop()

