#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        mspanel.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/01/02
# RCS-ID:      $Id: msgpanel.py,v 1.1 2005/06/09 16:37:53 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE.TXT
#-----------------------------------------------------------------------------

import wx
from wx.lib.mixins.listctrl import ListCtrlAutoWidthMixin
from time import time, strftime, localtime
from btconfig import BTConfig
from BitTorrent.encodedata import decodedata
from types import StringType

class MsgList(wx.ListCtrl):
    def __init__(self, parent, ID=-1, pos=wx.DefaultPosition, size=wx.DefaultSize,
                 style = wx.LC_REPORT | wx.LC_VRULES ):
        wx.ListCtrl.__init__(self, parent, ID, pos, size, style)
        self.itemDataMap = {}
        wx.EVT_COMMAND_RIGHT_CLICK(self, -1, self.OnRightClick) # wxMSW
        wx.EVT_RIGHT_UP(self, self.OnRightClick) # wxGTK     


    def OnRightClick(self, event):
        if not hasattr(self, "popupID1"):
            self.popupID1 = wx.NewId()
            self.popupID2 = wx.NewId()
            wx.EVT_MENU(self, self.popupID1, self.OnCBCopy)
            wx.EVT_MENU(self, self.popupID2, self.OnClearAll)

        menu = wx.Menu()
        menu.Append(self.popupID1, _("Copy to clipboard"), _("Copy selected to clipboard"))
        menu.Append(self.popupID2, _("Clear all messages"), _("Clear all messages"))

        self.PopupMenu(menu, self.ScreenToClient(wx.GetMousePosition()))
        menu.Destroy()
        
    def OnClearAll(self, event):
        self.DeleteAllItems()
    
    def OnCBCopy(self, event):
        msg = ""
        index = self.GetFirstSelected()
        while index != -1:
            data = self.itemDataMap.get( self.GetItemData(index) )
            if data != None:
                msg += data + '\n'
            index = self.GetNextSelected(index)

        if len(msg) > 0:
            to = wx.TextDataObject(msg)
            wx.TheClipboard.Open()
            wx.TheClipboard.SetData(to)
            wx.TheClipboard.Close()
        
class MessagePanel(wx.Panel):
    def __init__(self, parent, btconfig):
        wx.Panel.__init__(self, parent, -1)

        self.btconfig = btconfig
        
        sizer = wx.BoxSizer(wx.VERTICAL)
        colsizer = wx.FlexGridSizer(cols = 1)

        self.list = MsgList(self, -1)

        cols = [ [0, _("Date/Time"), wx.LIST_FORMAT_LEFT, 110],
                 [1, _("Message"), wx.LIST_FORMAT_LEFT, 2000]
            ]

        info = wx.ListItem()
        info.m_mask = wx.LIST_MASK_TEXT | wx.LIST_MASK_FORMAT
        info.m_format = 0
        
        for c in cols:
            info.m_text = c[1]
            info.m_format = c[2]
            self.list.InsertColumnInfo(c[0], info)
            self.list.SetColumnWidth(c[0], c[3])
        
        colsizer.Add(self.list, 1, wx.EXPAND)
        
        colsizer.AddGrowableRow(0)
        colsizer.AddGrowableCol(0)
        
        sizer.Add(colsizer, 1, wx.EXPAND | wx.ALL)        
        self.SetSizer(sizer)
        self.SetAutoLayout(True)    
        self.Layout()
    
    
    def AddMsg(self, name, msg, err_type=0):
        ## unicode fix - ugly but works for now!
        if type(name) is StringType: #drop type gives unicodetype normal doesn't hence this check
            name = decodedata(name)

        if type(msg) is StringType: 
            msg = decodedata(msg)

        # msg types. 0=Normal, -1=Error from bt, -2=Error 
        t = localtime(time())
        timestamp = "%s" % (strftime("%x %X", t))

        item_idx = 0
        self.list.InsertStringItem(item_idx, timestamp)
        self.list.SetStringItem(item_idx, 1, "[%s] - %s" % (name, msg))
        self.list.SetItemData(item_idx, self.list.GetItemCount())
        item = self.list.GetItem(item_idx)
        
        if err_type == -1:
            item.SetBackgroundColour( self.btconfig.GetColor('mp_errormsg_b') )
            item.SetTextColour( self.btconfig.GetColor('mp_errormsg_f') )
        if err_type == -2:
            item.SetBackgroundColour( self.btconfig.GetColor('mp_errormsg_f') )
            item.SetTextColour( self.btconfig.GetColor('mp_errormsg_b') )
        elif err_type == 0:
            pass
            
        self.list.SetItem(item)
        self.list.itemDataMap[self.list.GetItemCount()] = "[%s] - %s" % (name, msg)


class TestFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, -1, 'Test', size = wx.Size(430, 350), style = wx.DEFAULT_FRAME_STYLE)
        panel = wx.Panel(self, -1, style = wx.NO_FULL_REPAINT_ON_RESIZE)
        self.ppp = MessagePanel(panel, BTConfig())
        
        testbutton1 = wx.Button(panel, 100, "test1")
        testbutton2 = wx.Button(panel, 101, "test2")
        wx.EVT_BUTTON(self, 100, self.OnButton)
        
        sizer = wx.FlexGridSizer(cols=1)
        sizer.Add(self.ppp, 1, wx.EXPAND)
        sizer.AddGrowableRow(0)
        sizer.AddGrowableCol(0)
        sizer.Add(testbutton1, 1)
        sizer.Add(testbutton2, 1)
        panel.SetSizer(sizer)
        panel.Layout()

        self.Show(True)
        
    def OnButton(self, event):
        self.ppp.AddMsg(u"test.torrent", u"This is a test this is a really fucking long error\n the error knows no limits! Oh wait here it is.", -1)
        
        
        
if __name__ == "__main__":
    _ = lambda x: x # needed for gettext
    app = wx.PySimpleApp()
    test = TestFrame()
    app.SetTopWindow(test)
    app.MainLoop()
    
