import string
import time
import thread
import threading
import os
class logger:
    def __init__(self, loglevel, mode, thread_list):
        self.loglevel=loglevel
        self.mode=mode
        self.thread_list = thread_list
        self.lock2=thread.allocate_lock()

    def start_logging(self, logdest):
        try:
            self.file=open(logdest, 'ab')#try to open the logfile, opening the file in binary-append modus
        except:
            self.ctime=self.get_time()
            print self.ctime+' ERROR: Could not open logfile!'

    def set_loglevel(self, loglevel):#specify a different loglevel
        self.lock2.acquire()
        self.loglevel = loglevel
        self.lock2.release()
        
    def stop_logging(self):#uhm, this should write a last entry to the logfile and then just close it. Did not use this function for along time...
        self.lock2.acquire()
        self.ctime=self.get_time()
        merk=self.ctime+' NORMAL: T0 - logger - Closing logfile and stoping logging!\n'
        if self.mode=='Both' or self.mode=='File':
            self.file.write(merk)
            self.file.flush()
        if self.mode=='Both' or self.mode=='Screen':
            print merk
        time.sleep(1)
        self.file.close()
        self.lock2.release()

    def add(self, instance, message, prefix):#add a message to the lof in the format "[time] [loglevel]: T[threadnumber] - [class] - [message]"
        self.lock2.acquire()
        ID = self.get_thread_id()
        if self.should_log(prefix)==1:
            self.ctime=self.get_time()
            if self.mode=='Both' or self.mode=='File':
                merk=self.ctime+' '+prefix+': '+' '*(7-len(prefix))+'T'+ID+' - '+instance+' - '+message+'\n'
                self.file.write(merk)
                self.file.flush()
                
            if self.mode=='Both' or self.mode=='Screen':
                merk=self.ctime+' '+prefix+': '+' '*(7-len(prefix))+'T'+ID+' - '+instance+' - '+message
                print merk
        self.lock2.release()
        
    def reg_thread(self):
        #assign the lowest free number to a thread using a "thread ident", generated by a internal Python function, as a identifier
        self.lock2.acquire()
        ID = thread.get_ident()
        number = 1
        while self.thread_list[1].count(str(number))==1:
            number = number + 1
        self.thread_list[0].append(ID)
        self.thread_list[1].append(str(number))
        self.lock2.release()

    def del_thread_reg(self):
        #delete the "thread ident" -> number reference, freeing the number of reuse by another thread
        self.lock2.acquire()
        ID = thread.get_ident()
        place = self.thread_list[0].index(ID)
        del self.thread_list[0][place]
        del self.thread_list[1][place]
        self.lock2.release()

    def set_log_mode(self, mode):#specify a different logmodus (logging to screen and/or file)
        self.mode=mode
        
    def should_log(self, prefix):#determines, if a prefix is above or below the specified loglevel
        if prefix=='ERROR':
            self.messagelevel=5
        elif prefix=='WARNING':
            self.messagelevel=4
        elif prefix=='NORMAL':
            self.messagelevel=3
        elif prefix=='INFO':
            self.messagelevel=2
        elif prefix=='DEBUG':
            self.messagelevel=1
        else:
            self.messagelevel=1
            self.ctime=self.get_time()
            print self.ctime+' ERROR: Wrong loglevel!'
        if self.messagelevel>=self.loglevel:
            return 1
        else:
            return 0

    def get_time(self):#formats the current time to something long but readable
        gtime=time.gmtime(time.time())
        gtime=list(gtime)
        for i in range(0, len(gtime)):
            gtime[i]=str(gtime[i])
        for i in range(1, 6):
            if len(gtime[i])==1:
                gtime[i]='0'+gtime[i]
        gtime=gtime[3]+':'+gtime[4]+':'+gtime[5]+' '+gtime[2]+'.'+gtime[1]+'.'+gtime[0]
        return gtime

    def get_thread_id(self):#gets a (hopefully) unique identifier for a thread
        Ident = thread.get_ident()
        index = self.thread_list[0].index(Ident)
        ID = self.thread_list[1][index]
        return ID

    def give_thread_number(self):#returns the number, which is assigned to a given thread ident
        self.lock2.acquire()
        Ident = thread.get_ident()
        index = self.thread_list[0].index(Ident)
        ID = self.thread_list[1][index]
        self.lock2.release()
        return ID
    
#five loglevels: Error, Warning, Normal, Info, Debug | Error=5
