#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        images.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/11/02
# RCS-ID:      $Id: images.py,v 1.5 2005/09/16 07:47:13 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE.TXT
#-----------------------------------------------------------------------------
from os.path import join, normpath
import os
import wx

class Images:
    def __init__(self, path = ""):
        wx.Image_AddHandler(wx.BMPHandler())
        wx.Image_AddHandler(wx.PNGHandler())
        wx.Image_AddHandler(wx.ICOHandler())
        self.LoadImages(path)
        
    image_list = [
                    #clear icon used as spacer in g3listctrls
                    ('blank.bmp', 0), 

                    #peerlist/friends panel
                    ('usergreen.png', 1), ('userblue.png', 1), ('userred.png', 1),

                    #masterlist icons
                    ('smile.png', 1), ('stop.bmp', 0), ('down.png', 1), ('pause.bmp', 0), ('info.bmp', 0),
                    ('conn16.png', 1),

                    #status bar
                    ('up16.png', 1), ('down16.png', 1), 

                    #toolbar
                    ('stop24.png', 1), ('bturl24.png', 1), ('btfile24.png', 1), ('remove24.png', 1),
                    ('upqueue24.png', 1), ('downqueue24.png', 1), ('config24.png', 1), ('resume24.png', 1), 
                    ('pause24.png', 1), ('toggle24.png', 1), ('new24.png', 1), ('folder24.png', 1), 
                    ('tab24.png', 1), ('smalldarrow.png', 1), ('search24.png', 1)
                    
                    ]
                    

    def LoadImages(self, path):
        images = {}
        print 'Loading Images ' + str(path)
    
        for filename, arg in self.image_list:
            if arg == 0:
                images[filename] = wx.Bitmap(join(path, normpath("images/%s" % filename)), wx.BITMAP_TYPE_BMP)
            elif arg == 1:
                images[filename] = wx.Bitmap(join(path, normpath("images/%s" % filename)), wx.BITMAP_TYPE_PNG)
            
        images['rufus.bmp'] = wx.Bitmap(join(path, normpath("images/rufus.ico")), wx.BITMAP_TYPE_ICO)
        images['rufus.ico'] = wx.Icon(join(path, normpath("images/rufus.ico")), wx.BITMAP_TYPE_ICO)
        images['g316.ico'] = wx.Icon(join(path, normpath("images/rufus.ico")), wx.BITMAP_TYPE_ICO)
        images['userblue.ico'] = wx.Icon(join(path, normpath("images/userblue.bmp")), wx.BITMAP_TYPE_BMP)
        images['systray.ico'] = wx.Bitmap(join(path, normpath("images/userblue.png")), wx.BITMAP_TYPE_PNG)


        flags = {}
        flagicons = os.listdir( join(path, normpath("images/flags/")) )
        for icon in flagicons:
            if len(icon.split('.')) > 1 and icon.split('.')[1] == 'ico':
                flags[icon.split('.')[0]] = wx.Icon(join(path, normpath("images/flags/%s" % icon)), wx.BITMAP_TYPE_ICO)

        images['flags'] = flags
        self.images = images
        
    def GetImage(self, key):
        if self.images.has_key(key):
            return self.images[key]
        else:
            return self.images['blank.bmp']

    def __getitem__(self, key):
        return self.GetImage(key)
