; Script generated with the Venis Install Wizard & modified by d0c

; Define your application name
!define APPNAME "I2PRufus"
!define VERSION "0.0.4"
!define APPNAMEANDVERSION "${APPNAME} ${VERSION}"

; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "$PROGRAMFILES\I2PRufus"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "I2PRufus_${VERSION}_win32_setup.exe"
BrandingText "${APPNAMEANDVERSION}"
; Use compression
SetCompressor LZMA

; Modern interface settings
!include "MUI.nsh"

!define MUI_ABORTWARNING
!define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_FINISHPAGE_RUN "$INSTDIR\I2PRufus.exe"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
Page custom GetIniData
Page custom FLocations
!insertmacro MUI_PAGE_INSTFILES
Page custom CreateFolders
Page custom UpdateConfig
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_RESERVEFILE_LANGDLL

LangString TEXT_FLocations_TITLE ${LANG_ENGLISH} "Choose Default Save Locations"
LangString TEXT_FLocations_SUBTITLE ${LANG_ENGLISH} "Choose the folders to save your downloads and torrents to."

ReserveFile "pathsetup.dat"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

Section "I2PRufus Core" Section1

  ; Set Section properties
  SetOverwrite on

  ; Clears previous error logs
  Delete "$INSTDIR\*.log"
	
  ; Set Section Files and Shortcuts
  SetOutPath "$INSTDIR\"
  File /r "dist\*"
	
SectionEnd

Section "File Association" section2
  ; Delete any existing keys
  DeleteRegKey HKCR "Applications\btdownloadgui.exe"
  DeleteRegKey HKCR "Applications\Azureus.exe"

  ; Write the file association
  WriteRegStr HKCR .torrent "" bittorrent
  WriteRegStr HKCR .torrent "Content Type" application/x-bittorrent
  WriteRegStr HKCR "MIME\Database\Content Type\application/x-bittorrent" Extension .torrent
  WriteRegStr HKCR bittorrent "" "TORRENT File"
  WriteRegBin HKCR bittorrent EditFlags 00000100
  WriteRegStr HKCR "bittorrent\shell" "" open
  WriteRegStr HKCR "bittorrent\shell\open\command" "" `"$INSTDIR\I2PRufus.exe" "%1"`
SectionEnd

Section "Start Menu Shortcuts" section3

  SetOutPath "$INSTDIR"
  CreateDirectory "$SMPROGRAMS\${APPNAME}"
  CreateShortCut "$SMPROGRAMS\${APPNAME}\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\${APPNAME}\${APPNAME}.lnk" "$INSTDIR\I2PRufus.exe" "" "$INSTDIR\I2PRufus.exe" 0

SectionEnd

Section "Desktop Shortcuts" section4

  CreateShortCut "$DESKTOP\${APPNAME}.lnk" "$INSTDIR\I2PRufus.exe" "" "$INSTDIR\I2PRufus.exe" 0
  
SectionEnd

Section -FinishSection

  WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
  WriteRegStr HKLM "Software\${APPNAME}" "Version" "${VERSION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
  WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${Section1} "I2PRufus program files"
!insertmacro MUI_DESCRIPTION_TEXT ${Section2} "Associate I2PRufus with .torrent file extension"
!insertmacro MUI_DESCRIPTION_TEXT ${Section3} "Create I2PRufus Start Menu shortcuts"
!insertmacro MUI_DESCRIPTION_TEXT ${Section4} "Create I2PRufus Desktop shortcut"	
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section "Uninstall"
  
  ; Remove file association registry keys
  DeleteRegKey HKCR .torrent
  DeleteRegKey HKCR "MIME\Database\Content Type\application/x-bittorrent"
  DeleteRegKey HKCR bittorrent
	
  ; Remove program/uninstall regsitry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
  DeleteRegKey HKLM SOFTWARE\${APPNAME}

  ; Remove files and uninstaller
  Delete $INSTDIR\I2PRufus.exe
  Delete $INSTDIR\w9xpopen.exe
  Delete $INSTDIR\*.pyd
  Delete $INSTDIR\*.dll
  Delete $INSTDIR\*.dat
  Delete $INSTDIR\*.txt
  Delete $INSTDIR\*.ini
  Delete $INSTDIR\*.log
  Delete $INSTDIR\*.ben
	
  Delete $INSTDIR\images\flags\*.ico
  RMDir "$INSTDIR\images\flags"

  Delete $INSTDIR\images\*.png
  Delete $INSTDIR\images\*.bmp
  Delete $INSTDIR\images\*.ico
  Delete $INSTDIR\images\*.txt
  RMDir "$INSTDIR\images"

  RMDir /r "$INSTDIR\locale"

  Delete $INSTDIR\uninstall.exe

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\${APPNAME}\*.*"

  ; Remove desktop icon
  Delete "$DESKTOP\${APPNAME}.lnk"

  ; Remove directories used
  RMDir "$SMPROGRAMS\${APPNAME}"
  RMDir "$INSTDIR"

SectionEnd

Function .onInit

  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "pathsetup.dat"

  ;This was written by Vytautas - http://nsis.sourceforge.net/archive/nsisweb.php?page=453
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "I2PRufus") i .r1 ?e' 
  Pop $R0 
  StrCmp $R0 0 +3 
    MessageBox MB_OK "The ${APPNAME} installer is already running." 
    Abort 

FunctionEnd

Function GetIniData

ReadRegStr $R0 HKLM "Software\${APPNAME}" ""
IfFileExists "$R0\btconfig.ini" 0 NoBTConfig
    ReadINIStr $R1 "$R0\btconfig.ini" "OPTIONS" "download_dir"
    ReadINIStr $R2 "$R0\btconfig.ini" "OPTIONS" "torrent_dir"
    ReadINIStr $R3 "$R0\btconfig.ini" "OPTIONS" "completed_dl_dir"
    ReadINIStr $R4 "$R0\btconfig.ini" "OPTIONS" "completed_tor_dir"

    StrCmp $R1 "" +2
        !insertmacro MUI_INSTALLOPTIONS_WRITE "pathsetup.dat" "Field 2" "State" $R1
    StrCmp $R2 "" +2
        !insertmacro MUI_INSTALLOPTIONS_WRITE "pathsetup.dat" "Field 4" "State" $R2
    NoBTConfig:

FunctionEnd

Function FLocations

  !insertmacro MUI_HEADER_TEXT "$(TEXT_FLocations_TITLE)" "$(TEXT_FLocations_SUBTITLE)"
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "pathsetup.dat"

  !insertmacro MUI_INSTALLOPTIONS_READ $R1 "pathsetup.dat" "Field 2" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $R2 "pathsetup.dat" "Field 4" "State"

FunctionEnd

Function CreateFolders

    StrCmp $R3 "" 0 +2
        StrCpy $R3 $R1
    StrCmp $R4 "" 0 +2
        StrCpy $R4 $R2

    ;creates directories... if they already exist this will do nothing
    IfFileExists "$R1\*.*" Check1
      CreateDirectory "$R1"
    Check1:
    IfFileExists "$R2\*.*" Check2
      CreateDirectory "$R2"
    Check2:
    IfFileExists "$R3\*.*" Check3
      CreateDirectory "$R3"
    Check3:
    IfFileExists "$R4\*.*" CreateDone
      CreateDirectory "$R4"
    CreateDone:

FunctionEnd

Function UpdateConfig

    ;Updates btconfig.ini
    WriteINIStr "$INSTDIR\btconfig.ini" "OPTIONS" "download_dir" "$R1"
    WriteINIStr "$INSTDIR\btconfig.ini" "OPTIONS" "completed_dl_dir" "$R3"
    WriteINIStr "$INSTDIR\btconfig.ini" "OPTIONS" "use_download_dir" "True"
    WriteINIStr "$INSTDIR\btconfig.ini" "OPTIONS" "torrent_dir" "$R2"
    WriteINIStr "$INSTDIR\btconfig.ini" "OPTIONS" "completed_tor_dir" "$R4"
    WriteINIStr "$INSTDIR\btconfig.ini" "OPTIONS" "use_torrent_dir" "True"

FunctionEnd

; eof