#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        g3widgets.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/23/02
# RCS-ID:      $Id: g3widgets.py,v 1.7 2005/09/16 07:41:10 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE
#-----------------------------------------------------------------------------
import wx
import sys
import time
import os.path
import locale

try:
    import cjkcodecs.aliases
except:
    pass
try:
    import iconv_codec
except:
    pass

from types import StringType
from btconfig import BTConfig
from p2pgauge import P2P_Gauge, Avail_Gauge
    
if sys.platform == "win32":   
    win32_flag = True
else:
    win32_flag = False

class NoteBook(wx.Notebook):
    def __init__(self, parent, images, updateguifunc, name, btconfig):
        wx.Notebook.__init__(self, parent, -1, size = (-1, -1))
        
        self.images = images
        self.UpdateGUI = updateguifunc
        self.name = name
        self.btconfig = btconfig
        if btconfig != None:
            self.cfg = btconfig.Get(name + "_cfg")
        else:
            self.cfg = None
        
        wx.EVT_NOTEBOOK_PAGE_CHANGING(parent, self.GetId(), self.TabChanging) 
        wx.EVT_NOTEBOOK_PAGE_CHANGED(parent, self.GetId(), self.TabChanged) 

        wx.EVT_COMMAND_RIGHT_CLICK(self, -1, self.OnPageRightClick) # wxMSW
        wx.EVT_RIGHT_UP(self, self.OnPageRightClick) # wxGTK
       
    def Populate(self, statuspanel, detailspanel, graphpanel, friendspanel, 
            msgpanel, rsspanel, statusbar):
        self.graphpanel = graphpanel
        self.statuspanel = statuspanel
        self.statusbar = statusbar
        
        bmps = self.images
        
        self.pages = [ 
                         [True, _("Status"), statuspanel],
                         [True, _("Details"), detailspanel],
                         [True, _("Graph"), graphpanel],
                         [True, _("Friends"), friendspanel],
                         [True, _("Messages"), msgpanel],
                         [True, _("RSS Reader"), rsspanel],
                     ]

        self.InsertPages(self.pages)

    def TabChanged(self, event):
        selection =  event.GetSelection()
        self.GetPage(selection).Show(True)
        if selection == 0:
            self.statuspanel.peerlist.SetColSort((None,None))
        if selection == 2:
            self.graphpanel.UpdateSize()
            self.graphpanel.UpdateGraph()
        if selection == 4:
            self.statusbar.SetStatus("       ")
        self.UpdateGUI()


    def TabChanging(self, event):
        if win32_flag:
            oldpage = event.GetOldSelection()
            if oldpage >= 0:
                self.GetPage(oldpage).Show(False)

    # begin d0c

    def SaveCfg(self):
        if self.btconfig == None:
            return
        
        if self.cfg == None:
            self.cfg = [0] * len(self.pages)

        i = 0
        for c in self.pages:
            self.cfg[i] = c[0]
            i += 1
        print self.cfg
        self.btconfig.Set(self.name + "_cfg", self.cfg)


    def InsertPages(self, pages):
        self.pages = pages
        i = 0
 
        if self.cfg and len(self.cfg) != len(pages):
            self.cfg = None

        for p in pages:
            if self.cfg == None:
                self.AddPage(p[2], p[1])
            else:
                p[0] = self.cfg[i]
                if p[0]:
                    self.AddPage(p[2], p[1])
                else:
                    p[2].Hide()
                i += 1 


    def OnPageRightClick(self, event):
        menu = wx.Menu()
        if not hasattr(self, "_pmenuId"):
            self._pmenuId = [0] * len(self.pages)
            for i in range(1, len(self.pages)):
                self._pmenuId[i] = wx.NewId()
                wx.EVT_MENU(self, self._pmenuId[i], self.OnPageMenuItemCheck)

        for i in range(1, len(self.pages)):
            if self.pages[i][1] != "":
                menu.Append(self._pmenuId[i], "%s" % self.pages[i][1], "", True)
                if self.pages[i][0]:
                    menu.Check(self._pmenuId[i], True)
        
        self.PopupMenu(menu, self.ScreenToClient(wx.GetMousePosition()))
        menu.Destroy()

    
    def OnPageMenuItemCheck(self, event):
        chk_idx = self._pmenuId.index( event.GetId() )

        found = False
        for i in range(1, self.GetPageCount()):
            info = self.GetPageText(i)

            if info == self.pages[chk_idx][1]:
                self.pages[chk_idx][2].Hide()
                self.RemovePage(i)
                found = True
                break

        if not found:
            slack = 0
            for i in range(1, chk_idx):
                if self.pages[i][0] == False and i < chk_idx: 
                    slack += 1
                        
            page_idx = chk_idx-slack

            title = self.pages[chk_idx][1]
            page = self.pages[chk_idx][2]
            self.InsertPage(page_idx, page, title)
            self.SetSelection(page_idx)
        
        self.pages[chk_idx][0] = not self.pages[chk_idx][0]
        self.SaveCfg()
#        wx.CallAfter(self._doResize)
#        wx.CallAfter(self.OnPaint)

    # end d0c
                
#================================================================================
#class AFToolBar(wx.ToolBar):
#    def __init__(self, parent, id=-1, size=wx.DefaultSize, style=(wx.TB_HORIZONTAL|wx.SIMPLE_BORDER|wx.TB_DOCKABLE)):
#        wx.ToolBar.__init__(self, parent, id, size = size, style = style)
#        wx.StaticLine(self, -1, pos = (96, 3), size = (2, 24), style = wx.LI_VERTICAL)
#        wx.StaticLine(self, -1, pos = (228, 3), size = (2, 24), style = wx.LI_VERTICAL)
#        wx.StaticLine(self, -1, pos = (298, 3), size = (2, 24), style = wx.LI_VERTICAL)
#        wx.EVT_SIZE(self, self.OnReSize)
#    
#    def OnReSize(self, event):
#        self.Refresh(False)
#        self.Update()
#================================================================================
        
#class SplitterWin(wx.SplitterWindow):
#    def __init__(self, parent, btconfig):
#        wx.SplitterWindow.__init__(self, parent, -1, style=wx.SP_NOBORDER )
#        wx.EVT_SIZE(self, self.OnReSize)
#        wx.EVT_SPLITTER_DCLICK(self, -1, self.OnToggleSplitter) 
#        
#        self.parent = parent
#        self.btconfig = btconfig
#        #if minpane is not large enough wxListCtrlAutoWidthMixin freaks out
#        self.SetMinimumPaneSize(100)
#    
#    def OnReSize(self, event):
#        event.Skip()
#        if self.GetSashPosition() > 0:
#            self.SetSashPosition(self.GetSashPosition())
#            
#    def OnToggleSplitter(self, event):
#        if self.GetSplitMode() == wx.SPLIT_HORIZONTAL:
#            self.SetSplitMode(wx.SPLIT_VERTICAL)
#            self.btconfig.Set('splitter_style', 1)
#        else:
#            self.SetSplitMode(wx.SPLIT_HORIZONTAL)
#            self.btconfig.Set('splitter_style', 0)
#
#        self.parent.SetSize((self.parent.GetSize()[0]+1, self.parent.GetSize()[1]))
#        self.parent.SetSize((self.parent.GetSize()[0]-1, self.parent.GetSize()[1]))       
                        
class StatusBar_wImages(wx.StatusBar):
    def __init__(self, parent, images):
        wx.StatusBar.__init__(self, parent, -1, style = wx.ST_SIZEGRIP)
        self.SetFieldsCount(5)
        self.SetStatusWidths([-1, 40, 100, 100, 120])
        self.upbmp = wx.StaticBitmap(self, -1, images.GetImage('up16.png'))
        self.downbmp = wx.StaticBitmap(self, -1, images.GetImage('down16.png'))
        wx.EVT_SIZE(self, self.OnSize) 
        self.OnSize()
        
    def SetStatus(self, msg):
        if type(msg) is StringType: 
            try:
                msg = msg.decode('utf-8')
            except:
                try:
                    msg = msg.decode(locale.getpreferredencoding())
                except:
                    msg = msg.decode(locale.getpreferredencoding(), 'replace')                               
        self.SetStatusText(msg, 0)
        self.SetStatusText(_("Totals:"), 1)      
        
    def SetDownRate(self, rate):
        self.SetStatusText("       %.1f KB/s" % rate , 2)
    
    def SetUpRate(self, rate):
        self.SetStatusText("       %.1f KB/s" % rate , 3)
            
    def SetSeedsTotal(self, stotal, ptotal):
        self.SetStatusText(" S: %.0f L: %.0f P: %.0f" % (stotal, (ptotal - stotal), ptotal), 4)
    
    def OnSize(self, event=None):
        rect = self.GetFieldRect(2)
        self.downbmp.SetPosition(wx.Point(rect.x+1, rect.y+1))
        rect = self.GetFieldRect(3)
        self.upbmp.SetPosition(wx.Point(rect.x+1, rect.y+1))
        
        
class BMSpinCtrl(wx.SpinCtrl): #d0c
    def __init__(self, parent, id=-1, value="", pos=wx.DefaultPosition, size=wx.DefaultSize, 
        style=wx.SP_ARROW_KEYS , min=0, max=100, initial=0, name="", lower=0, upper=3):
        wx.SpinCtrl.__init__(self, parent, id, value, pos, size, style, min, max, initial, name)
        self.lower = lower
        self.upper = upper

        wx.EVT_SPIN_UP(self, -1, self.OnSpinUp)
        wx.EVT_SPIN_DOWN(self, -1, self.OnSpinDown)
        wx.EVT_KILL_FOCUS(self, self.OnKillFocus)

    def OnSpinUp(self, event):
        sval = event.GetSelection()
        if sval > self.lower and sval < self.upper:
            self.SetValue(self.upper-1)
        event.Skip()
        
    def OnSpinDown(self, event):
        sval = event.GetSelection()
        if sval > self.lower and sval < self.upper:
            self.SetValue(self.lower)
        event.Skip()

    def OnKillFocus(self, event):
        sval = self.GetValue()
        if sval > self.lower and sval < self.upper:
            self.SetValue(self.lower)
        event.Skip()
    
