#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        g3taskbar.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/26/03
# RCS-ID:      $Id: g3taskbar.py
# Copyright:   (c) 2002
# Licence:     See G3.LICENSE.TXT
#-----------------------------------------------------------------------------
import wx
import sys
from md5 import md5

if sys.platform == "win32":   
    win32_flag = True
else:
    win32_flag = False

class G3TaskBar:
    def __init__(self):
        self.passdlg = None
        if win32_flag:
            wx.EVT_ICONIZE(self, self.OnMinimize)
        self.tbicon = wx.TaskBarIcon()
        
    def CreateIcon(self):
        gauge = self.btconfig.g_colors['tb_down_color']
        requested = self.btconfig.g_colors['tb_up_color']
        nothave = self.btconfig.g_colors['g_nothave_color']
        
        bmp = self.images.GetImage('systray.ico')
        dc = wx.BufferedDC(None, bmp)
        dc.BeginDrawing()
        dc.SetPen(wx.Pen(gauge, 0, wx.TRANSPARENT))
        
        try:
            dwn_fraction = self.total_drate / self.btconfig.Get('net_max_downrate')
            up_fraction = self.total_urate / self.btconfig.Get('net_max_uprate')
        except ZeroDivisionError:
            dwn_fraction = 0
            up_fraction = 0
                       
        # left side - downloads
        dc.SetBrush(wx.Brush(nothave,wx.SOLID))
        dc.DrawRectangle(0, 0, 3, 16 )
        
        dc.SetBrush(wx.Brush(gauge,wx.SOLID))
        h = int(16*min(1,dwn_fraction))
        dc.DrawRectangle(0, 16-h, 3, h)
        
        # right side - uploads
        dc.SetBrush(wx.Brush(nothave,wx.SOLID))
        dc.DrawRectangle(13, 0, 3, 16 )
        
        dc.SetBrush(wx.Brush(requested,wx.SOLID))
        h = int(16*min(1,up_fraction))
        dc.DrawRectangle(13, 16-int(16*min(1,up_fraction)), 3, h)
        
        dc.EndDrawing()

        dc = None
        icon = wx.Icon('', wx.BITMAP_TYPE_BMP)
        icon.CopyFromBitmap(bmp)
        return icon

    def OnTaskBarPopup(self, event):
        menu = wx.Menu()
        if not hasattr(self, '_tbpopupid'):
            _tbpopupid = [0] * 2
            _tbpopupid[0] = wx.NewId()
            _tbpopupid[1] = wx.NewId()
            wx.EVT_MENU(self.tbicon, _tbpopupid[0], self.OnTaskBarActivate)
            wx.EVT_MENU(self.tbicon, _tbpopupid[1], self.OnClose)
        menu.Append(_tbpopupid[0], _("Restore"), "", False)
        menu.Append(_tbpopupid[1], _("Quit"), "", False)    
        self.tbicon.PopupMenu(menu)
        
    def OnTaskBarActivate(self, event=None):
        if not self.CheckPass():
            return
        
        if not self.btconfig.Get('fixedtrayicon'):
            self.tbicon.RemoveIcon()
        else:
            self.tbicon.SetIcon(self.images.GetImage('rufus.ico'))
        if self.IsIconized():
            self.Iconize(False)
            self.total_drate = 0
            self.total_urate = 0
#            self.UpdateIcon()
        if not self.IsShown():
            self.Show(True)
        self.Raise()
        self.UpdateGUI()
    
    def OnMinimize(self, event):
        if not event.Iconized():
            self.OnTaskBarActivate()
            return
        
        icon = self.CreateIcon()

        if self.btconfig.Get('usesystray'):
            if not self.tbicon.IsIconInstalled():
                self.tbicon.SetIcon(icon, "I2PRufus")
                wx.EVT_TASKBAR_LEFT_DCLICK(self.tbicon, self.OnTaskBarActivate)
                wx.EVT_TASKBAR_RIGHT_DOWN(self.tbicon, self.OnTaskBarPopup)
            self.Hide()
        else:
            self.Iconize(True)  # Iconize seems to retrigger wx.EVT_ICONIZE
    

    def UpdateIcon(self):
        icon = self.CreateIcon()
        if self.tbicon.IsIconInstalled():
            self.tbicon.SetIcon(icon, "I2PRufus\n(%.0fKB/s:Dn - %.0fKB/s:Up)\n[S: %.0f - L: %.0f - P: %.0f]" % (self.total_drate/1024, self.total_urate/1024, self.stotal, (self.ptotal-self.stotal) , self.ptotal))
        else:
            self.SetIcon(icon)

    def CheckPass(self, msgtype=None):
        if not win32_flag: #Returns true if not windows platform (for compat)
            return True
        
        if self.passdlg: #don't create another dialog if one is already present - set dialog focus instead (if poss)
            try:
                self.passdlg.SetFocus()
            except:
                pass
            return

        def repr_md5(str): #used to convert md5 digest into string representation
            return "%02x"*len(str) % tuple(map(ord, str))
        	
        if msgtype == "quit":
            msg = _("Enter password to allow application shutdown")
        else:
            msg = _("Enter password to restore from system tray")

        if self.btconfig.Get('tray_pass') and self.IsIconized() and self.btconfig.Get('tray_pass_enabled'):

            self.passdlg = PassDlg(self, msg)
            self.passdlg.SetIcon(self.images.GetImage('rufus.ico'))
            try:
                dlgresult = None
                errcount = 0
                while dlgresult != wx.ID_CANCEL and errcount < 3:
                    dlgresult = self.passdlg.ShowModal()
                    if dlgresult == wx.ID_OK:
                        answer = self.passdlg.GetValue()
                        if not repr_md5(md5(answer.encode('utf-8')).digest()) == self.btconfig.Get('tray_pass'):
                            print errcount 
                            errcount = errcount + 1
                            errdlg = wx.MessageDialog(self, _("Incorrect Password"), _("Password Error"), wx.OK | wx.ICON_ERROR)
                            errdlg.ShowModal()
                            errdlg.Destroy()
                        else:
                            return True
                else:
                    return False
            finally: 
                self.passdlg.Destroy()
        else:
            return True

class PassDlg(wx.Dialog): #had to create a custom password dialog as default was problematic
    def __init__(self, parent, msg):
        wx.Dialog.__init__(self, parent, title = _("Password Protected"), style = wx.DEFAULT_DIALOG_STYLE|wx.STAY_ON_TOP)
        self.label1 = wx.StaticText(self, -1, msg)
        self.edit1 = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD)
        self.staticline1 = wx.StaticLine(self, -1)
        self.OKbutt = wx.Button(self, wx.ID_OK)
        self.OKbutt.SetDefault()
        self.Cancelbutt = wx.Button(self, wx.ID_CANCEL)
        self.SetFocus()

        pass_sizer = wx.FlexGridSizer(4, 1, 0, 0)
        buttsizer = wx.FlexGridSizer(1, 2, 0, 0)
        pass_sizer.Add(self.label1, 0, wx.LEFT|wx.RIGHT|wx.TOP|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 12)
        pass_sizer.Add(self.edit1, 0, wx.ALL|wx.EXPAND, 8)
        pass_sizer.Add(self.staticline1, 0, wx.LEFT|wx.RIGHT|wx.BOTTOM|wx.EXPAND, 4)
        buttsizer.Add(self.OKbutt, 0, wx.ALL|wx.ALIGN_RIGHT|wx.FIXED_MINSIZE, 4)
        buttsizer.Add(self.Cancelbutt, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        buttsizer.AddGrowableCol(0)
        buttsizer.AddGrowableCol(1)
        pass_sizer.Add(buttsizer, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(pass_sizer)
        pass_sizer.Fit(self)
        pass_sizer.SetSizeHints(self)
        pass_sizer.AddGrowableCol(0)
        self.Layout()
        self.Centre()

    def GetValue(self):
        return self.edit1.GetValue()
    	
