#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        g3rpcclient.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/20/02
# RCS-ID:      $Id: g3rpcclient.py,v 1.3 2005/08/28 00:25:52 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE
#-----------------------------------------------------------------------------
from xmlrpclib import ServerProxy
from g3peerid import *
from traceback import print_exc
from base64 import encodestring
from btconfig import BTConfig
from threading import Thread
import socket

class RequestThread(Thread):

    def __init__(self, requestfunc, param):

        Thread.__init__(self)

        self.done = 0

        self.requestfunc = requestfunc
        self.param = param
        ##self.setDaemonic(True)
        
    def run(self):
        print 'starting thread'
        try:

            self.requestfunc(self.param)
        except socket.error, msg:
            print msg

        self.done = 1
        print 'thread ending'

class T_G3RPCCLient:
    def __init__(self, btconfig, ip="127.0.0.1"): ## needs to be updated in similar way to G3RPCCLient if ever used...
        self.server = ServerProxy("http://%s:%s" % (ip, btconfig.Get('web_interface_port')))
        
    def Announce(self, ip, peerid, port, infohash):
        try:
            t = RequestThread(self.server.FriendAnnounce, [ encodestring(peerid), port, encodestring(infohash)])
            t.start()
        except:
            print_exc()
            pass
        
    def Renounce(self, ip, peerid, port, infohash):
        print 'in Rennounce'
        try:
            t = RequestThread(self.server.FriendRenounce, [ encodestring(peerid), port, encodestring(infohash)])
            t.start()
        except:
            print_exc()
            pass

    def AddTorrent(self, responsefile):
        try:
            self.server.AddTorrent(responsefile)
        except:
            pass
        
            
class G3RPCCLient:
    def __init__(self, path = "", ip="127.0.0.1"):
        self.btconfig = BTConfig(path)
        self.btconfig.LoadOptions()
        self.server = ServerProxy("http://%s:%s" % (ip, self.btconfig.Get('web_interface_port')))

    def Announce(self, peerid, port, infohash):
        try:
            self.server.FriendAnnounce([ encodestring(peerid), port, encodestring(infohash)])
        except:
            pass
        
    def Renounce(self, peerid, port, infohash):
        try:
            self.server.FriendRenounce([ encodestring(peerid), port, encodestring(infohash)])
        except:
            pass

    def AddTorrent(self, responsefile):
        try:
            self.server.AddTorrent(responsefile)
        except:
            pass
        
def test_announce(client):
    client.Announce("-G3g3rmz000000000000", 6881, "GARRYYYYYYYYYYYYYYYY")
    client.Announce("-G3g3rmz000000000000", 6882, "BARRYYYYYYYYYYYYYYYY")
    client.Announce("-G3g3rmz000000000000", 6883, "MARRYYYYYYYYYYYYYYYY")

    ##client.Renounce("-G3g3rmz000000000000", 6881, "GARRYYYYYYYYYYYYYYYY")
    ##client.Renounce("-G3g3rmz000000000000", 6882, "BARRYYYYYYYYYYYYYYYY")
    ##client.Renounce("-G3g3rmz000000000000", 6883, "MARRYYYYYYYYYYYYYYYY")

if __name__ == "__main__":
    g = T_G3RPCCLient(argv[1])
    test_announce(g)
