#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        g3peerid.py
# Purpose:     
#
# Author:      d0c54v4g3, Jeremy Arendt
#
# Created:     2004/24/02
# RCS-ID:      $Id: g3peerid.py,v 1.8 2005/09/12 22:36:18 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE
#-----------------------------------------------------------------------------

from sys import argv

try:
    from mhash import MHASH, MHASH_SHA1
    mhash_flag = True
except:
    from sha import sha
    mhash_flag = False

from time import time
from os import getpid
from binascii import b2a_hex
from BitTorrent import version

def GetPeerName(peerid):
    #extracts name string from peerid
    def decodename(name_data):
        name_str = ""
        for c in name_data:
            if c != chr(0) and c.isalnum():
                name_str += c
            else:
                break 
        return name_str

    if peerid and len(peerid) == 20:
        if peerid[1:3] == "G3":
            return decodename(peerid[3:12])

        # BitMagnet 
        elif peerid[2:4] == "BM":
            return decodename(peerid[4:13])

        # Rufus                         to catch bitspirit with BT mode on
        elif peerid[2:4] == "RS" and peerid[14:20] != "HTTPBT" and peerid[16:20] != "UDP0": 
            for c in peerid[4:13]: 
                if c.isalnum() or c == chr(0):
                    rufus_chk = True
                else:
                    rufus_chk = False
                    break
            if rufus_chk:
                return decodename(peerid[4:13])
     
        # eXeem 
        elif peerid[:2] == "eX":
            return decodename(peerid[2:19])
    
    return ''
    
def GetClientName(peerid):
    if peerid == None or len(peerid) < 20:
        return "No Peerid Given"

    if peerid[1:3] == "G3":
        return "G3 Torrent"

    if peerid[:3] == "-MP":
        return StdDecodePeerId(peerid[3:10],"MooPolice ")
  
    #BitSpirit - d0c
    if peerid[14:20] == "HTTPBT" or peerid[16:20] == "UDP0":
        if peerid[2:4] == "BS":
            if peerid[1] == chr(0):  return "BitSpirit v1"
            if peerid[1] == chr(2):  return "BitSpirit v2"
        return "BitSpirit "

    #BitMagnet 
    if peerid[2:4] == "BM":
        return "BitMagnet " + DecodeVersionString(peerid[0:2])

    #Rufus 
    if peerid[2:4] == "RS":
        for c in peerid[4:13]: 
            if c.isalnum() or c == chr(0):
                rufus_chk = True
            else:
                rufus_chk = False
                break

        if rufus_chk:
            return "I2PRufus " + DecodeVersionString(peerid[0:2])

    #Experimental 3.2.1b2 - d0c
    if (peerid[:12] == (chr(0)*12)) and (peerid[12] == chr(97)) and (peerid[13] == chr(97)):
        return "Experimental 3.2.1b2"

    #Mainline BitTorrent - d0c
    if (peerid[:12] == (chr(0)*12)):
        return "I2P-Bt"
    
    #I2PSnark
    if (peerid[:9] == (chr(0)*9)):
        print 'Woot?'
        print peerid
        print '"'
        for i in range(0, len(peerid)):
            print peerid[i]
        print '"'
        print chr(0)*9
        return "I2PSnark"

    #Burst! - d0c 
    if peerid[:5] == "Mbrst":
        return MainlineDecodePeerId(peerid[5:10],"Burst! ") 

    #Mainline with version - d0c
    if peerid[:1] == "M":
        return MainlineDecodePeerId(peerid[1:8],"I2P-Bt ") 

    #MLDonkey - d0c
    if peerid[:3] == "-ML":
        return MainlineDecodePeerId(peerid[3:8],"MLDonkey ") 

    #unidentified clients with versions
    #-PO0001-
    #-UR0112-
        return StdDecodePeerId(peerid[3:10],"PO Client ") 
    if peerid[:3] == "-UR":
        return StdDecodePeerId(peerid[3:10],"UR Client ")
    if peerid[:3] == "-S2":
        return StdDecodePeerId(peerid[3:10],"S2 Client ")  
    if peerid[:3] == "-TR":
        return StdDecodePeerId(peerid[3:10],"TR Client ")  
    #unidentified clients with versions end
    
    
    if peerid[:3] == "-AR":
        return StdDecodePeerId(peerid[3:10],"Arctic ") 

    if "Azureus" in peerid:
        return "Azureus 2.0.3.2"

    if peerid[:3] == "-AZ":
        return StdDecodePeerId(peerid[3:10],"Azureus ") 

    if peerid[:1] == "S":
        return StdDecodePeerId(peerid[1:10],"Shad0w ") 
        
    if peerid[:1] == "T":
        return StdDecodePeerId(peerid[1:10],"BitTornado ") 

    if peerid[:1] == "A":
        return StdDecodePeerId(peerid[1:10],"ABC ") 

    if peerid[:3] == "-MT":
        return StdDecodePeerId(peerid[3:10],"Moonlight ") 

    if peerid[:1] == "U":
        return StdDecodePeerId(peerid[1:10],"UPnP ") 

    if peerid[:3] == "-LT":
        return StdDecodePeerId(peerid[3:10],"libtorrent ") 

    if peerid[:3] == "-BX":
        return StdDecodePeerId(peerid[3:10],"Bittorrent X ") 

    if peerid[:3] == "-TS":
        return StdDecodePeerId(peerid[3:10],"Torrentstorm ") 

    if peerid[:2] == "BG":
        return StdDecodePeerId(peerid[2:6],"BTGetit ") 

    if peerid[:4] == "-BOW":
        return StdDecodePeerId(peerid[4:9],"Bits on Wheels ") 

    if peerid[:9] == "270------":
        return StdDecodePeerId(peerid[:3],"GreedBT ") 

    if peerid[:3] == "-ZT":
        return StdDecodePeerId(peerid[3:10],"ZipTorrent ") 

    if peerid[:3] == "-BC":
        return StdDecodePeerId(peerid[3:10],"BitComet ") 

    if peerid[:3] == "-SZ":
        return StdDecodePeerId(peerid[3:10],"Shareaza ") 

    if peerid[:3] == "-KT":
        return StdDecodePeerId(peerid[3:10],"KTorrent ")

    if peerid[:3] == "-UT":
        return StdDecodePeerId(peerid[3:10],"uTorrent ") 
    
    #end d0c
        
    if peerid[:3] == "-TN":
        return StdDecodePeerId(peerid[3:10],"TorrentDotNET ")
        
    if peerid[:3] == "-SS":
        return StdDecodePeerId(peerid[3:10],"SwarmScope ")
        
    if peerid[:3] == "-BS":
        return StdDecodePeerId(peerid[3:10],"BTSlave ")
        
    if peerid[:3] == "-lt":
        return StdDecodePeerId(peerid[3:10],"libTorrent ")
        
    if peerid[:2] == "OP":
        return "Opera"   
   
    if peerid[:4] == "Plus":
        return "Plus! II"

    #BitComet/BitLord/BitVampire/Modded FUTB BitComet - d0c
    if peerid[:4] == "exbc" or peerid[1:4] == "UTB":
        version_str = ""
        if peerid[:4] == "FUTB":
            return "BitComet Mod1 " + DecodeVersionString(peerid[4:6])
        elif peerid[:4] == "xUTB":
            return "BitComet Mod2 " + DecodeVersionString(peerid[4:6])
        elif peerid[6:10] == "LORD":
            return "BitLord " + DecodeVersionString(peerid[4:6])
        elif peerid[6:9] == "---" and version_str == "0.54":
        	return "BitVampire 1.3.1"
        else:
            return "BitComet " + DecodeVersionString(peerid[4:6])  

    #BitSpirit - d0c
    if peerid[2:4] == "BS":
        if peerid[1] == chr(0):  return "BitSpirit v1"
        if peerid[1] == chr(2):  return "BitSpirit v2"
        return "BitSpirit"

    #XanTorrent - d0c
    if peerid[:10] == "DansClient":
        return "XanTorrent" 

    #TorrentTopia - d0c TODO: workout version from peerid
    if peerid[:9] == "346------":
        return "TorrentTopia v1.70" 

    #TorrenTres - d0c TODO: workout version from peerid
    if peerid[:8] == "XTORR302":
        return "TorrenTres 0.0.2" 

    #TurboBT - d0c
    if peerid[:7] == "turbobt":
        return "TurboBT " + peerid[7:10]

    #XBT - d0c
    if peerid[:3] == "XBT":
        version_str = peerid[3] + '.' + peerid[4] + '.' + peerid[5]
        return "XBT " + version_str[:len(version_str)]

    #Ctorrent - d0c
    if peerid[:3] == "-CT":
        version_str = peerid[3] + '.' + peerid[4] + '.' + peerid[6]
        return "Ctorrent " + version_str[:len(version_str)]

    #eXeem beta - d0c           
    if peerid[:3] == "-eX":
        version_str = ""
        version_str += str(int(peerid[3], 16)) + '.'
        version_str += str(int(peerid[4], 16))
        return "eXeem " + version_str[:len(version_str)]

    #eXeem beta .21 - d0c           
    if peerid[:2] == "eX":
        return "eXeem"

    #BitBuddy - d0c
    if peerid[:3] == "-BB":
        version_str = peerid[3] + '.' + peerid[4:7]
        return "BitBuddy " + version_str[:len(version_str)]

    #Shareaza - d0c
    shareaza = True
    for c in peerid[:15]:
        if c == chr(0):
            shareaza = False
            break
    for i in range(16,len(peerid)):
        if shareaza:
             if ord(peerid[i]) != (ord(peerid[i % 16]) ^ ord(peerid[15 - (i % 16)])):
                shareaza = False
                break
    if shareaza:
        return "Shareaza"

    #Deadman client - d0c
    if peerid[:16] == "Deadman Walking-":
        return "Deadman"

     #Ruby Torrent 
    if peerid[:7] == "rubytor":
        version_str = str(ord(peerid[7]))
        return "Ruby Torrent v" + version_str[:len(version_str)]
    
    return "Unknown client"

def GetRawPeerid(peerid):
    version_str = ""
    for c in peerid[0:20]:
        if c.isalnum():
            version_str += c
        else:
            version_str += '-'
   
    return version_str

def CreatePeerId(nick = ""):
    nick = str(nick) # Sanity check.
    nick = nick.encode('utf-8')
    if len(nick) == 0:
        mynick = "Unnamed" + (chr(0) * 2)
    elif len(nick) > 9:
        mynick = nick[:9]
    elif len(nick) < 9:
        mynick = nick + (chr(0) * (9 - len(nick)))
    else:
        mynick = nick    

    ver_0 = int(version[0])
    ver_1 = int(version[2] + version[4])
    
    if mhash_flag:       
        peerid = chr(ver_0)+chr(ver_1)+'RS' + mynick +  MHASH(MHASH_SHA1, (repr(time()) + ' ' + str(getpid()))).digest()[-7:]
    else:        
        peerid = chr(ver_0)+chr(ver_1)+'RS' + mynick + sha(repr(time()) + ' ' + str(getpid())).digest()[-7:]
        
    return peerid


def StdDecodePeerId(id_data, id_name):
    version_str = ""
    for c in id_data:
        if id_name == "BitTornado ":
            if c != '-' and c.isdigit():
                version_str += (c + '.')
            elif c != '-' and c.isalpha():
               version_str += (str(ord(c)-55) + '.')
            else:
               break
        else:
            if c != '-' and c.isalnum():
                version_str += (c + '.')
            else:
                break
                   
    return id_name + version_str[:len(version_str)-1]

def MainlineDecodePeerId(id_data, id_name):
    version_str = ""
    for c in id_data:
        if c != '-' and c.isalnum():
            version_str += (c + '.')
                   
    return id_name + version_str[:len(version_str)-1]

def DecodeVersionString (ver_data):
    version_str = ""
    version_str += str(ord(ver_data[0])) + '.'
    version_str += str(ord(ver_data[1])/10)  + '.'
    version_str += str(ord(ver_data[1])%10)
    return version_str[:len(version_str)]

if __name__ == '__main__':
    print CreatePeerId("d0c54v4g3")
    print CreatePeerId("Anonymous"), len(CreatePeerId("Anonymous"))
    print GetPeerName(CreatePeerId("Anonymous"))
    print GetClientName(CreatePeerId("d0c54v4g3"))

    ##NEW TEST PEERID DATA## - d0c
    #Mainline 3.4.2       0   1   2   3   4   5   6   7   8   9   10  11  12  13  14  15  16  17  18  19 
    print "*Mainline 3.4.2*"
    print GetClientName('\x4D\x33\x2D\x34\x2D\x32\x2D\x2D\x34\x50\x77\x19\x9F\xAE\xC4\xA6\x73\xBE\xCA\x01')
    #MainLine BitTorrent http://www.bittorrent.com
    print "*MainLine BitTorrent*"
    print GetClientName('\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4C\x53\x44\x19\x33\x10\x42\x77')
    #BitSpirit v2 http://www.lanspirit.net/
    print "*BitSpirit v2*"
    print GetClientName('\x00\x02\x42\x53\x07\x2A\xDB\x18\x34\x50\x77\x19\x9F\xAE\xC4\xA6\x73\xBE\xCA\x01')
    #Shareaza http://www.shareaza.com
    print "*Shareaza*"
    print GetClientName('\x8A\x92\x36\xB1\x67\x33\x5B\xDA\xAF\xCC\x85\x34\x5D\x59\x49\xAA\x20\xDB\x6F\xEC')
    print GetClientName('\x95\xAD\x85\x2D\x0A\x2C\x6B\xFD\x3C\x97\xEB\x23\x15\xE5\x68\x59\xCC\xC5\x60\x38')
    #Shareaza 2.1.3.2 new peer id (not real packet) http://www.shareaza.com
    print "*Shareaza with version ident*"
    print GetClientName('\x2D\x53\x5A\x32\x31\x33\x32\x2D\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00')
    #ABC 2.6.9 http://pingpong-abc.sourceforge.net
    print "*ABC 2.6.9*"
    print GetClientName('\x41\x32\x36\x39\x2D\x2D\x2D\x2D\x34\x50\x77\x19\x9F\xAE\xC4\xA6\x73\xBE\xCA\x01')
    #BitComet 0.56
    print "*BitComet 0.56*"
    print GetClientName('\x65\x78\x62\x63\x00\x38\x7A\x44\x63\x10\x2D\x6E\x9A\xD6\x72\x3B\x33\x9F\x35\xA9')
    #BitComet 0.0.5.9 - LeoXV http://www.bitcomet.com
    print "*BitComet 0.0.5.9*"
    print GetClientName('\x2D\x42\x43\x30\x30\x35\x39\x2D\x36\x77\x66\x47\x32\x77\x6B\x36\x77\x57\x4C\x63')
    #Azureus 2.2.0.0 http://azureus.sourceforge.net/
    print "*Azureus 2.2.0.0*"
    print GetClientName('\x2D\x41\x5A\x32\x32\x30\x30\x2D\x36\x77\x66\x47\x32\x77\x6B\x36\x77\x57\x4C\x63')
    #Burst! 1.1.3 http://krypt.dyndns.org:81/torrent/
    print "*Burst! 1.1.3*"
    print GetClientName('\x4D\x62\x72\x73\x74\x31\x2D\x31\x2D\x33\x61\x32\x30\x34\x38\x39\x33\x30\x33\x31')
    #Shad0w 5.8.B
    print "*Shad0w 5.8.B*"
    print GetClientName('\x53\x35\x38\x42\x2D\x2D\x2D\x2D\x2D\x7A\x78\x70\x70\x52\x4C\x4E\x48\x42\x6F\x35')
    #Experimental 3.2.1b2 http://ei.kefro.st/projects/btclient/
    print "*Experimental 3.2.1b2*" 
    print GetClientName('\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x61\xD2\x31\x4F\x4C\x62\xBA')
    #XanTorrent http://www.xantorrent.pwp.blueyonder.co.uk
    print "*XanTorrent*"
    print GetClientName('\x44\x61\x6E\x73\x43\x6C\x69\x65\x6E\x74\x20\x26\x4E\x2A\x12\x0B\xFB\xD1\xC4\x72')
    #XBT 0.3.6 http://xbtt.sourceforge.net
    print "*XBT 0.3.6*"
    print GetClientName('\x58\x42\x54\x30\x33\x36\x2D\x2D\x61\x31\x6A\x71\x63\x71\x66\x53\x36\x44\x35\x66')
    #BitMagnet 0.3.1 http://bitmagnet.sourceforge.net/ (previous name for Rufus)
    print "*BitMagnet 0.3.1*"
    print GetClientName('\x00\x1f\x42\x4d\x64\x30\x63\x35\x34\x76\x34\x67\x33\x34\xf4\x3d\x98\x23\x06\x62')
    print GetPeerName('\x00\x1f\x42\x4d\x64\x30\x63\x35\x34\x76\x34\x67\x33\x34\xf4\x3d\x98\x23\x06\x62')
    #eXeem beta 0.10 http://www.exeem.com/
    print "*eXeem beta 0.10*"
    print GetClientName('\x2D\x65\x58\x30\x41\x30\x30\x2D\x79\x4C\x72\x6A\x31\x6B\x48\x6A\x4C\x45\x33\x62')
    #eXeem beta 0.12 http://www.exeem.com/
    print "*eXeem beta 0.12*"
    print GetClientName('\x2D\x65\x58\x30\x43\x30\x30\x2D\x59\x4C\x29\x7A\x4E\x5A\x33\x7A\x30\x6E\x27\x73')
    #eXeem beta 0.13 http://www.exeem.com/
    print "*eXeem beta 0.13'"
    print GetClientName('\x2D\x65\x58\x30\x44\x30\x30\x2D\x67\x70\x21\x2E\x59\x52\x39\x50\x29\x45\x67\x45')
    #eXeem beta 0.14 http://www.exeem.com/
    print "*eXeem beta 0.14*"
    print GetClientName('\x2D\x65\x58\x30\x45\x30\x30\x2D\x6A\x49\x56\x45\x43\x6E\x76\x42\x68\x59\x51\x56')
    #BitBuddy 0.961 http://www.softpedia.com/get/Internet/File-Sharing/BitBuddy.shtml
    print "*BitBuddy 0.961*"
    print GetClientName('\x2D\x42\x42\x30\x39\x36\x31\x2D\x54\x42\x37\x6A\x4A\x5F\x67\x2D\x6F\x55\x47\x66')
    #TorrenTres 0.0.2 http://developer.berlios.de/projects/torrentres/
    print "*TorrenTres 0.0.2*" 
    print GetClientName('\x58\x54\x4F\x52\x52\x33\x30\x32\x2D\xC8\xB2\x84\xCC\x6C\x0F\xD0\xFE\xCD\x46\x5B')
    #TorrentTopia 1.70 http://www.torrentopia.org/
    print "*TorrentTopia 1.70*"
    print GetClientName('\x33\x34\x36\x2D\x2D\x2D\x2D\x2D\x2D\x6E\x2E\x4B\x7A\x65\x46\x50\x30\x6E\x56\x68')
    #TurboBT 5.0 http://turbobt.sourceforge.net/
    print "*TurboBT 5.0*"
    print GetClientName('\x74\x75\x72\x62\x6F\x62\x74\x35\x2E\x30\x2E\x30\xD1\xA5\x27\xD4\x52\x0D\x7E\x3E')
    #BitSpirit v 2.6.3 http://www.lanspirit.net/
    print "*BitSpirit v 2.6.3*"
    print GetClientName('\x00\x00\x00\x00\x00\x00\x00\x00\x70\x98\x28\xCC\x22\xB7\x48\x54\x54\x50\x42\x54')
    #BitSpirit v 2.7.3 http://www.lanspirit.net/
    print "*BitSpirit v 2.7.3*" 
    print GetClientName('\x00\x00\x00\x00\x00\x00\x00\x00\x70\x98\x28\xCC\x22\xB7\x48\x54\x54\x50\x42\x54')
    #UDP0 Bitspirit http://www.lanspirit.net/
    print "*UDP0 Bitspirit*"
    print GetClientName('\x00\x1F\x42\x4D\x41\x6E\x6F\x6E\x2E\x27\xC2\x67\x9C\xC3\xA9\xF8\x55\x44\x50\x30')
    #Deadman
    print "*Deadman*"
    print GetClientName('\x44\x65\x61\x64\x6D\x61\x6E\x20\x57\x61\x6C\x6B\x69\x6E\x67\x2D\x36\x35\x5A\x56')
    #BTGetit 0.7.0.8 http://www.btgetit.com/
    print "*BTGetit 0.7.0.8*"
    print GetClientName('\x42\x47\x30\x37\x30\x38\x58\x01\xE8\xCA\x76\x5B\xA7\x8C\x7D\x0B\xBE\xCB\x3D\xB2')
    #eXeem 2.1 - name http://www.exeem.com/
    print "*eXeem 2.1 - name*"
    print GetPeerName('\x65\x58\x64\x30\x63\x35\x34\x76\x34\x67\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00')
    #eXeem 2.1 - client detection http://www.exeem.com/
    print "*eXeem 2.1 - client detection*"
    print GetClientName('\x65\x58\x64\x30\x63\x35\x34\x76\x34\x67\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00')
    #Bits on Wheels Preview Release 0.3? http://www.bitsonwheels.com
    print "*Bits on Wheels Preview Release 0.3?*"
    print GetClientName('\x2D\x42\x4F\x57\x50\x30\x33\x2D\x30\x30\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36')
    #BitLord 0.56 http://www.bitlord.com/
    print "*BitLord 0.56*"
    print GetClientName('\x65\x78\x62\x63\x00\x38\x4C\x4F\x52\x44\x32\x00\x04\x8E\xCE\xD5\x7B\xD7\x10\x28')
    #BitComet 0.56
    print "*BitComet 0.56*"
    print GetClientName('\x65\x78\x62\x63\x00\x38\x2A\x8A\x6B\x37\x6D\x84\xBD\xCF\x82\x8C\x25\x9B\x07\x04')
    #Ctorrent 1.3.4 http:\\ctorrent.sourceforge.net
    print "*Ctorrent 1.3.4*"
    print GetClientName('\x2D\x43\x54\x31\x33\x30\x34\x2D\x9C\x74\x41\xCE\xD7\x3E\x6E\x98\x41\x1F\x67\xD7')
    #BitVampire 1.3.1 (spoofs BitComet 0.54 with extra '---')
    print "*BitVampire 1.3.1 (spoofs BitComet 0.54 with extra '---')*"
    print GetClientName('\x65\x78\x62\x63\x00\x36\x2D\x2D\x2D\x55\x21\xE5\xF0\x3A\x78\xC3\x3F\x54\x21\xF1')
    #BitTorrent Plus! 2 RC10 http://www.bitwonder.com/
    print "*BitTorrent Plus! 2 RC10*"
    print GetClientName('\x50\x6C\x75\x73\x31\x32\x52\x31\x30\x2D\x66\x4E\x36\x6E\x69\x32\x41\x7A\x4F\x4B')
    #BitSpirit 2 HTTPBT http://www.lanspirit.net/
    print "*BitSpirit 2 HTTPBT*" 
    print GetClientName('\x00\x02\x42\x53\x9B\x7E\xD3\xE0\x58\xA8\x38\x4A\xA7\x48\x48\x54\x54\x50\x42\x54')
    #GreedBT 2.7.0
    print "*GreedBT 2.7.0*"
    print GetClientName('\x32\x37\x30\x2D\x2D\x2D\x2D\x2D\x2D\x68\x34\x69\x66\x4B\x7A\x4B\x6E\x4A\x4F\x50')
    #BitTornado 0.3.10 http://www.bittornado.com
    print "*BitTornado 0.3.10*"
    print GetClientName('\x54\x30\x33\x41\x2D\x2D\x2D\x2D\x2D\x63\x51\x37\x4B\x58\x48\x42\x4E\x73\x32\x64')
    #BitComet 0.56 http://www.bitcomet.com/
    print "*BitComet 0.56*"
    print GetClientName('\x65\x78\x62\x63\x00\x39\x2A\x8A\x6B\x37\x6D\x84\xBD\xCF\x82\x8C\x25\x9B\x07\x04')
    #ZipTorrrent 1.2.1.0 http://www.ziptorrent.com/
    print "*ZipTorrrent 1.2.1.0*"
    print GetClientName('\x2D\x5A\x54\x31\x32\x31\x30\x2D\x6C\x61\x42\x7A\x46\x38\x37\x35\x38\x54\x61\x79')
    #Azureus 2.0.3.2 http://azureus.sourceforge.net/
    print "*Azureus 2.0.3.2*"
    print GetClientName('\x2D\x2D\x2D\x2D\x2D\x41\x7A\x75\x72\x65\x75\x73\x54\x69\x4E\x7A\x2A\x64\x54\xA7')
    #MooPolice  1.0.2.38  (fake BitSpirit UDP0) http://www.moopolice.de/
    print "*MooPolice  1.0.2.38  (fake BitSpirit UDP0)*"
    print GetClientName('\x2d\x4d\x50\x31\x30\x32\x5d\x2d\xc7\x75\xeb\x16\x54\x55\x5f\xa0\x55\x44\x50\x30')
    #MooPolice 1.0.2 http://www.moopolice.de/
    print "*MooPolice 1.0.2*"
    print GetClientName('\x2d\x4d\x50\x31\x30\x32\x5d\x2d\xc7\x75\xeb\x16\x54\x2d\x2d\x2d\x2d\x2d\x2d\x2d')
    #KTorrent v1.0.0.0 http://ktorrent.pwsp.net/
    print "*KTorrent 1.0.0.0*"
    print GetClientName('\x2D\x4B\x54\x31\x30\x30\x30\x2D\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00')    
    #MLDonkey 2.6.3 http://www.mldonkey.net/
    print "*MLDonkey 2.6.3*"
    print GetClientName('\x2D\x4D\x4C\x32\x2D\x36\x2D\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00')
    #utorrent 1.1.0.0 http://www.utorrent.com
    print "*uTorrent*"
    print GetClientName('\x2D\x55\x54\x31\x31\x30\x30\x2D\xFB\xD3\x12\x64\xB4\x35\xC3\x4F\xD7\x16\x2C\x6C')
    #Ruby Torrent v0 http://rubytorrent.rubyforge.org
    print "*Ruby Torrent v0*"
    print GetClientName('\x72\x75\x62\x79\x74\x6f\x72\x00\x84\xBD\x6B\x37\x41\x1F\x8A\x44\x16\x6E\x74\x55') 

    #Patched clients
    #BitComet Mod 0.57 (FUTB)
    print "*BitComet Mod 0.57 (FUTB)*"
    print GetClientName('\x46\x55\x54\x42\x00\x39\x2A\x8A\x6B\x37\x6D\x84\xBD\xCF\x82\x8C\x25\x9B\x07\x04')
    #BitComet Mod 0.57 (xUTB)
    print "*BitComet Mod 0.57 (xUTB)*"
    print GetClientName('\x78\x55\x54\x42\x00\x39\x2A\x8A\x6B\x37\x6D\x84\xBD\xCF\x82\x8C\x25\x9B\x07\x04')

    #unknown clients (actual packets)
    print "-s20060- Unknown Client"
    print GetClientName('\x2D\x53\x32\x30\x30\x36\x30\x2D\x2F\x74\x20\xA2\xE5\xD7\xAE\xCC\xD1\x90\xE7\x6F')
    #-TR0003-
    print "-TR0003- Unknown Client"
    print GetClientName('\x2D\x54\x52\x30\x30\x30\x33\x2D\x69\x77\x6C\x79\x6B\x72\x37\x79\x64\x6C\x31\x73')
    
    #unknown clients (not actual packet bytes!)
    #-PO0001-
    print "-PO0001- Unknown Client"
    print GetClientName('\x2D\x50\x4F\x30\x30\x30\x31\x2D\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00')
    #-UR0112-
    print "-UR0112- Unknown Client"
    print GetClientName('\x2D\x55\x52\x30\x31\x31\x32\x2D\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00')    
        
##    http://www.lookuptables.com/  ASCII table
