#-----------------------------------------------------------------------------
# Name:        friendspanel.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/28/01
# RCS-ID:      $Id: friendspanel.py,v 1.3 2005/08/10 19:31:11 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE.TXT
#-----------------------------------------------------------------------------
import wx
from wx.lib.mixins.listctrl import ListCtrlAutoWidthMixin
from traceback import print_exc
from btconfig import BTConfig
from images import Images
from friend import Friend, MyFriend, FriendList
import time
import re

class FriendsListCtrl(wx.ListCtrl, ListCtrlAutoWidthMixin):
    def __init__(self, parent, bmps = None, pos=wx.DefaultPosition, size=wx.DefaultSize,
                 style = wx.LC_REPORT | wx.LC_VRULES, onselectfunc=None):
        wx.ListCtrl.__init__(self, parent, -1, pos, size, style)
        ListCtrlAutoWidthMixin.__init__(self)
        self.itemDataMap = {}
        
        self.OnSelect = onselectfunc
        
        if bmps == None:
            bmps = Images()
        
        self.images = [1] * 4
        self.i_list = wx.ImageList(16, 16)
        mask_color = wx.Color(255,255,255)
        b_mask_color = wx.Color(0,0,0)
        self.images[0] = self.i_list.AddWithColourMask(bmps.GetImage('blank.bmp'), b_mask_color)
        self.images[1] = self.i_list.AddWithColourMask(bmps.GetImage('usergreen.png'), b_mask_color)
        self.images[2] = self.i_list.AddWithColourMask(bmps.GetImage('userblue.png'), b_mask_color)
        self.images[3] = self.i_list.AddWithColourMask(bmps.GetImage('userred.png'), b_mask_color)
        self.SetImageList(self.i_list, wx.IMAGE_LIST_SMALL)

        self.col2sort = 1
        self.last_selected = -1
        
        info = wx.ListItem()
        info.m_mask = wx.LIST_MASK_TEXT | wx.LIST_MASK_FORMAT
        info.m_format = 0
        
        info.m_text = _("Name")
        self.InsertColumnInfo(0, info)
        #I2P: changed "IP Address" to "Destination
        info.m_text = _("Destination")
        self.InsertColumnInfo(1, info)

        info.m_text = _("Status")
        self.InsertColumnInfo(2, info)
       
        info.m_text = _("Files")
        self.InsertColumnInfo(3, info)
        
        info.m_text = _("Total ULed")
        self.InsertColumnInfo(4, info)
        
        info.m_text = _("Total DLed")
        self.InsertColumnInfo(5, info)

        info.m_text = _("Type")
        self.InsertColumnInfo(6, info)
        
        self.SetColumnWidth(0, 100)
        self.SetColumnWidth(1, 100)
        self.SetColumnWidth(2, 70)
        self.SetColumnWidth(3, 50)
        self.SetColumnWidth(4, 80)
        self.SetColumnWidth(5, 80)
        self.SetColumnWidth(6, 200)
        
        wx.EVT_LIST_ITEM_FOCUSED(self, -1, self.OnFocusChange)
        wx.EVT_LIST_ITEM_SELECTED(self, -1, self.OnFocusChange)
        wx.EVT_LIST_ITEM_DESELECTED(self, -1, self.OnFocusChange)      

    def OnFocusChange(self, event):
        if self.last_selected != event.m_itemIndex and event.m_itemIndex != -1:
            self.last_selected = event.m_itemIndex
            key = self.GetItemData(event.m_itemIndex)
            if self.itemDataMap.has_key(key):
                self.OnSelect(self.itemDataMap[key])

    def GetSelectedData(self):
        if self.GetFirstSelected() != -1:
            return self.GetItemData( self.GetFirstSelected() )
        else:
            return None

    def GetSelectedIPs(self):
        selected = []
        
        index = self.GetFirstSelected()
        while index != -1:
            key = self.GetItemData(index)
            try:
                ip = self.itemDataMap[key][1]
                selected.append(ip)
            except:
                pass
            index = self.GetNextSelected(index)
            
        return selected
                
    def GetSelectedIP(self):
        key = self.GetSelectedData()
        if key == None:
            return None
        try:
            return self.itemDataMap[key][1]
        except:
            return None
    
    def Reset(self):
        self.DeleteAllItems()
        
    def FriendsPopulate(self, friends):
        self.itemDataMap = {}
        
        for f in friends:
            data = hash(f.ip)
            
            ip = f.ip
            if f.online: 
                status = _("online")
            else: 
                status = _("offline")
            
            if f.type and not f.temp:
                type = _("Peer I added as friend")
                name = f.name
            elif f.type and f.temp:
                type = _("Peer I have given temporary upload preference")
                name = f.ip
            else:
                type = _("Peer claiming to be a friend")
                name = f.name
            
            nfiles = "%d" % len(f.sharedfiles)
            total_up = "%d" % f.total_up
            total_down = "%d" % f.total_down
            
            item_idx = self.FindItemData(-1, data)
            if item_idx < 0:
                item_idx = self.GetItemCount()
                self.InsertStringItem(item_idx, name)
            else:
                self.SetStringItem(item_idx, 0, name)

            self.SetStringItem(item_idx, 1, ip)
            self.SetStringItem(item_idx, 2, status)
            self.SetStringItem(item_idx, 3, nfiles)
            self.SetStringItem(item_idx, 4, total_up)
            self.SetStringItem(item_idx, 5, total_down)
            self.SetStringItem(item_idx, 6, type)
            self.SetItemData(item_idx, data)
            
            self.itemDataMap[data] = [name, ip, status, nfiles, total_up, total_down, type]
            
            item = self.GetItem(item_idx)
            item.m_mask = wx.LIST_MASK_IMAGE
            
            pl_bgcolor = wx.SystemSettings_GetColour(wx.SYS_COLOUR_WINDOW)
            
            if f.type and f.online:
                item.SetBackgroundColour(pl_bgcolor)
                item.m_image = self.images[1]
            elif f.type and not f.online:
                item.SetBackgroundColour(pl_bgcolor)
                item.m_image = self.images[2]
            elif not f.type:
                item.SetBackgroundColour(pl_bgcolor)
                item.m_image = self.images[3]
                
            self.SetItem(item)
        
        item = self.GetNextItem(-1)
        i = 0
        while i < self.GetItemCount() and item != -1:
            nextitem = self.GetNextItem(item)
            data = self.GetItemData(item)
            
            if self.itemDataMap.has_key(data) == False:
                self.DeleteItem(item)
            else:
                item = nextitem
                i+=1

    def FoesPopulate(self, foes):
        self.itemDataMap = {}
        
        for f in foes:
            data = hash(f.ip)
            
            ip = f.ip
            status = ""
            
            if f.temp:
                type = _("Temp ban")
                name = f.name
            else:
                type = _("Permanent ban")
                name = f.name
           
            nfiles = ""
            total_up = "0"
            total_down = "0"
            
            item_idx = self.FindItemData(-1, data)
            if item_idx < 0:
                item_idx = self.GetItemCount()
                self.InsertStringItem(item_idx, name)
            else:
                self.SetStringItem(item_idx, 0, name)

            self.SetStringItem(item_idx, 1, ip)
            self.SetStringItem(item_idx, 2, status)
            self.SetStringItem(item_idx, 3, nfiles)
            self.SetStringItem(item_idx, 4, total_up)
            self.SetStringItem(item_idx, 5, total_down)
            self.SetStringItem(item_idx, 6, type)
            self.SetItemData(item_idx, data)
            
            self.itemDataMap[data] = [name, ip, status, nfiles, total_up, total_down, type]
            
            item = self.GetItem(item_idx)
            item.m_mask = wx.LIST_MASK_IMAGE
            
            pl_bgcolor = wx.SystemSettings_GetColour(wx.SYS_COLOUR_WINDOW)
            
            item.SetBackgroundColour(pl_bgcolor)
            item.m_image = self.images[3]
                            
            self.SetItem(item)
        
        item = self.GetNextItem(-1)
        i = 0
        while i < self.GetItemCount() and item != -1:
            nextitem = self.GetNextItem(item)
            data = self.GetItemData(item)
            
            if self.itemDataMap.has_key(data) == False:
                self.DeleteItem(item)
            else:
                item = nextitem
                i+=1
                
class FriendsPanel(wx.Panel):
    def __init__(self, parent, btconfig, friends, bmps=None):
        wx.Panel.__init__(self, parent, -1)
        self.btconfig = btconfig
        self.friends = friends
        self.list_mode = True  #True: Friends, #False: Foes
        
        self.list = FriendsListCtrl(self, bmps, onselectfunc=self.OnSelect)
        self.addbutt = wx.Button(self, 100, _("Add Friend"), size=(80,20))
        self.removebutt = wx.Button(self, 101, _("Remove Friend"), size=(80,20))
        self.editname = wx.TextCtrl(self, -1, "", size=(80,20))
        self.editip = wx.TextCtrl(self, -1, "", size=(100,20))
        label1 = wx.StaticText(self, -1, _("name:"))
        #I2P: renamed the label from "Ip" to "Destination"
        label2 = wx.StaticText(self, -1, _("Destination:"))
        
        sizer = wx.FlexGridSizer(cols = 1)
        buttons = wx.FlexGridSizer(cols = 9, hgap=4)
        
        combo_id = wx.NewId()
        #I2P: renamed occuring "IPs" to "Dests"
        self.combo1 = wx.ComboBox(self, combo_id, size = wx.Size(150, 20),
            choices = [_(u"Friends - Prefered Dests"), _(u"Foes - Banned Dests")], 
            style=wx.CB_READONLY )

        #I2P: renamed occuring "IPs" to "Dests"
        self.combo1.SetValue( _(u"Friends - Prefered Dests") )
        wx.EVT_COMBOBOX(self, combo_id, self.OnComboSelect) 
        
        buttons.Add(self.combo1, 1)
        buttons.Add( (10,-1) )
        buttons.Add(self.removebutt, 1)
        buttons.Add(self.addbutt, 1)
        buttons.Add((8,-1))
        buttons.Add(label1 , 1, wx.TOP, 3)
        buttons.Add(self.editname , 1)
        buttons.Add(label2 , 1, wx.TOP, 3)
        buttons.Add(self.editip , 1)
        
        sizer.Add(buttons, 1, wx.EXPAND)
        sizer.Add(self.list, 1, wx.EXPAND)
        sizer.AddGrowableCol(0)
        sizer.AddGrowableRow(1)
        
        wx.EVT_BUTTON(self, 100, self.OnAdd)
        wx.EVT_BUTTON(self, 101, self.OnRemove)
        
        self.SetSizer(sizer)
        self.Layout()
        self.list.FriendsPopulate(self.friends)
        
    def OnComboSelect(self, event):
        
        if self.list_mode:
            self.addbutt.SetLabel(_("Add Foe"))
            self.removebutt.SetLabel(_("Remove Foe"))
            #I2P: renamed occuring "IPs" to "Dests"
            self.combo1.SetValue(_("Foes - Banned Dests"))
            self.list_mode =  0
        else:
            self.addbutt.SetLabel(_("Add Friend"))
            self.removebutt.SetLabel(_("Remove Friend"))
            #I2P: renamed occuring "IPs" to "Dests"
            self.combo1.SetValue(_("Friends - Prefered Dests"))
            self.list_mode = 1
            
        self.list.Reset()
        self.Update()

        
    def OnAdd(self, event):
        #I2P: remove IP check, we don't use IPs
        #ip = re.compile("(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)") 
        #ip_match = ip.match( self.editip.GetValue() )       
        #if ip_match == None:
        #    return
        #/I2P
        #I2P: Ip kann direkt ausgelesen werden. Newline wird entfernt
        ip = (self.editip.GetValue())[0:-1]
        #I2P: Add check for a valid destination
        print 'IP: "'+ip+'"'
        print 'LEN:',len(ip)
        print 'bla:',ip[(len(ip)-4):len(ip)]
        if not (len(ip)==516 and ip[(len(ip)-4):len(ip)]=='AAAA'):
            return
        #/I2P
        
        #Debug
        #print self.editname.GetValue()
        #print ip
        
        if self.list_mode == True:
            self.friends.AddFriend(ip, self.editname.GetValue(), True, False)
            self.list.FriendsPopulate(self.friends.friends)
        else:
            self.friends.AddFoe(ip, self.editname.GetValue(), False)
            self.list.FoesPopulate(self.friends.foes)
        
        self.friends.Save()
        self.editname.SetValue("")
        self.editip.SetValue("")


    def OnRemove(self, event):
        if self.list_mode:
            for ip in self.list.GetSelectedIPs():
                if ip != None:
                    self.friends.RemoveByIP(ip)
            self.list.FriendsPopulate(self.friends.friends)
        else:
            for ip in self.list.GetSelectedIPs():
                if (ip != None):
                    self.friends.RemoveFoe(ip)
            
            self.list.FoesPopulate(self.friends.foes)
            
        self.friends.Save()
        
        
    def Update(self):
        if self.list_mode == True:
            self.list.FriendsPopulate(self.friends.friends)
        else:
            self.list.FoesPopulate(self.friends.foes)
    
    def OnSelect(self, data):
        self.editname.SetValue(data[0])
        self.editip.SetValue(data[1])
        
#---------------------------------------------------------------------------

if __name__ == "__main__":
    _ = lambda x: x # needed for gettext
    app = wx.PySimpleApp()
    frame = wx.Frame(None, -1, '')
    btconfig = BTConfig()
    fl = FriendList(btconfig)
    fl.Load()
    p = FriendsPanel(frame, BTConfig(), fl)

    p.Show(True)
    frame.Show(True)
    app.MainLoop()



