#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        btconfig.py
# Purpose:
#
# Author:      Jeremy Arendt
#
# Created:     2004/28/01
# RCS-ID:      $Id: btconfig.py 
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE.TXT
#-----------------------------------------------------------------------------

from os.path import join, exists, curdir
from traceback import print_exc
import ConfigParser
import wx
from types import *
import sys
import os
import os.path

if sys.platform == "win32":   
    win32_flag = True
else:
    win32_flag = False

class BTConfig:
    g_colors = {
        'g_have_color'      : wx.Color(0,128,255),
        'g_requested_color' : wx.Color(255,180,0),
        'g_nothave_color'   : wx.Color(190,210,240),
        'g_overall_color'   : wx.Color(0,230,0),
        'g_text_color'      : wx.Color(255,255,255),
               
        'tb_up_color'       : wx.Color(255,180,0),
        'tb_down_color'     : wx.Color(0,230,0),

        'ml_checking'       : wx.Color(0,0,50),
        'ml_complete'       : wx.Color(0,128,255),
        'ml_seeding'        : wx.Color(0,150,0),
        'ml_paused'         : wx.Color(64,64,100),
        'ml_stopped'        : wx.Color(0,0,0),
        'ml_downloading'    : wx.Color(0,0,0),
        
        'mp_errormsg_f'     : wx.Color(50,20,10),
        'mp_errormsg_b'     : wx.Color(255,255,230),

        'gp_bgcolor'        : wx.Color(255,255,255),
        'gp_grapharea_b'    : wx.Color(190,210,240),
        'gp_grapharea_f'    : wx.Color(100,100,140),
        'gp_hbars'          : wx.Color(100,100,140),
        'gp_total_drate1'   : wx.Color(0,153,0),
        'gp_total_urate1'   : wx.Color(255,180,0),
        'gp_sel_drate1'     : wx.Color(62,154,222),
        'gp_sel_urate1'     : wx.Color(255,255,153),
        'default'           : wx.Color(255,255,255),

        # default const colours that are used for colour reset funcs

        'def_g_have_color'      : wx.Color(0,128,255),
        'def_g_requested_color' : wx.Color(255,180,0),
        'def_g_nothave_color'   : wx.Color(190,210,240),
        'def_g_overall_color'   : wx.Color(0,230,0),
        'def_g_text_color'      : wx.Color(255,255,255),

        'def_tb_up_color'       : wx.Color(255,180,0),
        'def_tb_down_color'     : wx.Color(0,230,0),

        'def_ml_checking'       : wx.Color(0,0,50),
        'def_ml_complete'       : wx.Color(0,128,255),
        'def_ml_seeding'        : wx.Color(0,150,0),
        'def_ml_paused'         : wx.Color(64,64,100),
        'def_ml_stopped'        : wx.Color(0,0,0),
        'def_ml_downloading'    : wx.Color(0,0,0),
        
        'def_mp_errormsg_f'     : wx.Color(50,20,10),
        'def_mp_errormsg_b'     : wx.Color(255,255,230),

        'def_gp_bgcolor'        : wx.Color(255,255,255),
        'def_gp_grapharea_b'    : wx.Color(190,210,240),
        'def_gp_grapharea_f'    : wx.Color(100,100,140),
        'def_gp_hbars'          : wx.Color(100,100,140),
        'def_gp_total_drate1'   : wx.Color(0,153,0),
        'def_gp_total_urate1'   : wx.Color(255,180,0),
        'def_gp_sel_drate1'     : wx.Color(62,154,222),
        'def_gp_sel_urate1'     : wx.Color(255,255,153),
        'def_default'           : wx.Color(255,255,255)
    }

    avail_lang = {
        'en'    : "English",
        'h4'    : "H4x0r",
    }

    def __init__(self, path = curdir, btdownload = None):        
        if win32_flag:
            torrent_dir = join(path, "torrents")
            download_dir = join(path, "incoming")
            completed_dl_dir  = join(path, "incoming\\completed")
            completed_tor_dir = join(path, "torrents\\completed")
            resume_data_dir = join(path, "resumedata")
            use_torrent_dir = False
            use_download_dir = False
        else:
            torrent_dir = join(os.path.expanduser('~/Rufus'), "torrents")
            download_dir = join(os.path.expanduser('~/Rufus'), "incoming")
            completed_dl_dir  = join(os.path.expanduser('~/Rufus'), "incoming/completed")
            completed_tor_dir = join(os.path.expanduser('~/Rufus'), "torrents/completed")
            resume_data_dir = join(os.path.expanduser('~/Rufus'), "resumedata") 
            use_torrent_dir = True
            use_download_dir = True
        self.config = {
            'gui_update_rate': 1,
            'splitter_style': 0,
            'on_complete'   : 2,    #0: stop only queue>0, 1: stop on cust option, 2: keep sharing, 3: stop
            'toggle_toolbar': False,
        
            'end_on_percent': False,
            'end_on_ratio'  : False,
            'end_on_timelimit' : False,
            'end_on_newrate': False,
            'end_percent'   : 1.50,
            'end_ratio'     : 1,
            'end_timelimit' : 5000,
            'end_newrate'   : 0,

            'max_sessions'  : 7,
            'popup_errors'  : False,
            'maxuploads'    : 6,
            'maxupspeed'    : 0,
            'max_initiate'  : 35,
            'max_connections' : 55,
            'avg_peer_urate': 15,
            'path'          : path,
            'use_global_urate': True,
            'total_max_uprate' : 0,
            'total_max_downrate' : 0,
            'net_max_uprate' : 102400,   #kbps
            'net_max_downrate': 102400,  #kbps
            'minport'       : 6881,
            'maxport'       : 6999,
            'bind_address'  : None,
            'ip_2report'    : None,
            'choker'        : 0,
            'choke_period'  : 10,
            'opt_choke_period' : 30,
            'choke_minrate' : 0.0,
            'nickname'      : "Anonymous",
            'load_completed'  :  True,
            
            'torrent_dir'   : (torrent_dir),
            'download_dir'  : (download_dir),
            'completed_dl_dir'  : (completed_dl_dir),
            'completed_tor_dir' : (completed_tor_dir),
            'use_torrent_dir'   : (use_torrent_dir),
            'use_download_dir'  : (use_download_dir),
            'tdir_scan'     : 120,

            #fast resume settings
            'resume_data_dir'  : (resume_data_dir),
            'use_resume_dir'  : True,
            
            'splitterpos'   : 120,
            'clientsize'    : (750,480),
            'clientpos'     : (-1,-1),
            'maximized'     : False,
            'fixedtrayicon'   : False,
            'usesystray'    : True,
            'confirmexit'   : False,
            
            'PeerList_cfg'  : None,
            'MasterList_cfg': None,
            'DLOrderMngr2_cfg' : None,
            'TrackerMngr_cfg' : None,
            'RSSList_cfg'   : None,
            'MainNotebook_cfg'   : None,
            
            'file_ranges'   : [],
            'random_order'  : True,
            'torrent_state' : 0,    #0:Running, 1:Paused, 2:Stopped

            #I2P: reverse_dns isn't supported anymore                       
            # 'reverse_dns'   : True,
            #/I2P
            'sort_list'     : False,
            #I2P: flags aren't supported anymore 
            #'country_flags' : True,
            #/I2P
            # Peer window mini gauge
            'p_gauge_type'    : False, #False:pieces, True:percentage
            # Torrent window mini gauge
            't_gauge_type'    : False, #False:pieces, True:percentage

            'max_hashflunks': 5,
            'max_trkrflunks': 5,
            
            'use_web_interface': False,
            'show_add_URL': False,
            'web_interface_port': 7007,
            'web_interface_pass': "password",
            'always_check_hashes': False,
            
            'use_multimngr': True,
            'show_pane2': True,
            
            'pre_allocate'      : 1,
            'choke_udban'       : 3,
            'choke_activate'    : 1,
            'choke_multiplier'  : 1,

            #I2P: unneeded, we don't support version checking
            ## Update Settings
            #'ud_on_start'       : True,
            #'ud_hourly'         : False,
            #'ud_rate'           : 4,
            #/I2P
             
            # Language defaults to English
            'lang_pref'         : "en",

            # Debug Tracker
            'dbg_tracker'       : False,

            # Branding options
            'cust_title'        : None,
            'cust_home'         : None,
            'cust_img'          : None,

            # Tray Password
            'tray_pass'         : None,
            'tray_pass_enabled' : False,

            # Moving torrent on pause/resume
            'resume_move'       : False,
            'pause_move'        : False,

            #I2P: Options for SAM/eep-proxy
            #SAM
            'sam_ip'            : "127.  0.  0.  1",
            'sam_port'          : 7656,

            #eep-proxy
            'eep_ip'            : "127.  0.  0.  1",
            'eep_port'          : 4444,
            #/I2P
            #i2p: Log options
            'loglevel'          : 3,
            #I2P: SAM concurrent connection attempts
            'sim_conn_attempts'   : 1,
            #I2P: SAM sessionname
            'sessionname'       : 'I2PRufus',
            #I2P: SAM Tunnel options
            'inb_quantity'       : '2',
            'inb_backQuan'       : '0',
            'inb_length'       : '2',
            'inb_lengthVar'       : '-1',
            'inb_allowZero'       : True,
            'out_quantity'       : '2',
            'out_backQuan'       : '0',
            'out_length'       : '2',
            'out_lengthVar'       : '-1',
            'out_allowZero'       : True
        }
        
        
        if win32_flag:
            self.config_file = join(path, "btconfig.ini")
        else:
            self.config_file = join(os.path.expanduser('~/.Rufus'), 'btconfig.ini')
        
        self.btdownload = btdownload

    def __getitem__(self, param):
        try:
            return self.config[param]
        except:
            print_exc()
            return None

    def __setitem__(self, param, value):
        try:
            self.config[param] = value
        except:
            print_exc()
            return None
                
    def Get(self, param):
        try:
            return self.config[param]
        except:
            print_exc()
            return None

    def Set(self, param, value):
        try:
            self.config[param] = value
        except:
            print_exc()
            return None
        return value

    def GetColor(self, name):
        try:
            return self.g_colors[name]
        except:
            return self.g_colors['default']
    
    def SetColor(self, name, color):
        try:
            self.g_colors[name] = color
        except:
            pass

    def MirrorOptions(self, btconfig):
        self.g_colors = btconfig.g_colors

        for param in self.config:
            if param == 'use_torrent_dir' or\
               param == 'use_torrent_dir' or\
               param == 'download_dir' or\
               param == 'torrent_dir' or \
               param == 'completed_dl_dir' or\
               param == 'completed_tor_dir' or \
               param == 'random_order' or \
               param == 'file_ranges':
                continue
            else:
                self.Set(param, btconfig.Get(param))
                
        self.SyncOptions()
    
    def Clone(self):
        btconfig = BTConfig()
        for param in self.config:
            if param == 'file_ranges' or\
               param == 'random_order':
                continue
            else:
                btconfig.Set(param, self.Get(param))
        
        return btconfig
    
    def Inject(self, params):
        try:
            for key, value in params.items():
                self.Set(key, value)
        except:
            print_exc()
            pass
        
    def Setbtdownload(self, btdownload):
        self.btdownload = btdownload

    def GetColor_AsStr(self, key):
        c = self.g_colors[key]
        return '[' + str(c.Red()) + ',' + str(c.Green()) + ',' + str(c.Blue()) + ']'
    
    def GetLang(self):
        return self.avail_lang

    def SyncOptions(self, btdownload = None):
        #print 'Syncing Options'
        if btdownload != None:
            self.btdownload = btdownload
                                     
        if self.btdownload != None:
            try:
                if not self.config['use_global_urate']:
                    self.btdownload.SetMaxUpSpeed(self.config['maxupspeed'] * 1024)
                else:
                    self.btdownload.SetMaxUpSpeed(0)
                    
                self.btdownload.SetMaxUploads(self.config['maxuploads'])
                self.btdownload.SetMaxInitiate(self.config['max_initiate'])
                self.btdownload.SetMaxAllowIn(self.config['max_connections'])
                self.btdownload.SelectChoker(self.config['choker'], self.config['choke_period'], 
                        self.config['opt_choke_period'], self.config['choke_minrate'], self.config['choke_udban'], self.config['choke_activate'], self.config['choke_multiplier'])
            except AttributeError:
                print 'Error while syncing options'
                
                
    def LoadOptions(self):
        if exists(self.config_file) == False:
            return
        
        #print "Loading config file: %s" % self.config_file
        cp = ConfigParser.ConfigParser()
        file = open(self.config_file, 'r')
        cp.readfp(file)
        
        try:
            if (cp.has_section('COLORS')):
                for color in self.g_colors:
                    try:
                        c = eval( cp.get('COLORS', color) )
                        self.g_colors[color] = wx.Color(c[0], c[1], c[2])
                    except:
                        pass

            if (cp.has_section('LANG')):
                self.avail_lang = {}
                for i, j in cp.items('LANG'):
                    try:
                        self.avail_lang[i] = j
                    except:
                        pass

            if (cp.has_section('OPTIONS')):
                for param in self.config:
                    try:
                        p = cp.get('OPTIONS', param)
                        try:
                            self.config[param] = eval(p)
                        except:
                            self.config[param] = p
                    except:
                        pass

        except:
            print 'ERROR: ini file corrupt'
            
        file.close()


    def UpdateOptions(self):
        pass
    

    def SaveOptions(self):
        #print 'saving options'
        try:
            cp = ConfigParser.ConfigParser()

            cp.add_section('COLORS')
            for color in self.g_colors:
                cp.set('COLORS', color, self.GetColor_AsStr(color))

            cp.add_section('LANG')
            for lang in self.avail_lang:
                cp.set('LANG', lang, self.avail_lang[lang])            

            cp.add_section('OPTIONS')
            for param in self.config:
                cp.set('OPTIONS', param, self.config[param])
            
            file = open(self.config_file, 'w')
            cp.write(file)
            file.close()
        except:
            print "ERROR: writing config ini file"
