
# -------------------------------------------------------------
# eep.py: Eeproxy access module
# -------------------------------------------------------------

"""
Eeproxy access module
"""


import urllib2
from urllib import quote

eepaddr   = '127.0.0.1:4444'    # Default port for eeproxy

# --------------------------------------------------
# Functions
# --------------------------------------------------

def urlrewrite(url):
    if url.find('http://') != 0: url = 'http://' + url
            
    # Handle I2P Destination
    suffix = url[len('http://'):]
    if suffix[:4] != 'i2p/':
        # Deperate the destination from the remaining string
        if suffix.find('/') > 0:
            (destination, remainder) = suffix.split('/', 1)
        else: 
            destination = suffix
            remainder = ''

        # Strip the port if present
        if destination.find(':') > 0:
            (destination, port) = destination.split(':', 1)

        # Put it all back together
        if len(destination) >= 256:
            # Remove Azureus style .i2p
            if destination[-4:] == '.i2p':
                destination = destination[:-4]
            url = 'http://i2p/' + destination + '/' + remainder
        else:
            url = 'http://' + destination + '/' + remainder
        
    # Add trailing slash
    if url.find('/', len('http://')) < 0: 
        url = url + '/'

    return url


def urlopen(url, eepaddr=eepaddr):
  """Like urllib2.urlopen(url), but only works for eep-sites.
     Example: f = urlopen('http://duck.i2p/index.html')"""

  import socket
  socket.setdefaulttimeout(60)

  url = urlrewrite(url)

  # Remove http:// and trailing slash from eepaddr.
  if eepaddr.find('http://') == 0: eepaddr = eepaddr[len('http://'):]
  eepaddr = eepaddr.rstrip('/')

  proxy    = urllib2.ProxyHandler(                                 \
             {'http': 'http://' + eepaddr})
  opener   = urllib2.build_opener(proxy, urllib2.HTTPHandler)
  return opener.open(url)

def urlget(url, eepaddr=eepaddr):
  """Get contents of an eepsite.
     Example: urlget('http://duck.i2p/')."""
  f = urlopen(url, eepaddr=eepaddr)
  ans = f.read()
  f.close()
  return ans
