# Written by Bram Cohen
# see LICENSE.txt for license information

#I2P: use httpproxy
from eep import urlopen
#/I2P
from urlparse import urljoin
from btformats import check_message
from Choker import Choker
from Storage import Storage
from StorageWrapper import StorageWrapper
from Uploader import Upload
from Downloader import Downloader
from Connecter import Connecter
from Encrypter import Encoder
#I2P: RawServer replacement
from SamServer import SamServer
#/I2P
from Rerequester import Rerequester
from DownloaderFeedback import DownloaderFeedback
from RateMeasure import RateMeasure
from CurrentRateMeasure import Measure
from PiecePicker import PiecePicker
from bencode import bencode, bdecode
from __init__ import version
from binascii import b2a_hex

try:
    from mhash import MHASH, MHASH_SHA1
    mhash_flag = True
except:
    from sha import sha
    mhash_flag = False

from os import path, makedirs
from parseargs import parseargs, formatDefinitions
from socket import error as socketerror
from random import seed
from threading import Thread, Event
from time import time
from os.path import exists, join
import encodings
import sys
import os

if sys.platform == "win32":   
    win32_flag = True
else:
    win32_flag = False

try:
    from os import getpid

except ImportError:
    def getpid():
        return 1
    
class Download:
    def __init__(self, sam, log, invokelater=None, ScrapeCatcher=None):
        self.storagewrapper = None
        self.SAM = sam
        self.log = log
        self.InvokeLater = invokelater
        self.ScrapeCatcher = ScrapeCatcher
#I2P: move all these settings in a init, instead of setting them only once when the class is imported, since we need a default set for each torrent
        self.defaults = [
        ('max_uploads', 7,
            "the maximum number of uploads to allow at once."),
        ('keepalive_interval', 120.0,
            'number of seconds to pause between sending keepalives'),
    #I2P: maximum slice size
        ('download_slice_size', 2**16,
    #/I2P
            "How many bytes to query for per request."),
        ('request_backlog', 5,
            "how many requests to keep in a single pipe at once."),
        ('max_message_length', 2 ** 23,
            "maximum length prefix encoding you'll accept over the wire - larger values get the connection dropped."),
        ('ip', '',
            "ip to report you have to the tracker."),
        ('minport', 6881, 'minimum port to listen on, counts up if unavailable'),
    #I2P: dont try a whole portrange, so minport == maxport
        ('maxport', 6881, 'maximum port to listen on'),
    #/I2P
        ('responsefile', '',
            'file the server response was stored in, alternative to url'),
        ('url', '',
            'url to get file from, alternative to responsefile'),
        ('saveas', '',
            'local file name to save the file as, null indicates query user'),
        ('timeout', 300.0,
            'time to wait between closing sockets which nothing has been received on'),
        ('timeout_check_interval', 60.0,
            'time to wait between checking if any connections have timed out'),
        ('max_slice_length', 2 ** 17,
            "maximum length slice to send to peers, larger requests are ignored"),
        ('max_rate_period', 20.0,
            "maximum amount of time to guess the current rate estimate represents"),
    #I2P: used for the sessionname
        ('bind', '',
    #/I2P
            'ip to bind to locally'),
        ('upload_rate_fudge', 5.0, 
            'time equivalent of writing to kernel-level TCP buffer, for rate adjustment'),
    #I2P: less often
        ('display_interval', 1.0,
    #/I2P
            'time between updates of displayed information'),
        ('rerequest_interval', 5 * 60,
            'time to wait between requesting more peers'),
        ('min_peers', 20, 
            'minimum number of peers to not do rerequesting'),
        ('http_timeout', 60, 
            'number of seconds to wait before assuming that an http connection has timed out'),
        ('max_initiate', 35,
            'number of peers at which to stop initiating new connections'),
        ('max_allow_in', 55,
            'maximum number of connections to allow, after this new incoming connections will be immediately closed'),
        ('check_hashes', 1,
            'whether to check hashes on disk'),
        ('max_upload_rate', 0,
            'maximum KB/s to upload at, 0 means no limit'),
        ('snub_time', 30.0,
            "seconds to wait for data to come in over a connection before assuming it's semi-permanently choked"),
        ('spew', 0,
            "whether to display diagnostic info to stdout"),
        ('rarest_first_cutoff', 2,
            "number of downloads at which to switch from random to rarest first"),
        ('min_uploads', 4,
            "the number of uploads to fill out to with extra optimistic unchokes"),
        ('report_hash_failures', 1,
            "whether to inform the user that hash failures occur. They're non-fatal."),
        ('filesize', 0,
            "only used internally as a param"),
        ('up_total', 0,
            "only used internally as a param"),
        ('down_total', 0,
            "only used internally as a param"),
        ('pre_allocate', 1,
            "preallocate file on disk"),
    #I2P: new command line arguments
        ('sam_bridge', '127.0.0.1:7656',
            "address to the sam bridge used to access I2P."),
        ('http_proxy', '127.0.0.1:4444',
            "address to the http proxy used to access I2P."),
        ('tunnel_depth', 1,
            "number of nodes in our tunnel.  Shorter tunnels increase performance, longer tunnels increase anonymity."),
        ('tunnel_number', '',
            "number of tunnels.  More tunnels increases reliability, fewer tunnels reduces load."),
        ('length_variance', -1,
            "if n > 0, randomly permute tunnel_depth by + 0 to n through variance.  If n < 0, randomly permute by +/- 0 to n.")
    #/I2P
        ]
#/I2P
        
    def ParseResponseFile(self, responsefile, url=None, errorfunc=None):
        try:
            if responsefile and responsefile != '':
                h = open(responsefile, 'rb')
            elif url != None:
                h = urlopen(url)
            else:
#I2P: use proxy
                h = urlopen(config['url'], config['http_proxy'])
#/I2P
            response = h.read()
            h.close()
        except IOError, e:
            if responsefile != '' and responsefile.find('Temporary Internet Files') != -1:
                if errorfunc != None:
                    errorfunc('BitTorrent was passed a filename that doesn\'t exist.  ' +
                        'Either clear your Temporary Internet Files or right-click the link ' + 
                        'and save the .torrent to disk first.')
            else:
                if errorfunc != None:
                    errorfunc('problem getting response info - ' + str(e))
            return None

        try:
            response = bdecode(response)
            check_message(response)
        except ValueError, e:
            if errorfunc != None:
                errorfunc("got bad file info - " + str(e))
            return None
        
        return response
                
    
    def setup(self, params, filefunc, statusfunc, finfunc, errorfunc, doneflag, 
        cols, pathFunc = None, callback = None, resumepath=None):
        self.resumepath = resumepath

            
        if len(params) == 0:
            #I2P: changed "default" to "self.default", because each instance of the class has now it's own set of defaults
            errorfunc('arguments are -\n' + formatDefinitions(self.defaults, cols))
            #/I2P
            return False
        try:
            #I2P: changed "default" to "self.default", because each instance of the class has now it's own set of defaults
            config, args = parseargs(params, self.defaults, 0, 50)
            #/I2P
            if args:
                if config.get('responsefile', None) == None:
                    raise ValueError, 'must have responsefile as arg or parameter, not both'
                if path.isfile(args[0]):
                    config['responsefile'] = args[0]
                else: 
                    config['url'] = args[0]
            if (config['responsefile'] == '') == (config['url'] == ''):
                raise ValueError, 'need responsefile or url'
        except ValueError, e:
            errorfunc('error: ' + str(e) + '\nrun with no args for parameter explanations')
            return False
        
        response = self.ParseResponseFile(config['responsefile'], config['url'])
        if response == None:
            return False
        
        try:
            def make(f, forcedir = False):
                if not forcedir:
                    f = path.split(f)[0]
                if f != '' and not path.exists(f):
                    makedirs(f)
                    
            info = response['info']

            if response.has_key('encoding'):
                enc_type = response['encoding']
            else:
                enc_type = 'latin-1'

            if info.has_key('name.utf-8'):
                ent_type = '.utf-8'
                enc_type = 'UTF-8'
            else:
                ent_type = ''


            file_name = info['name'+ent_type].decode(enc_type)

            if info.has_key('length'):
                file_length = info['length']
                file = filefunc(file_name, file_length, config['saveas'], False)
                config['saveas'] = file
                if file is None:
                    return False
                make(file)
                files = [(file, file_length)]                
            else:
                file_length = 0
                for x in info['files']:
                    file_length += x['length']
                file = filefunc(file_name, file_length, config['saveas'], True)
                config['saveas'] = file
                if file is None:
                    return False
                    
                # if this path exists, and no files from the info dict exist, we assume it's a new download and 
                # the user wants to create a new directory with the default name
                existing = 0

                if path.exists(file):

                    for x in info['files']:
                        path_name = x['path'+ent_type][0].decode(enc_type) 

                        tfile = path.join(file, path_name)
                            
                        if path.exists(tfile):

                            existing = 1
                    if not existing:
                        file_name = info['name'+ent_type].decode(enc_type)

                        file = path.join(file, file_name)

                make(file, True)
                
                # alert the UI to any possible change in path
                if pathFunc != None:
                    pathFunc(file)
                    
                files = []

                for x in info['files']:

                    n = file
                    path_tmp = x['path'+ent_type]

                    for i in path_tmp:
                        n = path.join(n, i.decode(enc_type))

                    files.append((n, x['length']))

                    make(n)
    
        except OSError, e:
            errorfunc("Couldn't allocate dir - " + str(e))
            return False
        
        self.config = config
        self.info = info
        self.enc_type = enc_type
        self.ent_type = ent_type
        self.files = files
        self.response = response
        self.file_length = file_length
        self.errorfunc = errorfunc
        
        if callback != None:
            callback()

        
    def download(self, params, statusfunc, finfunc, errorfunc, \
            friendfunc, doneflag, cols, my_id=None, spewflag=Event(), \
            onstartfunc=None):
    
        info = self.info
        enc_type = self.enc_type
        ent_type = self.ent_type
        config = self.config
        files = self.files
        response = self.response
        file_length = self.file_length
             
        finflag = Event()
        ann = [None]

        if my_id == None:
            myid = 'M' + version.replace('.', '-')        
            if mhash_flag:
                myid = myid + ('-' * (8 - len(myid))) + b2a_hex(MHASH(MHASH_SHA1, (repr(time()) + ' ' + str(getpid()))).digest()[-6:])
            else:                
                myid = myid + ('-' * (8 - len(myid))) + b2a_hex(sha(repr(time()) + ' ' + str(getpid())).digest()[-6:])
                
        else:
            myid = my_id
        seed(myid)
        pieces = [info['pieces'][x:x+20] for x in xrange(0, 
            len(info['pieces']), 20)]
        def failed(reason, errorfunc = errorfunc, doneflag = doneflag):
            doneflag.set()
            if reason is not None:
                errorfunc(reason)
#I2P: additional arguments
        rawserver = SamServer(doneflag, sha(bencode(info)).digest(), self.SAM, self.log,
                        config['timeout_check_interval'], config['timeout'],
                        errorfunc = errorfunc,
                        maxconnects = config['max_allow_in'])
#/I2P
        if mhash_flag:
            infohash = MHASH(MHASH_SHA1, (bencode(info))).digest()
        else:
            infohash = sha(bencode(info)).digest()        
            
        try:
            try:
                storage = Storage(files, open, path.exists, path.getsize)
            except IOError, e:
                errorfunc('trouble accessing files - ' + str(e))
                return
            def finished(finfunc = finfunc, finflag = finflag, 
                    ann = ann, storage = storage, errorfunc = errorfunc):
                finflag.set()
                try:
                    storage.set_readonly()
                except (IOError, OSError), e:
                    errorfunc('trouble setting readonly at end - ' + str(e))
                if ann[0] is not None:
                    ann[0](1)
                finfunc()
            rm = [None]
            def data_flunked(amount, rm = rm, errorfunc = errorfunc, report_hash_failures = config['report_hash_failures'], index=-1, ip=None):
                if rm[0] is not None:
                    rm[0](amount)
                if report_hash_failures:
                    if ip != None:
                        errorfunc('Piece %d from %s failed hash check, re-downloading it' % (index, ip), "hash_flunked")
                    else:
                        errorfunc('A piece from UNKNOWN failed hash check, re-downloading it')
            self.resumefile = None
            if self.resumepath != None:
                if not os.path.exists(self.resumepath):
                    try:
                        makedirs(self.resumepath)
                    except IOError, msg:
                        self.resumefile = None
                        errorfunc(_("An error occurred when trying to create resumedata folder")+str(msg))

                if os.path.exists(self.resumepath):
                    self.resumefile = join(self.resumepath, infohash.encode('hex')+".dat")  

            self.storagewrapper = StorageWrapper(storage, 
                config['download_slice_size'], pieces, 
                info['piece length'], finished, failed, statusfunc, doneflag, 
                config['check_hashes'], data_flunked, config['pre_allocate'], self.resumefile, errorfunc)
        except ValueError, e:
            failed('bad data - ' + str(e))
        except IOError, e:
            failed('IOError - ' + str(e))
        if doneflag.isSet():
            return

        config['ip'] = self.SAM.get_own_dest()
        listen_port = config['minport']
            
        choker = Choker(config['max_uploads'], rawserver.add_task, friendfunc, 
            infohash, finflag.isSet, config['min_uploads'])
        picker = PiecePicker(len(pieces), config['rarest_first_cutoff'])
        for i in xrange(len(pieces)):
            if self.storagewrapper.do_I_have(i):
                picker.complete(i)
        upmeasure = Measure(config['max_rate_period'], 
            config['upload_rate_fudge'], total=config['up_total'])
        downmeasure = Measure(config['max_rate_period'],
            total=config['down_total'])
        def make_upload(connection, choker = choker, 
                storagewrapper = self.storagewrapper, 
                max_slice_length = config['max_slice_length'],
                max_rate_period = config['max_rate_period'],
                fudge = config['upload_rate_fudge']):
            return Upload(connection, choker, self.storagewrapper, 
                max_slice_length, max_rate_period, fudge)
        ratemeasure = RateMeasure(self.storagewrapper.get_amount_left())
        rm[0] = ratemeasure.data_rejected
        downloader = Downloader(self.storagewrapper, picker,
            config['request_backlog'], config['max_rate_period'],
            len(pieces), downmeasure, config['snub_time'], 
            ratemeasure.data_came_in)
        connecter = Connecter(make_upload, downloader, choker,
            len(pieces), upmeasure, config['max_upload_rate'] * 1024, rawserver.add_task)
        
        encoder = Encoder(self.log, connecter, rawserver, 
            myid, config['max_message_length'], rawserver.add_task, 
            config['keepalive_interval'], infohash, config['max_initiate'])
        rerequest = Rerequester(response['announce'], config['rerequest_interval'], 
            response.get('announce-list'),
            rawserver.add_task, connecter.how_many_connections,
            config['min_peers'], encoder.start_connection, 
            rawserver.add_task, self.storagewrapper.get_amount_left, 
            upmeasure.get_session_total, downmeasure.get_session_total, listen_port, 
            config['ip'], myid, infohash, config['http_timeout'], errorfunc, 
            config['max_initiate'], doneflag, upmeasure.get_rate, downmeasure.get_rate,
#I2P: use proxy
            encoder.ever_got_incoming, config['http_proxy'], self.InvokeLater, self.ScrapeCatcher)
#/I2P
        if config['spew']:
            spewflag.set()
        DownloaderFeedback(choker, rawserver.add_task, statusfunc, 
            upmeasure.get_rate, downmeasure.get_rate, 
            upmeasure.get_total, downmeasure.get_total, ratemeasure.get_time_left, 
            ratemeasure.get_size_left, file_length, finflag,
            config['display_interval'], spewflag, picker, self.storagewrapper)


        self.upmeasure = upmeasure
        self.downmeasure = downmeasure
        self.encoder = encoder
        self.connecter = connecter
        self.rerequest = rerequest
        self.choker = choker
        self.rawserver = rawserver
        self.picker = picker
        self.doneflag = doneflag
        self.spewflag = spewflag
        
        if onstartfunc:
            pass2start = {
                'peer_id' : myid,
                'info_hash' : infohash,
                'listen_port' : listen_port,
                'announce' : response.get('announce').strip(),
                'announce-list' : response.get('announce-list'),
                'comment' : response.get('comment'),
                'creation_date' : response.get('creation date'),
                'saveas' : config.get('saveas'),
                'filename' : info['name'+ent_type].decode(enc_type),
                'filesize': file_length,
                'responsefile': config.get('responsefile'),
                'nhashes': self.storagewrapper.get_nhashes(),
                'piecesize': self.storagewrapper.piece_size
            }
            onstartfunc(pass2start)

        statusfunc({"activity" : 'connecting to peers'})
        ann[0] = rerequest.announce
        rerequest.begin()
        rawserver.listen_forever(encoder)
        storage.close()
        rerequest.announce(2)
        
        config['up_total'] = upmeasure.get_total()
        config['down_total'] = downmeasure.get_total()
        
#------------------------------------------------------------------------------
    def ToggleSpew(self, value=True):
        if hasattr(self, 'spewflag'):
            if value:
                if not self.spewflag.isSet():
                    self.spewflag.set()
            else:
                if self.spewflag.isSet():
                    self.spewflag.clear()
                
        
    def GetFiles(self):
        if hasattr(self, 'files'):
            return self.files
    
    def GetFileRanges(self):
        file_ranges = []
        files = self.storagewrapper.get_files()
        piece_size = self.storagewrapper.piece_size
        havelist = self.storagewrapper.get_have_list()
        
        if piece_size == 0 or len(files) == 0:
            return None
        
        start_idx = 0L
        tail = 0
        for file in files:
            pieces = max(1, (file[1] + tail) / piece_size)
            
            tail = (file[1] + tail) % piece_size
            if tail:
                pieces += 1
            
            havecount = 0
            for h in havelist[start_idx:start_idx + pieces]:
                if h:
                    havecount += 1
            
            file_ranges.append([file, start_idx, start_idx + pieces - 1, 
                                float(havecount)/pieces, True])

            if tail:
                start_idx = start_idx + pieces - 1
            else:
                start_idx = start_idx + pieces
            
        return file_ranges
            
   
    def SetPieceRanges(self, ranges):
        if hasattr(self, 'doneflag') and self.doneflag.isSet():
            return

        def foo(self=self, ranges=ranges):
            self.picker.ranges = ranges
        self.rawserver.add_task(foo, 0)
        
    def StartConnection(self, ip, port, peer_id):
        if hasattr(self, 'doneflag') and self.doneflag.isSet():
            return
        self.encoder._start_connection((ip, port), peer_id)

    def ReAnnounce(self, url=None):
        if hasattr(self, 'doneflag') and self.doneflag.isSet():
            return
        def foo():
            self.rerequest.announce(url=url)
        self.rawserver.add_task(foo, 0)
        
    def SelectChoker(self, selection, choke_period, opt_unchoke_period, min_rate, choke_udban, choke_activate, choke_multiplier):
        if hasattr(self, 'doneflag') and self.doneflag.isSet():
            return
        self.choker.SelectChokeAlgo(selection, [choke_period, opt_unchoke_period, min_rate*1024], choke_udban, choke_activate, choke_multiplier)
    
    def ReChoke(self):
        if hasattr(self, 'doneflag') and self.doneflag.isSet():
            return
        self.choker.rechoke()
        
    def SetMaxInitiate(self, max_initiate):
        if hasattr(self, 'config') and not self.doneflag.isSet():
            self.config['max_initiate'] = max_initiate
            
            def foo(self=self, max_initiate=max_initiate):
                self.encoder.max_initiate = max_initiate
                self.rerequest.maxpeers = max_initiate
           
            self.rawserver.add_task(foo, 0)

    def SetMaxAllowIn(self, max_allow_in):
        if hasattr(self, 'config') and not self.doneflag.isSet():
            self.config['max_allow_in'] = max_allow_in
            
            def foo(self=self, max_allow_in=max_allow_in):
                self.rawserver.maxconnects = max_allow_in
           
            self.rawserver.add_task(foo, 0)
                        
    def SetMaxUpSpeed(self, rate):
        if hasattr(self, 'config') and not self.doneflag.isSet():
            self.config['max_upload_rate'] = rate
            self.connecter.change_max_upload_rate(rate)

    def SetMaxUploads(self, value):
        if hasattr(self, 'config') and not self.doneflag.isSet():
            self.config['max_uploads'] = value
            self.choker.change_max_uploads(value)

    def GetConfig(self):
        if hasattr(self, 'config'):
            return self.config
        else:
            return None
           
    def GetUpTotal(self):
        if hasattr(self, 'upmeasure'):
            return self.upmeasure.get_total()
        else:
            return 0
    
    def GetDownTotal(self):
        if hasattr(self, 'downmeasure'):
            return self.downmeasure.get_total()
        else:
            return 0

    def GetAnnounceURLs(self):
        if hasattr(self, 'rerequest'):
            return self.rerequest.url_list
        else:
            return []
    
    def SetAnnounceURLs(self, url_list):
        if hasattr(self, 'rerequest'):
            def foo(self=self, url_list = url_list):
                self.rerequest.url_list = url_list
           
            self.rawserver.add_task(foo, 0)

    def SaveResumeFile(self):
        if self.storagewrapper != None:
           if len(self.storagewrapper.get_have_array()) != 0:
                self.storagewrapper.SaveFastResume()   	

    def Shutdown(self):
        print "Download Cleanup"
        self.SaveResumeFile()

    #remove unneeded fast resume data
    def KillFastResumeData(self):
        try:
            if os.path.exists(self.resumefile):
                os.remove(self.resumefile)
        except (os.error, AttributeError):
            pass 
