import select
import socket
import sys
import thread
import time
import traceback

class pseudo_logger:#used if no logger is given to sam_tcp
    def __init__(self):
        pass
    def add(self, instance, message, prefix):#called if something should be logged
        if not prefix=='DEBUG':
            print self.get_time()+' '+prefix+': '+' '*(7-len(prefix))+instance+' - '+message
        
    def get_time(self):#constructs a string containing the current time and date
        gtime=time.gmtime(time.time())
        gtime=list(gtime)
        for i in range(0, len(gtime)):
            gtime[i]=str(gtime[i])
        for i in range(1, 6):
            if len(gtime[i])==1:
                gtime[i]='0'+gtime[i]
        gtime=gtime[3]+':'+gtime[4]+':'+gtime[5]+' '+gtime[2]+'.'+gtime[1]+'.'+gtime[0]
        return gtime
    
class sam_tcp:
    def __init__(self, log=pseudo_logger(), max_sim_connects=1):
        self.log = log
        self.max_sim_connects = max_sim_connects
        self.lock = thread.allocate_lock()
        self.out_connections = [[],[]]
        self.in_connections = [[],[]]
        self.id = 0
        self.received_data = ''
        self.cache = ['','']
        self.send_data = []
        self.curr_conn_atempts = []
        self.connect_queue = []
        self.connect_attempts = 0
        self.connected = 0
        self.own_dest = ''

    def connect_to_sam(self, ip, port, destname, direction='BOTH', inb_quantity='2', inb_backQuan='0', \
                       inb_length='2', inb_lengthVar='-1', inb_allowZero='true', out_quantity='2', out_backQuan='0', \
                       out_length='2', out_lengthVar='-1', out_allowZero='true' ):
        #must be called to establish a connection and session with SAM, returns if it succeded
        self.lock.acquire()
        exception = []
        result = 'SOCKET_ERROR'
        self.samsocket = socket.socket()
        self.samsocket.settimeout(140)
        try:
            #this monster should probably be split into several functions or restructured to be more readable (although it works just fine...)
            self.samsocket.connect((ip, port))
            self.samsocket.sendall('HELLO VERSION MIN=1.0 MAX=1.0\n')
            response = self.samsocket.recv(1024)
            if not response=='':
                line = self.parse_line(response[0:(len(response)-1)])
                result = self.get_value(line, 'RESULT')
                if result=='OK':
                    #connection to sam is established
                    self.samsocket.sendall('SESSION CREATE STYLE=STREAM DESTINATION='+destname+' DIRECTION='+direction+\
                                        ' inbound.nickname='+destname+\
                                        ' inbound.quantity='+str(inb_quantity)+\
                                        ' inbound.backupQuantity='+str(inb_backQuan)+\
                                        ' inbound.length='+str(inb_length)+\
                                        ' inbound.lengthVariance='+str(inb_lengthVar)+\
                                        ' inbound.allowZeroHop='+str(inb_allowZero)+\
                                        ' outbound.quantity='+str(out_quantity)+\
                                        ' outbound.backupQuantity='+str(out_backQuan)+\
                                        ' outbound.length='+str(out_length)+\
                                        ' outbound.lengthVariance='+str(out_lengthVar)+\
                                        ' outbound.allowZeroHop='+str(out_allowZero)+\
                                        '\n')

                    response = self.samsocket.recv(1024)
                    if not response=='':
                        line = self.parse_line(response[0:(len(response)-1)])
                        result = self.get_value(line, 'RESULT')
                        if not result=='OK':
                            #error creating the session
                            exception = [0, self.get_value(line, 'MESSAGE')]
                        else:
                            #session established
                            self.samsocket.sendall('NAMING LOOKUP NAME=ME\n')
                            response = self.samsocket.recv(1024)
                            if not response=='':
                                line = self.parse_line(response[0:(len(response)-1)])
                                result = self.get_value(line, 'RESULT')
                                if not result=='OK':
                                    #error getting own destination
                                    exception = [0, self.get_value(line, 'MESSAGE')]
                                else:
                                    self.samsocket.setblocking(0)#make it a non-blocking socket from now on
                                    self.own_dest = self.get_value(line, 'VALUE')
                                    self.log.add('SAM_TCP', 'SAM session established, using destination "'+self.own_dest+'"', 'NORMAL')
                                    self.connected = 1
                            else:
                                #socket disconnected
                                result = 'SOCKET_ERROR'
                                exception = [0, 'Connection to SAM lost']
                    else:
                        #socket disconnected
                        result = 'SOCKET_ERROR'
                        exception = [0, 'Connection to SAM lost']
                else:
                    #error handshaking
                    result = 'SOCKET_ERROR'
                    exception = [0, self.get_value(line, 'MESSAGE')]
            else:
                #socket disconnected
                exception = [0, 'Connection to SAM lost']
        except socket.error, why: #socket error
            try:
                result = 'SOCKET_ERROR'
                exception = [why[0], why[1]]
            except:
                result = 'SOCKET_ERROR'
                exception = [0, str(why)]
        except: #something in the code failed
            result = 'ERROR'
            exception = [0, 'An unhandled error occured!']
            self.log_traceback()

        self.lock.release()
        return [result, exception]

    def parse_line(self, response):#parses one line and returns a list like [request_type,[[parameters],[values]]]
        response = response.split(' ')
        result = [response[0]+' '+response[1], [[],[]] ]
        for i in xrange(2, len(response)):
            if '=' in response[i]:
                para = response[i].split('=')
                result[1][0].append(para[0])
                result[1][1].append(para[1])
            else:
                result[1][1][-1] = result[1][1][-1] + ' ' + response[i]
        return result

    def get_value(self, line, paraname):#returns the value for a given parameter in a given (already with the above function parsed) line
        place = line[1][0].index(paraname)
        value = line[1][1][place]
        return value

    def connect(self, destination):#connect to a remote destination, returns the Stream ID on success and else an error code
        self.lock.acquire()
        try:
            self.id = self.id + 1
            self.connect_queue.append('STREAM CONNECT ID='+str(self.id)+' DESTINATION='+destination+'\n')
            self.out_connections[0].append(str(self.id))
            self.out_connections[1].append([[], destination, 'connecting'])
            response = str(self.id) 
        except socket.error:
            #SAM disconnected us
            response = 'SAM_ERROR'
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        self.lock.release()
        return response

    def shutdown(self, connection_id, should_lock=True):#closes a stream, returns a status message and tolerates a call for an already closed stream
        if should_lock==True:
            self.lock.acquire()
        try:
            if connection_id[0]=='-':
                #connection_id refers to an inbound connection
                connections = self.in_connections
            else:
                #connection_id refers to an outbound connection
                connections = self.out_connections
                
            if connection_id in connections[0]:
                #ID exists
                place = connections[0].index(connection_id)                 
                if not (connections[1][place][2]=='closed' or connections[1][place][2]=='connecting'):
                    message = 'STREAM CLOSE ID='+connection_id+'\n'
                    self.send_data.append(message)
                    response = 'OK'
                elif connections[1][place][2]=='connecting':
                    #closing of a connection, which is still connecting
                    if connection_id in self.curr_conn_atempts:
                        self.connect_attempts = self.connect_attempts - 1
                        place2 = self.curr_conn_atempts.index(connection_id)
                        del self.curr_conn_atempts[place2]
                    response = 'CONNECTING_ERROR'
                else:
                    response = 'CLOSED_ERROR'
                del connections[1][place]
                del connections[0][place]
            else:
                response = 'ID_ERROR'
        except socket.error:
            #SAM disconnected us
            response = 'SAM_ERROR'
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        if should_lock==True:
            self.lock.release()
        return response
            

    def send(self, connection_id, data):
        #sends data to a remote destination, using the given Stream ID
        #this function currently doesn't check if the stream is already closed, this will be added in the future
        self.lock.acquire()
        try:
            if connection_id[0]=='-':
                #connection_id refers to an inbound connection
                connections = self.in_connections
            else:
                #connection_id refers to an outbound connection
                connections = self.out_connections
                
            if connection_id in connections[0]:
                #ID exists
                place = connections[0].index(connection_id)
                if not connections[1][place][2]=='closed':
                    #stream is still alive
                    message = 'STREAM SEND ID='+connection_id+' SIZE='+str(len(data))+'\n'+data
                    self.send_data.append(message)
                    response = 'OK'
                else:
                    response = 'CLOSED_ERROR'
            else:
                response = 'ID_ERROR'
        except socket.error:
            #SAM disconnected us
            response = 'SAM_ERROR'
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        self.lock.release()
        return response

    def send_queued_connects(self):
        try:
            if self.connect_attempts<self.max_sim_connects and len(self.connect_queue)>0:#send queued outgoing connect requests
                line = self.parse_line(self.connect_queue[0])
                connection_id = self.get_value(line, 'ID')
                while not (len(self.connect_queue)<=2) and not (connection_id  in self.out_connections[0]):
                    #get a new one until the connection wasn't already killed due to a timeout or soemthing similiar
                    del self.connect_queue[0]
                    line = self.parse_line(self.connect_queue[0])
                    connection_id = self.get_value(line, 'ID')
                if connection_id in self.out_connections[0]:
                    self.curr_conn_atempts.append(connection_id)
                    self.connect_attempts = self.connect_attempts + 1
                    self.send_data.append(self.connect_queue[0])
                    del self.connect_queue[0]
                else:
                    del self.connect_queue[0]
            response = 'OK'
        except socket.error:
            #SAM disconnected us
            response = 'SAM_ERROR'
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        return response
            
    def select(self, read_list, connected_list, error_list):
        #checks for IDs in the read_list, if data is available, for IDs in the connected_list if the stream is connected
        #and for IDs in the error_list if a socket error happened, if the stream was closed or if the ID doesn't exist for this class
        #returns the IDs in the appropriate list, if the above mentioned requirements are met
        self.lock.acquire()
        result = self.process_recv_buffer()#process incomming data from SAM
        
        if not (result=='ERROR' or result=='SAM_ERROR'):#send queued outgoing connect requests
            result = self.send_queued_connects()
            
        if not (result=='ERROR' or result=='SAM_ERROR'):
            try:
                result = [[],[],[]]
                for connection_id in read_list: #received data
                    if connection_id[0]=='-':
                        #inbound
                        if connection_id in self.in_connections[0]:
                            place = self.in_connections[0].index(connection_id)
                            if len(self.in_connections[1][place][0])>0:
                                result[0].append(connection_id)
                    else:
                        #outbound
                        if connection_id in self.out_connections[0]:
                            place = self.out_connections[0].index(connection_id)
                            if len(self.out_connections[1][place][0])>0:
                                result[0].append(connection_id)

                for connection_id in connected_list: #connected
                    if connection_id[0]=='-':
                        #inbound
                        if connection_id in self.in_connections[0]:
                            place = self.in_connections[0].index(connection_id)
                            if self.in_connections[1][place][2]=='connected':
                                result[1].append(connection_id)
                    else:
                        #outbound
                        if connection_id in self.out_connections[0]:
                            place = self.out_connections[0].index(connection_id)
                            if self.out_connections[1][place][2]=='connected':
                                result[1].append(connection_id)

                for connection_id in error_list: #closed
                    if connection_id[0]=='-':
                        #inbound
                        if connection_id in self.in_connections[0]:
                            place = self.in_connections[0].index(connection_id)
                            if self.in_connections[1][place][2]=='closed':
                                result[2].append(connection_id)
                        else:
                            #client_ID is not listed in the connection list
                            result[2].append(connection_id)
                    else:
                        #outbound
                        if connection_id in self.out_connections[0]:
                            place = self.out_connections[0].index(connection_id)
                            if self.out_connections[1][place][2]=='closed':
                                result[2].append(connection_id)
                        else:
                            #client_ID is not listed in the connection list
                            result[2].append(connection_id)
            except:
                #internal error
                result = 'ERROR'
                self.log_traceback()
        self.lock.release()
        return result

    def send_queued_data(self):#sends queued outgoing messages for SAM
        try:
            if len(self.send_data)>0:
                #there are some messages
                data = ''.join(self.send_data)
                transmitted = self.samsocket.send(data)
                if transmitted<len(data):
                    #not everything was send
                    self.send_data.append(data[transmitted:])
                else:
                    #all was send
                    self.send_data = []
            response = 'OK'
        except socket.error:
            #something went wrong with the socket/sending
            response = 'SAM_ERROR'
        except:
            #something in the code crashed
            response = 'ERROR'
            self.log_traceback()
        return response
                
    def process_recv_buffer(self):#handles incomming data from sam
        try:
            response = 'OK'
            status = select.select([self.samsocket],[self.samsocket],[self.samsocket], 0)
            if self.samsocket in status[1]:#socket is writeable -> send the queued messages to SAM
                response = self.send_queued_data()
                
            if response=='OK' and self.samsocket in status[0]: #socket is readable = theres data from SAM
                try:
                    sam_data = []
                    while self.samsocket in status[0] and not (self.samsocket in status[2]):
                        #get all data out of the buffer
                        incom_data = self.samsocket.recv(1000000)
                        sam_data.append(incom_data)
                        status = select.select([],[self.samsocket],[self.samsocket], 0)
                        if incom_data=='':
                            #the connection to SAM failed
                            status[2].append(self.samsocket)
                    sam_data = ''.join(sam_data)
                    if self.samsocket in status[2]:
                        #the socket failed
                        response='SAM_ERROR'
                    else:
                        #everything is all fine
                        self.received_data = self.received_data + sam_data
                        self.received_data = self.received_data.split('\n')
                        while len(self.received_data)>1:#process the data from SAM line for line
                            line = self.parse_line(self.received_data[0])
                            self.log.add('SAM_TCP', 'Line: '+str(line), 'DEBUG')
                            del self.received_data[0]
                            if line[0]=='STREAM CLOSED':#connection was closed from the remote host
                                self.process_close(line)
                                
                            elif line[0]=='STREAM CONNECTED':#connection from remote host
                                self.process_connected(line)

                            elif line[0]=='STREAM RECEIVED':#received data
                                self.process_received(line)
                                    
                            elif line[0]=='STREAM STATUS':#connection status report
                                self.process_status(line)

                            else:
                                #this class doesn't know what it should do with this line
                                self.log.add('SAM_TCP', 'Got something strange from SAM: "'+line+'"', 'WARNING')
                        if len(self.received_data)>0:
                            self.received_data = self.received_data[0]
                        else:
                            self.received_data = ''
                        response = 'OK'
                        
                except socket.error:
                    #SAM disconnected us
                    response = 'SAM_ERROR'
                    
                except:
                    #internal error
                    response = 'ERROR'
                    self.log_traceback()
                
            elif self.samsocket in status[2]:
                response = 'SAM_ERROR'

            else:
                response = 'OK'

        except socket.error:
            #SAM disconnected us
            response = 'SAM_ERROR'
            
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
    
        return response

    def process_close(self, line):#a stream was closed
        connection_id = self.get_value(line, 'ID')
        if connection_id[0]=='-':
            #connection_id refers to an inbound connection
            connections = self.in_connections
        else:
            #connection_id refers to an outbound connection
            connections = self.out_connections
            
        if connection_id in connections[0]:
            place = connections[0].index(connection_id)
            connections[1][place][2] = 'closed'
        else:
            self.log.add('SAM_TCP', connection_id+' - discarded close', 'DEBUG')
                        
    def process_connected(self, line):#someone connected to us
        remote_dest = self.get_value(line, 'DESTINATION')
        connection_id = self.get_value(line, 'ID')
        if self.cache[0]==connection_id:
            #SAM sometime sends the incomming data before it reports the incomming connection.
            #If this happens, then the incomming data is cached: use it now
            data = [self.cache[1]]
            self.cache = ['','']
            self.log.add('SAM_TCP', 'New in conn with ID '+connection_id+', inserted cached data', 'DEBUG')
        else:
            data = []
        self.in_connections[0].append(connection_id)
        self.in_connections[1].append([data, remote_dest, 'connected'])
        self.log.add('SAM_TCP', 'New in conn with ID '+connection_id+', dest: '+remote_dest[0:10]+'...', 'DEBUG')

    def process_received(self, line):#got data from a remote destination
        connection_id = self.get_value(line, 'ID')
        size = int(self.get_value(line, 'SIZE'))
        data = []
        received = 0
        while received<size and len(self.received_data)>0:
            #append things to data while it doesn't met the given size
            missing = size - received
            if (len(self.received_data[0])+1)<=missing:
                #the line is shorter then the missing bytes
                if len(self.received_data)>1:
                    data.append(self.received_data[0]+'\n')
                    received = received + len(self.received_data[0]+'\n')
                else:
                    data.append(self.received_data[0])
                    received = received + len(self.received_data[0])
                del self.received_data[0]
            else:
                #the line is longer then the missing bytes, split it
                data.append(self.received_data[0][0:missing])
                received = received + len(self.received_data[0][0:missing])
                self.received_data[0] = self.received_data[0][missing:len(self.received_data[0])]
        data = ''.join(data)
        if received==size:
            #data is complete, handle it
            if connection_id[0]=='-':
                #connection_id refers to an inbound connection
                if connection_id in self.in_connections[0]:
                    place = self.in_connections[0].index(connection_id)
                    self.in_connections[1][place][0].append(data)
                else:
                    #the connection ID is unknown to this class and it's a incomming connection -> cache the data, SAM will probably send us the STREAM_CONNECTED message soon enough
                    self.cache[0]=connection_id
                    self.cache[1]=data
                    self.log.add('SAM_TCP', '"'+connection_id+'" - cached data', 'DEBUG')
            else:
                #connection_id refers to an outbound connection
                if connection_id in self.out_connections[0]:
                    place = self.out_connections[0].index(connection_id)
                    self.out_connections[1][place][0].append(data)
                else:
                    #the connection ID is unknown to this class and it's an outbound connection -> discard the data
                    self.log.add('SAM_TCP', '"'+connection_id+'" - discarded data', 'DEBUG')
        else:
            #SAM still needs to send us some data
            self.received_data.append('STREAM RECEIVED ID='+connection_id+' SIZE='+str(size)+'\n'+data)
        
    def process_status(self, line):#SAM gives us a status message for a stream -> either a stream was established or one failed
        connection_id = self.get_value(line, 'ID')
        if connection_id[0]=='-':
            #connection_id refers to an inbound connection
            connections = self.in_connections
        else:
            #connection_id refers to an outbound connection
            connections = self.out_connections
            
        if connection_id in connections[0]:
            #the id is known
            result = self.get_value(line, 'RESULT')
            place = connections[0].index(connection_id)
            if connections[1][place][2]=='connecting':
                #this is the result of a connection attempt
                if connection_id in self.curr_conn_atempts:
                    self.connect_attempts = self.connect_attempts - 1
                    place2 = self.curr_conn_atempts.index(connection_id)
                    del self.curr_conn_atempts[place2]
            if result=='OK':
                #the stream was established
                connections[1][place][2] = 'connected'            
            else:
                #the stream failed
                connections[1][place][2] = 'closed'
        else:
            #this class doesn't know about this ID -> discard the information, the stream was already closed/removed
            self.log.add('SAM_TCP', connection_id+' - discarded status', 'DEBUG')
                                
    def recv(self, connection_id):#get all available data for a given stream id, returning a status message and the data if the status is 'OK'
        self.lock.acquire()
        try:
            if connection_id[0]=='-':
                #connection_id refers to an inbound connection
                connections = self.in_connections
            else:
                #connection_id refers to an outbound connection
                connections = self.out_connections
            
            if connection_id in connections[0]:
                #the ID is known
                place = connections[0].index(connection_id)
                if len(connections[1][place][0])>0:
                    #there is data available
                    data = ''.join(connections[1][place][0])
                    connections[1][place][0] = []
                else:
                    data = ''
                response = 'OK'
            else:
                response = 'ID_ERROR'
                data = 'ID is unknown'
        except:
            #internal error
            response = 'ERROR'
            data = 'Internal Error'
            self.log_traceback()
        self.lock.release()
        return [response, data]

    def get_in_conns(self):#returns all currently existing incomming connections, both closed and not closed ones
        self.lock.acquire()
        try:
            response = []
            for i in xrange(0, len(self.in_connections[1])):
                response.append([self.in_connections[0][i], self.in_connections[1][i][1]])
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        self.lock.release()
        return response
        
    def cleanup(self, connection_id):#delete a failed/closed stream
        self.lock.acquire()
        try:
            if connection_id[0]=='-':
                #connection_id refers to an inbound connection
                connections = self.in_connections
            else:
                #connection_id refers to an outbound connection
                connections = self.out_connections
                
            if connection_id in connections[0]:
                #ID is known
                place = connections[0].index(connection_id)
                if connections[1][place][2]=='connecting':
                    if connection_id in self.curr_conn_atempts:
                        self.connect_attempts = self.connect_attempts - 1
                        place2 = self.curr_conn_atempts.index(connection_id)
                        del self.curr_conn_atempts[place2]                  
                del connections[0][place]
                del connections[1][place]
                response = 'OK'
            else:
                response = 'ID_ERROR'
            
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        self.lock.release()
        return response
            
    def reset(self):#reset the whole class, necessary if the connection to SAM failed
        self.lock.acquire()
        self.out_connections = [[],[]]
        self.in_connections = [[],[]]
        self.id = 0
        self.received_data = ''
        self.connected = 0
        self.cache = ['','']
        self.send_data = []
        self.curr_conn_atempts = []
        self.connect_queue = []
        self.connect_attempts = 0
        self.samsocket.close()
        self.lock.release()

    def kill(self):#close the connection to SAM
        self.lock.acquire()
        self.connected = 0
        self.samsocket.close()
        self.lock.release()

    def status(self):#returns true if the connection to SAM is established
        self.lock.acquire()
        response = self.connected
        self.lock.release()
        return response

    def get_own_dest(self):#returns the own destination
        self.lock.acquire()
        response = self.own_dest
        self.lock.release()
        return response
    
    def log_traceback(self):#To log unknown error with a at least somewhat nice traceback
        try:
            trace = traceback.extract_tb(sys.exc_traceback)
            trace_string = 'Traceback:\n'
            trace_string = trace_string + str(sys.exc_type)+'\n'
            for i in range(0, len(trace)):
                trace_string = trace_string + str(trace[i][0]) + ', Line: '+ str(trace[i][1]) + ', in: ' + str(trace[i][2]) + '\n'
                for j in range(3, len(trace[i])):
                    race_string = trace_string + '\t' + str(trace[i][j]) + '\n'
            trace_string = trace_string + str(sys.exc_value)
            self.log.add('SAM_TCP', trace_string, 'ERROR')
        except:
           self.log.add('SAM_TCP', 'An error occured while generating a traceback...', 'ERROR')

class sam_bittorrent(sam_tcp): #specialised class for bittorrent, supports differentiating of incomming connections with the info_hash
    def process_connected(self, line):#someone connected to us
        remote_dest = self.get_value(line, 'DESTINATION')
        connection_id = self.get_value(line, 'ID')
        if self.cache[0]==connection_id:
            #SAM sometime sends the incomming data before it reports the incomming connection.
            #If this happens, then the incomming data is cached: use it now
            data = [self.cache[1]]
            torrent_hash = self.get_torrent_hash(data)
            self.cache = ['','']
            self.log.add('SAM_TCP', 'New in conn with ID '+connection_id+', inserted cached data', 'DEBUG')
        else:
            data = []
            torrent_hash = 'unknown'
        self.in_connections[0].append(connection_id)
        self.in_connections[1].append([data, remote_dest, 'connected', torrent_hash, time.time()])
        self.log.add('SAM_TCP', 'New in conn with ID '+connection_id+', dest: '+remote_dest[0:10]+'..., hash: '+torrent_hash, 'DEBUG')

    def process_received(self, line):#got data from a remote destination
        connection_id = self.get_value(line, 'ID')
        size = int(self.get_value(line, 'SIZE'))
        data = []
        received = 0
        while received<size and len(self.received_data)>0:
            #append things to data while it doesn't met the given size
            missing = size - received
            if (len(self.received_data[0])+1)<=missing:
                #the line is shorter then the missing bytes
                if len(self.received_data)>1:
                    data.append(self.received_data[0]+'\n')
                    received = received + len(self.received_data[0]+'\n')
                else:
                    data.append(self.received_data[0])
                    received = received + len(self.received_data[0])
                del self.received_data[0]
            else:
                #the line is longer then the missing bytes, split it
                data.append(self.received_data[0][0:missing])
                received = received + len(self.received_data[0][0:missing])
                self.received_data[0] = self.received_data[0][missing:len(self.received_data[0])]
        data = ''.join(data)
        if received==size:
            #data is complete, handle it
            if connection_id[0]=='-':
                #inbound connection
                if connection_id in self.in_connections[0]:
                    place = self.in_connections[0].index(connection_id)
                    self.in_connections[1][place][0].append(data)
                    if self.in_connections[1][place][3]=='unknown':
                        #connection wasn't assigned to a torrent yet
                        torrent_hash = self.get_torrent_hash(data)
                        self.in_connections[1][place][3]=torrent_hash
                else:
                    #the connection ID is unknown to this class and it's a incomming connection -> cache the data, SAM will probably send us the STREAM_CONNECTED message soon enough
                    self.cache[0]=connection_id
                    self.cache[1]=data
                    self.log.add('SAM_TCP', '"'+connection_id+'" - cached data', 'DEBUG')
            else:
                #outbound connection
                if connection_id in self.out_connections[0]:
                    place = self.out_connections[0].index(connection_id)
                    self.out_connections[1][place][0].append(data)
                else:
                    #the connection ID is unknown to this class and it's an outbound connection -> discard the data
                    self.log.add('SAM_TCP', '"'+connection_id+'" - discarded data', 'DEBUG')
        else:
            #SAM still needs to send us some data
            self.received_data.append('STREAM RECEIVED ID='+connection_id+' SIZE='+str(size)+'\n'+data)

    def get_in_conns(self, torrent_hash):
        #returns all currently existing incomming connections, both closed and not closed ones,
        #but only the ones with a matching torrent_hash
        self.lock.acquire()
        try:
            current_time = time.time()
            response = []
            for i in xrange(0, len(self.in_connections[1])):
                if self.in_connections[1][i][3]==torrent_hash:
                    self.in_connections[1][i][4] = current_time
                    response.append([self.in_connections[0][i], self.in_connections[1][i][1]])
        except:
            #internal error
            response = 'ERROR'
            self.log_traceback()
        self.lock.release()
        return response

    def get_torrent_hash(self, data):
        if len(data)>48:
            if data[1:20]=='BitTorrent protocol':
                torrent_hash = data[28:48]
            else:
                torrent_hash = 'unknown'
        else:
            torrent_hash = 'unknown'
        return torrent_hash

    def timeout(self, timeout_time):
        self.lock.acquire()
        current_time = time.time()
        response = []
        for i in xrange(0, len(self.in_connections[1])):
            if (current_time - self.in_connections[1][i][4])>timeout_time:
                response.append([self.in_connections[0][i], self.in_connections[1][i][1]])
        for data_set in response:
            self.shutdown(data_set[0], should_lock=False)
        self.lock.release()
        return response
