# Written by Bram Cohen
# see LICENSE.txt for license information

#I2P: use httpproxy
from eep import urlopen, quote
#/I2P
from urllib import quote
from httplib import InvalidURL
from btformats import check_peers
from bencode import bdecode
from threading import Thread, Lock
from socket import error
from time import time
from random import randrange
from binascii import b2a_hex
import socket
import httplib
import gzip
from cStringIO import StringIO

class Rerequester:
#I2P: add http proxy
    def __init__(self, url, interval, url_list, sched, howmany, minpeers, 
            connect, externalsched, amount_left, up, down,
            port, ip, myid, infohash, timeout, errorfunc, maxpeers, doneflag,
            upratefunc, downratefunc, ever_got_incoming, http_proxy, InvokeLater, ScrapeCatcher):
#/I2P
        
        self.InvokeLater = InvokeLater
        self.ScrapeCatcher = ScrapeCatcher
        self.url_params = ('?info_hash=%s&peer_id=%s&port=%s' %
            (quote(infohash), quote(myid), str(port))) 
        if ip != '':
            #Rawn: Added ".i2p" for compatibility with the Azureus-Tracker...
            self.url_params += '&ip=' + quote(ip) + '.i2p'
        
        self.url_list = []
        if url_list == None:
            self.url_list.append(url)
        else:
            for ugroup in url_list:
                for url in ugroup:
                    self.url_list.append(url)

        self.interval = interval
        self.last = None
        self.trackerid = None
        self.announce_interval = 30 * 60
        self.sched = sched
        self.howmany = howmany
        self.minpeers = minpeers
        self.connect = connect
        self.externalsched = externalsched
        self.amount_left = amount_left
        self.up = up
        self.down = down
        self.timeout = timeout
        self.errorfunc = errorfunc
        self.maxpeers = maxpeers
        self.doneflag = doneflag
        self.upratefunc = upratefunc
        self.downratefunc = downratefunc
        self.ever_got_incoming = ever_got_incoming
        self.last_failed = True
        self.last_time = 0
        self.curr_url = ""
        self.key = b2a_hex( myid[::-1][:4] )
#I2P: add http proxy
        self.http_proxy = http_proxy
#/I2P

    def c(self):
        self.sched(self.c, self.interval)
        if self.ever_got_incoming():
            getmore = self.howmany() <= self.minpeers / 3
        else:
            getmore = self.howmany() < self.minpeers
        if getmore or time() - self.last_time > self.announce_interval:
            self.announce()

    def begin(self):
        self.sched(self.c, self.interval)
        self.announce(0)
    
    def get_url(self):
        url = self.url_list.pop(0)
        self.url_list.append(url)
        return url
   
    def announce(self, event = None, url=None):
        self.last_time = time()
        if url == None:
            url = self.get_url()

        self.curr_url = url
        urlstr = "%s%s" % (url, self.url_params)
        
        #print 'announcing to', self.curr_url
        
        s = ('%s&uploaded=%s&downloaded=%s&left=%s' %
            (urlstr, str(self.up()), str(self.down()), str(self.amount_left())))
        if self.last is not None:
            s += '&last=' + quote(str(self.last))
        if self.trackerid is not None:
            s += '&trackerid=' + quote(str(self.trackerid))
        if self.howmany() >= self.maxpeers:
            s += '&numwant=0'
#I2P: dont use compact mode
#        else:
#            s += '&no_peer_id=1&compact=1&numwant='+ str(self.maxpeers - self.howmany())            
#/I2P
        if event != None:
            s += '&event=' + ['started', 'completed', 'stopped'][event]
        s += '&key=' + self.key
        #print s

        set = SetOnce().set
        def checkfail(self = self, set = set):
            if set():
                if self.last_failed:
                    if self.upratefunc() < 100 and self.downratefunc() < 100:
                        self.errorfunc('Problem connecting to tracker [%s] - timeout exceeded' % self.curr_url, 'tracker_timeout')
                    else:
                        self.errorfunc('Problem connecting to tracker [%s] - timeout exceeded' % self.curr_url, 'tracker_bcool')
                self.last_failed = True
        self.sched(checkfail, self.timeout)
        Thread(target = self.rerequest, args = [s, set]).start()

    def rerequest(self, url, set):
        try:
#I2P: use proxy
            #print 'REQUEST: "'+str(url)[0:10]+'"'
            h = urlopen(url, self.http_proxy)
#/I2P
            r = h.read()
            try:
                #Rawn: Workaround for the Azureus Tracker. Should get unnecessary with I2P 0.6.1.6
                #      Basically the Azureus Tracker sends back a gziped response, which gets decoded here
                data = StringIO(r)
                decod = gzip.GzipFile(fileobj = data)
                r = decod.read()
            except:
                pass
            h.close()
            if set():
                def add(self = self, r = r):
                    self.last_failed = False
                    self.postrequest(r)
                self.externalsched(add, 0)
        except (IOError, error, InvalidURL, socket.error, httplib.HTTPException, ValueError), e:
            if set():
                def fail_404(self = self, r = ('Problem connecting to tracker [%s] - %s' % (self.curr_url, str(e)))):
                    if self.last_failed:
                        self.errorfunc(r, 'tracker_404')
                    self.last_failed = True
                def fail_bcool(self = self, r = ('Problem connecting to tracker [%s] - %s' % (self.curr_url, str(e)))):
                    if self.last_failed:
                        self.errorfunc(r, 'tracker_bcool')
                    self.last_failed = True
                if self.upratefunc() < 100 and self.downratefunc() < 100:
                    self.externalsched(fail_404, 0)
                else:
                    self.externalsched(fail_bcool, 0)
    
      
    def postrequest(self, data):

        #clears white space from end of response data - causes errors in bdecode
        data = data.rstrip()        
        try:
            try:
                r = bdecode(data)
            except ValueError, e:
                self.errorfunc("Warning: Received bad data from tracker - %s" %  str(e), 'tracker_bcool')
                r = bdecode(data, sloppy=1)
            peers = []
            
            check_peers(r)
            if r.has_key('failure reason'):
                if self.upratefunc() < 100 and self.downratefunc() < 100:
                    self.errorfunc(('rejected by tracker [%s] - %s' % (self.curr_url, r['failure reason'])), 'tracker_refuse')
                else:
                    self.errorfunc(('rejected by tracker [%s] - %s' % (self.curr_url, r['failure reason'])), 'tracker_bcool')
            else:
                if r.has_key('warning message'):
                    self.errorfunc(('warning from tracker [%s] - %s' % (self.curr_url, r['warning message'])), 'tracker_bcool')
                    print r['warning message']
                self.announce_interval = r.get('interval', self.announce_interval)
                self.interval = r.get('min interval', self.interval)
                self.trackerid = r.get('tracker id', self.trackerid)
                #Rawn: Would be nifty as a replacement for repeating scrapes, but postmans tracker doesn't support this,
                #      so it's somewhat pointless... still added it as a backup
                complete = r.get('complete')
                incomplete = r.get('incomplete')
                if not (complete==None or incomplete==None):
                    scrape = { 'complete' : r.get('complete'), 'incomplete' : r.get('incomplete') }
                    self.InvokeLater(self.ScrapeCatcher, (True, scrape, True))
                self.last = r.get('last')
                p = r['peers']
                if type(p) == type(''):
                    for x in xrange(0, len(p), 6):
                        ip = '.'.join([str(ord(i)) for i in p[x:x+4]])
                        port = (ord(p[x+4]) << 8) | ord(p[x+5])
                        peers.append((ip, port, None))
                else:
                    for x in p:
                        peers.append((x['ip'], x['port'], x.get('peer id')))
                ps = len(peers) + self.howmany()
                if ps < self.maxpeers:
                    if self.doneflag.isSet():
                        if r.get('num peers', 1000) - r.get('done peers', 0) > ps * 1.2:
                            self.last = None
                    else:
                        if r.get('num peers', 1000) > ps * 1.2:
                            self.last = None
                for x in peers:
                    self.connect((x[0], x[1]), x[2])
            
            collector = r
            collector['peers'] = peers
            self.errorfunc('Tracker Response - %s' % collector,'tracker_response')
                    
        except ValueError, e:
            if data != '':
                
                if self.upratefunc() < 100 and self.downratefunc() < 100:
                    self.errorfunc(('bad data from tracker [%s] - %s' % (self.curr_url, str(e))), 'tracker_refuse')
                else:
                    self.errorfunc(('bad data from tracker [%s] - %s' % (self.curr_url, str(e))), 'tracker_bcool')

        
class SetOnce:
    def __init__(self):
        self.lock = Lock()
        self.first = True

    def set(self):
        try:
            self.lock.acquire()
            r = self.first
            self.first = False
            return r
        finally:
            self.lock.release()

