# Written by Bram Cohen
# see LICENSE.txt for license information

from random import randrange, shuffle, choice

class PiecePicker:
    def __init__(self, numpieces, rarest_first_cutoff = 1):
        self.rarest_first_cutoff = rarest_first_cutoff
        self.numpieces = numpieces
        self.interests = [range(numpieces)]
        self.pos_in_interests = range(numpieces)
        self.numinterests = [0] * numpieces
        self.numavail = [0] * numpieces #g3rmz
        self.started = []
        self.seedstarted = []
        self.numgot = 0
        self.scrambled = range(numpieces)
        shuffle(self.scrambled)
        self.ranges = [[0, numpieces]] #g3rmz

    def got_have(self, piece):
        self.numavail[piece] += 1
        if self.numinterests[piece] is None:
            return
        numint = self.numinterests[piece]
        if numint == len(self.interests) - 1:
            self.interests.append([])
        self.numinterests[piece] += 1
        self._shift_over(piece, self.interests[numint], self.interests[numint + 1])

    def lost_have(self, piece):
        self.numavail[piece] -= 1
        if self.numinterests[piece] is None:
            return
        numint = self.numinterests[piece]
        self.numinterests[piece] -= 1
        self._shift_over(piece, self.interests[numint], self.interests[numint - 1])

    def _shift_over(self, piece, l1, l2):
        p = self.pos_in_interests[piece]
        l1[p] = l1[-1]
        self.pos_in_interests[l1[-1]] = p
        del l1[-1]
        newp = randrange(len(l2) + 1)
        if newp == len(l2):
            self.pos_in_interests[piece] = len(l2)
            l2.append(piece)
        else:
            old = l2[newp]
            self.pos_in_interests[old] = len(l2)
            l2.append(old)
            l2[newp] = piece
            self.pos_in_interests[piece] = newp

    def requested(self, piece, seed = False):
        if piece not in self.started:
            self.started.append(piece)
        if seed and piece not in self.seedstarted:
            self.seedstarted.append(piece)

    def complete(self, piece):
        assert self.numinterests[piece] is not None
        self.numgot += 1
        l = self.interests[self.numinterests[piece]]
        p = self.pos_in_interests[piece]
        l[p] = l[-1]
        self.pos_in_interests[l[-1]] = p
        del l[-1]
        self.numinterests[piece] = None
        try:
            self.started.remove(piece)
            self.seedstarted.remove(piece)
        except ValueError:
            pass
    
    
    def next(self, havefunc, seed = False):
        piece = None
        for start, end in self.ranges:
            piece = self.get_next(havefunc, start, end, seed)
            if piece != None:
                break
        return piece
        
    
    def get_next(self, havefunc, start, end, seed):
        bests = None
        bestnum = 2 ** 30
        if seed:
            s = self.seedstarted
        else:
            s = self.started
        for i in s:
            if havefunc(i):
                if self.numinterests[i] < bestnum:
                    bests = [i]
                    bestnum = self.numinterests[i]
                elif self.numinterests[i] == bestnum:
                    bests.append(i)
        if bests:
            shuffle(bests)
            for j in bests:
                for start, end in self.ranges:
                    if j >= start and j <= end and havefunc(j):
                        return j

        for i in xrange(1, min(bestnum, len(self.interests))):
            for j in self.interests[i]:
                if j >= start and j <= end and havefunc(j):
                    return j
        return None    
    

    def am_I_complete(self):
        return self.numgot == self.numpieces

    def bump(self, piece):
        l = self.interests[self.numinterests[piece]]
        pos = self.pos_in_interests[piece]
        del l[pos]
        l.append(piece)
        for i in range(pos,len(l)):
            self.pos_in_interests[l[i]] = i
            
    def get_numavail(self):
        return self.numavail
    
    def get_interests(self):
        return self.interests
        
