"""
Logger class

Written by duck in 2004 and released into the public domain.
"""

import time
try:
    import logging
except ImportError:
    logging = None

class Logger:
    
    def __init__(self, name):
        if logging:
            self._initLogger(name, logging.INFO)
            self.debug = self.logger.debug
            self.error = self.logger.error
            self.info = self.logger.info
            self.warn = self.logger.warn
        else:
            self.logger = None
            self.debug = self._debug
            self.error = self._error
            self.info = self._info
            self.warn = self._warn
    
    def _initLogger(self, name, level):
        """
        initialize a logger with specified name and loglevel
        """
        logger = logging.getLogger(name)
        #I2P: No, we don't want one log for every torrent...
        #fhdlr = logging.FileHandler(name + '.log')
        #/I2P
        shdlr = logging.StreamHandler()
        formatter = logging.Formatter('%(asctime)s %(levelname)s: %(message)s')
        formatter.converter = time.gmtime
        #I2P: see above
        #fhdlr.setFormatter(formatter)
        #/I2P
        shdlr.setFormatter(formatter)
        #I2P: see above
        #logger.addHandler(fhdlr)
        #/I2P
        logger.addHandler(shdlr)
        logger.setLevel(level)
        self.logger = logger

    def _print(self, name, msg, *args):
        now = time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime())
        message = msg % args
        print "%s %s: %s" % (now, name, message)

    def _debug(self, msg, *args, **kwargs):
        self._print('DEBUG', msg, *args)

    def _error(self, msg, *args, **kwargs):
        self._print('ERROR', msg, *args)

    def _info(self, msg, *args, **kwargs):
        self._print('INFO', msg, *args)

    def _warn(self, msg, *args, **kwargs):
        self._print('WARN', msg, *args)

def main():
    logger = Logger('blub')
    logger.warn('Oh no!')
    logger.error('Oh no!')

if __name__ == '__main__':
    main()
