# Written by Bram Cohen and Jeremy Arendt
# see LICENSE.txt for license information

from random import randrange


class Choker:
    def __init__(self, max_uploads, schedule, friendfunc, infohash, done = lambda: False, min_uploads = None):
        self.max_uploads = max_uploads
        if min_uploads is None:
            min_uploads = max_uploads
        self.min_uploads = min_uploads
        self.schedule = schedule
        self.getfriends = friendfunc
        self.connections = []
        self.infohash = infohash
        self.count = 0
        self.done = done
        self.choke_delay = 10
        self.optimistic_uchoke_period = 3
        self.min_rate = 0.0
        self._SelectChokeAlgo(0, [10, 3, 0], 0, 0, 0)
        schedule(self._OnChoke, self.choke_delay)        
    #d: [choke_delay, optimistic_uchoke_period, self.min_rate]    
    def SelectChokeAlgo(self, newval, d, choke_udban, choke_activate, choke_multiplier):
        def foo(self=self, newval=newval, d=d):
            self._SelectChokeAlgo(newval, d, choke_udban, choke_activate, choke_multiplier)
        self.schedule(foo, 0),        
    
    def _SelectChokeAlgo(self, s, d, choke_udban, choke_activate, choke_multiplier):
        self.choke_delay = d[0]
        self.min_rate = d[2]
        self.choke_udban = choke_udban        
        self.choke_activate = choke_activate
        self.choke_multiplier = choke_multiplier

        if self.choke_delay >= self.optimistic_uchoke_period:
            self.optimistic_uchoke_period = 1
        else:
            self.optimistic_uchoke_period = int(self.optimistic_uchoke_period / self.choke_delay)
        
        if s == 0:
            self._rechoke = self._g3_rechoke
            self._shuffler = self._round_robin
        elif s == 1:
            self._rechoke = self._BT34_rechoke
            self._shuffler = self._round_robin
        elif s == 2:            
            self._rechoke = self._leoxv_rechoke
            self._shuffler = self._round_robin
        else:
            self._rechoke = self._BT34_rechoke
            self._shuffler = self._round_robin
        
    def _OnChoke(self):
        self.schedule(self._OnChoke, self.choke_delay)
        self.count += 1
        self._shuffler()        # call a shuffler
        self._rechoke()         # call a choker        

    def _no_shuffle(self):
        pass
                    
    def _round_robin(self):
        if self.count % self.optimistic_uchoke_period == 0:
            for i in xrange(len(self.connections)):
                u = self.connections[i].get_upload()
                if u.is_choked() and u.is_interested():
                    self.connections = self.connections[i:] + self.connections[:i]
                    break
                    
    def _leoxv_rechoke(self): ## By Jukka Lehtomaki all rights reserved        
        preferred = []
        friends = []
        friends_ip, foes_ip = self.getfriends(self.infohash)        
          
        if self.count % self.optimistic_uchoke_period == 0:  ## LeoXV 2005 CPU usage hack    
            if len(friends_ip) > 0:
                for c in self.connections:
                    if not self._snubbed(c) and c.get_upload().is_interested():
                        try:
                            if friends_ip.has_key(c.get_ip()):
                                friends.append(c)
                        except:
                            print "could not get connection's ip"

        del friends[self.max_uploads-1:]
        
        for c in self.connections:
            if not self._snubbed(c) and c.get_upload().is_interested() \
                and self._rate(c) >= self.min_rate:
                    preferred.append((-self._rate(c), c))
        preferred.sort()

        nperferred = max(0, self.max_uploads - (len(friends) + 1))
        try:
            del preferred[nperferred:]
        except TypeError:
            print 'DEBUG: slice index was not an integer',  nperferred
        preferred = [x[1] for x in preferred]

        preferred = friends + preferred
        count = len(preferred)
        hit = False
        
        j = 0
        for c in self.connections:
            u = c.get_upload()

            if self.count % self.optimistic_uchoke_period == 0:  ## LeoXV 2005 CPU usage hack  
                if foes_ip.has_key(c.get_ip()):
                    self.close_connection(c)
                    continue                    
            if c in preferred:
                j+=1
                u.unchoke()
            else:
                if count < self.min_uploads or not hit:
                    j+=1
                    u.unchoke()
                    if u.is_interested():
                        count += 1
                        hit = True
                else:
                    u.choke()                    

            if self.count % self.optimistic_uchoke_period == 0:  ## LeoXV 2005 CPU usage hack
                if not self.done(): ## LeoXV               
                    d = c.get_download() 
                    iutotal = d.connection.upload.measure.get_total()
                    idtotal = d.connection.download.measure.get_total()
                    
                    try:
                        share_ratio = ((float(iutotal)+1) / (float(idtotal)+1))
                    except ZeroDivisionError:
                        share_ratio = "0"   
                    
                    if share_ratio != None and self.choke_udban >= 1:
                        if share_ratio > self.choke_udban and iutotal > (1048576 * self.choke_activate):                   
                            u.choke() ## choke
    ##                        self.close_connection(c) ## ban
                            continue

    def _g3_rechoke(self):
        preferred = []
        friends = []
        friends_ip, foes_ip = self.getfriends(self.infohash)
        
        if self.count % self.optimistic_uchoke_period == 0:  ## LeoXV 2005 CPU usage hack
            if len(friends_ip) > 0:
                for c in self.connections:
                    if not self._snubbed(c) and c.get_upload().is_interested():
                        try:
                            if friends_ip.has_key(c.get_ip()):
                                friends.append(c)
                        except:
                            print "could not get connection's ip"

        del friends[self.max_uploads-1:]
        
        for c in self.connections:
            if not self._snubbed(c) and c.get_upload().is_interested() \
                and self._rate(c) >= self.min_rate:
                    preferred.append((-self._rate(c), c))
        preferred.sort()

        nperferred = max(0, self.max_uploads - (len(friends) + 1))
        try:
            del preferred[nperferred:]
        except TypeError:
            print 'DEBUG: slice index was not an integer',  nperferred
        preferred = [x[1] for x in preferred]

        preferred = friends + preferred
        count = len(preferred)
        hit = False
        
        j = 0
        for c in self.connections:
            u = c.get_upload()
            
            if self.count % self.optimistic_uchoke_period == 0:  ## LeoXV 2005 CPU usage hack            
                if foes_ip.has_key(c.get_ip()):
                    self.close_connection(c)
                    continue
                
            if c in preferred:
                j+=1
                u.unchoke()
            else:
                if count < self.min_uploads or not hit:
                    j+=1
                    u.unchoke()
                    if u.is_interested():
                        count += 1
                        hit = True
                else:
                    u.choke()
        
    def _BT34_rechoke(self):
        preferred = []
        for c in self.connections:
            if not self._snubbed(c) and c.get_upload().is_interested():
                preferred.append((-self._rate(c), c))
        preferred.sort()
        del preferred[self.max_uploads - 1:]
        preferred = [x[1] for x in preferred]
        count = len(preferred)
        hit = False
        for c in self.connections:
            u = c.get_upload()
            if c in preferred:
                u.unchoke()
            else:
                if count < self.min_uploads or not hit:
                    u.unchoke()
                    if u.is_interested():
                        count += 1
                        hit = True
                else:
                    u.choke()

    def _snubbed(self, c):
        if self.done():
            return False
        return c.get_download().is_snubbed()

    def _rate(self, c):
        if self.done():
            return c.get_upload().get_rate()
        else:
            return c.get_download().get_rate()

    def connection_made(self, connection, p = None):
        if p is None:
            p = randrange(-2, len(self.connections) + 1)
        self.connections.insert(max(p, 0), connection)
        self._rechoke()

    def connection_lost(self, connection):
        self.connections.remove(connection)
        if connection.get_upload().is_interested() and not connection.get_upload().is_choked():
            self._rechoke()

    def interested(self, connection):
        if not connection.get_upload().is_choked():
            self._rechoke()

    def not_interested(self, connection):
        if not connection.get_upload().is_choked():
            self._rechoke()

    def close_connection(self, c):
        def foo(self=self, c=c):
            c.close()
        self.schedule(foo, 0);
        
    def change_max_uploads(self, newval):
        def foo(self=self, newval=newval):
            self._change_max_uploads(newval)
        self.schedule(foo, 0);
    
    def rechoke(self):
        def foo(self=self):
            self._rechoke()
        self.schedule(foo, 0);
                
    def _change_max_uploads(self, newval):
        self.max_uploads = newval
        self.min_uploads = max(1, newval)
        #self._rechoke()

