/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.TrackerInfo;

public class TrackerClient
extends I2PAppThread {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(TrackerClient.class);
    private static final String NO_EVENT = "";
    private static final String STARTED_EVENT = "started";
    private static final String COMPLETED_EVENT = "completed";
    private static final String STOPPED_EVENT = "stopped";
    private static final String NOT_REGISTERED = "torrent not registered";
    private static final int SLEEP = 5;
    private static final int DELAY_MIN = 2000;
    private static final int DELAY_MUL = 1500;
    private static final int MAX_REGISTER_FAILS = 10;
    private static final int INITIAL_SLEEP = 90000;
    private static final int MAX_CONSEC_FAILS = 5;
    private static final int LONG_SLEEP = 1800000;
    private I2PSnarkUtil _util;
    private final MetaInfo meta;
    private final PeerCoordinator coordinator;
    private final int port;
    private boolean stop;
    private boolean started;
    private List trackers;

    public TrackerClient(I2PSnarkUtil util, MetaInfo meta, PeerCoordinator coordinator) {
        super("TrackerClient-" + TrackerClient.urlencode(coordinator.getID()));
        this._util = util;
        this.meta = meta;
        this.coordinator = coordinator;
        this.port = 6881;
        this.stop = false;
        this.started = false;
    }

    public void start() {
        if (this.stop) {
            throw new RuntimeException("Dont rerun me, create a copy");
        }
        super.start();
        this.started = true;
    }

    public boolean halted() {
        return this.stop;
    }

    public boolean started() {
        return this.started;
    }

    public void halt() {
        this.stop = true;
        this.interrupt();
    }

    private boolean verifyConnected() {
        while (!this.stop && !this._util.connected()) {
            boolean ok = this._util.connect();
            if (ok) continue;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.stop && this._util.connected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String infoHash = TrackerClient.urlencode(this.meta.getInfoHash());
        String peerID = TrackerClient.urlencode(this.coordinator.getID());
        this._log.debug("Announce: [" + this.meta.getAnnounce() + "] infoHash: " + infoHash);
        this.trackers = new ArrayList(2);
        String primary = this.meta.getAnnounce();
        if (TrackerClient.isValidAnnounce(primary)) {
            this.trackers.add(new Tracker(this.meta.getAnnounce(), true));
        } else {
            this._log.warn("Skipping invalid or non-i2p announce: " + primary);
        }
        List tlist = this._util.getOpenTrackers();
        if (tlist != null) {
            for (int i = 0; i < tlist.size(); ++i) {
                String url = (String)tlist.get(i);
                if (!TrackerClient.isValidAnnounce(url)) {
                    this._log.error("Bad announce URL: [" + url + "]");
                    continue;
                }
                int slash = url.indexOf(47, 7);
                if (slash <= 7) {
                    this._log.error("Bad announce URL: [" + url + "]");
                    continue;
                }
                if (primary.startsWith(url.substring(0, slash))) continue;
                String dest = this._util.lookup(url.substring(7, slash));
                if (dest == null) {
                    this._log.error("Announce host unknown: [" + url.substring(7, slash) + "]");
                    continue;
                }
                if (primary.startsWith("http://" + dest) || primary.startsWith("http://i2p/" + dest)) continue;
                this.trackers.add(new Tracker(url, false));
                this._log.debug("Additional announce: [" + url + "] for infoHash: " + infoHash);
            }
        }
        if (tlist.isEmpty()) {
            this.stop = true;
            this._log.error("No valid trackers for infoHash: " + infoHash);
            return;
        }
        long uploaded = this.coordinator.getUploaded();
        long downloaded = this.coordinator.getDownloaded();
        long left = this.coordinator.getLeft();
        boolean completed = left == 0L;
        int sleptTime = 0;
        try {
            if (!this.verifyConnected()) {
                return;
            }
            boolean runStarted = false;
            boolean firstTime = true;
            int consecutiveFails = 0;
            RandomSource r = I2PAppContext.getGlobalContext().random();
            while (!this.stop) {
                String event;
                try {
                    int delay;
                    int random = ((Random)r).nextInt(120000);
                    if (firstTime) {
                        delay = ((Random)r).nextInt(30000);
                        firstTime = false;
                    } else {
                        delay = completed && runStarted ? 900000 + random : (this.coordinator.trackerProblems != null && ++consecutiveFails < 5 ? 90000 : 300000 + random);
                    }
                    if (delay > 0) {
                        Thread.sleep(delay);
                    }
                }
                catch (InterruptedException interrupt) {
                    // empty catch block
                }
                if (this.stop) {
                    return;
                }
                if (!this.verifyConnected()) {
                    return;
                }
                uploaded = this.coordinator.getUploaded();
                downloaded = this.coordinator.getDownloaded();
                left = this.coordinator.getLeft();
                if (!completed && left == 0L) {
                    completed = true;
                    event = COMPLETED_EVENT;
                } else {
                    event = NO_EVENT;
                }
                sleptTime = 0;
                int maxSeenPeers = 0;
                for (Tracker tr : this.trackers) {
                    block54: {
                        if (!(this.stop || tr.stop || !completed && !this.coordinator.needPeers() || !event.equals(COMPLETED_EVENT) && System.currentTimeMillis() <= tr.lastRequestTime + tr.interval)) {
                            try {
                                if (!tr.started) {
                                    event = STARTED_EVENT;
                                }
                                TrackerInfo info = this.doRequest(tr, infoHash, peerID, uploaded, downloaded, left, event);
                                this.coordinator.trackerProblems = null;
                                tr.trackerProblems = null;
                                tr.registerFails = 0;
                                tr.consecutiveFails = 0;
                                if (tr.isPrimary) {
                                    consecutiveFails = 0;
                                }
                                runStarted = true;
                                tr.started = true;
                                Set<Peer> peers = info.getPeers();
                                tr.seenPeers = info.getPeerCount();
                                if (this.coordinator.trackerSeenPeers < tr.seenPeers) {
                                    this.coordinator.trackerSeenPeers = tr.seenPeers;
                                }
                                if (left > 0L && !completed) {
                                    ArrayList<Peer> ordered = new ArrayList<Peer>(peers);
                                    Collections.shuffle(ordered, r);
                                    Iterator it = ordered.iterator();
                                    while (!this.stop && it.hasNext()) {
                                        Peer cur = (Peer)it.next();
                                        if (!this.coordinator.addPeer(cur)) continue;
                                        int delay = 1500;
                                        delay *= cur.getPeerID().getAddress().calculateHash().toBase64().charAt(0) % 10;
                                        sleptTime += (delay += 2000);
                                        try {
                                            Thread.sleep(delay);
                                        }
                                        catch (InterruptedException ie) {}
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                this._util.debug("WARNING: Could not contact tracker at '" + tr.announce + "': " + ioe, 2);
                                tr.trackerProblems = ioe.getMessage();
                                if (tr.isPrimary) {
                                    this.coordinator.trackerProblems = tr.trackerProblems;
                                }
                                if (tr.trackerProblems.toLowerCase().startsWith(NOT_REGISTERED)) {
                                    if (this.trackers.size() == 1) {
                                        this.stop = true;
                                        this.coordinator.snark.stopTorrent();
                                    } else if (tr.registerFails++ > 10) {
                                        tr.stop = true;
                                    }
                                }
                                if (++tr.consecutiveFails != 5) break block54;
                                tr.seenPeers = 0;
                                if (tr.interval >= 1800000L) break block54;
                                tr.interval = 1800000L;
                            }
                        }
                    }
                    if (tr.stop || maxSeenPeers >= tr.seenPeers) continue;
                    maxSeenPeers = tr.seenPeers;
                }
                this.coordinator.trackerSeenPeers = maxSeenPeers;
                if (runStarted) continue;
                this._util.debug("         Retrying in one minute...", 5);
            }
            return;
        }
        catch (Throwable t) {
            this._util.debug("TrackerClient: " + t, 1, t);
            if (!(t instanceof OutOfMemoryError)) return;
            throw (OutOfMemoryError)t;
        }
        finally {
            try {
                Iterator iter = this.trackers.iterator();
                while (iter.hasNext()) {
                    if (!this._util.connected()) {
                        return;
                    }
                    Tracker tr = (Tracker)iter.next();
                    if (!tr.started || tr.stop || tr.trackerProblems != null) continue;
                    this.doRequest(tr, infoHash, peerID, uploaded, downloaded, left, STOPPED_EVENT);
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackerInfo doRequest(Tracker tr, String infoHash, String peerID, long uploaded, long downloaded, long left, String event) throws IOException {
        String s = tr.announce + "?info_hash=" + infoHash + "&peer_id=" + peerID + "&port=" + this.port + "&ip=" + this._util.getOurIPString() + ".i2p" + "&uploaded=" + uploaded + "&downloaded=" + downloaded + "&left=" + left + "&compact=1" + (!event.equals(NO_EVENT) ? "&event=" + event : NO_EVENT);
        s = left <= 0L || event.equals(STOPPED_EVENT) || !this.coordinator.needPeers() ? s + "&numwant=0" : s + "&numwant=" + this._util.getMaxConnections();
        this._util.debug("Sending TrackerClient request: " + s, 4);
        tr.lastRequestTime = System.currentTimeMillis();
        File fetched = this._util.get(s);
        if (fetched == null) {
            throw new IOException("Error fetching " + s);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(fetched);
            TrackerInfo info = new TrackerInfo(in, this.coordinator.getID(), this.coordinator.getMetaInfo());
            this._util.debug("TrackerClient response: " + info, 4);
            String failure = info.getFailureReason();
            if (failure != null) {
                throw new IOException(failure);
            }
            tr.interval = info.getInterval() * 1000;
            TrackerInfo trackerInfo = info;
            return trackerInfo;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {}
            }
            fetched.delete();
        }
    }

    public static String urlencode(byte[] bs) {
        StringBuilder sb = new StringBuilder(bs.length * 3);
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                sb.append((char)c);
                continue;
            }
            sb.append('%');
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }

    static boolean isValidAnnounce(String ann) {
        URL url;
        try {
            url = new URL(ann);
        }
        catch (MalformedURLException mue) {
            return false;
        }
        return url.getProtocol().equals("http") && (url.getHost().endsWith(".i2p") || url.getHost().equals("i2p")) && url.getPort() < 0;
    }

    private static class Tracker {
        String announce;
        boolean isPrimary;
        long interval;
        long lastRequestTime;
        String trackerProblems;
        boolean stop;
        boolean started;
        int registerFails;
        int consecutiveFails;
        int seenPeers;

        public Tracker(String a, boolean p) {
            this.announce = a;
            this.isPrimary = p;
            this.interval = 90000L;
            this.lastRequestTime = 0L;
            this.trackerProblems = null;
            this.stop = false;
            this.started = false;
            this.registerFails = 0;
            this.consecutiveFails = 0;
            this.seenPeers = 0;
        }
    }
}

