/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.crypto.SHA1;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.StorageListener;

public class Storage {
    private MetaInfo metainfo;
    private long[] lengths;
    private RandomAccessFile[] rafs;
    private String[] names;
    private Object[] RAFlock;
    private long[] RAFtime;
    private File[] RAFfile;
    private int[] priorities;
    private final StorageListener listener;
    private I2PSnarkUtil _util;
    private BitField bitfield;
    private int needed;
    private boolean _probablyComplete;
    int piece_size;
    int pieces;
    boolean changed;
    private static final int MIN_PIECE_SIZE = 262144;
    public static final int MAX_PIECE_SIZE = 0x200000;
    public static final int MAX_PIECES = 10240;
    public static final long MAX_TOTAL_SIZE = 0x500000000L;
    private static final char[] ILLEGAL = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'};
    private static final long RAFCloseDelay = 420000L;

    public Storage(I2PSnarkUtil util, MetaInfo metainfo, StorageListener listener) throws IOException {
        this._util = util;
        this.metainfo = metainfo;
        this.listener = listener;
        this.needed = metainfo.getPieces();
        this._probablyComplete = false;
        this.bitfield = new BitField(this.needed);
    }

    public Storage(I2PSnarkUtil util, File baseFile, String announce, StorageListener listener) throws IOException {
        this._util = util;
        this.listener = listener;
        this.getFiles(baseFile);
        long total = 0L;
        ArrayList<Long> lengthsList = new ArrayList<Long>();
        for (int i = 0; i < this.lengths.length; ++i) {
            long length = this.lengths[i];
            total += length;
            lengthsList.add(new Long(length));
        }
        this.piece_size = 262144;
        this.pieces = (int)((total - 1L) / (long)this.piece_size) + 1;
        while (this.pieces > 10240 && this.piece_size < 0x200000) {
            this.piece_size *= 2;
            this.pieces = (int)((total - 1L) / (long)this.piece_size) + 1;
        }
        byte[] piece_hashes = new byte[20 * this.pieces];
        this.bitfield = new BitField(this.pieces);
        this.needed = 0;
        ArrayList files = new ArrayList();
        for (int i = 0; i < this.names.length; ++i) {
            ArrayList<String> file = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.names[i], File.separator);
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                file.add(part);
            }
            files.add(file);
        }
        if (files.size() == 1) {
            files = null;
            lengthsList = null;
        }
        this.metainfo = new MetaInfo(announce, baseFile.getName(), null, files, lengthsList, this.piece_size, piece_hashes, total);
    }

    public void create() throws IOException {
        this.fast_digestCreate();
    }

    private void fast_digestCreate() throws IOException {
        SHA1 digest = new SHA1();
        byte[] piece_hashes = this.metainfo.getPieceHashes();
        byte[] piece = new byte[this.piece_size];
        for (int i = 0; i < this.pieces; ++i) {
            int length = this.getUncheckedPiece(i, piece);
            digest.update(piece, 0, length);
            byte[] hash = digest.digest();
            for (int j = 0; j < 20; ++j) {
                piece_hashes[20 * i + j] = hash[j];
            }
            this.bitfield.set(i);
        }
        this.metainfo = this.metainfo.reannounce(this.metainfo.getAnnounce());
    }

    private void getFiles(File base) throws IOException {
        ArrayList files = new ArrayList();
        this.addFiles(files, base);
        int size = files.size();
        this.names = new String[size];
        this.lengths = new long[size];
        this.rafs = new RandomAccessFile[size];
        this.RAFlock = new Object[size];
        this.RAFtime = new long[size];
        this.RAFfile = new File[size];
        this.priorities = new int[size];
        int i = 0;
        for (File f : files) {
            this.names[i] = f.getPath();
            if (base.isDirectory() && this.names[i].startsWith(base.getPath())) {
                this.names[i] = this.names[i].substring(base.getPath().length() + 1);
            }
            this.lengths[i] = f.length();
            this.RAFlock[i] = new Object();
            this.RAFfile[i] = f;
            ++i;
        }
    }

    private void addFiles(List l, File f) {
        if (!f.isDirectory()) {
            l.add(f);
        } else {
            File[] files = f.listFiles();
            if (files == null) {
                this._util.debug("WARNING: Skipping '" + f + "' not a normal file.", 2);
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                this.addFiles(l, files[i]);
            }
        }
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    public int needed() {
        return this.needed;
    }

    public boolean complete() {
        return this.needed == 0;
    }

    public long remaining(String file) {
        long bytes = 0L;
        for (int i = 0; i < this.rafs.length; ++i) {
            File f = this.RAFfile[i];
            String canonical = null;
            if (f != null) {
                try {
                    canonical = f.getCanonicalPath();
                }
                catch (IOException ioe) {
                    f = null;
                }
            }
            if (f != null && canonical.equals(file)) {
                if (this.complete()) {
                    return 0L;
                }
                int psz = this.metainfo.getPieceLength(0);
                long start = bytes;
                long end = start + this.lengths[i];
                int pc = (int)(bytes / (long)psz);
                long rv = 0L;
                if (!this.bitfield.get(pc)) {
                    rv = Math.min((long)psz - start % (long)psz, this.lengths[i]);
                }
                int pieces = this.metainfo.getPieces();
                for (int j = pc + 1; (long)j * (long)psz < end && j < pieces; ++j) {
                    if (this.bitfield.get(j)) continue;
                    if ((long)(j + 1) * (long)psz < end) {
                        rv += (long)psz;
                        continue;
                    }
                    rv += end - (long)j * (long)psz;
                }
                return rv;
            }
            bytes += this.lengths[i];
        }
        return -1L;
    }

    public int getPriority(String file) {
        if (this.complete() || this.metainfo.getFiles() == null || this.priorities == null) {
            return 0;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            File f = this.RAFfile[i];
            if (f == null) continue;
            try {
                String canonical = f.getCanonicalPath();
                if (!canonical.equals(file)) continue;
                return this.priorities[i];
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setPriority(String file, int pri) {
        if (this.complete() || this.metainfo.getFiles() == null || this.priorities == null) {
            return;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            File f = this.RAFfile[i];
            if (f == null) continue;
            try {
                String canonical = f.getCanonicalPath();
                if (!canonical.equals(file)) continue;
                this.priorities[i] = pri;
                return;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public int[] getFilePriorities() {
        return this.priorities;
    }

    void setFilePriorities(int[] p) {
        this.priorities = p;
    }

    public int[] getPiecePriorities() {
        if (this.complete() || this.metainfo.getFiles() == null || this.priorities == null) {
            return null;
        }
        int[] rv = new int[this.metainfo.getPieces()];
        int file = 0;
        long pcEnd = -1L;
        long fileEnd = this.lengths[0] - 1L;
        int psz = this.metainfo.getPieceLength(0);
        for (int i = 0; i < rv.length; ++i) {
            pcEnd += (long)psz;
            int pri = this.priorities[file];
            while (fileEnd <= pcEnd && file < this.lengths.length - 1) {
                long oldFileEnd = fileEnd;
                fileEnd += this.lengths[++file];
                if (this.priorities[file] <= pri || oldFileEnd >= pcEnd) continue;
                pri = this.priorities[file];
            }
            rv[i] = pri;
        }
        return rv;
    }

    public BitField getBitField() {
        return this.bitfield;
    }

    public String getBaseName() {
        return Storage.filterName(this.metainfo.getName());
    }

    public void check(String rootDir) throws IOException {
        this.check(rootDir, 0L, null);
    }

    public void check(String rootDir, long savedTime, BitField savedBitField) throws IOException {
        File base = new File(rootDir, Storage.filterName(this.metainfo.getName()));
        boolean useSavedBitField = savedTime > 0L && savedBitField != null;
        List files = this.metainfo.getFiles();
        if (files == null) {
            long lm;
            this._util.debug("Creating/Checking file: " + base, 3);
            if (!base.createNewFile() && !base.exists()) {
                throw new IOException("Could not create file " + base);
            }
            this.lengths = new long[1];
            this.rafs = new RandomAccessFile[1];
            this.names = new String[1];
            this.RAFlock = new Object[1];
            this.RAFtime = new long[1];
            this.RAFfile = new File[1];
            this.lengths[0] = this.metainfo.getTotalLength();
            this.RAFlock[0] = new Object();
            this.RAFfile[0] = base;
            if (useSavedBitField && ((lm = base.lastModified()) <= 0L || lm > savedTime)) {
                useSavedBitField = false;
            }
            this.names[0] = base.getName();
        } else {
            this._util.debug("Creating/Checking directory: " + base, 3);
            if (!base.mkdir() && !base.isDirectory()) {
                throw new IOException("Could not create directory " + base);
            }
            List ls = this.metainfo.getLengths();
            int size = files.size();
            long total = 0L;
            this.lengths = new long[size];
            this.rafs = new RandomAccessFile[size];
            this.names = new String[size];
            this.RAFlock = new Object[size];
            this.RAFtime = new long[size];
            this.RAFfile = new File[size];
            for (int i = 0; i < size; ++i) {
                long lm;
                File f = this.createFileFromNames(base, (List)files.get(i));
                this.lengths[i] = (Long)ls.get(i);
                this.RAFlock[i] = new Object();
                this.RAFfile[i] = f;
                total += this.lengths[i];
                if (useSavedBitField && ((lm = base.lastModified()) <= 0L || lm > savedTime)) {
                    useSavedBitField = false;
                }
                this.names[i] = f.getName();
            }
            long metalength = this.metainfo.getTotalLength();
            if (total != metalength) {
                throw new IOException("File lengths do not add up " + total + " != " + metalength);
            }
        }
        if (useSavedBitField) {
            this.bitfield = savedBitField;
            this.needed = this.metainfo.getPieces() - this.bitfield.count();
            this._probablyComplete = this.complete();
            this._util.debug("Found saved state and files unchanged, skipping check", 3);
        } else {
            this.changed = true;
            this.checkCreateFiles();
        }
        if (this.complete()) {
            this._util.debug("Torrent is complete", 3);
        } else {
            if (files != null) {
                this.priorities = new int[files.size()];
            }
            this._util.debug("Still need " + this.needed + " out of " + this.metainfo.getPieces() + " pieces", 3);
        }
    }

    public void reopen(String rootDir) throws IOException {
        File base = new File(rootDir, Storage.filterName(this.metainfo.getName()));
        List files = this.metainfo.getFiles();
        if (files == null) {
            this._util.debug("Reopening file: " + base, 3);
            if (!base.exists()) {
                throw new IOException("Could not reopen file " + base);
            }
        } else {
            this._util.debug("Reopening directory: " + base, 3);
            if (!base.isDirectory()) {
                throw new IOException("Could not reopen directory " + base);
            }
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                File f = Storage.getFileFromNames(base, (List)files.get(i));
                if (f.exists()) continue;
                throw new IOException("Could not reopen file " + f);
            }
        }
    }

    private static String filterName(String name) {
        if (name.equals(".") || name.equals(" ")) {
            return "_";
        }
        String rv = name;
        if (rv.startsWith(".")) {
            rv = '_' + rv.substring(1);
        }
        if (rv.endsWith(".") || rv.endsWith(" ")) {
            rv = rv.substring(0, rv.length() - 1) + '_';
        }
        for (int i = 0; i < ILLEGAL.length; ++i) {
            if (rv.indexOf(ILLEGAL[i]) < 0) continue;
            rv = rv.replace(ILLEGAL[i], '_');
        }
        return rv;
    }

    private File createFileFromNames(File base, List names) throws IOException {
        File f = null;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = Storage.filterName((String)it.next());
            if (it.hasNext()) {
                f = new File(base, name);
                if (!f.mkdir() && !f.isDirectory()) {
                    throw new IOException("Could not create directory " + f);
                }
                base = f;
                continue;
            }
            f = new File(base, name);
            if (f.createNewFile() || f.exists()) continue;
            throw new IOException("Could not create file " + f);
        }
        return f;
    }

    public static File getFileFromNames(File base, List names) {
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = Storage.filterName((String)it.next());
            base = new File(base, name);
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCreateFiles() throws IOException {
        boolean resume = false;
        this._probablyComplete = true;
        this.needed = this.metainfo.getPieces();
        for (int i = 0; i < this.rafs.length; ++i) {
            Object object;
            long length = this.RAFfile[i].length();
            if (this.RAFfile[i].exists() && length == this.lengths[i]) {
                if (this.listener != null) {
                    this.listener.storageAllocated(this, length);
                }
                resume = true;
                continue;
            }
            if (length == 0L) {
                this.changed = true;
                object = this.RAFlock[i];
                synchronized (object) {
                    this.allocateFile(i);
                    try {
                        this.closeRAF(i);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    continue;
                }
            }
            this._util.debug("File '" + this.names[i] + "' exists, but has wrong length - repairing corruption", 1);
            this.changed = true;
            this._probablyComplete = false;
            object = this.RAFlock[i];
            synchronized (object) {
                this.checkRAF(i);
                this.rafs[i].setLength(this.lengths[i]);
                try {
                    this.closeRAF(i);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                continue;
            }
        }
        if (resume) {
            this.pieces = this.metainfo.getPieces();
            byte[] piece = new byte[this.metainfo.getPieceLength(0)];
            int file = 0;
            long fileEnd = this.lengths[0];
            long pieceEnd = 0L;
            for (int i = 0; i < this.pieces; ++i) {
                int length = this.getUncheckedPiece(i, piece);
                boolean correctHash = this.metainfo.checkPiece(i, piece, 0, length);
                pieceEnd += (long)length;
                while (fileEnd <= pieceEnd) {
                    Object object = this.RAFlock[file];
                    synchronized (object) {
                        try {
                            this.closeRAF(file);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    if (++file >= this.rafs.length) break;
                    fileEnd += this.lengths[file];
                }
                if (correctHash) {
                    this.bitfield.set(i);
                    --this.needed;
                }
                if (this.listener == null) continue;
                this.listener.storageChecked(this, i, correctHash);
            }
        }
        this._probablyComplete = this.complete();
        if (this.listener != null) {
            this.listener.storageAllChecked(this);
            if (this.needed <= 0) {
                this.listener.storageCompleted(this);
            }
        }
    }

    private void allocateFile(int nr) throws IOException {
        byte[] zeros;
        this.openRAF(nr, false);
        this.listener.storageCreateFile(this, this.names[nr], this.lengths[nr]);
        int ZEROBLOCKSIZE = this.metainfo.getPieceLength(0);
        try {
            zeros = new byte[ZEROBLOCKSIZE];
        }
        catch (OutOfMemoryError oom) {
            throw new IOException(oom.toString());
        }
        int i = 0;
        while ((long)i < this.lengths[nr] / (long)ZEROBLOCKSIZE) {
            this.rafs[nr].write(zeros);
            if (this.listener != null) {
                this.listener.storageAllocated(this, ZEROBLOCKSIZE);
            }
            ++i;
        }
        int size = (int)(this.lengths[nr] - (long)(i * ZEROBLOCKSIZE));
        this.rafs[nr].write(zeros, 0, size);
        if (this.listener != null) {
            this.listener.storageAllocated(this, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.rafs == null) {
            return;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            if (this.RAFlock[i] == null) continue;
            try {
                Object object = this.RAFlock[i];
                synchronized (object) {
                    this.closeRAF(i);
                    continue;
                }
            }
            catch (IOException ioe) {
                this._util.debug("Error closing " + this.RAFfile[i], 1, ioe);
            }
        }
        this.changed = false;
    }

    public byte[] getPiece(int piece, int off, int len) throws IOException {
        byte[] bs;
        if (!this.bitfield.get(piece)) {
            return null;
        }
        try {
            bs = new byte[len];
        }
        catch (OutOfMemoryError oom) {
            this._util.debug("Out of memory, can't honor request for piece " + piece, 2, oom);
            return null;
        }
        this.getUncheckedPiece(piece, bs, off, len);
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putPiece(int piece, byte[] ba) throws IOException {
        int len;
        long start;
        byte[] bs = (byte[])ba.clone();
        int length = bs.length;
        boolean correctHash = this.metainfo.checkPiece(piece, bs, 0, length);
        if (this.listener != null) {
            this.listener.storageChecked(this, piece, correctHash);
        }
        if (!correctHash) {
            return false;
        }
        BitField bitField = this.bitfield;
        synchronized (bitField) {
            if (this.bitfield.get(piece)) {
                return true;
            }
        }
        int i = 0;
        long raflen = this.lengths[i];
        for (start = (long)piece * (long)this.metainfo.getPieceLength(0); start > raflen; start -= raflen) {
            raflen = this.lengths[++i];
        }
        int off = 0;
        for (int written = 0; written < length; written += len) {
            int need = length - written;
            len = start + (long)need < raflen ? need : (int)(raflen - start);
            Object object = this.RAFlock[i];
            synchronized (object) {
                this.checkRAF(i);
                this.rafs[i].seek(start);
                this.rafs[i].write(bs, off + written, len);
                continue;
            }
        }
        this.changed = true;
        boolean complete = false;
        BitField bitField2 = this.bitfield;
        synchronized (bitField2) {
            if (!this.bitfield.get(piece)) {
                this.bitfield.set(piece);
                --this.needed;
                complete = this.needed == 0;
            }
        }
        if (complete) {
            this.needed = this.metainfo.getPieces();
            this.bitfield = new BitField(this.needed);
            this.checkCreateFiles();
            if (this.needed > 0) {
                if (this.listener != null) {
                    this.listener.setWantedPieces(this);
                }
                this._util.debug("WARNING: Not really done, missing " + this.needed + " pieces", 2);
            }
        }
        return true;
    }

    private int getUncheckedPiece(int piece, byte[] bs) throws IOException {
        return this.getUncheckedPiece(piece, bs, 0, this.metainfo.getPieceLength(piece));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUncheckedPiece(int piece, byte[] bs, int off, int length) throws IOException {
        int len;
        long start;
        int i = 0;
        long raflen = this.lengths[i];
        for (start = (long)piece * (long)this.metainfo.getPieceLength(0) + (long)off; start > raflen; start -= raflen) {
            raflen = this.lengths[++i];
        }
        for (int read = 0; read < length; read += len) {
            int need = length - read;
            len = start + (long)need < raflen ? need : (int)(raflen - start);
            Object object = this.RAFlock[i];
            synchronized (object) {
                this.checkRAF(i);
                this.rafs[i].seek(start);
                this.rafs[i].readFully(bs, read, len);
                continue;
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanRAFs() {
        long cutoff = System.currentTimeMillis() - 420000L;
        for (int i = 0; i < this.RAFlock.length; ++i) {
            Object object = this.RAFlock[i];
            synchronized (object) {
                if (this.RAFtime[i] > 0L && this.RAFtime[i] < cutoff) {
                    try {
                        this.closeRAF(i);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                continue;
            }
        }
    }

    private void checkRAF(int i) throws IOException {
        if (this.RAFtime[i] > 0L) {
            this.RAFtime[i] = System.currentTimeMillis();
            return;
        }
        this.openRAF(i);
    }

    private void openRAF(int i) throws IOException {
        this.openRAF(i, this._probablyComplete);
    }

    private void openRAF(int i, boolean readonly) throws IOException {
        this.rafs[i] = new RandomAccessFile(this.RAFfile[i], readonly || !this.RAFfile[i].canWrite() ? "r" : "rw");
        this.RAFtime[i] = System.currentTimeMillis();
    }

    private void closeRAF(int i) throws IOException {
        this.RAFtime[i] = 0L;
        if (this.rafs[i] == null) {
            return;
        }
        this.rafs[i].close();
        this.rafs[i] = null;
    }
}

