/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.data.Destination;
import net.i2p.util.I2PThread;
import net.i2p.util.RandomSource;
import org.klomp.snark.BitField;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.CoordinatorListener;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerAcceptor;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerMonitorTask;
import org.klomp.snark.ShutdownListener;
import org.klomp.snark.SnarkManager;
import org.klomp.snark.SnarkShutdown;
import org.klomp.snark.Storage;
import org.klomp.snark.StorageListener;
import org.klomp.snark.TrackerClient;
import org.klomp.snark.bencode.BDecoder;

public class Snark
implements StorageListener,
CoordinatorListener,
ShutdownListener {
    private static final int MIN_PORT = 6881;
    private static final int MAX_PORT = 6889;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTICE = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    public static final int ALL = 6;
    private static boolean command_interpreter = true;
    private static final String newline = System.getProperty("line.separator");
    private static final String copyright = "The Hunting of the Snark Project - Copyright (C) 2003 Mark J. Wielaard" + newline + newline + "Snark comes with ABSOLUTELY NO WARRANTY.  This is free software, and" + newline + "you are welcome to redistribute it under certain conditions; read the" + newline + "COPYING file for details." + newline + newline + "This is the I2P port, allowing anonymous bittorrent (http://www.i2p.net/)" + newline + "It will not work with normal torrents, so don't even try ;)";
    private static final String usage = "Press return for help. Type \"quit\" and return to stop.";
    private static final String help = "Commands: 'info', 'list', 'quit'.";
    String activity = "Not started";
    public static final String PROP_MAX_CONNECTIONS = "i2psnark.maxConnections";
    public String torrent;
    public MetaInfo meta;
    public Storage storage;
    public PeerCoordinator coordinator;
    public ConnectionAcceptor acceptor;
    public TrackerClient trackerclient;
    public String rootDataDir = ".";
    public CompleteListener completeListener;
    public boolean stopped;
    byte[] id;
    public I2PSnarkUtil _util;
    private PeerCoordinatorSet _peerCoordinatorSet;
    boolean allocating = false;
    private long allocated = 0L;
    boolean allChecked = false;
    boolean checking = false;
    boolean prechecking = true;
    static final int MIN_TOTAL_UPLOADERS = 4;
    static final int MAX_TOTAL_UPLOADERS = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        SnarkManager sm;
        System.out.println(copyright);
        System.out.println();
        if (args.length > 0 && "--config".equals(args[0])) {
            I2PThread.addOOMEventListener(new OOMListener());
            sm = SnarkManager.instance();
            if (args.length > 1) {
                sm.loadConfig(args[1]);
            }
        } else {
            Snark snark = Snark.parseArguments(args);
            SnarkShutdown snarkhook = new SnarkShutdown(snark.storage, snark.coordinator, snark.acceptor, snark.trackerclient, snark);
            Timer timer = new Timer(true);
            PeerMonitorTask monitor = new PeerMonitorTask(snark.coordinator);
            timer.schedule((TimerTask)monitor, 10000L, 10000L);
            if (command_interpreter) {
                boolean quit = false;
                System.out.println();
                System.out.println(usage);
                System.out.println();
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String line = br.readLine();
                    while (!quit && line != null) {
                        if ("quit".equals(line = line.toLowerCase())) {
                            quit = true;
                        } else if ("list".equals(line)) {
                            List<Peer> list = snark.coordinator.peers;
                            synchronized (list) {
                                System.out.println(snark.coordinator.peers.size() + " peers -" + " (i)nterested," + " (I)nteresting," + " (c)hoking," + " (C)hoked:");
                                for (Peer peer : snark.coordinator.peers) {
                                    System.out.println(peer);
                                    System.out.println("\ti: " + peer.isInterested() + " I: " + peer.isInteresting() + " c: " + peer.isChoking() + " C: " + peer.isChoked());
                                }
                            }
                        } else if ("info".equals(line)) {
                            System.out.println("Name: " + snark.meta.getName());
                            System.out.println("Torrent: " + snark.torrent);
                            System.out.println("Tracker: " + snark.meta.getAnnounce());
                            List files = snark.meta.getFiles();
                            System.out.println("Files: " + (files == null ? 1 : files.size()));
                            System.out.println("Pieces: " + snark.meta.getPieces());
                            System.out.println("Piece size: " + snark.meta.getPieceLength(0) / 1024 + " KB");
                            System.out.println("Total size: " + snark.meta.getTotalLength() / 0x100000L + " MB");
                        } else if ("".equals(line) || "help".equals(line)) {
                            System.out.println(usage);
                            System.out.println(help);
                        } else {
                            System.out.println("Unknown command: " + line);
                            System.out.println(usage);
                        }
                        if (quit) continue;
                        System.out.println();
                        line = br.readLine();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("ERROR while reading stdin: " + ioe);
                }
                snarkhook.start();
            }
            return;
        }
        System.out.println("Running in multitorrent mode");
        while (true) {
            try {
                while (true) {
                    SnarkManager snarkManager = sm;
                    synchronized (snarkManager) {
                        sm.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }

    Snark(I2PSnarkUtil util, String torrent, String ip, int user_port, StorageListener slistener, CoordinatorListener clistener) {
        this(util, torrent, ip, user_port, slistener, clistener, null, null, null, true, ".");
    }

    public Snark(I2PAppContext ctx, Properties opts, String torrent, StorageListener slistener, boolean start, String rootDir) {
        this(new I2PSnarkUtil(ctx), torrent, null, -1, slistener, null, null, null, null, false, rootDir);
        String host = opts.getProperty("i2cp.hostname");
        int port = 0;
        String s = opts.getProperty("i2cp.port");
        if (s != null) {
            try {
                port = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this._util.setI2CPConfig(host, port, opts);
        s = opts.getProperty("i2psnark.upbw.max");
        if (s != null) {
            try {
                int v = Integer.parseInt(s);
                this._util.setMaxUpBW(v);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((s = opts.getProperty(PROP_MAX_CONNECTIONS)) != null) {
            try {
                int v = Integer.parseInt(s);
                this._util.setMaxConnections(v);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (start) {
            this.startTorrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark(I2PSnarkUtil util, String torrent, String ip, int user_port, StorageListener slistener, CoordinatorListener clistener, CompleteListener complistener, PeerCoordinatorSet peerCoordinatorSet, ConnectionAcceptor connectionAcceptor, boolean start, String rootDir) {
        int i;
        if (slistener == null) {
            slistener = this;
        }
        this.completeListener = complistener;
        this._util = util;
        this._peerCoordinatorSet = peerCoordinatorSet;
        this.acceptor = connectionAcceptor;
        this.torrent = torrent;
        this.rootDataDir = rootDir;
        this.stopped = true;
        this.activity = "Network setup";
        int snark = 3;
        this.id = new byte[20];
        RandomSource random = I2PAppContext.getGlobalContext().random();
        for (i = 0; i < 9; ++i) {
            this.id[i] = 0;
        }
        this.id[i++] = snark;
        this.id[i++] = snark;
        this.id[i++] = snark;
        while (i < 20) {
            this.id[i++] = (byte)((Random)random).nextInt(256);
        }
        this.debug("My peer id: " + PeerID.idencode(this.id), 4);
        Object lastException = null;
        this.meta = null;
        File f = null;
        InputStream in = null;
        try {
            f = new File(torrent);
            if (f.exists()) {
                in = new FileInputStream(f);
            } else {
                this.activity = "Getting torrent";
                File torrentFile = this._util.get(torrent, 3);
                if (torrentFile == null) {
                    this.fatal("Unable to fetch " + torrent);
                } else {
                    torrentFile.deleteOnExit();
                    in = new FileInputStream(torrentFile);
                }
            }
            this.meta = new MetaInfo(new BDecoder(in));
        }
        catch (IOException ioe) {
            if (f != null && f.exists()) {
                if (ip == null) {
                    this.fatal("'" + torrent + "' exists," + " but is not a valid torrent metainfo file." + System.getProperty("line.separator"), ioe);
                } else {
                    this.fatal("I2PSnark does not support creating and tracking a torrent at the moment");
                }
            } else {
                this.fatal("Cannot open '" + torrent + "'", ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.debug(this.meta.toString(), 4);
        if (this.storage == null) {
            try {
                this.activity = "Checking storage";
                this.storage = new Storage(this._util, this.meta, slistener);
                if (this.completeListener != null) {
                    this.storage.check(this.rootDataDir, this.completeListener.getSavedTorrentTime(this), this.completeListener.getSavedTorrentBitField(this));
                } else {
                    this.storage.check(this.rootDataDir);
                }
            }
            catch (IOException ioe) {
                try {
                    this.storage.close();
                }
                catch (IOException ioee) {
                    ioee.printStackTrace();
                }
                this.fatal("Could not check or create storage", ioe);
            }
        }
        if (start) {
            this.startTorrent();
        }
    }

    public void startTorrent() {
        boolean ok = this._util.connect();
        if (!ok) {
            this.fatal("Unable to connect to I2P");
        }
        if (this.coordinator == null) {
            I2PServerSocket serversocket = this._util.getServerSocket();
            if (serversocket == null) {
                this.fatal("Unable to listen for I2P connections");
            } else {
                Destination d = serversocket.getManager().getSession().getMyDestination();
                this.debug("Listening on I2P destination " + d.toBase64() + " / " + d.calculateHash().toBase64(), 3);
            }
            this.debug("Starting PeerCoordinator, ConnectionAcceptor, and TrackerClient", 3);
            this.activity = "Collecting pieces";
            this.coordinator = new PeerCoordinator(this._util, this.id, this.meta, this.storage, this, this);
            if (this._peerCoordinatorSet != null) {
                this._peerCoordinatorSet.add(this.coordinator);
                if (this.acceptor != null) {
                    this.acceptor.startAccepting(this._peerCoordinatorSet, serversocket);
                }
            } else {
                this.acceptor = new ConnectionAcceptor(this._util, serversocket, new PeerAcceptor(this.coordinator));
            }
            this.trackerclient = new TrackerClient(this._util, this.meta, this.coordinator);
        }
        this.stopped = false;
        boolean coordinatorChanged = false;
        if (this.coordinator.halted()) {
            if (this._peerCoordinatorSet != null) {
                this._peerCoordinatorSet.remove(this.coordinator);
            }
            PeerCoordinator newCoord = new PeerCoordinator(this._util, this.coordinator.getID(), this.coordinator.getMetaInfo(), this.coordinator.getStorage(), this.coordinator.getListener(), this);
            if (this._peerCoordinatorSet != null) {
                this._peerCoordinatorSet.add(newCoord);
            }
            this.coordinator = newCoord;
            coordinatorChanged = true;
        }
        if (!this.trackerclient.started() && !coordinatorChanged) {
            this.trackerclient.start();
        } else if (this.trackerclient.halted() || coordinatorChanged) {
            try {
                this.storage.reopen(this.rootDataDir);
            }
            catch (IOException ioe) {
                try {
                    this.storage.close();
                }
                catch (IOException ioee) {
                    ioee.printStackTrace();
                }
                this.fatal("Could not reopen storage", ioe);
            }
            TrackerClient newClient = new TrackerClient(this._util, this.coordinator.getMetaInfo(), this.coordinator);
            if (!this.trackerclient.halted()) {
                this.trackerclient.halt();
            }
            this.trackerclient = newClient;
            this.trackerclient.start();
        }
    }

    public void stopTorrent() {
        Storage st;
        PeerCoordinator pc;
        this.stopped = true;
        TrackerClient tc = this.trackerclient;
        if (tc != null) {
            tc.halt();
        }
        if ((pc = this.coordinator) != null) {
            pc.halt();
        }
        if ((st = this.storage) != null) {
            boolean changed = this.storage.changed;
            try {
                this.storage.close();
            }
            catch (IOException ioe) {
                System.out.println("Error closing " + this.torrent);
                ioe.printStackTrace();
            }
            if (changed && this.completeListener != null) {
                this.completeListener.updateStatus(this);
            }
        }
        if (pc != null && this._peerCoordinatorSet != null) {
            this._peerCoordinatorSet.remove(pc);
        }
        if (this._peerCoordinatorSet == null) {
            this._util.disconnect();
        }
    }

    static Snark parseArguments(String[] args) {
        return Snark.parseArguments(args, null, null);
    }

    static Snark parseArguments(String[] args, StorageListener slistener, CoordinatorListener clistener) {
        int user_port = -1;
        String ip = null;
        String torrent = null;
        I2PSnarkUtil util = new I2PSnarkUtil(I2PAppContext.getGlobalContext());
        boolean configured = util.configured();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--port")) {
                if (args.length - 1 < i + 1) {
                    Snark.usage("--port needs port number to listen on");
                }
                try {
                    user_port = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    Snark.usage("--port argument must be a number (" + nfe + ")");
                }
                i += 2;
                continue;
            }
            if (args[i].equals("--no-commands")) {
                command_interpreter = false;
                ++i;
                continue;
            }
            if (args[i].equals("--i2cp")) {
                String i2cpHost = args[i + 1];
                String i2cpPort = args[i + 2];
                Properties opts = null;
                if (i + 3 < args.length && !args[i + 3].startsWith("--")) {
                    opts = new Properties();
                    StringTokenizer tok = new StringTokenizer(args[i + 3], " \t");
                    while (tok.hasMoreTokens()) {
                        String str = tok.nextToken();
                        int split = str.indexOf(61);
                        if (split <= 0) continue;
                        opts.setProperty(str.substring(0, split), str.substring(split + 1));
                    }
                }
                if (!configured) {
                    util.setI2CPConfig(i2cpHost, Integer.parseInt(i2cpPort), opts);
                }
                i += 3 + (opts != null ? 1 : 0);
                continue;
            }
            torrent = args[i];
            ++i;
            break;
        }
        if (torrent == null || i != args.length) {
            if (torrent != null && torrent.startsWith("-")) {
                Snark.usage("Unknow option '" + torrent + "'.");
            } else {
                Snark.usage("Need exactly one <url>, <file> or <dir>.");
            }
        }
        return new Snark(util, torrent, ip, user_port, slistener, clistener);
    }

    private static void usage(String s) {
        System.out.println("snark: " + s);
        Snark.usage();
    }

    private static void usage() {
        System.out.println("Usage: snark [--debug [level]] [--no-commands] [--port <port>]");
        System.out.println("             [--eepproxy hostname portnum]");
        System.out.println("             [--i2cp routerHost routerPort ['name=val name=val name=val']]");
        System.out.println("             (<url>|<file>)");
        System.out.println("  --debug\tShows some extra info and stacktraces");
        System.out.println("    level\tHow much debug details to show");
        System.out.println("         \t(defaults to 3, with --debug to 4, highest level is 6).");
        System.out.println("  --no-commands\tDon't read interactive commands or show usage info.");
        System.out.println("  --port\tThe port to listen on for incomming connections");
        System.out.println("        \t(if not given defaults to first free port between 6881-6889).");
        System.out.println("  --share\tStart torrent tracker on <ip> address or <host> name.");
        System.out.println("  --eepproxy\thttp proxy to use (default of 127.0.0.1 port 4444)");
        System.out.println("  --i2cp\tlocation of your I2P router (default of 127.0.0.1 port 7654)");
        System.out.println("        \toptional settings may be included, such as");
        System.out.println("        \tinbound.length=2 outbound.length=2 inbound.lengthVariance=-1 ");
        System.out.println("  <url>  \tURL pointing to .torrent metainfo file to download/share.");
        System.out.println("  <file> \tEither a local .torrent metainfo file to download");
        System.out.println("         \tor (with --share) a file to share.");
        System.exit(-1);
    }

    public void fatal(String s) {
        this.fatal(s, null);
    }

    public void fatal(String s, Throwable t) {
        this._util.debug(s, 1, t);
        this.stopTorrent();
        throw new RuntimeException(s + (t == null ? "" : ": " + t));
    }

    private void debug(String s, int level) {
        this._util.debug(s, level, null);
    }

    public void peerChange(PeerCoordinator coordinator, Peer peer) {
    }

    public void storageCreateFile(Storage storage, String name, long length) {
        this.allocating = true;
    }

    public void storageAllocated(Storage storage, long length) {
        this.allocating = true;
        this.allocated += length;
    }

    public void storageChecked(Storage storage, int num, boolean checked) {
        this.allocating = false;
        if (!this.allChecked && !this.checking) {
            this.checking = true;
        }
        if (!this.checking) {
            this.debug("Got " + (checked ? "" : "BAD ") + "piece: " + num, 4);
        }
    }

    public void storageAllChecked(Storage storage) {
        this.allChecked = true;
        this.checking = false;
        if (storage.changed && this.completeListener != null) {
            this.completeListener.updateStatus(this);
        }
    }

    public void storageCompleted(Storage storage) {
        this.debug("Completely received " + this.torrent, 4);
        if (this.completeListener != null) {
            this.completeListener.torrentComplete(this);
        }
    }

    public void setWantedPieces(Storage storage) {
        this.coordinator.setWantedPieces();
    }

    public void shutdown() {
        System.exit(0);
    }

    public boolean overUploadLimit(int uploaders) {
        if (this._peerCoordinatorSet == null || uploaders <= 0) {
            return false;
        }
        int totalUploaders = 0;
        Iterator iter = this._peerCoordinatorSet.iterator();
        while (iter.hasNext()) {
            PeerCoordinator c = (PeerCoordinator)iter.next();
            if (c.halted()) continue;
            totalUploaders += c.uploaders;
        }
        int limit = this._util.getMaxUploaders();
        return totalUploaders > limit;
    }

    public boolean overUpBWLimit() {
        if (this._peerCoordinatorSet == null) {
            return false;
        }
        long total = 0L;
        Iterator iter = this._peerCoordinatorSet.iterator();
        while (iter.hasNext()) {
            PeerCoordinator c = (PeerCoordinator)iter.next();
            if (c.halted()) continue;
            total += c.getCurrentUploadRate();
        }
        long limit = 1024L * (long)this._util.getMaxUpBW();
        this.debug("Total up bw: " + total + " Limit: " + limit, 2);
        return total > limit;
    }

    public boolean overUpBWLimit(long total) {
        long limit = 1024L * (long)this._util.getMaxUpBW();
        return total > limit;
    }

    public static interface CompleteListener {
        public void torrentComplete(Snark var1);

        public void updateStatus(Snark var1);

        public long getSavedTorrentTime(Snark var1);

        public BitField getSavedTorrentBitField(Snark var1);
    }

    private static class OOMListener
    implements I2PThread.OOMEventListener {
        private OOMListener() {
        }

        public void outOfMemory(OutOfMemoryError err) {
            try {
                err.printStackTrace();
                System.out.println("OOM in the snark" + err);
            }
            catch (Throwable t) {
                System.out.println("OOM in the OOM");
            }
            System.exit(0);
        }
    }
}

