/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.Set;
import net.i2p.util.ConcurrentHashSet;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Piece
implements Comparable {
    private int id;
    private Set<PeerID> peers;
    private boolean requested;
    private int priority;

    public Piece(int id) {
        this.id = id;
        this.peers = new ConcurrentHashSet<PeerID>();
    }

    public int compareTo(Object o) throws ClassCastException {
        int pdiff = ((Piece)o).priority - this.priority;
        if (pdiff != 0) {
            return pdiff;
        }
        return this.peers.size() - ((Piece)o).peers.size();
    }

    public boolean equals(Object o) {
        if (o instanceof Piece) {
            if (o == null) {
                return false;
            }
            return this.id == ((Piece)o).id;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + this.id;
        return hash;
    }

    public int getId() {
        return this.id;
    }

    public Set<PeerID> getPeers() {
        return this.peers;
    }

    public boolean addPeer(Peer peer) {
        return this.peers.add(peer.getPeerID());
    }

    public boolean removePeer(Peer peer) {
        return this.peers.remove(peer.getPeerID());
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public boolean isDisabled() {
        return this.priority < 0;
    }

    public void setDisabled() {
        this.priority = -1;
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

