/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.CoordinatorListener;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCheckerTask;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.PeerState;
import org.klomp.snark.Piece;
import org.klomp.snark.Request;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerCoordinator
implements PeerListener {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerCoordinator.class);
    final MetaInfo metainfo;
    final Storage storage;
    final Snark snark;
    static final long CHECK_PERIOD = 40000L;
    static final int MAX_UPLOADERS = 6;
    int uploaders = 0;
    int interestedAndChoking = 0;
    private long uploaded;
    private long downloaded;
    static final int RATE_DEPTH = 3;
    private long[] uploaded_old = new long[]{-1L, -1L, -1L};
    private long[] downloaded_old = new long[]{-1L, -1L, -1L};
    final List<Peer> peers = new ArrayList<Peer>();
    volatile int peerCount;
    private final Timer timer = new Timer(true);
    private final byte[] id;
    private List<Piece> wantedPieces;
    private boolean halted = false;
    private final CoordinatorListener listener;
    public I2PSnarkUtil _util;
    private static final Random _random = I2PAppContext.getGlobalContext().random();
    public String trackerProblems = null;
    public int trackerSeenPeers = 0;
    private static final int END_GAME_THRESHOLD = 8;
    private static final int MAX_PARALLEL_REQUESTS = 4;
    private Request savedRequest = null;
    private long savedRequestTime = 0L;

    public PeerCoordinator(I2PSnarkUtil util, byte[] id, MetaInfo metainfo, Storage storage, CoordinatorListener listener, Snark torrent) {
        this._util = util;
        this.id = id;
        this.metainfo = metainfo;
        this.storage = storage;
        this.listener = listener;
        this.snark = torrent;
        this.setWantedPieces();
        this.timer.schedule((TimerTask)new PeerCheckerTask(this._util, this), 20000L + (long)_random.nextInt(40000), 40000L);
    }

    public void setWantedPieces() {
        this.wantedPieces = new ArrayList<Piece>();
        BitField bitfield = this.storage.getBitField();
        int[] pri = this.storage.getPiecePriorities();
        for (int i = 0; i < this.metainfo.getPieces(); ++i) {
            if (bitfield.get(i) || pri != null && pri[i] < 0) continue;
            Piece p = new Piece(i);
            if (pri != null) {
                p.setPriority(pri[i]);
            }
            this.wantedPieces.add(p);
        }
        Collections.shuffle(this.wantedPieces, _random);
    }

    public Storage getStorage() {
        return this.storage;
    }

    public CoordinatorListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> peerList() {
        List<Peer> list = this.peers;
        synchronized (list) {
            return new ArrayList<Peer>(this.peers);
        }
    }

    public byte[] getID() {
        return this.id;
    }

    public boolean completed() {
        return this.storage.complete();
    }

    public int getPeerCount() {
        return this.peerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPeers() {
        List<Peer> list = this.peers;
        synchronized (list) {
            int rv;
            this.peerCount = rv = this.peers.size();
            return rv;
        }
    }

    public long getLeft() {
        return (long)this.storage.needed() * (long)this.metainfo.getPieceLength(0);
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public void setRateHistory(long up, long down) {
        PeerCoordinator.setRate(up, this.uploaded_old);
        PeerCoordinator.setRate(down, this.downloaded_old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRate(long val, long[] array) {
        long[] lArray = array;
        synchronized (array) {
            for (int i = 2; i > 0; --i) {
                array[i] = array[i - 1];
            }
            array[0] = val;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public long getDownloadRate() {
        return PeerCoordinator.getRate(this.downloaded_old);
    }

    public long getUploadRate() {
        return PeerCoordinator.getRate(this.uploaded_old);
    }

    public long getCurrentUploadRate() {
        long r = this.uploaded_old[0];
        if (r <= 0L) {
            return 0L;
        }
        return r * 1000L / 40000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getRate(long[] array) {
        long rate = 0L;
        int factor = 0;
        long[] lArray = array;
        synchronized (array) {
            int i;
            for (i = 0; i < 3 && array[i] >= 0L; ++i) {
                int f = 3 - i;
                rate += array[i] * (long)f;
                factor += f;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (i == 0) {
                return 0L;
            }
            return rate / ((long)factor * 40000L / 1000L);
        }
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needPeers() {
        List<Peer> list = this.peers;
        synchronized (list) {
            return !this.halted && this.peers.size() < this.getMaxConnections();
        }
    }

    private int getMaxConnections() {
        int size = this.metainfo.getPieceLength(0);
        int max = this._util.getMaxConnections();
        if (size <= 524288 || this.completed()) {
            return max;
        }
        if (size <= 0x100000) {
            return (max + max + 2) / 3;
        }
        return (max + 2) / 3;
    }

    public boolean halted() {
        return this.halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        this.halted = true;
        ArrayList<Peer> removed = new ArrayList<Peer>();
        List<Peer> list = this.peers;
        synchronized (list) {
            this.timer.cancel();
            removed.addAll(this.peers);
            this.peers.clear();
            this.peerCount = 0;
        }
        while (!removed.isEmpty()) {
            Peer peer = (Peer)removed.remove(0);
            peer.disconnect();
            this.removePeerFromPieces(peer);
        }
        this.savedRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(Peer peer) {
        if (this.halted) {
            peer.disconnect(false);
            return;
        }
        Peer toDisconnect = null;
        List<Peer> list = this.peers;
        synchronized (list) {
            Peer old = PeerCoordinator.peerIDInList(peer.getPeerID(), this.peers);
            if (old != null && old.getInactiveTime() > 480000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Remomving old peer: " + peer + ": " + old + ", inactive for " + old.getInactiveTime());
                }
                this.peers.remove(old);
                toDisconnect = old;
                old = null;
            }
            if (old != null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Already connected to: " + peer + ": " + old + ", inactive for " + old.getInactiveTime());
                }
                peer.disconnect(false);
            } else if (this.peers.size() >= this.getMaxConnections()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Already at MAX_CONNECTIONS in connected() with peer: " + peer);
                }
                peer.disconnect(false);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("New connection to peer: " + peer + " for " + this.metainfo.getName());
                }
                this.peers.add(0, peer);
                this.peerCount = this.peers.size();
                this.unchokePeer();
                if (this.listener != null) {
                    this.listener.peerChange(this, peer);
                }
            }
        }
        if (toDisconnect != null) {
            toDisconnect.disconnect(false);
            this.removePeerFromPieces(toDisconnect);
        }
    }

    private static Peer peerIDInList(PeerID pid, List peers) {
        for (Peer cur : peers) {
            if (!pid.sameID(cur.getPeerID())) continue;
            return cur;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPeer(final Peer peer) {
        boolean need_more;
        if (this.halted) {
            peer.disconnect(false);
            return false;
        }
        int peersize = 0;
        List<Peer> list = this.peers;
        synchronized (list) {
            peersize = this.peers.size();
            need_more = !peer.isConnected() && peersize < this.getMaxConnections();
            Peer old = PeerCoordinator.peerIDInList(peer.getPeerID(), this.peers);
            need_more = need_more && (old == null || old.getInactiveTime() > 480000L);
        }
        if (need_more) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding a peer " + peer.getPeerID().toString() + " for " + this.metainfo.getName(), new Exception("add/run"));
            }
            final PeerCoordinator listener = this;
            final BitField bitfield = this.storage.getBitField();
            Runnable r = new Runnable(){

                public void run() {
                    peer.runConnection(PeerCoordinator.this._util, listener, bitfield);
                }
            };
            String threadName = peer.toString();
            new I2PAppThread(r, threadName).start();
            return true;
        }
        if (this._log.shouldLog(10)) {
            if (peer.isConnected()) {
                this._log.info("Add peer already connected: " + peer);
            } else {
                this._log.info("Connections: " + peersize + "/" + this.getMaxConnections() + " not accepting extra peer: " + peer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unchokePeer() {
        LinkedList<Peer> interested = new LinkedList<Peer>();
        List<Peer> list = this.peers;
        synchronized (list) {
            int count = 0;
            int unchokedCount = 0;
            int maxUploaders = this.allowedUploaders();
            for (Peer peer : this.peers) {
                if (!peer.isChoking() || !peer.isInterested()) continue;
                ++count;
                if (this.uploaders >= maxUploaders) continue;
                if (peer.isInteresting() && !peer.isChoked()) {
                    interested.add(unchokedCount++, peer);
                    continue;
                }
                interested.add(peer);
            }
            while (this.uploaders < maxUploaders && !interested.isEmpty()) {
                Peer peer;
                peer = (Peer)interested.remove(0);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Unchoke: " + peer);
                }
                peer.setChoking(false);
                ++this.uploaders;
                --count;
                this.peers.remove(peer);
                this.peers.add(peer);
                this.peerCount = this.peers.size();
            }
            this.interestedAndChoking = count;
        }
    }

    public byte[] getBitMap() {
        return this.storage.getBitField().getFieldBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotHave(Peer peer, int piece) {
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            return this.wantedPieces.contains(new Piece(piece));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotBitField(Peer peer, BitField bitfield) {
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece p : this.wantedPieces) {
                int i = p.getId();
                if (!bitfield.get(i)) continue;
                p.addPeer(peer);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int wantPiece(Peer peer, BitField havePieces) {
        if (this.halted) {
            if (this._log.shouldLog(30)) {
                this._log.warn("We don't want anything from the peer, as we are halted!  peer=" + peer);
            }
            return -1;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Piece p;
            Piece piece = null;
            Collections.sort(this.wantedPieces);
            ArrayList<Piece> requested = new ArrayList<Piece>();
            Iterator<Piece> it = this.wantedPieces.iterator();
            while (piece == null && it.hasNext() && !(p = it.next()).isDisabled()) {
                if (havePieces.get(p.getId()) && !p.isRequested()) {
                    piece = p;
                    continue;
                }
                if (!p.isRequested()) continue;
                requested.add(p);
            }
            if (piece == null) {
                if (this.wantedPieces.size() > 8) {
                    return -1;
                }
                Collections.shuffle(requested, _random);
                Iterator it2 = requested.iterator();
                while (piece == null && it2.hasNext()) {
                    Piece p2 = (Piece)it2.next();
                    if (!havePieces.get(p2.getId())) continue;
                    int requestedCount = 0;
                    List<Peer> list2 = this.peers;
                    synchronized (list2) {
                        for (Peer pr : this.peers) {
                            if (!pr.isRequesting(p2.getId())) continue;
                            if (pr.equals(peer)) {
                                requestedCount = 4;
                                break;
                            }
                            if (++requestedCount < 4) continue;
                            break;
                        }
                    }
                    if (requestedCount >= 4) continue;
                    piece = p2;
                }
                if (piece == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("nothing to even rerequest from " + peer + ": requested = " + requested);
                    }
                    return -1;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("parallel request (end game?) for " + peer + ": piece = " + piece);
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Now requesting: piece " + piece + " priority " + piece.getPriority());
            }
            piece.setRequested(true);
            return piece.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePiecePriorities() {
        int[] pri = this.storage.getPiecePriorities();
        if (pri == null) {
            this._log.debug("Updated piece priorities called but no priorities to set?");
            return;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            BitField want = new BitField(pri.length);
            for (Piece p : this.wantedPieces) {
                want.set(p.getId());
            }
            BitField bitfield = this.storage.getBitField();
            for (int i = 0; i < pri.length; ++i) {
                if (pri[i] < 0 || bitfield.get(i) || want.get(i)) continue;
                Piece piece = new Piece(i);
                this.wantedPieces.add(piece);
                List<Peer> list2 = this.peers;
                synchronized (list2) {
                    for (Peer p : this.peers) {
                        BitField bf;
                        PeerState s = p.state;
                        if (s == null || (bf = s.bitfield) == null || !bf.get(i)) continue;
                        piece.addPeer(p);
                    }
                    continue;
                }
            }
            Iterator<Piece> iter = this.wantedPieces.iterator();
            while (iter.hasNext()) {
                Piece p = iter.next();
                int priority = pri[p.getId()];
                if (priority >= 0) {
                    p.setPriority(priority);
                    continue;
                }
                iter.remove();
                List<Peer> list3 = this.peers;
                synchronized (list3) {
                    for (Peer peer : this.peers) {
                        peer.cancel(p.getId());
                    }
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Updated piece priorities, now wanted: " + this.wantedPieces);
            }
            Collections.shuffle(this.wantedPieces, _random);
            List<Peer> list4 = this.peers;
            synchronized (list4) {
                for (Peer peer : this.peers) {
                    peer.request();
                }
            }
        }
    }

    @Override
    public byte[] gotRequest(Peer peer, int piece, int off, int len) {
        if (this.halted) {
            return null;
        }
        try {
            return this.storage.getPiece(piece, off, len);
        }
        catch (IOException ioe) {
            this.snark.stopTorrent();
            this._log.error("Error reading the storage for " + this.metainfo.getName(), ioe);
            throw new RuntimeException("B0rked");
        }
    }

    @Override
    public void uploaded(Peer peer, int size) {
        this.uploaded += (long)size;
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
    }

    @Override
    public void downloaded(Peer peer, int size) {
        this.downloaded += (long)size;
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotPiece(Peer peer, int piece, byte[] bs) {
        if (this.halted) {
            this._log.info("Got while-halted piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
            return true;
        }
        List<Comparable> list = this.wantedPieces;
        synchronized (list) {
            Piece p;
            block16: {
                p = new Piece(piece);
                if (!this.wantedPieces.contains(p)) {
                    this._log.info("Got unwanted piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
                    if (this.storage.getBitField().get(piece)) {
                        return true;
                    }
                }
                try {
                    if (this.storage.putPiece(piece, bs)) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Got valid piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
                        }
                        break block16;
                    }
                    this.downloaded -= (long)this.metainfo.getPieceLength(piece);
                    this._log.warn("Got BAD piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
                    return false;
                }
                catch (IOException ioe) {
                    this.snark.stopTorrent();
                    this._log.error("Error writing storage for " + this.metainfo.getName(), ioe);
                    throw new RuntimeException("B0rked");
                }
            }
            this.wantedPieces.remove(p);
        }
        list = this.peers;
        synchronized (list) {
            ArrayList<Peer> toDisconnect = new ArrayList<Peer>();
            for (Peer p : this.peers) {
                if (!p.isConnected()) continue;
                if (this.completed() && p.isCompleted()) {
                    toDisconnect.add(p);
                    continue;
                }
                p.have(piece);
            }
            for (Peer p : toDisconnect) {
                p.disconnect(true);
            }
        }
        return true;
    }

    @Override
    public void gotChoke(Peer peer, boolean choke) {
        if (this._log.shouldLog(20)) {
            this._log.info("Got choke(" + choke + "): " + peer);
        }
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotInterest(Peer peer, boolean interest) {
        if (interest) {
            List<Peer> list = this.peers;
            synchronized (list) {
                if (this.uploaders < this.allowedUploaders() && peer.isChoking()) {
                    ++this.uploaders;
                    peer.setChoking(false);
                    if (this._log.shouldLog(20)) {
                        this._log.info("Unchoke: " + peer);
                    }
                }
            }
        }
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(Peer peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Disconnected " + peer, new Exception("Disconnected by"));
        }
        List<Peer> list = this.peers;
        synchronized (list) {
            if (this.peers.remove(peer)) {
                this.unchokePeer();
                this.removePeerFromPieces(peer);
            }
            this.peerCount = this.peers.size();
        }
        if (this.listener != null) {
            this.listener.peerChange(this, peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerFromPieces(Peer peer) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece piece : this.wantedPieces) {
                piece.removePeer(peer);
            }
        }
    }

    @Override
    public void savePeerPartial(PeerState state) {
        if (this.halted) {
            return;
        }
        Request req = state.getPartialRequest();
        if (req == null) {
            return;
        }
        if (this.savedRequest == null || req.off > this.savedRequest.off || System.currentTimeMillis() > this.savedRequestTime + 900000L) {
            if ((this.savedRequest == null || req.piece != this.savedRequest.piece && req.off != this.savedRequest.off) && this._log.shouldLog(10)) {
                this._log.debug(" Saving orphaned partial piece " + req);
                if (this.savedRequest != null) {
                    this._log.debug(" (Discarding previously saved orphan) " + this.savedRequest);
                }
            }
            this.savedRequest = req;
            this.savedRequestTime = System.currentTimeMillis();
        } else if (req.piece != this.savedRequest.piece && this._log.shouldLog(10)) {
            this._log.debug(" Discarding orphaned partial piece " + req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request getPeerPartial(BitField havePieces) {
        if (this.savedRequest == null) {
            return null;
        }
        if (!havePieces.get(this.savedRequest.piece)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Peer doesn't have orphaned piece " + this.savedRequest);
            }
            return null;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece piece : this.wantedPieces) {
                if (piece.getId() != this.savedRequest.piece) continue;
                Request req = this.savedRequest;
                piece.setRequested(true);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Restoring orphaned partial piece " + req);
                }
                this.savedRequest = null;
                return req;
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("We no longer want orphaned piece " + this.savedRequest);
        }
        this.savedRequest = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnrequestedIfOnlyOne(Peer peer, int piece) {
        List<Comparable> list = this.peers;
        synchronized (list) {
            for (Peer peer2 : this.peers) {
                if (peer2.equals(peer) || peer2.state == null) continue;
                int[] arr = peer2.state.getRequestedPieces();
                int i = 0;
                while (arr[i] >= 0) {
                    if (arr[i] == piece) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Another peer is requesting piece " + piece);
                        }
                        return;
                    }
                    ++i;
                }
            }
        }
        list = this.wantedPieces;
        synchronized (list) {
            for (Piece piece2 : this.wantedPieces) {
                if (piece2.getId() != piece) continue;
                piece2.setRequested(false);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Removing from request list piece " + piece);
                }
                return;
            }
        }
    }

    @Override
    public void markUnrequested(Peer peer) {
        if (this.halted || peer.state == null) {
            return;
        }
        int[] arr = peer.state.getRequestedPieces();
        int i = 0;
        while (arr[i] >= 0) {
            this.markUnrequestedIfOnlyOne(peer, arr[i]);
            ++i;
        }
    }

    public int allowedUploaders() {
        if (this.listener != null && this.listener.overUploadLimit(this.uploaders)) {
            return this.uploaders - 1;
        }
        if (this.uploaders < 6) {
            return this.uploaders + 1;
        }
        return 6;
    }

    public boolean overUpBWLimit() {
        if (this.listener != null) {
            return this.listener.overUpBWLimit();
        }
        return false;
    }

    public boolean overUpBWLimit(long total) {
        if (this.listener != null) {
            return this.listener.overUpBWLimit(total * 1000L / 40000L);
        }
        return false;
    }
}

