/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;
import org.klomp.snark.BitField;
import org.klomp.snark.Message;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerState;
import org.klomp.snark.Request;

class PeerConnectionOut
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerConnectionOut.class);
    private final Peer peer;
    private final DataOutputStream dout;
    private Thread thread;
    private boolean quit;
    private final List sendQueue = new ArrayList();
    private static long __id = 0L;
    private long _id;
    long lastSent;
    private static final int SEND_TIMEOUT = 180000;
    private static final int REQ_TIMEOUT = 420000;

    public PeerConnectionOut(Peer peer, DataOutputStream dout) {
        this.peer = peer;
        this.dout = dout;
        this._id = ++__id;
        this.lastSent = System.currentTimeMillis();
        this.quit = false;
    }

    public void startup() {
        this.thread = new I2PAppThread(this, "Snark sender " + this._id + ": " + this.peer);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.quit && this.peer.isConnected()) {
                boolean shouldFlush;
                Message m = null;
                PeerState state = null;
                List list = this.sendQueue;
                synchronized (list) {
                    shouldFlush = !this.quit && this.peer.isConnected() && this.sendQueue.isEmpty();
                }
                if (shouldFlush) {
                    this.dout.flush();
                }
                list = this.sendQueue;
                synchronized (list) {
                    while (!this.quit && this.peer.isConnected() && this.sendQueue.isEmpty()) {
                        try {
                            this.sendQueue.wait(60000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                    state = this.peer.state;
                    if (!this.quit && state != null && this.peer.isConnected()) {
                        Iterator it = this.sendQueue.iterator();
                        while (m == null && it.hasNext()) {
                            Message nm = (Message)it.next();
                            if (nm.type == 7) {
                                if (state.choking) {
                                    it.remove();
                                    SimpleTimer.getInstance().removeEvent(nm.expireEvent);
                                }
                                nm = null;
                            } else if (nm.type == 6 && state.choked) {
                                it.remove();
                                SimpleTimer.getInstance().removeEvent(nm.expireEvent);
                                nm = null;
                            }
                            if (m != null || nm == null) continue;
                            m = nm;
                            SimpleTimer.getInstance().removeEvent(nm.expireEvent);
                            it.remove();
                        }
                        if (m == null && !this.sendQueue.isEmpty()) {
                            m = (Message)this.sendQueue.remove(0);
                            SimpleTimer.getInstance().removeEvent(m.expireEvent);
                        }
                    }
                }
                if (m == null) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Send " + this.peer + ": " + m + " on " + this.peer.metainfo.getName());
                }
                this.lastSent = System.currentTimeMillis();
                if (m.type == 0) {
                    this.removeMessage(7);
                }
                int remainder = 0;
                if (m.type == 7) {
                    if (m.len <= 16384) {
                        state.uploaded(m.len);
                    } else {
                        state.uploaded(16384);
                        remainder = m.len - 16384;
                    }
                }
                m.sendMessage(this.dout);
                if (remainder > 0) {
                    state.uploaded(remainder);
                }
                m = null;
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(20)) {
                this._log.info("IOError sending to " + this.peer, ioe);
            }
        }
        catch (Throwable t) {
            this._log.error("Error sending to " + this.peer, t);
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
        }
        finally {
            this.quit = true;
            this.peer.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        List list = this.sendQueue;
        synchronized (list) {
            this.quit = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.sendQueue.clear();
            this.sendQueue.notify();
        }
        if (this.dout != null) {
            try {
                this.dout.close();
            }
            catch (IOException ioe) {
                this._log.warn("Error closing the stream to " + this.peer, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(Message m) {
        if (m.type == 7) {
            SimpleScheduler.getInstance().addEvent(new RemoveTooSlow(m), 180000L);
        }
        List list = this.sendQueue;
        synchronized (list) {
            this.sendQueue.add(m);
            this.sendQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMessage(int type) {
        boolean removed = false;
        List list = this.sendQueue;
        synchronized (list) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                Message m = (Message)it.next();
                if (m.type != type) continue;
                it.remove();
                removed = true;
            }
            this.sendQueue.notifyAll();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAlive() {
        Message m = new Message();
        m.type = (byte)-1;
        List list = this.sendQueue;
        synchronized (list) {
            if (this.sendQueue.isEmpty()) {
                this.sendQueue.add(m);
            }
            this.sendQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChoke(boolean choke) {
        List list = this.sendQueue;
        synchronized (list) {
            int inverseType;
            int n = inverseType = choke ? 1 : 0;
            if (!this.removeMessage(inverseType)) {
                Message m = new Message();
                m.type = choke ? (byte)0 : 1;
                this.addMessage(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInterest(boolean interest) {
        List list = this.sendQueue;
        synchronized (list) {
            int inverseType;
            int n = inverseType = interest ? 3 : 2;
            if (!this.removeMessage(inverseType)) {
                Message m = new Message();
                m.type = interest ? (byte)2 : (byte)3;
                this.addMessage(m);
            }
        }
    }

    void sendHave(int piece) {
        Message m = new Message();
        m.type = (byte)4;
        m.piece = piece;
        this.addMessage(m);
    }

    void sendBitfield(BitField bitfield) {
        Message m = new Message();
        m.type = (byte)5;
        m.data = bitfield.getFieldBytes();
        m.off = 0;
        m.len = m.data.length;
        this.addMessage(m);
    }

    void retransmitRequests(List requests) {
        long now = System.currentTimeMillis();
        for (Request req : requests) {
            if (now <= req.sendTime + 420000L) continue;
            if (this._log.shouldLog(10)) {
                this._log.debug("Retransmit request " + req + " to peer " + this.peer);
            }
            this.sendRequest(req);
        }
    }

    void sendRequests(List requests) {
        for (Request req : requests) {
            this.sendRequest(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequest(Request req) {
        List list = this.sendQueue;
        synchronized (list) {
            for (Message m : this.sendQueue) {
                if (m.type != 6 || m.piece != req.piece || m.begin != req.off || m.length != req.len) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Discarding duplicate request " + req + " to peer " + this.peer);
                }
                return;
            }
        }
        Message m = new Message();
        m.type = (byte)6;
        m.piece = req.piece;
        m.begin = req.off;
        m.length = req.len;
        this.addMessage(m);
        req.sendTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queuedBytes() {
        int total = 0;
        List list = this.sendQueue;
        synchronized (list) {
            for (Message m : this.sendQueue) {
                if (m.type != 7) continue;
                total += m.length;
            }
        }
        return total;
    }

    void sendPiece(int piece, int begin, int length, byte[] bytes) {
        Message m = new Message();
        m.type = (byte)7;
        m.piece = piece;
        m.begin = begin;
        m.length = length;
        m.data = bytes;
        m.off = 0;
        m.len = length;
        this.addMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCancel(Request req) {
        List list = this.sendQueue;
        synchronized (list) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                Message m = (Message)it.next();
                if (m.type != 6 || m.piece != req.piece || m.begin != req.off || m.length != req.len) continue;
                it.remove();
            }
        }
        Message m = new Message();
        m.type = (byte)8;
        m.piece = req.piece;
        m.begin = req.off;
        m.length = req.len;
        this.addMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRequest(int piece, int begin, int length) {
        List list = this.sendQueue;
        synchronized (list) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                Message m = (Message)it.next();
                if (m.type != 7 || m.piece != piece || m.begin != begin || m.length != length) continue;
                it.remove();
            }
        }
    }

    private class RemoveTooSlow
    implements SimpleTimer.TimedEvent {
        private Message _m;

        public RemoveTooSlow(Message m) {
            this._m = m;
            m.expireEvent = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            boolean removed = false;
            List list = PeerConnectionOut.this.sendQueue;
            synchronized (list) {
                removed = PeerConnectionOut.this.sendQueue.remove(this._m);
                PeerConnectionOut.this.sendQueue.notifyAll();
            }
            if (removed) {
                PeerConnectionOut.this._log.info("Took too long to send " + this._m + " to " + PeerConnectionOut.this.peer);
            }
        }
    }
}

