/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerCoordinatorSet;

public class PeerAcceptor {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerAcceptor.class);
    private final PeerCoordinator coordinator;
    final PeerCoordinatorSet coordinators;
    private static final int LOOKAHEAD_SIZE = "19".length() + "BitTorrent protocol".length() + 8 + 20;

    public PeerAcceptor(PeerCoordinator coordinator) {
        this.coordinator = coordinator;
        this.coordinators = null;
    }

    public PeerAcceptor(PeerCoordinatorSet coordinators) {
        this.coordinators = coordinators;
        this.coordinator = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connection(I2PSocket socket, InputStream in, OutputStream out) throws IOException {
        byte[] peerInfoHash = null;
        if (in instanceof BufferedInputStream) {
            in.mark(LOOKAHEAD_SIZE);
            peerInfoHash = this.readHash(in);
            in.reset();
        } else {
            try {
                peerInfoHash = this.readHash(in);
                if (this._log.shouldLog(20)) {
                    this._log.info("infohash read from " + socket.getPeerDestination().calculateHash().toBase64() + ": " + Base64.encode(peerInfoHash));
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(20)) throw ioe;
                this._log.info("Unable to read the infohash from " + socket.getPeerDestination().calculateHash().toBase64());
                throw ioe;
            }
            in = new SequenceInputStream(new ByteArrayInputStream(peerInfoHash), in);
        }
        if (this.coordinator != null) {
            MetaInfo meta = this.coordinator.getMetaInfo();
            if (!DataHelper.eq(meta.getInfoHash(), peerInfoHash)) throw new IOException("Peer wants another torrent (" + Base64.encode(peerInfoHash) + ") while we only support (" + Base64.encode(meta.getInfoHash()) + ")");
            if (this.coordinator.needPeers()) {
                Peer peer = new Peer(socket, in, out, this.coordinator.getID(), this.coordinator.getMetaInfo());
                this.coordinator.addPeer(peer);
                return;
            } else {
                socket.close();
            }
            return;
        } else {
            Iterator iter = this.coordinators.iterator();
            while (iter.hasNext()) {
                PeerCoordinator cur = (PeerCoordinator)iter.next();
                MetaInfo meta = cur.getMetaInfo();
                if (!DataHelper.eq(meta.getInfoHash(), peerInfoHash)) continue;
                if (cur.needPeers()) {
                    Peer peer = new Peer(socket, in, out, cur.getID(), cur.getMetaInfo());
                    cur.addPeer(peer);
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Rejecting new peer for " + cur.snark.torrent);
                }
                socket.close();
                return;
            }
            throw new IOException("Peer wants another torrent (" + Base64.encode(peerInfoHash) + ") while we don't support that hash");
        }
    }

    private byte[] readHash(InputStream in) throws IOException {
        byte[] buf = new byte[LOOKAHEAD_SIZE];
        int read = DataHelper.read(in, buf);
        if (read != buf.length) {
            throw new IOException("Unable to read the hash (read " + read + ")");
        }
        byte[] rv = new byte[20];
        System.arraycopy(buf, buf.length - rv.length - 1, rv, 0, rv.length);
        return rv;
    }
}

