/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketEepGet;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;
import net.i2p.util.Translate;
import org.klomp.snark.PeerID;
import org.klomp.snark.Snark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PSnarkUtil {
    private I2PAppContext _context;
    private Log _log;
    private boolean _shouldProxy;
    private String _proxyHost;
    private int _proxyPort;
    private String _i2cpHost;
    private int _i2cpPort;
    private Map<String, String> _opts;
    private I2PSocketManager _manager;
    private boolean _configured;
    private final Set<Hash> _shitlist;
    private int _maxUploaders;
    private int _maxUpBW;
    private int _maxConnections;
    private File _tmpDir;
    private int _startupDelay;
    public static final int DEFAULT_STARTUP_DELAY = 3;
    public static final String PROP_USE_OPENTRACKERS = "i2psnark.useOpentrackers";
    public static final boolean DEFAULT_USE_OPENTRACKERS = true;
    public static final String PROP_OPENTRACKERS = "i2psnark.opentrackers";
    public static final String DEFAULT_OPENTRACKERS = "http://tracker.welterde.i2p/a";
    public static final int DEFAULT_MAX_UP_BW = 8;
    public static final int MAX_CONNECTIONS = 16;
    private static final String BUNDLE_NAME = "org.klomp.snark.web.messages";

    public I2PSnarkUtil(I2PAppContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(Snark.class);
        this._opts = new HashMap<String, String>();
        this.setI2CPConfig("127.0.0.1", 7654, null);
        this._shitlist = new ConcurrentHashSet<Hash>();
        this._configured = false;
        this._maxUploaders = 10;
        this._maxUpBW = 8;
        this._maxConnections = 16;
        this._startupDelay = 3;
        this._tmpDir = new SecureDirectory(ctx.getTempDir(), "i2psnark");
        FileUtil.rmdir(this._tmpDir, false);
        this._tmpDir.mkdirs();
    }

    public boolean configured() {
        return this._configured;
    }

    public void setI2CPConfig(String i2cpHost, int i2cpPort, Map opts) {
        if (i2cpHost != null) {
            this._i2cpHost = i2cpHost;
        }
        if (i2cpPort > 0) {
            this._i2cpPort = i2cpPort;
        }
        if (opts != null) {
            this._opts.putAll(opts);
        }
        this._configured = true;
    }

    public void setMaxUploaders(int limit) {
        this._maxUploaders = limit;
        this._configured = true;
    }

    public void setMaxUpBW(int limit) {
        this._maxUpBW = limit;
        this._configured = true;
    }

    public void setMaxConnections(int limit) {
        this._maxConnections = limit;
        this._configured = true;
    }

    public void setStartupDelay(int minutes) {
        this._startupDelay = minutes;
        this._configured = true;
    }

    public String getI2CPHost() {
        return this._i2cpHost;
    }

    public int getI2CPPort() {
        return this._i2cpPort;
    }

    public Map<String, String> getI2CPOptions() {
        return this._opts;
    }

    public String getEepProxyHost() {
        return this._proxyHost;
    }

    public int getEepProxyPort() {
        return this._proxyPort;
    }

    public boolean getEepProxySet() {
        return this._shouldProxy;
    }

    public int getMaxUploaders() {
        return this._maxUploaders;
    }

    public int getMaxUpBW() {
        return this._maxUpBW;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public int getStartupDelay() {
        return this._startupDelay;
    }

    public synchronized boolean connect() {
        if (this._manager == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Connecting to I2P", new Exception("I did it"));
            }
            Properties opts = new Properties();
            if (this._opts != null) {
                for (String key : this._opts.keySet()) {
                    opts.setProperty(key, this._opts.get(key).toString());
                }
            }
            if (opts.getProperty("inbound.nickname") == null) {
                opts.setProperty("inbound.nickname", "I2PSnark");
            }
            if (opts.getProperty("outbound.nickname") == null) {
                opts.setProperty("outbound.nickname", "I2PSnark");
            }
            if (opts.getProperty("i2p.streaming.inactivityTimeout") == null) {
                opts.setProperty("i2p.streaming.inactivityTimeout", "240000");
            }
            if (opts.getProperty("i2p.streaming.inactivityAction") == null) {
                opts.setProperty("i2p.streaming.inactivityAction", "1");
            }
            if (opts.getProperty("i2p.streaming.initialWindowSize") == null) {
                opts.setProperty("i2p.streaming.initialWindowSize", "1");
            }
            if (opts.getProperty("i2p.streaming.slowStartGrowthRateFactor") == null) {
                opts.setProperty("i2p.streaming.slowStartGrowthRateFactor", "1");
            }
            this._manager = I2PSocketManagerFactory.createManager(this._i2cpHost, this._i2cpPort, opts);
        }
        return this._manager != null;
    }

    public boolean connected() {
        return this._manager != null;
    }

    public void disconnect() {
        I2PSocketManager mgr = this._manager;
        this._manager = null;
        this._shitlist.clear();
        mgr.destroySocketManager();
        FileUtil.rmdir(this._tmpDir, false);
        this._tmpDir.mkdirs();
    }

    I2PSocket connect(PeerID peer) throws IOException {
        I2PSocketManager mgr = this._manager;
        if (mgr == null) {
            throw new IOException("No socket manager");
        }
        Destination addr = peer.getAddress();
        if (addr == null) {
            throw new IOException("Null address");
        }
        Hash dest = addr.calculateHash();
        if (this._shitlist.contains(dest)) {
            throw new IOException("Not trying to contact " + dest.toBase64() + ", as they are shitlisted");
        }
        try {
            I2PSocket rv = this._manager.connect(addr);
            if (rv != null) {
                this._shitlist.remove(dest);
            }
            return rv;
        }
        catch (I2PException ie) {
            this._shitlist.add(dest);
            SimpleScheduler.getInstance().addEvent(new Unshitlist(dest), 600000L);
            throw new IOException("Unable to reach the peer " + peer + ": " + ie.getMessage());
        }
    }

    public File get(String url) {
        return this.get(url, true, 0);
    }

    public File get(String url, boolean rewrite) {
        return this.get(url, rewrite, 0);
    }

    public File get(String url, int retries) {
        return this.get(url, true, retries);
    }

    public File get(String url, boolean rewrite, int retries) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Fetching [" + url + "] proxy=" + this._proxyHost + ":" + this._proxyPort + ": " + this._shouldProxy);
        }
        File out = null;
        try {
            out = File.createTempFile("i2psnark", null, this._tmpDir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            if (out != null) {
                out.delete();
            }
            return null;
        }
        out.deleteOnExit();
        String fetchURL = url;
        if (rewrite) {
            fetchURL = this.rewriteAnnounce(url);
        }
        if (!this.connected() && !this.connect()) {
            return null;
        }
        I2PSocketEepGet get = new I2PSocketEepGet(this._context, this._manager, retries, out.getAbsolutePath(), fetchURL);
        if (get.fetch()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Fetch successful [" + url + "]: size=" + out.length());
            }
            return out;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Fetch failed [" + url + "]");
        }
        out.delete();
        return null;
    }

    public I2PServerSocket getServerSocket() {
        I2PSocketManager mgr = this._manager;
        if (mgr != null) {
            return mgr.getServerSocket();
        }
        return null;
    }

    String getOurIPString() {
        Destination dest;
        if (this._manager == null) {
            return "unknown";
        }
        I2PSession sess = this._manager.getSession();
        if (sess != null && (dest = sess.getMyDestination()) != null) {
            return dest.toBase64();
        }
        return "unknown";
    }

    static Destination getDestinationFromBase64(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            if (ip.length() < 520) {
                return null;
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    Destination getDestination(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            Destination dest;
            if (ip.length() < 520 && (dest = this._context.namingService().lookup(ip)) != null) {
                return dest;
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public String lookup(String name) {
        Destination dest = this.getDestination(name);
        if (dest == null) {
            return null;
        }
        return dest.toBase64();
    }

    String rewriteAnnounce(String origAnnounce) {
        int destStart = "http://".length();
        int destEnd = origAnnounce.indexOf(".i2p");
        if (destEnd < destStart + 516) {
            return origAnnounce;
        }
        int pathStart = origAnnounce.indexOf(47, destEnd);
        String rv = "http://i2p/" + origAnnounce.substring(destStart, destEnd) + origAnnounce.substring(pathStart);
        return rv;
    }

    public void setOpenTrackerString(String ot) {
        this._opts.put(PROP_OPENTRACKERS, ot);
    }

    public String getOpenTrackerString() {
        String rv = this._opts.get(PROP_OPENTRACKERS);
        if (rv == null) {
            return DEFAULT_OPENTRACKERS;
        }
        return rv;
    }

    public List getOpenTrackers() {
        if (!this.shouldUseOpenTrackers()) {
            return null;
        }
        ArrayList<String> rv = new ArrayList<String>(1);
        String trackers = this.getOpenTrackerString();
        StringTokenizer tok = new StringTokenizer(trackers, ", ");
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        if (rv.isEmpty()) {
            return null;
        }
        return rv;
    }

    public boolean shouldUseOpenTrackers() {
        String rv = this._opts.get(PROP_USE_OPENTRACKERS);
        if (rv == null) {
            return true;
        }
        return Boolean.valueOf(rv);
    }

    void debug(String msg, int snarkDebugLevel) {
        this.debug(msg, snarkDebugLevel, null);
    }

    void debug(String msg, int snarkDebugLevel, Throwable t) {
        if (t instanceof OutOfMemoryError) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                t.printStackTrace();
            }
            catch (Throwable tt) {
                // empty catch block
            }
            try {
                System.out.println("OOM thread: " + Thread.currentThread().getName());
            }
            catch (Throwable tt) {
                // empty catch block
            }
        }
        switch (snarkDebugLevel) {
            case 0: 
            case 1: {
                this._log.error(msg, t);
                break;
            }
            case 2: {
                this._log.warn(msg, t);
                break;
            }
            case 3: 
            case 4: {
                this._log.info(msg, t);
                break;
            }
            default: {
                this._log.debug(msg, t);
            }
        }
    }

    public String getString(String key) {
        return Translate.getString(key, this._context, BUNDLE_NAME);
    }

    public String getString(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    public String getString(String s, Object o, Object o2) {
        return Translate.getString(s, o, o2, this._context, BUNDLE_NAME);
    }

    public String getString(int n, String s, String p) {
        return Translate.getString(n, s, p, this._context, BUNDLE_NAME);
    }

    private class Unshitlist
    implements SimpleTimer.TimedEvent {
        private Hash _dest;

        public Unshitlist(Hash dest) {
            this._dest = dest;
        }

        public void timeReached() {
            I2PSnarkUtil.this._shitlist.remove(this._dest);
        }
    }
}

