/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.Version;
import org.mortbay.http.ajp.AJP13InputStream;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.ajp.AJP13OutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URI;

public class AJP13Connection
extends HttpConnection {
    private static Log log = LogFactory.getLog(AJP13Connection.class);
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener listener, InputStream in, OutputStream out, Socket socket, int bufferSize) throws IOException {
        super(listener, null, new AJP13InputStream(in, out, bufferSize), out, socket);
        LineInput lin = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lin.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getOutputStream(), bufferSize);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut);
        this._listener = listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        packet = null;
        request = this.getRequest();
        response = this.getResponse();
        context = null;
        gotRequest = false;
        this._persistent = true;
        this._keepAlive = true;
        try {
            try {
                block73: {
                    try {
                        packet = null;
                        packet = this._ajpIn.nextPacket();
                        if (packet != null) ** GOTO lbl-1000
                        var6_6 = false;
                        ** GOTO lbl54
                    }
                    catch (IOException e) {
                        LogSupport.ignore(AJP13Connection.log, e);
                        var7_54 = false;
                        var18_14 = null;
                        if (packet == null) return false;
                        if (!gotRequest) {
                            return false;
                        }
                        try {
                            try {
                                this.getOutputStream().close();
                                if (!this._persistent) {
                                    this._ajpOut.end();
                                }
                                this._ajpOut.close();
                                this.getOutputStream().resetStream();
                                this.getOutputStream().addObserver(this);
                                this.getInputStream().resetStream();
                                this._ajpIn.resetStream();
                                this._ajpOut.resetStream();
                            }
                            catch (Exception e) {
                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                                this._persistent = false;
                                var21_26 = null;
                                this.statsRequestEnd();
                                if (context == null) return var7_54;
                                context.log(request, response, -1);
                                return var7_54;
                            }
                            var21_25 = null;
                        }
                        catch (Throwable var20_49) {
                            var21_27 = null;
                            this.statsRequestEnd();
                            if (context == null) throw var20_49;
                            context.log(request, response, -1);
                            throw var20_49;
                        }
lbl54:
                        // 1 sources

                        var18_12 = null;
                        if (packet == null) return false;
                        if (!gotRequest) {
                            return false;
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            if (packet.getDataSize() != 0) break block73;
                            var6_7 = true;
                        }
                        ** GOTO lbl334
                        this.statsRequestEnd();
                        if (context == null) return var7_54;
                        context.log(request, response, -1);
                        return var7_54;
                    }
                }
                type = packet.getByte();
                if (AJP13Connection.log.isDebugEnabled()) {
                    AJP13Connection.log.debug((Object)("AJP13 type=" + type + " size=" + packet.unconsumedData()));
                }
                switch (type) {
                    case 2: {
                        request.setTimeStamp(System.currentTimeMillis());
                        request.setState(0);
                        request.setMethod(packet.getMethod());
                        version = packet.getString();
                        try {
                            request.setVersion(version);
                        }
                        catch (Exception e) {
                            AJP13Connection.log.warn((Object)("Bad version" + version), (Throwable)e);
                            AJP13Connection.log.warn((Object)packet.toString());
                        }
                        path = packet.getString();
                        sc = path.lastIndexOf(";");
                        if (sc < 0) {
                            request.setPath(URI.encodePath(path));
                        } else {
                            request.setPath(URI.encodePath(path.substring(0, sc)) + path.substring(sc));
                        }
                        this._remoteAddr = packet.getString();
                        this._remoteHost = packet.getString();
                        this._serverName = packet.getString();
                        this._serverPort = packet.getInt();
                        this._isSSL = packet.getBoolean();
                        this._keepAlive = request.getDotVersion() >= 1;
                        h = packet.getInt();
                        for (i = 0; i < h; ++i) {
                            hdr = packet.getHeader();
                            val = packet.getString();
                            request.addField(hdr, val);
                            if (this._keepAlive || !hdr.equalsIgnoreCase("Connection") || !val.equalsIgnoreCase("keep-alive")) continue;
                            this._keepAlive = true;
                        }
                        attr = packet.getByte();
                        while ((255 & attr) != 255) {
                            value = attr == 11 ? null : packet.getString();
                            switch (attr) {
                                case 11: {
                                    request.setAttribute("javax.servlet.request.key_size", new Integer(packet.getInt()));
                                    break;
                                }
                                case 10: {
                                    request.setAttribute(value, packet.getString());
                                    break;
                                }
                                case 9: {
                                    request.setAttribute("javax.servlet.request.ssl_session", value);
                                    break;
                                }
                                case 8: {
                                    request.setAttribute("javax.servlet.request.cipher_suite", value);
                                    break;
                                }
                                case 7: {
                                    cf = CertificateFactory.getInstance("X.509");
                                    certstream = new ByteArrayInputStream(value.getBytes());
                                    cert = (X509Certificate)cf.generateCertificate(certstream);
                                    certs = new X509Certificate[]{cert};
                                    request.setAttribute("javax.servlet.request.X509Certificate", certs);
                                    break;
                                }
                                case 6: {
                                    request.setAttribute("org.mortbay.http.ajp.JVMRoute", value);
                                    break;
                                }
                                case 5: {
                                    request.setQuery(value);
                                    break;
                                }
                                case 4: {
                                    request.setAuthType(value);
                                    break;
                                }
                                case 3: {
                                    request.setAuthUser(value);
                                    break;
                                }
                                default: {
                                    AJP13Connection.log.warn((Object)("Unknown attr: " + attr + "=" + value));
                                }
                            }
                            attr = packet.getByte();
                        }
                        this._listener.customizeRequest(this, request);
                        gotRequest = true;
                        this.statsRequestStart();
                        request.setState(2);
                        if (request.getContentLength() == 0 && request.getField("Transfer-Encoding") == null) {
                            this._ajpIn.close();
                        }
                        response.setState(0);
                        response.setVersion("HTTP/1.1");
                        response.setDateField("Date", this._request.getTimeStamp());
                        if (!Version.isParanoid()) {
                            response.setField("Server", Version.getDetail());
                        }
                        if (AJP13Connection.log.isDebugEnabled()) {
                            AJP13Connection.log.debug((Object)("REQUEST:\n" + request));
                        }
                        context = this.service(request, response);
                        if (!AJP13Connection.log.isDebugEnabled()) break;
                        AJP13Connection.log.debug((Object)("RESPONSE:\n" + response));
                        break;
                    }
                    default: {
                        if (AJP13Connection.log.isDebugEnabled()) {
                            AJP13Connection.log.debug((Object)("Ignored: " + packet));
                        }
                        this._persistent = false;
                        break;
                    }
                }
                ** GOTO lbl372
            }
            catch (SocketException e) {
                LogSupport.ignore(AJP13Connection.log, e);
                this._persistent = false;
                var18_16 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var20_51) {
                    var21_33 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var20_51;
                    context.log(request, response, -1);
                    throw var20_51;
                }
                try {}
                catch (Exception e) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    var21_32 = null;
                    this.statsRequestEnd();
                    if (context == null) return this._persistent;
                    context.log(request, response, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var21_31 = null;
                this.statsRequestEnd();
                if (context == null) return this._persistent;
                context.log(request, response, -1);
                return this._persistent;
            }
            catch (Exception e) {
                AJP13Connection.log.warn((Object)"EXCEPTION ", (Throwable)e);
                this._persistent = false;
                try {
                    if (gotRequest) {
                        this._ajpOut.close();
                    }
                }
                catch (IOException e2) {
                    LogSupport.ignore(AJP13Connection.log, e2);
                }
                var18_17 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var20_52) {
                    var21_36 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var20_52;
                    context.log(request, response, -1);
                    throw var20_52;
                }
                try {}
                catch (Exception e) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    var21_35 = null;
                    this.statsRequestEnd();
                    if (context == null) return this._persistent;
                    context.log(request, response, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var21_34 = null;
                this.statsRequestEnd();
                if (context == null) return this._persistent;
                context.log(request, response, -1);
                return this._persistent;
            }
        }
        catch (Throwable var17_67) {
            block74: {
                var18_18 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var20_53) {
                    var21_39 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var20_53;
                    context.log(request, response, -1);
                    throw var20_53;
                }
                try {}
                catch (Exception e) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    var21_38 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var17_67;
                    context.log(request, response, -1);
                    throw var17_67;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                break block74;
lbl-1000:
                // 1 sources

                try {}
                catch (Throwable var20_47) {
                    var21_21 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var20_47;
                    context.log(request, response, -1);
                    throw var20_47;
                }
                try {}
                catch (Exception e) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    var21_20 = null;
                    this.statsRequestEnd();
                    if (context == null) return var6_6;
                    context.log(request, response, -1);
                    return var6_6;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var21_19 = null;
                this.statsRequestEnd();
                if (context == null) return var6_6;
                context.log(request, response, -1);
                return var6_6;
lbl334:
                // 1 sources

                var18_13 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var20_48) {
                    var21_24 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var20_48;
                    context.log(request, response, -1);
                    throw var20_48;
                }
                try {}
                catch (Exception e) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    var21_23 = null;
                    this.statsRequestEnd();
                    if (context == null) return var6_7;
                    context.log(request, response, -1);
                    return var6_7;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var21_22 = null;
                this.statsRequestEnd();
                if (context == null) return var6_7;
                context.log(request, response, -1);
                return var6_7;
lbl372:
                // 1 sources

                var18_15 = null;
                if (packet == null) return false;
                if (!gotRequest) {
                    return false;
                }
                try {}
                catch (Throwable var20_50) {
                    var21_30 = null;
                    this.statsRequestEnd();
                    if (context == null) throw var20_50;
                    context.log(request, response, -1);
                    throw var20_50;
                }
                try {}
                catch (Exception e) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    var21_29 = null;
                    this.statsRequestEnd();
                    if (context == null) return this._persistent;
                    context.log(request, response, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var21_28 = null;
                this.statsRequestEnd();
                if (context == null) return this._persistent;
                context.log(request, response, -1);
                return this._persistent;
            }
            var21_37 = null;
            this.statsRequestEnd();
            if (context == null) throw var17_67;
            context.log(request, response, -1);
            throw var17_67;
        }
    }

    protected void firstWrite() throws IOException {
        log.debug((Object)"ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        log.debug((Object)"ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

