/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.Cookie;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.NCSARequestLog;
import org.mortbay.util.StringUtil;

public class I2PRequestLog
extends NCSARequestLog {
    public I2PRequestLog() {
    }

    public I2PRequestLog(String filename) throws IOException {
        super(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpRequest request, HttpResponse response, int responseLength) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getPath()) != null) {
                return;
            }
            if (this._fileOut == null) {
                return;
            }
            StringBuilder buf = new StringBuilder(160);
            String addr = request.getField("X-I2P-DestHash");
            if (addr != null) {
                buf.append(addr).append(".i2p");
            } else {
                buf.append(request.getRemoteAddr());
            }
            buf.append(" - ");
            String user = request.getAuthUser();
            buf.append(user == null ? "-" : user);
            buf.append(" [");
            buf.append(this._logDateCache.format(request.getTimeStamp()));
            buf.append("] \"");
            buf.append(request.getMethod());
            buf.append(' ');
            buf.append(request.getURI());
            buf.append(' ');
            buf.append(request.getVersion());
            buf.append("\" ");
            int status = response.getStatus();
            buf.append((char)(48 + status / 100 % 10));
            buf.append((char)(48 + status / 10 % 10));
            buf.append((char)(48 + status % 10));
            if (responseLength >= 0) {
                buf.append(' ');
                if (responseLength > 99999) {
                    buf.append(Integer.toString(responseLength));
                } else {
                    if (responseLength > 9999) {
                        buf.append((char)(48 + responseLength / 10000 % 10));
                    }
                    if (responseLength > 999) {
                        buf.append((char)(48 + responseLength / 1000 % 10));
                    }
                    if (responseLength > 99) {
                        buf.append((char)(48 + responseLength / 100 % 10));
                    }
                    if (responseLength > 9) {
                        buf.append((char)(48 + responseLength / 10 % 10));
                    }
                    buf.append((char)(48 + responseLength % 10));
                }
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            String log = buf.toString();
            Writer writer = this._writer;
            synchronized (writer) {
                this._writer.write(log);
                if (this.isExtended()) {
                    this.logExtended(request, response, this._writer);
                    if (!this.getLogCookies()) {
                        this._writer.write(" -");
                    }
                }
                if (this.getLogCookies()) {
                    Cookie[] cookies = request.getCookies();
                    if (cookies == null || cookies.length == 0) {
                        this._writer.write(" -");
                    } else {
                        this._writer.write(" \"");
                        for (int i = 0; i < cookies.length; ++i) {
                            if (i != 0) {
                                this._writer.write(59);
                            }
                            this._writer.write(cookies[i].getName());
                            this._writer.write(61);
                            this._writer.write(cookies[i].getValue());
                        }
                        this._writer.write("\"");
                    }
                }
                if (this.getLogLatency()) {
                    this._writer.write(" " + (System.currentTimeMillis() - request.getTimeStamp()));
                }
                this._writer.write(StringUtil.__LINE_SEPARATOR);
                this._writer.flush();
            }
        }
        catch (IOException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }
}

