/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PServerSocketImpl;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketImpl;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.I2PSocketOptionsImpl;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

class I2PSocketManagerImpl
implements I2PSocketManager,
I2PSessionListener {
    private I2PAppContext _context;
    private Log _log;
    private I2PSession _session;
    private I2PServerSocketImpl _serverSocket = null;
    private final Object lock = new Object();
    private HashMap<String, I2PSocket> _outSockets;
    private HashMap<String, I2PSocket> _inSockets;
    private I2PSocketOptions _defaultOptions;
    private long _acceptTimeout;
    private String _name;
    private final List<I2PSocketManager.DisconnectListener> _listeners = new ArrayList<I2PSocketManager.DisconnectListener>(1);
    private static int __managerId = 0;
    public static final short ACK = 81;
    public static final short CLOSE_OUT = 82;
    public static final short DATA_OUT = 80;
    public static final short SYN = 161;
    public static final short CLOSE_IN = 162;
    public static final short DATA_IN = 160;
    public static final short CHAFF = 255;
    private static final long ACCEPT_TIMEOUT_DEFAULT = 5000L;

    public I2PSocketManagerImpl() {
        this("SocketManager " + ++__managerId);
    }

    public I2PSocketManagerImpl(String name) {
        this.init(I2PAppContext.getGlobalContext(), null, null, name);
    }

    public void init(I2PAppContext context, I2PSession session, Properties opts, String name) {
        this._name = name;
        this._context = context;
        this._log = this._context.logManager().getLog(I2PSocketManager.class);
        this._inSockets = new HashMap(16);
        this._outSockets = new HashMap(16);
        this._acceptTimeout = 5000L;
        this.setSession(session);
        this.setDefaultOptions(this.buildOptions(opts));
        this._context.statManager().createRateStat("streaming.lifetime", "How long before the socket is closed?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.sent", "How many bytes are sent in the stream?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.received", "How many bytes are received in the stream?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.transferBalance", "How many streams send more than they receive (positive means more sent, negative means more received)?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.synNoAck", "How many times have we sent a SYN but not received an ACK?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.ackSendFailed", "How many times have we tried to send an ACK to a SYN and failed?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.nackSent", "How many times have we refused a SYN with a NACK?", "streaming", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("streaming.nackReceived", "How many times have we received a NACK to our SYN?", "streaming", new long[]{600000L, 3600000L, 86400000L});
    }

    public I2PSession getSession() {
        return this._session;
    }

    public void setSession(I2PSession session) {
        this._session = session;
        if (session != null) {
            session.setSessionListener((I2PSessionListener)this);
        }
    }

    public void setAcceptTimeout(long ms) {
        this._acceptTimeout = ms;
    }

    public long getAcceptTimeout() {
        return this._acceptTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(I2PSession session) {
        this._log.info(this.getName() + ": Disconnected from the session");
        this.destroySocketManager();
        ArrayList<I2PSocketManager.DisconnectListener> listeners = null;
        List<I2PSocketManager.DisconnectListener> list = this._listeners;
        synchronized (list) {
            listeners = new ArrayList<I2PSocketManager.DisconnectListener>(this._listeners);
            this._listeners.clear();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            I2PSocketManager.DisconnectListener lsnr = (I2PSocketManager.DisconnectListener)listeners.get(i);
            lsnr.sessionDisconnected();
        }
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        this._log.error(this.getName() + ": Error occurred: [" + message + "]", error);
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
        try {
            byte[] msg = session.receiveMessage(msgId);
            if (msg.length == 1 && msg[0] == -1) {
                this._log.debug(this.getName() + ": Ping received");
                return;
            }
            if (msg.length < 4) {
                this._log.warn(this.getName() + ": ==== packet too short ====");
                return;
            }
            int type = msg[0] & 0xFF;
            String id = I2PSocketManagerImpl.toString(new byte[]{msg[1], msg[2], msg[3]});
            byte[] payload = new byte[msg.length - 4];
            System.arraycopy(msg, 4, payload, 0, payload.length);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": Message read: type = [" + Integer.toHexString(type) + "] id = [" + I2PSocketManagerImpl.getReadableForm(id) + "] payload length: [" + payload.length + "]");
            }
            switch (type) {
                case 81: {
                    this.ackAvailable(id, payload);
                    return;
                }
                case 82: {
                    this.disconnectAvailable(id, payload);
                    return;
                }
                case 80: {
                    this.sendOutgoingAvailable(id, payload);
                    return;
                }
                case 161: {
                    this.synIncomingAvailable(id, payload, session);
                    return;
                }
                case 162: {
                    this.disconnectIncoming(id, payload);
                    return;
                }
                case 160: {
                    this.sendIncoming(id, payload);
                    return;
                }
                case 255: {
                    return;
                }
            }
            this.handleUnknown(type, id, payload);
            return;
        }
        catch (I2PException ise) {
            this._log.warn(this.getName() + ": Error processing", (Throwable)ise);
        }
        catch (IllegalStateException ise) {
            this._log.debug(this.getName() + ": Error processing", (Throwable)ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackAvailable(String id, byte[] payload) {
        long begin = this._context.clock().now();
        I2PSocketImpl s = null;
        Object object = this.lock;
        synchronized (object) {
            s = (I2PSocketImpl)this._outSockets.get(id);
        }
        if (s == null) {
            this._log.warn(this.getName() + ": No socket responsible for ACK packet for id " + I2PSocketManagerImpl.getReadableForm(id));
            return;
        }
        long socketRetrieved = this._context.clock().now();
        String remoteId = null;
        remoteId = s.getRemoteID(false);
        if (payload.length == 3 && remoteId == null) {
            String newID = I2PSocketManagerImpl.toString(payload);
            long beforeSetRemId = this._context.clock().now();
            s.setRemoteID(newID);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": ackAvailable - socket retrieval took " + (socketRetrieved - begin) + "ms, getRemoteId took " + (beforeSetRemId - socketRetrieved) + "ms, setRemoteId took " + (this._context.clock().now() - beforeSetRemId) + "ms");
            }
            return;
        }
        if (this._log.shouldLog(30)) {
            if (payload.length != 3) {
                this._log.warn(this.getName() + ": Ack packet had " + payload.length + " bytes");
            } else {
                this._log.warn(this.getName() + ": Remote ID already exists? " + remoteId);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getName() + ": invalid ack - socket retrieval took " + (socketRetrieved - begin) + "ms, overall took " + (this._context.clock().now() - begin) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAvailable(String id, byte[] payload) {
        I2PSocketImpl s = null;
        Object object = this.lock;
        synchronized (object) {
            s = (I2PSocketImpl)this._outSockets.get(id);
        }
        this._log.debug(this.getName() + ": *Disconnect outgoing for socket " + s + " on id " + I2PSocketManagerImpl.getReadableForm(id));
        try {
            if (s != null) {
                if (payload.length > 0) {
                    this._log.debug(this.getName() + ": Disconnect packet had " + payload.length + " bytes");
                }
                if (s.getRemoteID(false) == null) {
                    s.setRemoteID(null);
                    return;
                }
                s.internalClose();
                object = this.lock;
                synchronized (object) {
                    this._outSockets.remove(id);
                }
            }
            return;
        }
        catch (Exception t) {
            this._log.warn(this.getName() + ": Ignoring error on disconnect for socket " + s, (Throwable)t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOutgoingAvailable(String id, byte[] payload) throws IllegalStateException {
        I2PSocketImpl s = null;
        Object object = this.lock;
        synchronized (object) {
            s = (I2PSocketImpl)this._outSockets.get(id);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getName() + ": *Packet send outgoing [" + payload.length + "] for socket " + s + " on id " + I2PSocketManagerImpl.getReadableForm(id));
        }
        if (s != null) {
            s.queueData(payload);
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn(this.getName() + ": Null socket with data available");
        }
        throw new IllegalStateException("Null socket with data available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synIncomingAvailable(String id, byte[] payload, I2PSession session) throws DataFormatException, I2PSessionException {
        byte[] packet;
        Destination d = new Destination();
        d.fromByteArray(payload);
        I2PSocketImpl s = null;
        boolean acceptConnections = this._serverSocket != null;
        String newLocalID = null;
        Object object = this.lock;
        synchronized (object) {
            newLocalID = I2PSocketManagerImpl.makeID(this._inSockets);
            if (acceptConnections) {
                s = new I2PSocketImpl(d, this, false, newLocalID);
                s.setRemoteID(id);
            }
        }
        this._log.debug(this.getName() + ": *Syn! for socket " + s + " on id " + I2PSocketManagerImpl.getReadableForm(newLocalID) + " from " + d.calculateHash().toBase64().substring(0, 6));
        if (!acceptConnections) {
            packet = I2PSocketManagerImpl.makePacket((byte)82, id, I2PSocketManagerImpl.toBytes(newLocalID));
            boolean replySentOk = false;
            I2PSession i2PSession = this._session;
            synchronized (i2PSession) {
                replySentOk = this._session.sendMessage(d, packet);
            }
            if (!replySentOk) {
                this._log.warn(this.getName() + ": Error sending close to " + d.calculateHash().toBase64() + " in response to a new con message", (Throwable)new Exception("Failed creation"));
            }
            this._context.statManager().addRateData("streaming.nackSent", 1L, 1L);
            return;
        }
        if (this._serverSocket.addWaitForAccept(s, this._acceptTimeout)) {
            this._inSockets.put(newLocalID, s);
            packet = I2PSocketManagerImpl.makePacket((byte)81, id, I2PSocketManagerImpl.toBytes(newLocalID));
            boolean replySentOk = false;
            replySentOk = this._session.sendMessage(d, packet);
            if (!replySentOk) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getName() + ": Error sending reply to " + d.calculateHash().toBase64() + " in response to a new con message for socket " + s, (Throwable)new Exception("Failed creation"));
                }
                s.internalClose();
                this._context.statManager().addRateData("streaming.ackSendFailed", 1L, 1L);
            }
        } else {
            packet = I2PSocketManagerImpl.toBytes(" " + id);
            packet[0] = 82;
            boolean nackSent = session.sendMessage(d, packet);
            if (!nackSent) {
                this._log.warn(this.getName() + ": Error sending NACK for session creation for socket " + s);
            }
            s.internalClose();
            this._context.statManager().addRateData("streaming,nackSent", 1L, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectIncoming(String id, byte[] payload) {
        I2PSocketImpl s = null;
        Object object = this.lock;
        synchronized (object) {
            s = (I2PSocketImpl)this._inSockets.get(id);
            if (payload.length == 0 && s != null) {
                this._inSockets.remove(id);
            }
        }
        this._log.debug(this.getName() + ": *Disconnect incoming for socket " + s);
        try {
            if (payload.length == 0 && s != null) {
                s.internalClose();
                return;
            }
            if (payload.length > 0 && this._log.shouldLog(40)) {
                this._log.warn(this.getName() + ": Disconnect packet had " + payload.length + " bytes");
            }
            if (s != null) {
                s.internalClose();
            }
            return;
        }
        catch (Exception t) {
            this._log.warn(this.getName() + ": Ignoring error on disconnect", (Throwable)t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIncoming(String id, byte[] payload) throws IllegalStateException {
        I2PSocketImpl s = null;
        Object object = this.lock;
        synchronized (object) {
            s = (I2PSocketImpl)this._inSockets.get(id);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getName() + ": *Packet send incoming [" + payload.length + "] for socket " + s);
        }
        if (s != null) {
            s.queueData(payload);
            return;
        }
        this._log.info(this.getName() + ": Null socket with data available");
        throw new IllegalStateException("Null socket with data available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnknown(int type, String id, byte[] payload) {
        this._log.error(this.getName() + ": \n\n=============== Unknown packet! " + "============" + "\nType: " + type + "\nID:   " + I2PSocketManagerImpl.getReadableForm(id) + "\nBase64'ed Data: " + Base64.encode((byte[])payload) + "\n\n\n");
        if (id != null) {
            Object object = this.lock;
            synchronized (object) {
                this._inSockets.remove(id);
                this._outSockets.remove(id);
            }
        }
    }

    public void reportAbuse(I2PSession session, int severity) {
        this._log.error(this.getName() + ": Abuse reported [" + severity + "]");
    }

    public void setDefaultOptions(I2PSocketOptions options) {
        this._defaultOptions = options;
    }

    public I2PSocketOptions getDefaultOptions() {
        return this._defaultOptions;
    }

    public I2PSocketOptions buildOptions() {
        return this.buildOptions(null);
    }

    public I2PSocketOptions buildOptions(Properties opts) {
        return new I2PSocketOptionsImpl(opts);
    }

    public I2PServerSocket getServerSocket() {
        if (this._serverSocket == null) {
            this._serverSocket = new I2PServerSocketImpl(this);
        }
        return this._serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSocket connect(Destination peer, I2PSocketOptions options) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        I2PSocketImpl s;
        String lcID;
        String localID;
        Object object = this.lock;
        synchronized (object) {
            localID = I2PSocketManagerImpl.makeID(this._outSockets);
            lcID = I2PSocketManagerImpl.getReadableForm(localID);
            s = new I2PSocketImpl(peer, this, true, localID);
            this._outSockets.put(localID, s);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getName() + ": connect(" + peer.calculateHash().toBase64().substring(0, 6) + ", ...): localID = " + lcID);
        }
        try {
            ByteArrayOutputStream pubkey = new ByteArrayOutputStream();
            this._session.getMyDestination().writeBytes((OutputStream)pubkey);
            byte[] packet = I2PSocketManagerImpl.makePacket((byte)-95, localID, pubkey.toByteArray());
            boolean sent = false;
            sent = this._session.sendMessage(peer, packet);
            if (!sent) {
                this._log.info(this.getName() + ": Unable to send & receive ack for SYN packet for socket " + s + " with localID = " + lcID);
                Object object2 = this.lock;
                synchronized (object2) {
                    this._outSockets.remove(s.getLocalID());
                }
                this._context.statManager().addRateData("streaming.synNoAck", 1L, 1L);
                throw new I2PException("Error sending through I2P network");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": syn sent ok to " + peer.calculateHash().toBase64().substring(0, 6) + " with localID = " + lcID);
            }
            String remoteID = options != null ? s.getRemoteID(true, options.getConnectTimeout()) : s.getRemoteID(true, this.getDefaultOptions().getConnectTimeout());
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": remoteID received from " + peer.calculateHash().toBase64().substring(0, 6) + ": " + I2PSocketManagerImpl.getReadableForm(remoteID) + " with localID = " + lcID);
            }
            if (remoteID == null) {
                this._context.statManager().addRateData("streaming.nackReceived", 1L, 1L);
                throw new ConnectException("Connection refused by peer for socket " + s);
            }
            if ("".equals(remoteID)) {
                this._context.statManager().addRateData("streaming.synNoAck", 1L, 1L);
                throw new NoRouteToHostException("Unable to reach peer for socket " + s);
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": TIMING: s given out for remoteID " + I2PSocketManagerImpl.getReadableForm(remoteID) + " for socket " + s);
            }
            return s;
        }
        catch (InterruptedIOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getName() + ": Timeout waiting for ack from syn for id " + lcID + " to " + peer.calculateHash().toBase64().substring(0, 6) + " for socket " + s, (Throwable)ioe);
            }
            Object object3 = this.lock;
            synchronized (object3) {
                this._outSockets.remove(s.getLocalID());
            }
            s.internalClose();
            this._context.statManager().addRateData("streaming.synNoAck", 1L, 1L);
            throw new InterruptedIOException("Timeout waiting for ack");
        }
        catch (ConnectException ex) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": Connection error waiting for ack from syn for id " + lcID + " to " + peer.calculateHash().toBase64().substring(0, 6) + " for socket " + s, (Throwable)ex);
            }
            s.internalClose();
            throw ex;
        }
        catch (NoRouteToHostException ex) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getName() + ": No route to host waiting for ack from syn for id " + lcID + " to " + peer.calculateHash().toBase64().substring(0, 6) + " for socket " + s, (Throwable)ex);
            }
            s.internalClose();
            throw ex;
        }
        catch (IOException ex) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getName() + ": Error sending syn on id " + lcID + " to " + peer.calculateHash().toBase64().substring(0, 6) + " for socket " + s, (Throwable)ex);
            }
            Object object4 = this.lock;
            synchronized (object4) {
                this._outSockets.remove(s.getLocalID());
            }
            s.internalClose();
            throw new I2PException("Unhandled IOException occurred");
        }
        catch (I2PException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getName() + ": Error sending syn on id " + lcID + " to " + peer.calculateHash().toBase64().substring(0, 6) + " for socket " + s, (Throwable)ex);
            }
            Object object5 = this.lock;
            synchronized (object5) {
                this._outSockets.remove(s.getLocalID());
            }
            s.internalClose();
            throw ex;
        }
        catch (Exception e) {
            s.internalClose();
            this._log.warn(this.getName() + ": Unhandled error connecting on " + lcID + " to " + peer.calculateHash().toBase64().substring(0, 6) + " for socket " + s, (Throwable)e);
            throw new ConnectException("Unhandled error connecting: " + e.getMessage());
        }
    }

    public I2PSocket connect(Destination peer) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        return this.connect(peer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySocketManager() {
        if (this._serverSocket != null) {
            this._serverSocket.close();
            this._serverSocket = null;
        }
        Object object = this.lock;
        synchronized (object) {
            I2PSocketImpl sock;
            String id2 = null;
            for (String id2 : this._inSockets.keySet()) {
                sock = (I2PSocketImpl)this._inSockets.get(id2);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getName() + ": Closing inSocket \"" + I2PSocketManagerImpl.getReadableForm(sock.getLocalID()) + "\"");
                }
                sock.internalClose();
            }
            for (String id2 : this._outSockets.keySet()) {
                sock = (I2PSocketImpl)this._outSockets.get(id2);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getName() + ": Closing outSocket \"" + I2PSocketManagerImpl.getReadableForm(sock.getLocalID()) + "\"");
                }
                sock.internalClose();
            }
        }
        this._log.debug(this.getName() + ": Waiting for all open sockets to really close...");
        object = this.lock;
        synchronized (object) {
            while (this._inSockets.size() != 0 || this._outSockets.size() != 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this._log.debug(this.getName() + ": Destroying I2P session...");
            this._session.destroySession();
            this._log.debug(this.getName() + ": I2P session destroyed");
        }
        catch (I2PSessionException e) {
            this._log.warn(this.getName() + ": Error destroying I2P session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listSockets() {
        HashSet<I2PSocket> sockets = new HashSet<I2PSocket>(8);
        Object object = this.lock;
        synchronized (object) {
            sockets.addAll(this._inSockets.values());
            sockets.addAll(this._outSockets.values());
        }
        return sockets;
    }

    public boolean ping(Destination peer, long timeoutMs) {
        try {
            return this._session.sendMessage(peer, new byte[]{-1});
        }
        catch (I2PException ex) {
            this._log.warn(this.getName() + ": I2PException:", (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSocket(I2PSocketImpl sock) {
        String localId = sock.getLocalID();
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            removed = null != this._inSockets.remove(localId);
            removed = removed || null != this._outSockets.remove(localId);
            this.lock.notify();
        }
        long now = this._context.clock().now();
        long lifetime = now - sock.getCreatedOn();
        long timeSinceClose = now - sock.getClosedOn();
        long sent = sock.getBytesSent();
        long recv = sock.getBytesReceived();
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getName() + ": Removing socket \"" + I2PSocketManagerImpl.getReadableForm(localId) + "\" [" + sock + ", send: " + sent + ", recv: " + recv + ", lifetime: " + lifetime + "ms, time since close: " + timeSinceClose + " removed? " + removed + ")]", (Throwable)new Exception("removeSocket called"));
        }
        this._context.statManager().addRateData("streaming.lifetime", lifetime, lifetime);
        this._context.statManager().addRateData("streaming.sent", sent, lifetime);
        this._context.statManager().addRateData("streaming.received", recv, lifetime);
        if (sent > recv) {
            this._context.statManager().addRateData("streaming.transferBalance", 1L, lifetime);
        } else if (recv > sent) {
            this._context.statManager().addRateData("streaming.transferBalance", -1L, lifetime);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        List<I2PSocketManager.DisconnectListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        List<I2PSocketManager.DisconnectListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(lsnr);
        }
    }

    public static String getReadableForm(String id) {
        if (id == null) {
            return "(null)";
        }
        if (id.length() != 3) {
            return "Bogus";
        }
        return Base64.encode((byte[])I2PSocketManagerImpl.toBytes(id));
    }

    private static String makeID(HashMap uniqueIn) {
        byte[] nid;
        String newID;
        do {
            int id = (int)(Math.random() * 1.6777215E7 + 1.0);
            nid = new byte[]{(byte)(id / 65536), (byte)(id / 256 % 256), (byte)(id % 256)};
        } while (uniqueIn.get(newID = I2PSocketManagerImpl.toString(nid)) != null);
        return newID;
    }

    public static byte[] makePacket(byte type, String id, byte[] payload) {
        byte[] packet = new byte[payload.length + 4];
        packet[0] = type;
        byte[] temp = I2PSocketManagerImpl.toBytes(id);
        if (temp.length != 3) {
            throw new RuntimeException("Incorrect ID length: " + temp.length);
        }
        System.arraycopy(temp, 0, packet, 1, 3);
        System.arraycopy(payload, 0, packet, 4, payload.length);
        return packet;
    }

    private static final String toString(byte[] data) {
        try {
            return new String(data, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("WTF!  iso-8859-1 isn't supported?");
        }
    }

    private static final byte[] toBytes(String str) {
        try {
            return str.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("WTF!  iso-8859-1 isn't supported?");
        }
    }
}

