/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.BOB.DoCMDS;
import net.i2p.BOB.NamedDB;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.RetransmissionTimer;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer2;

public class BOB {
    private static final Log _log = new Log(BOB.class);
    public static final String PROP_CONFIG_LOCATION = "BOB.config";
    public static final String PROP_BOB_PORT = "BOB.port";
    public static final String PROP_BOB_HOST = "BOB.host";
    private static NamedDB database;
    private static Properties props;
    private static AtomicBoolean spin;
    private static final String P_RUNNING = "RUNNING";
    private static final String P_STARTING = "STARTING";
    private static final String P_STOPPING = "STOPPING";
    private static AtomicBoolean lock;

    public static void info(String arg) {
        System.out.println("INFO:" + arg);
        _log.info(arg);
    }

    public static void warn(String arg) {
        System.out.println("WARNING:" + arg);
        _log.warn(arg);
    }

    public static void error(String arg) {
        System.out.println("ERROR: " + arg);
        _log.error(arg);
    }

    public static void stop() {
        spin.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        database = new NamedDB();
        ServerSocket listener = null;
        int i = 0;
        boolean save = false;
        String configLocation = System.getProperty(PROP_CONFIG_LOCATION, "bob.config");
        RetransmissionTimer Y = RetransmissionTimer.getInstance();
        SimpleScheduler Y1 = SimpleScheduler.getInstance();
        SimpleTimer2 Y2 = SimpleTimer2.getInstance();
        i = Y.hashCode();
        i = Y1.hashCode();
        i = Y2.hashCode();
        File cfg = new File(configLocation);
        if (!cfg.isAbsolute()) {
            cfg = new File(I2PAppContext.getGlobalContext().getConfigDir(), configLocation);
        }
        try {
            FileInputStream fi = new FileInputStream(cfg);
            props.load(fi);
            fi.close();
        }
        catch (FileNotFoundException fnfe) {
            BOB.warn("Unable to load up the BOB config file " + cfg.getAbsolutePath() + ", Using defaults.");
            BOB.warn(fnfe.toString());
            save = true;
        }
        catch (IOException ioe) {
            BOB.warn("IOException on BOB config file " + cfg.getAbsolutePath() + ", using defaults.");
            BOB.warn(ioe.toString());
        }
        if (!props.containsKey("i2cp.tcp.host")) {
            props.setProperty("i2cp.tcp.host", "localhost");
        }
        if (!props.containsKey("i2cp.tcp.port")) {
            props.setProperty("i2cp.tcp.port", "7654");
        }
        if (!props.containsKey("i2cp.messageReliability")) {
            props.setProperty("i2cp.messageReliability", "BestEffort");
        }
        if (!props.containsKey(PROP_BOB_PORT)) {
            props.setProperty(PROP_BOB_PORT, "2827");
        }
        if (!props.containsKey("inbound.length")) {
            props.setProperty("inbound.length", "1");
        }
        if (!props.containsKey("outbound.length")) {
            props.setProperty("outbound.length", "1");
        }
        if (!props.containsKey("inbound.lengthVariance")) {
            props.setProperty("inbound.lengthVariance", "0");
        }
        if (!props.containsKey("outbound.lengthVariance")) {
            props.setProperty("outbound.lengthVariance", "0");
        }
        if (!props.containsKey(PROP_BOB_HOST)) {
            props.setProperty(PROP_BOB_HOST, "localhost");
        }
        if (save) {
            cfg = new File(configLocation);
            if (!cfg.isAbsolute()) {
                cfg = new File(I2PAppContext.getGlobalContext().getConfigDir(), configLocation);
            }
            try {
                BOB.warn("Writing new defaults file " + cfg.getAbsolutePath());
                FileOutputStream fo = new FileOutputStream(cfg);
                props.store(fo, cfg.getAbsolutePath());
                fo.close();
            }
            catch (IOException ioe) {
                BOB.error("IOException on BOB config file " + cfg.getAbsolutePath() + ", " + ioe);
            }
        }
        i = 0;
        boolean g = false;
        try {
            BOB.info("BOB is now running.");
            listener = new ServerSocket(Integer.parseInt(props.getProperty(PROP_BOB_PORT)), 10, InetAddress.getByName(props.getProperty(PROP_BOB_HOST)));
            Socket server = null;
            listener.setSoTimeout(500);
            while (spin.get()) {
                try {
                    server = listener.accept();
                    server.setKeepAlive(true);
                    g = true;
                }
                catch (ConnectException ce) {
                    g = false;
                }
                catch (SocketTimeoutException ste) {
                    g = false;
                }
                if (!g) continue;
                DoCMDS conn_c = new DoCMDS(spin, lock, server, props, database, _log);
                Thread t = new Thread(conn_c);
                t.setName("BOB.DoCMDS " + i);
                t.start();
                ++i;
            }
        }
        catch (IOException ioe) {
            BOB.error("IOException on socket listen: " + ioe);
            ioe.printStackTrace();
        }
        Object var13_19 = null;
        BOB.info("BOB is now shutting down...");
        try {
            listener.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        BOB.visitAllThreads();
        database.getReadLock();
        int all = database.getcount();
        database.releaseReadLock();
        for (i = 0; i < all; ++i) {
            database.getReadLock();
            NamedDB nickinfo = (NamedDB)database.getnext(i);
            nickinfo.getReadLock();
            if (nickinfo.get(P_RUNNING).equals(Boolean.TRUE) && nickinfo.get(P_STOPPING).equals(Boolean.FALSE) && nickinfo.get(P_STARTING).equals(Boolean.FALSE)) {
                nickinfo.releaseReadLock();
                database.releaseReadLock();
                database.getWriteLock();
                nickinfo.getWriteLock();
                nickinfo.add(P_STOPPING, new Boolean(true));
                nickinfo.releaseWriteLock();
                database.releaseWriteLock();
                continue;
            }
            nickinfo.releaseReadLock();
            database.releaseReadLock();
        }
        {
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            BOB.info("BOB is now shutting down...");
            try {
                listener.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            BOB.visitAllThreads();
            database.getReadLock();
            all = database.getcount();
            database.releaseReadLock();
            for (i = 0; i < all; ++i) {
                database.getReadLock();
                NamedDB nickinfo = (NamedDB)database.getnext(i);
                nickinfo.getReadLock();
                if (nickinfo.get(P_RUNNING).equals(Boolean.TRUE) && nickinfo.get(P_STOPPING).equals(Boolean.FALSE) && nickinfo.get(P_STARTING).equals(Boolean.FALSE)) {
                    nickinfo.releaseReadLock();
                    database.releaseReadLock();
                    database.getWriteLock();
                    nickinfo.getWriteLock();
                    nickinfo.add(P_STOPPING, new Boolean(true));
                    nickinfo.releaseWriteLock();
                    database.releaseWriteLock();
                    continue;
                }
                nickinfo.releaseReadLock();
                database.releaseReadLock();
            }
            BOB.info("BOB is now stopped.");
            throw throwable;
        }
        BOB.info("BOB is now stopped.");
    }

    private static void visitAllThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        BOB.waitjoin(root, 0, root.getName());
    }

    private static void waitjoin(ThreadGroup group, int level, String tn) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            if (!thread.getName().startsWith("BOB.DoCMDS ")) continue;
            try {
                if (!thread.isAlive()) continue;
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {}
                continue;
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            BOB.waitjoin(groups[i], level + 1, groups[i].getName());
        }
    }

    static {
        props = new Properties();
        spin = new AtomicBoolean(true);
        lock = new AtomicBoolean(false);
    }
}

