/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udpTunnel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.udp.I2PSinkAnywhere;
import net.i2p.i2ptunnel.udp.I2PSource;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class I2PTunnelUDPServerBase
extends I2PTunnelTask
implements Source,
Sink {
    private static final Log _log = new Log(I2PTunnelUDPServerBase.class);
    private final Object lock = new Object();
    protected Object slock = new Object();
    private static volatile long __serverId = 0L;
    protected Logging l;
    private static final long DEFAULT_READ_TIMEOUT = -1L;
    protected long readTimeout = -1L;
    private I2PSession _session;
    private Source _i2pSource;
    private Sink _i2pSink;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public I2PTunnelUDPServerBase(boolean verify, File privkey, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("UDPServer <- " + privkeyname, notifyThis, tunnel);
        FileInputStream fis = null;
        fis = new FileInputStream(privkey);
        this.init(verify, fis, privkeyname, l);
        Object var10_8 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                _log.error("Error starting server", ioe);
                this.notifyEvent("openServerResult", "error");
                Object var10_9 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void init(boolean verify, InputStream privData, String privkeyname, Logging l) {
        this.l = l;
        int portNum = 7654;
        if (this.getTunnel().port != null) {
            try {
                portNum = Integer.parseInt(this.getTunnel().port);
            }
            catch (NumberFormatException nfe) {
                _log.log(50, "Invalid port specified [" + this.getTunnel().port + "], reverting to " + portNum);
            }
        }
        I2PClient client = I2PClientFactory.createClient();
        try {
            this._session = client.createSession(privData, this.getTunnel().getClientOptions());
        }
        catch (I2PSessionException exc) {
            throw new RuntimeException("failed to create session", exc);
        }
        this._i2pSource = new I2PSource(this._session, verify, false);
        this._i2pSink = new I2PSinkAnywhere(this._session, true);
    }

    public void startRunning() {
        try {
            this._session.connect();
        }
        catch (I2PSessionException exc) {
            throw new RuntimeException("failed to connect session", exc);
        }
        this.start();
        this.notifyEvent("openServerResult", "ok");
        this.open = true;
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            this.l.log("Shutting down server " + this.toString());
            try {
                if (this._session != null) {
                    this._session.destroySession();
                }
            }
            catch (I2PException ex) {
                _log.error("Error destroying the session", ex);
            }
            this.l.log("Server shut down.");
            this.open = false;
            return true;
        }
    }

    public void setSink(Sink s) {
        this._i2pSource.setSink(s);
    }

    public void start() {
        this._i2pSource.start();
    }

    public void send(Destination to, byte[] data) {
        this._i2pSink.send(to, data);
    }
}

