/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udpTunnel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.ServerSocket;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.udp.I2PSink;
import net.i2p.i2ptunnel.udp.I2PSinkAnywhere;
import net.i2p.i2ptunnel.udp.I2PSource;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public abstract class I2PTunnelUDPClientBase
extends I2PTunnelTask
implements Source,
Sink {
    private static final Log _log = new Log(I2PTunnelUDPClientBase.class);
    protected I2PAppContext _context;
    protected Logging l;
    static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    private static volatile long __clientId = 0L;
    protected long _clientId;
    protected Destination dest = null;
    private boolean listenerReady = false;
    private ServerSocket ss;
    private final Object startLock = new Object();
    private boolean startRunning = false;
    private byte[] pubkey;
    private String handlerName;
    private Object conLock = new Object();
    private int _numConnectionBuilders;
    private int _maxWaitTime;
    private I2PSession _session;
    private Source _i2pSource;
    private Sink _i2pSink;
    private Destination _otherDest;

    public I2PTunnelUDPClientBase(String destination, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super("UDPServer", notifyThis, tunnel);
        byte[] key;
        this._clientId = ++__clientId;
        this.l = l;
        this._context = tunnel.getContext();
        tunnel.getClientOptions().setProperty("i2cp.dontPublishLeaseSet", "true");
        I2PClient client = I2PClientFactory.createClient();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(512);
            Destination destN = client.createDestination(out);
            key = out.toByteArray();
        }
        catch (Exception exc) {
            throw new RuntimeException("failed to create i2p-destination", exc);
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(key);
            this._session = client.createSession(in, tunnel.getClientOptions());
        }
        catch (Exception exc) {
            throw new RuntimeException("failed to create session", exc);
        }
        this._i2pSource = new I2PSource(this._session, false, true);
        if (destination != null && destination.length() > 0) {
            try {
                this._otherDest = I2PTunnel.destFromName(destination);
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
            if (this._otherDest == null) {
                l.log("Could not resolve " + destination);
                throw new RuntimeException("failed to create session - could not resolve " + destination);
            }
            this._i2pSink = new I2PSink(this._session, this._otherDest, false);
        } else {
            this._i2pSink = new I2PSinkAnywhere(this._session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRunning() {
        Object object = this.startLock;
        synchronized (object) {
            try {
                this._session.connect();
            }
            catch (I2PSessionException exc) {
                throw new RuntimeException("failed to connect session", exc);
            }
            this.start();
            this.startRunning = true;
            this.startLock.notify();
        }
        this.open = true;
    }

    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        if (this._session != null) {
            try {
                this._session.destroySession();
            }
            catch (I2PSessionException i2PSessionException) {
                // empty catch block
            }
        }
        this.l.log("Closing client " + this.toString());
        this.open = false;
        return true;
    }

    public void setSink(Sink s) {
        this._i2pSource.setSink(s);
    }

    public void start() {
        this._i2pSource.start();
    }

    public void send(Destination to, byte[] data) {
        this._i2pSink.send(to, data);
    }
}

