/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSUDPTunnel;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class SOCKS5Server
extends SOCKSServer {
    private static final Log _log = new Log(SOCKS5Server.class);
    private static final int SOCKS_VERSION_5 = 5;
    private Socket clientSock = null;
    private boolean setupCompleted = false;
    static SOCKSUDPTunnel _tunnel;
    static final Object _startLock;
    static byte[] dummyIP;

    public SOCKS5Server(Socket clientSock) {
        this.clientSock = clientSock;
    }

    public Socket getClientSocket() throws SOCKSException {
        this.setupServer();
        return this.clientSock;
    }

    protected void setupServer() throws SOCKSException {
        if (this.setupCompleted) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(this.clientSock.getInputStream());
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.init(in, out);
            if (this.manageRequest(in, out) == 3) {
                this.handleUDP(in, out);
            }
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        this.setupCompleted = true;
    }

    private void init(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int nMethods = in.readByte() & 0xFF;
        boolean methodOk = false;
        int method = 255;
        for (int i = 0; i < nMethods; ++i) {
            int meth = in.readByte() & 0xFF;
            if (meth != 0) continue;
            method = meth;
        }
        boolean canContinue = false;
        switch (method) {
            case 0: {
                _log.debug("no authentication required");
                this.sendInitReply(0, out);
                return;
            }
        }
        _log.debug("no suitable authentication methods found (" + Integer.toHexString(method) + ")");
        this.sendInitReply(255, out);
        throw new SOCKSException("Unsupported authentication method");
    }

    private int manageRequest(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int socksVer = in.readByte() & 0xFF;
        if (socksVer != 5) {
            _log.debug("error in SOCKS5 request (protocol != 5? wtf?)");
            throw new SOCKSException("Invalid protocol version in request: " + socksVer);
        }
        int command = in.readByte() & 0xFF;
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                _log.debug("BIND command is not supported!");
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("BIND command not supported");
            }
            case 3: {
                break;
            }
            default: {
                _log.debug("unknown command in request (" + Integer.toHexString(command) + ")");
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Invalid command in request");
            }
        }
        byte rsv = in.readByte();
        int addressType = in.readByte() & 0xFF;
        switch (addressType) {
            case 1: {
                this.connHostName = new String("");
                for (int i = 0; i < 4; ++i) {
                    int octet = in.readByte() & 0xFF;
                    this.connHostName = this.connHostName + Integer.toString(octet);
                    if (i == 3) continue;
                    this.connHostName = this.connHostName + ".";
                }
                if (command == 3) break;
                _log.warn("IPV4 address type in request: " + this.connHostName + ". Is your client secure?");
                break;
            }
            case 3: {
                int addrLen = in.readByte() & 0xFF;
                if (addrLen == 0) {
                    _log.debug("0-sized address length? wtf?");
                    throw new SOCKSException("Illegal DOMAINNAME length");
                }
                byte[] addr = new byte[addrLen];
                in.readFully(addr);
                this.connHostName = new String(addr);
                _log.debug("DOMAINNAME address type in request: " + this.connHostName);
                break;
            }
            case 4: {
                if (command == 3) break;
                _log.warn("IP V6 address type in request! Is your client secure? (IPv6 is not supported, anyway :-)");
                this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("IPV6 addresses not supported");
            }
            default: {
                _log.debug("unknown address type in request (" + Integer.toHexString(command) + ")");
                this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Invalid addresses type in request");
            }
        }
        this.connPort = in.readUnsignedShort();
        if (this.connPort == 0) {
            _log.debug("trying to connect to TCP port 0?  Dropping!");
            this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
            throw new SOCKSException("Invalid port number in request");
        }
        return command;
    }

    protected void confirmConnection() throws SOCKSException {
        try {
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.sendRequestReply(0, 1, InetAddress.getByName("127.0.0.1"), null, 1, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
    }

    private void sendInitReply(int replyCode, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        reps.write(5);
        reps.write(replyCode);
        byte[] reply = reps.toByteArray();
        if (_log.shouldLog(10)) {
            _log.debug("Sending init reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private void sendRequestReply(int replyCode, int addressType, InetAddress inetAddr, String domainName, int bindPort, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        DataOutputStream dreps = new DataOutputStream(reps);
        dreps.write(5);
        dreps.write(replyCode);
        dreps.write(0);
        dreps.write(addressType);
        switch (addressType) {
            case 1: {
                dreps.write(inetAddr.getAddress());
                break;
            }
            case 3: {
                dreps.writeByte(domainName.length());
                dreps.writeBytes(domainName);
                break;
            }
            default: {
                _log.error("unknown address type passed to sendReply() (" + Integer.toHexString(addressType) + ")! wtf?");
                return;
            }
        }
        dreps.writeShort(bindPort);
        byte[] reply = reps.toByteArray();
        if (_log.shouldLog(10)) {
            _log.debug("Sending request reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    public I2PSocket getDestinationI2PSocket(I2PSOCKSTunnel t) throws SOCKSException {
        I2PSocket destSock;
        DataOutputStream out;
        this.setupServer();
        if (this.connHostName == null) {
            _log.error("BUG: destination host name has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        if (this.connPort == 0) {
            _log.error("BUG: destination port has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        try {
            out = new DataOutputStream(this.clientSock.getOutputStream());
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        try {
            if (this.connHostName.toLowerCase().endsWith(".i2p")) {
                _log.debug("connecting to " + this.connHostName + "...");
                Destination dest = I2PTunnel.destFromName(this.connHostName);
                if (dest == null) {
                    try {
                        this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException("Host not found");
                }
                destSock = t.createI2PSocket(I2PTunnel.destFromName(this.connHostName));
            } else {
                if ("localhost".equals(this.connHostName) || "127.0.0.1".equals(this.connHostName)) {
                    String err = "No localhost accesses allowed through the Socks Proxy";
                    _log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                if (this.connPort == 80) {
                    String err = "No handler for HTTP outproxy implemented";
                    _log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                List<String> proxies = t.getProxies(this.connPort);
                if (proxies == null || proxies.isEmpty()) {
                    String err = "No outproxy configured for port " + this.connPort + " and no default configured either";
                    _log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                int p = I2PAppContext.getGlobalContext().random().nextInt(proxies.size());
                String proxy = proxies.get(p);
                _log.debug("connecting to port " + this.connPort + " proxy " + proxy + " for " + this.connHostName + "...");
                destSock = t.createI2PSocket(I2PTunnel.destFromName(proxy));
            }
            this.confirmConnection();
            _log.debug("connection confirmed - exchanging data...");
        }
        catch (DataFormatException e) {
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error in destination format");
        }
        catch (SocketException e) {
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        catch (I2PException e) {
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        return destSock;
    }

    /*
     * Exception decompiling
     */
    private void handleUDP(DataInputStream in, DataOutputStream out) throws SOCKSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        _startLock = new Object();
        dummyIP = new byte[4];
    }

    private static class Reply {
        private static final int SUCCEEDED = 0;
        private static final int GENERAL_SOCKS_SERVER_FAILURE = 1;
        private static final int CONNECTION_NOT_ALLOWED_BY_RULESET = 2;
        private static final int NETWORK_UNREACHABLE = 3;
        private static final int HOST_UNREACHABLE = 4;
        private static final int CONNECTION_REFUSED = 5;
        private static final int TTL_EXPIRED = 6;
        private static final int COMMAND_NOT_SUPPORTED = 7;
        private static final int ADDRESS_TYPE_NOT_SUPPORTED = 8;

        private Reply() {
        }
    }

    private static class Command {
        private static final int CONNECT = 1;
        private static final int BIND = 2;
        private static final int UDP_ASSOCIATE = 3;

        private Command() {
        }
    }

    private static class AddressType {
        private static final int IPV4 = 1;
        private static final int DOMAINNAME = 3;
        private static final int IPV6 = 4;

        private AddressType() {
        }
    }

    private static class Method {
        private static final int NO_AUTH_REQUIRED = 0;
        private static final int NO_ACCEPTABLE_METHODS = 255;

        private Method() {
        }
    }
}

