/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataFormatException;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class SOCKS4aServer
extends SOCKSServer {
    private static final Log _log = new Log(SOCKS4aServer.class);
    private Socket clientSock = null;
    private boolean setupCompleted = false;

    public SOCKS4aServer(Socket clientSock) {
        this.clientSock = clientSock;
    }

    public Socket getClientSocket() throws SOCKSException {
        this.setupServer();
        return this.clientSock;
    }

    protected void setupServer() throws SOCKSException {
        if (this.setupCompleted) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(this.clientSock.getInputStream());
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.manageRequest(in, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        this.setupCompleted = true;
    }

    private void manageRequest(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int command = in.readByte() & 0xFF;
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                _log.debug("BIND command is not supported!");
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                throw new SOCKSException("BIND command not supported");
            }
            default: {
                _log.debug("unknown command in request (" + Integer.toHexString(command) + ")");
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                throw new SOCKSException("Invalid command in request");
            }
        }
        this.connPort = in.readUnsignedShort();
        if (this.connPort == 0) {
            _log.debug("trying to connect to TCP port 0?  Dropping!");
            this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            throw new SOCKSException("Invalid port number in request");
        }
        this.connHostName = new String("");
        boolean alreadyWarned = false;
        for (int i = 0; i < 4; ++i) {
            int octet = in.readByte() & 0xFF;
            this.connHostName = this.connHostName + Integer.toString(octet);
            if (i == 3) continue;
            this.connHostName = this.connHostName + ".";
            if (octet == 0 || alreadyWarned) continue;
            _log.warn("IPV4 address type in request: " + this.connHostName + ". Is your client secure?");
            alreadyWarned = true;
        }
        this.readString(in);
        if (this.connHostName.startsWith("0.0.0.") && !this.connHostName.equals("0.0.0.0")) {
            this.connHostName = this.readString(in);
        }
    }

    private String readString(DataInputStream in) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder(16);
        while ((c = (char)(in.readByte() & 0xFF)) != '\u0000') {
            sb.append(c);
        }
        return sb.toString();
    }

    protected void confirmConnection() throws SOCKSException {
        try {
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.sendRequestReply(90, InetAddress.getByName("127.0.0.1"), 1, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
    }

    private void sendRequestReply(int replyCode, InetAddress inetAddr, int bindPort, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        DataOutputStream dreps = new DataOutputStream(reps);
        dreps.write(0);
        dreps.write(replyCode);
        dreps.writeShort(bindPort);
        dreps.write(inetAddr.getAddress());
        byte[] reply = reps.toByteArray();
        if (_log.shouldLog(10)) {
            _log.debug("Sending request reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    public I2PSocket getDestinationI2PSocket(I2PSOCKSTunnel t) throws SOCKSException {
        I2PSocket destSock;
        DataOutputStream out;
        this.setupServer();
        if (this.connHostName == null) {
            _log.error("BUG: destination host name has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        if (this.connPort == 0) {
            _log.error("BUG: destination port has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        try {
            out = new DataOutputStream(this.clientSock.getOutputStream());
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        try {
            if (this.connHostName.toLowerCase().endsWith(".i2p") || this.connHostName.toLowerCase().endsWith(".onion")) {
                _log.debug("connecting to " + this.connHostName + "...");
                destSock = t.createI2PSocket(I2PTunnel.destFromName(this.connHostName));
            } else {
                if ("localhost".equals(this.connHostName) || "127.0.0.1".equals(this.connHostName)) {
                    String err = "No localhost accesses allowed through the Socks Proxy";
                    _log.error(err);
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                if (this.connPort == 80) {
                    String err = "No handler for HTTP outproxy implemented - to: " + this.connHostName;
                    _log.error(err);
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                List<String> proxies = t.getProxies(this.connPort);
                if (proxies == null || proxies.isEmpty()) {
                    String err = "No outproxy configured for port " + this.connPort + " and no default configured either - host: " + this.connHostName;
                    _log.error(err);
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                int p = I2PAppContext.getGlobalContext().random().nextInt(proxies.size());
                String proxy = proxies.get(p);
                _log.debug("connecting to port " + this.connPort + " proxy " + proxy + " for " + this.connHostName + "...");
                destSock = t.createI2PSocket(I2PTunnel.destFromName(proxy));
            }
            this.confirmConnection();
            _log.debug("connection confirmed - exchanging data...");
        }
        catch (DataFormatException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error in destination format");
        }
        catch (SocketException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        catch (I2PException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        return destSock;
    }

    private static class Reply {
        private static final int SUCCEEDED = 90;
        private static final int CONNECTION_REFUSED = 91;

        private Reply() {
        }
    }

    private static class Command {
        private static final int CONNECT = 1;
        private static final int BIND = 2;

        private Command() {
        }
    }
}

