/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSServerFactory;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PSOCKSTunnel
extends I2PTunnelClientBase {
    private static final Log _log = new Log(I2PSOCKSTunnel.class);
    private HashMap<String, List<String>> proxies = null;
    protected Destination outProxyDest = null;
    private static final String PROP_PROXY = "i2ptunnel.socks.proxy.";

    public I2PSOCKSTunnel(int localPort, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) {
        super(localPort, ownDest, l, notifyThis, "SOCKSHandler", tunnel, pkf);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openSOCKSTunnelResult", "error");
            return;
        }
        this.setName(this.getLocalPort() + " -> SOCKSTunnel");
        this.parseOptions();
        this.startRunning();
        this.notifyEvent("openSOCKSTunnelResult", "ok");
    }

    @Override
    protected void clientConnectionRun(Socket s) {
        try {
            SOCKSServer serv = SOCKSServerFactory.createSOCKSServer(s);
            Socket clientSock = serv.getClientSocket();
            I2PSocket destSock = serv.getDestinationI2PSocket(this);
            new I2PTunnelRunner(clientSock, destSock, this.sockLock, null, this.mySockets);
        }
        catch (SOCKSException e) {
            _log.error("Error from SOCKS connection", e);
            I2PSOCKSTunnel.closeSocket(s);
        }
    }

    private void parseOptions() {
        Properties opts = this.getTunnel().getClientOptions();
        this.proxies = new HashMap(0);
        for (Map.Entry<Object, Object> e : opts.entrySet()) {
            String prop = (String)e.getKey();
            if (!prop.startsWith(PROP_PROXY) || prop.length() <= PROP_PROXY.length()) continue;
            String port = prop.substring(PROP_PROXY.length());
            ArrayList<String> proxyList = new ArrayList<String>(1);
            StringTokenizer tok = new StringTokenizer((String)e.getValue(), ", \t");
            while (tok.hasMoreTokens()) {
                String proxy = tok.nextToken().trim();
                if (proxy.endsWith(".i2p")) {
                    proxyList.add(proxy);
                    continue;
                }
                _log.error("Non-i2p SOCKS outproxy: " + proxy);
            }
            this.proxies.put(port, proxyList);
        }
    }

    public HashMap<String, List<String>> getProxyMap() {
        return this.proxies;
    }

    public List<String> getProxies(int port) {
        List<String> rv = this.proxies.get(port + "");
        if (rv == null) {
            rv = this.getDefaultProxies();
        }
        return rv;
    }

    public List<String> getDefaultProxies() {
        return this.proxies.get("default");
    }
}

