/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelControllerGroup {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(TunnelControllerGroup.class);
    private static TunnelControllerGroup _instance;
    static final String DEFAULT_CONFIG_FILE = "i2ptunnel.config";
    private final List<TunnelController> _controllers = Collections.synchronizedList(new ArrayList());
    private String _configFile = "i2ptunnel.config";
    private final Map<I2PSession, Set<TunnelController>> _sessions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TunnelControllerGroup getInstance() {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                _instance = new TunnelControllerGroup(DEFAULT_CONFIG_FILE);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private TunnelControllerGroup(String configFile) {
        this._configFile = configFile;
        this._sessions = new HashMap<I2PSession, Set<TunnelController>>(4);
        this.loadControllers(this._configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (args == null || args.length <= 0) {
                _instance = new TunnelControllerGroup(DEFAULT_CONFIG_FILE);
            } else if (args.length == 1) {
                _instance = new TunnelControllerGroup(args[0]);
            } else {
                System.err.println("Usage: TunnelControllerGroup [filename]");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void loadControllers(String configFile) {
        String type;
        Properties cfg = this.loadConfig(configFile);
        if (cfg == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the config from " + configFile);
            }
            return;
        }
        int i = 0;
        while ((type = cfg.getProperty("tunnel." + i + ".type")) != null) {
            TunnelController controller = new TunnelController(cfg, "tunnel." + i + ".");
            this._controllers.add(controller);
            ++i;
        }
        I2PAppThread startupThread = new I2PAppThread(new StartControllers(), "Startup tunnels");
        startupThread.start();
        if (this._log.shouldLog(20)) {
            this._log.info(i + " controllers loaded from " + configFile);
        }
    }

    public void reloadControllers() {
        this.unloadControllers();
        this.loadControllers(this._configFile);
    }

    public void unloadControllers() {
        this.stopAllControllers();
        this._controllers.clear();
        if (this._log.shouldLog(20)) {
            this._log.info("All controllers stopped and unloaded");
        }
    }

    public void addController(TunnelController controller) {
        this._controllers.add(controller);
    }

    public List<String> removeController(TunnelController controller) {
        if (controller == null) {
            return new ArrayList<String>();
        }
        controller.stopTunnel();
        List<String> msgs = controller.clearMessages();
        this._controllers.remove(controller);
        msgs.add("Tunnel " + controller.getName() + " removed");
        return msgs;
    }

    public List<String> stopAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.stopTunnel();
            msgs.addAll(controller.clearMessages());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers stopped");
        }
        return msgs;
    }

    public List<String> startAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.startTunnelBackground();
            msgs.addAll(controller.clearMessages());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers started");
        }
        return msgs;
    }

    public List<String> restartAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.restartTunnel();
            msgs.addAll(controller.clearMessages());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers restarted");
        }
        return msgs;
    }

    public List<String> clearAllMessages() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            msgs.addAll(controller.clearMessages());
        }
        return msgs;
    }

    public void saveConfig() {
        this.saveConfig(this._configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveConfig(String configFile) {
        SecureFileOutputStream fos;
        block12: {
            File parent;
            this._configFile = configFile;
            File cfgFile = new File(configFile);
            if (!cfgFile.isAbsolute()) {
                cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), configFile);
            }
            if ((parent = cfgFile.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            TreeMap<Object, Object> map = new TreeMap<Object, Object>();
            for (int i = 0; i < this._controllers.size(); ++i) {
                TunnelController controller = this._controllers.get(i);
                Properties cur = controller.getConfig("tunnel." + i + ".");
                map.putAll(cur);
            }
            StringBuilder buf = new StringBuilder(1024);
            for (String key : map.keySet()) {
                String val = (String)map.get(key);
                buf.append(key).append('=').append(val).append('\n');
            }
            fos = null;
            fos = new SecureFileOutputStream(cfgFile);
            fos.write(buf.toString().getBytes("UTF-8"));
            if (!this._log.shouldLog(20)) break block12;
            this._log.info("Config written to " + cfgFile.getPath());
        }
        Object var10_11 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                this._log.error("Error writing out the config");
                Object var10_12 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private Properties loadConfig(String configFile) {
        File cfgFile = new File(configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), configFile);
        }
        if (!cfgFile.exists()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Unable to load the controllers from " + cfgFile.getAbsolutePath());
            }
            return null;
        }
        Properties props = new Properties();
        try {
            DataHelper.loadProps(props, cfgFile);
            return props;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the controllers from " + cfgFile.getAbsolutePath(), ioe);
            }
            return null;
        }
    }

    public List<TunnelController> getControllers() {
        return this._controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(TunnelController controller, I2PSession session) {
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners == null) {
                owners = new HashSet<TunnelController>(1);
                this._sessions.put(session, owners);
            }
            owners.add(controller);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Acquiring session " + session + " for " + controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(TunnelController controller, I2PSession session) {
        boolean shouldClose = false;
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners != null) {
                owners.remove(controller);
                if (owners.isEmpty()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("After releasing session " + session + " by " + controller + ", no more owners remain");
                    }
                    shouldClose = true;
                    this._sessions.remove(session);
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("After releasing session " + session + " by " + controller + ", " + owners.size() + " owners remain");
                    }
                    shouldClose = false;
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("After releasing session " + session + " by " + controller + ", no owners were even known?!");
                }
                shouldClose = true;
            }
        }
        if (shouldClose) {
            try {
                session.destroySession();
                if (this._log.shouldLog(20)) {
                    this._log.info("Session destroyed: " + session);
                }
            }
            catch (I2PSessionException ise) {
                this._log.error("Error closing the client session", ise);
            }
        }
    }

    private class StartControllers
    implements Runnable {
        private StartControllers() {
        }

        public void run() {
            for (int i = 0; i < TunnelControllerGroup.this._controllers.size(); ++i) {
                TunnelController controller = (TunnelController)TunnelControllerGroup.this._controllers.get(i);
                if (!controller.getStartOnLoad()) continue;
                controller.startTunnel();
            }
        }
    }
}

