/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.util.I2PAppThread;
import net.i2p.util.InternalServerSocket;
import net.i2p.util.Log;

class InternalSocketRunner
implements Runnable {
    private I2PTunnelClientBase client;
    private int port;
    private ServerSocket ss;
    private boolean open;
    private static final Log _log = new Log(InternalSocketRunner.class);

    InternalSocketRunner(I2PTunnelClientBase client) {
        this.client = client;
        this.port = client.getLocalPort();
        I2PAppThread t = new I2PAppThread(this, "Internal socket port " + this.port, true);
        t.start();
    }

    public final void run() {
        try {
            this.ss = new InternalServerSocket(this.port);
            this.open = true;
            while (true) {
                Socket s = this.ss.accept();
                this.client.manageConnection(s);
            }
        }
        catch (IOException ex) {
            if (this.open) {
                _log.error("Error listening for internal connections on " + this.port, ex);
            }
            this.open = false;
            return;
        }
    }

    void stopRunning() {
        if (this.open) {
            try {
                this.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.open = false;
        }
    }
}

