/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClient;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class I2Ping
extends I2PTunnelTask
implements Runnable {
    private static final Log _log = new Log(I2Ping.class);
    private int PING_COUNT = 3;
    private static final int CPING_COUNT = 5;
    private static final int PING_TIMEOUT = 5000;
    private static final long PING_DISTANCE = 1000L;
    private int MAX_SIMUL_PINGS = 10;
    private boolean countPing = false;
    private boolean reportTimes = true;
    private I2PSocketManager sockMgr;
    private Logging l;
    private boolean finished = false;
    private String command;
    private long timeout = 5000L;
    private final Object simulLock = new Object();
    private int simulPings = 0;
    private long lastPingTime = 0L;
    private final Object lock = new Object();
    private final Object slock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2Ping(String cmd, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("I2Ping [" + cmd + "]", notifyThis, tunnel);
        this.l = l;
        this.command = cmd;
        Object object = this.slock;
        synchronized (object) {
            this.sockMgr = ownDest ? I2PTunnelClient.buildSocketManager(tunnel) : I2PTunnelClient.getSocketManager(tunnel);
        }
        I2PAppThread t = new I2PAppThread(this);
        t.setName("Client");
        t.start();
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.l.log("*** I2Ping results:");
        try {
            this.runCommand(this.command);
        }
        catch (InterruptedException ex) {
            this.l.log("*** Interrupted");
            _log.error("Pinger interrupted", ex);
        }
        catch (IOException ex) {
            _log.error("Pinger exception", ex);
        }
        this.l.log("*** Finished.");
        Object object = this.lock;
        synchronized (object) {
            this.finished = true;
        }
        this.close(false);
    }

    public void runCommand(String cmd) throws InterruptedException, IOException {
        while (true) {
            int pos;
            if (cmd.startsWith("-t ")) {
                pos = (cmd = cmd.substring(3)).indexOf(" ");
                if (pos == -1) {
                    this.l.log("Syntax error");
                    return;
                }
                this.timeout = Long.parseLong(cmd.substring(0, pos));
                cmd = cmd.substring(pos + 1);
                continue;
            }
            if (cmd.startsWith("-m ")) {
                pos = (cmd = cmd.substring(3)).indexOf(" ");
                if (pos == -1) {
                    this.l.log("Syntax error");
                    return;
                }
                this.MAX_SIMUL_PINGS = Integer.parseInt(cmd.substring(0, pos));
                cmd = cmd.substring(pos + 1);
                continue;
            }
            if (cmd.startsWith("-n ")) {
                pos = (cmd = cmd.substring(3)).indexOf(" ");
                if (pos == -1) {
                    this.l.log("Syntax error");
                    return;
                }
                this.PING_COUNT = Integer.parseInt(cmd.substring(0, pos));
                cmd = cmd.substring(pos + 1);
                continue;
            }
            if (cmd.startsWith("-c ")) {
                this.countPing = true;
                cmd = cmd.substring(3);
                continue;
            }
            if (!cmd.equals("-h")) break;
            cmd = "-l hosts.txt";
        }
        if (cmd.startsWith("-l ")) {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(cmd.substring(3)));
            ArrayList<PingHandler> pingHandlers = new ArrayList<PingHandler>();
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith(";") || line.startsWith("!")) continue;
                if (line.indexOf("=") != -1) {
                    line = line.substring(0, line.indexOf("="));
                }
                pingHandlers.add(new PingHandler(line));
                if (++i <= 1) continue;
                this.reportTimes = false;
            }
            br.close();
            for (Thread thread : pingHandlers) {
                thread.join();
            }
            return;
        }
        PingHandler t = new PingHandler(cmd);
        t.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!forced && !this.finished) {
                this.l.log("There are still pings running!");
                return false;
            }
            this.l.log("Closing pinger " + this.toString());
            this.l.log("Pinger closed.");
            this.open = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(Destination dest) throws I2PException {
        try {
            Object object = this.simulLock;
            synchronized (object) {
                while (this.simulPings >= this.MAX_SIMUL_PINGS) {
                    this.simulLock.wait();
                }
                ++this.simulPings;
                while (this.lastPingTime + 1000L > System.currentTimeMillis()) {
                    Thread.sleep(500L);
                }
                this.lastPingTime = System.currentTimeMillis();
            }
            boolean sent = this.sockMgr.ping(dest, this.timeout);
            Object object2 = this.simulLock;
            synchronized (object2) {
                --this.simulPings;
                this.simulLock.notifyAll();
            }
            return sent;
        }
        catch (InterruptedException ex) {
            _log.error("Interrupted", ex);
            return false;
        }
    }

    public class PingHandler
    extends I2PAppThread {
        private String destination;

        public PingHandler(String dest) {
            this.destination = dest;
            this.setName("PingHandler for " + dest);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Destination dest = I2PTunnel.destFromName(this.destination);
                if (dest == null) {
                    Object object = I2Ping.this.lock;
                    synchronized (object) {
                        I2Ping.this.l.log("Unresolvable: " + this.destination + "");
                    }
                    return;
                }
                int pass = 0;
                int fail = 0;
                long totalTime = 0L;
                int cnt = I2Ping.this.countPing ? 5 : I2Ping.this.PING_COUNT;
                StringBuilder pingResults = new StringBuilder(2 * cnt + this.destination.length() + 3);
                for (int i = 0; i < cnt; ++i) {
                    boolean sent = I2Ping.this.ping(dest);
                    if (I2Ping.this.countPing) {
                        if (!sent) {
                            pingResults.append(i).append(" ");
                            break;
                        }
                        if (i != cnt - 1) continue;
                        pingResults.append("+ ");
                        continue;
                    }
                    if (I2Ping.this.reportTimes) {
                        if (sent) {
                            ++pass;
                            long rtt = System.currentTimeMillis() - I2Ping.this.lastPingTime;
                            totalTime += rtt;
                            I2Ping.this.l.log(i + 1 + ": + " + rtt + " ms");
                            continue;
                        }
                        ++fail;
                        I2Ping.this.l.log(i + 1 + ": -");
                        continue;
                    }
                    pingResults.append(sent ? "+ " : "- ");
                }
                if (I2Ping.this.reportTimes) {
                    pingResults.append("  ").append(pass).append(" received ");
                    if (pass > 0) {
                        pingResults.append("(average time ").append(totalTime / (long)pass).append(" ms) ");
                    }
                    pingResults.append("and ").append(fail).append(" lost for destination: ");
                }
                pingResults.append("  ").append(this.destination);
                Object object = I2Ping.this.lock;
                synchronized (object) {
                    I2Ping.this.l.log(pingResults.toString());
                }
            }
            catch (I2PException ex) {
                _log.error("Error pinging " + this.destination, ex);
            }
        }
    }
}

