/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base32;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class I2PTunnelIRCServer
extends I2PTunnelServer
implements Runnable {
    public static final String PROP_METHOD = "ircserver.method";
    public static final String PROP_METHOD_DEFAULT = "user";
    public static final String PROP_CLOAK = "ircserver.cloakKey";
    public static final String PROP_WEBIRC_PASSWORD = "ircserver.webircPassword";
    public static final String PROP_WEBIRC_SPOOF_IP = "ircserver.webircSpoofIP";
    public static final String PROP_WEBIRC_SPOOF_IP_DEFAULT = "127.0.0.1";
    public static final String PROP_HOSTNAME = "ircserver.fakeHostname";
    public static final String PROP_HOSTNAME_DEFAULT = "%f.b32.i2p";
    private static final Log _log = new Log(I2PTunnelIRCServer.class);
    private byte[] cloakKey;
    private String hostname;
    private String method;
    private String webircPassword;
    private String webircSpoofIP;

    public I2PTunnelIRCServer(InetAddress host, int port, File privkey, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privkey, privkeyname, l, notifyThis, tunnel);
        this.initCloak(tunnel);
    }

    private void initCloak(I2PTunnel tunnel) {
        Properties opts = tunnel.getClientOptions();
        this.method = opts.getProperty(PROP_METHOD, PROP_METHOD_DEFAULT);
        assert (this.method != null);
        this.webircPassword = opts.getProperty(PROP_WEBIRC_PASSWORD);
        this.webircSpoofIP = opts.getProperty(PROP_WEBIRC_SPOOF_IP, PROP_WEBIRC_SPOOF_IP_DEFAULT);
        String passphrase = opts.getProperty(PROP_CLOAK);
        if (passphrase == null) {
            this.cloakKey = new byte[32];
            tunnel.getContext().random().nextBytes(this.cloakKey);
        } else {
            this.cloakKey = SHA256Generator.getInstance().calculateHash(passphrase.trim().getBytes()).getData();
        }
        this.hostname = opts.getProperty(PROP_HOSTNAME, PROP_HOSTNAME_DEFAULT);
    }

    protected void blockingHandle(I2PSocket socket) {
        block14: {
            try {
                String modifiedRegistration;
                if (!this.method.equals("webirc")) {
                    socket.setReadTimeout(15000L);
                    InputStream in = socket.getInputStream();
                    modifiedRegistration = I2PTunnelIRCServer.filterRegistration(in, this.cloakDest(socket.getPeerDestination()));
                    socket.setReadTimeout(this.readTimeout);
                } else {
                    StringBuffer buf = new StringBuffer("WEBIRC ");
                    buf.append(this.webircPassword);
                    buf.append(" cgiirc ");
                    buf.append(this.cloakDest(socket.getPeerDestination()));
                    buf.append(' ');
                    buf.append(this.webircSpoofIP);
                    buf.append("\r\n");
                    modifiedRegistration = buf.toString();
                }
                Socket s = new Socket(this.remoteHost, this.remotePort);
                new I2PTunnelRunner(s, socket, this.slock, null, modifiedRegistration.getBytes(), null);
            }
            catch (SocketException ex) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    if (_log.shouldLog(40)) {
                        _log.error("Error while closing the received i2p con", ex);
                    }
                }
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (_log.shouldLog(30)) {
                    _log.warn("Error while receiving the new IRC Connection", ex);
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!_log.shouldLog(40)) break block14;
                _log.error("OOM in IRC server", oom);
            }
        }
    }

    String cloakDest(Destination d) {
        byte[] b = new byte[d.size() + this.cloakKey.length];
        System.arraycopy(b, 0, d.toByteArray(), 0, d.size());
        System.arraycopy(b, d.size(), this.cloakKey, 0, this.cloakKey.length);
        String hc = Base32.encode(SHA256Generator.getInstance().calculateHash(b).getData());
        String hf = Base32.encode(d.calculateHash().getData());
        return this.hostname.replace("%f", hf).replace("%c", hc);
    }

    private static String filterRegistration(InputStream in, String newHostname) throws IOException {
        String command;
        StringBuilder buf = new StringBuilder(128);
        int lineCount = 0;
        do {
            String s;
            if ((s = DataHelper.readLine(in)) == null) {
                throw new IOException("EOF reached before the end of the headers [" + buf.toString() + "]");
            }
            if (++lineCount > 10) {
                throw new IOException("Too many lines before USER or SERVER, giving up");
            }
            s = s.trim();
            if (_log.shouldLog(10)) {
                _log.debug("Got line: " + s);
            }
            String[] field = s.split(" ", 5);
            int idx = 0;
            if (field[0].charAt(0) == ':') {
                ++idx;
            }
            try {
                command = field[idx++];
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new IOException("Dropping defective message: index out of bounds while extracting command.");
            }
            if ("USER".equalsIgnoreCase(command)) {
                if (field.length < idx + 4) {
                    throw new IOException("Too few parameters in USER message: " + s);
                }
                buf.append("USER ").append(field[idx]).append(' ').append(newHostname);
                buf.append(' ');
                buf.append(field[idx + 2]).append(' ').append(field[idx + 3]).append("\r\n");
                break;
            }
            buf.append(s).append("\r\n");
        } while (!"SERVER".equalsIgnoreCase(command));
        if (_log.shouldLog(10)) {
            _log.debug("All done, sending: " + buf.toString());
        }
        return buf.toString();
    }
}

