/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class I2PTunnelIRCClient
extends I2PTunnelClientBase
implements Runnable {
    private static final Log _log = new Log(I2PTunnelIRCClient.class);
    private static volatile long __clientId = 0L;
    protected List<Destination> dests;
    private static final long DEFAULT_READ_TIMEOUT = 300000L;
    protected long readTimeout = 300000L;

    public I2PTunnelIRCClient(int localPort, String destinations, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "IRCHandler " + ++__clientId, tunnel, pkf);
        StringTokenizer tok = new StringTokenizer(destinations, ", ");
        this.dests = new ArrayList<Destination>(2);
        while (tok.hasMoreTokens()) {
            String destination = tok.nextToken();
            try {
                Destination destN = I2PTunnel.destFromName(destination);
                if (destN == null) {
                    l.log("Could not resolve " + destination);
                    continue;
                }
                this.dests.add(destN);
            }
            catch (DataFormatException dfe) {
                l.log("Bad format parsing \"" + destination + "\"");
            }
        }
        if (this.dests.isEmpty()) {
            l.log("No target destinations found");
            this.notifyEvent("openClientResult", "error");
            throw new IllegalArgumentException("No valid target destinations found");
        }
        this.setName(this.getLocalPort() + " -> IRCClient");
        this.startRunning();
        this.notifyEvent("openIRCClientResult", "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientConnectionRun(Socket s) {
        block7: {
            if (_log.shouldLog(10)) {
                _log.debug("got a connection.");
            }
            Destination clientDest = this.pickDestination();
            I2PSocket i2ps = null;
            try {
                i2ps = this.createI2PSocket(clientDest);
                i2ps.setReadTimeout(this.readTimeout);
                StringBuffer expectedPong = new StringBuffer();
                I2PAppThread in = new I2PAppThread(new IrcInboundFilter(s, i2ps, expectedPong), "IRC Client " + __clientId + " in", true);
                in.start();
                I2PAppThread out = new I2PAppThread(new IrcOutboundFilter(s, i2ps, expectedPong), "IRC Client " + __clientId + " out", true);
                out.start();
            }
            catch (Exception ex) {
                if (_log.shouldLog(40)) {
                    _log.error("Error connecting", ex);
                }
                I2PTunnelIRCClient.closeSocket(s);
                if (i2ps == null) break block7;
                Object object = this.sockLock;
                synchronized (object) {
                    this.mySockets.remove(this.sockLock);
                }
            }
        }
    }

    private final Destination pickDestination() {
        int size = this.dests.size();
        if (size <= 0) {
            if (_log.shouldLog(40)) {
                _log.error("No client targets?!");
            }
            return null;
        }
        if (size == 1) {
            return this.dests.get(0);
        }
        int index = this._context.random().nextInt(size);
        return this.dests.get(index);
    }

    public static String inboundFilter(String s, StringBuffer expectedPong) {
        String command;
        String[] field = s.split(" ", 4);
        int idx = 0;
        String[] allowedCommands = new String[]{"MODE", "JOIN", "NICK", "QUIT", "PART", "WALLOPS", "ERROR", "KICK", "H", "TOPIC"};
        if (field[0].charAt(0) == ':') {
            ++idx;
        }
        try {
            command = field[idx++];
        }
        catch (IndexOutOfBoundsException ioobe) {
            _log.warn("Dropping defective message: index out of bounds while extracting command.");
            return null;
        }
        ++idx;
        try {
            new Integer(command);
            return s;
        }
        catch (NumberFormatException nfe) {
            if ("PING".equalsIgnoreCase(command)) {
                return "PING 127.0.0.1";
            }
            if ("PONG".equalsIgnoreCase(command)) {
                String pong = expectedPong.length() > 0 ? expectedPong.toString() : s;
                expectedPong.setLength(0);
                return pong;
            }
            for (int i = 0; i < allowedCommands.length; ++i) {
                if (!allowedCommands[i].equalsIgnoreCase(command)) continue;
                return s;
            }
            if ("PRIVMSG".equalsIgnoreCase(command) || "NOTICE".equalsIgnoreCase(command)) {
                String msg;
                if ((msg = field[idx++]).indexOf(1) >= 0) {
                    if ((msg = msg.substring(2)).startsWith("ACTION ")) {
                        return s;
                    }
                    return null;
                }
                return s;
            }
            return null;
        }
    }

    public static String outboundFilter(String s, StringBuffer expectedPong) {
        String msg;
        String[] field = s.split(" ", 3);
        String[] allowedCommands = new String[]{"MODE", "JOIN", "NICK", "WHO", "WHOIS", "LIST", "NAMES", "NICK", "SILENCE", "MAP", "OPER", "KICK", "HELPME", "RULES", "TOPIC", "ISON"};
        if (field[0].length() == 0) {
            return null;
        }
        if (field[0].charAt(0) == ':') {
            return null;
        }
        String command = field[0].toUpperCase();
        if ("PING".equals(command)) {
            String rv = null;
            expectedPong.setLength(0);
            if (field.length == 1) {
                rv = "PING";
            } else if (field.length == 2) {
                rv = "PING " + field[1];
            } else if (field.length == 3) {
                rv = "PING " + field[1];
                expectedPong.append("PONG ").append(field[2]).append(" :").append(field[1]);
            } else {
                if (_log.shouldLog(40)) {
                    _log.error("IRC client sent a PING we don't understand, filtering it (\"" + s + "\")");
                }
                rv = null;
            }
            if (_log.shouldLog(30)) {
                _log.warn("sending ping [" + rv + "], waiting for [" + expectedPong + "] orig was [" + s + "]");
            }
            return rv;
        }
        if ("PONG".equals(command)) {
            return "PONG 127.0.0.1";
        }
        for (int i = 0; i < allowedCommands.length; ++i) {
            if (!allowedCommands[i].equals(command)) continue;
            return s;
        }
        if ("NOTICE".equals(command) && (msg = field[2]).startsWith(":DCC ")) {
            return null;
        }
        if ("PRIVMSG".equals(command) || "NOTICE".equals(command)) {
            msg = field[2];
            if (msg.indexOf(1) >= 0) {
                if ((msg = msg.substring(2)).startsWith("ACTION ")) {
                    return s;
                }
                return null;
            }
            return s;
        }
        if ("USER".equals(command)) {
            int idx = field[2].lastIndexOf(":");
            if (idx < 0) {
                return "USER user hostname localhost :realname";
            }
            String realname = field[2].substring(idx + 1);
            String ret = "USER " + field[1] + " hostname localhost :" + realname;
            return ret;
        }
        if ("PART".equals(command)) {
            return "PART " + field[1] + " :leaving";
        }
        if ("QUIT".equals(command)) {
            return "QUIT :leaving";
        }
        return null;
    }

    static /* synthetic */ Log access$000() {
        return _log;
    }

    public static class IrcOutboundFilter
    implements Runnable {
        private Socket local;
        private I2PSocket remote;
        private StringBuffer expectedPong;

        public IrcOutboundFilter(Socket _local, I2PSocket _remote, StringBuffer pong) {
            this.local = _local;
            this.remote = _remote;
            this.expectedPong = pong;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block25: {
                block24: {
                    try {
                        in = new BufferedReader(new InputStreamReader(this.local.getInputStream(), "ISO-8859-1"));
                        output = this.remote.getOutputStream();
                    }
                    catch (IOException e) {
                        if (I2PTunnelIRCClient.access$000().shouldLog(40) == false) return;
                        I2PTunnelIRCClient.access$000().error("IrcOutboundFilter: no streams", e);
                        return;
                    }
                    if (I2PTunnelIRCClient.access$000().shouldLog(10)) {
                        I2PTunnelIRCClient.access$000().debug("IrcOutboundFilter: Running.");
                    }
                    try {
                        try {
                            try {}
                            catch (IOException e1) {
                                if (!I2PTunnelIRCClient.access$000().shouldLog(30)) break block24;
                                I2PTunnelIRCClient.access$000().warn("IrcOutboundFilter: disconnected", e1);
                                break block24;
                            }
                        }
                        catch (RuntimeException re) {
                            I2PTunnelIRCClient.access$000().error("Error filtering outbound data", re);
                            var6_9 = null;
                            if (this.remote != null) {
                                try {
                                    this.remote.close();
                                }
                                catch (IOException e) {}
                            }
                            break block25;
                        }
                    }
                    catch (Throwable var5_14) {
                        var6_10 = null;
                        if (this.remote == null) throw var5_14;
                        ** try [egrp 4[TRYBLOCK] [7 : 425->437)] { 
lbl35:
                        // 1 sources

                        this.remote.close();
                        throw var5_14;
lbl37:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var5_14;
                    }
                    while ((inmsg = in.readLine()) != null) {
                        if (inmsg.endsWith("\r")) {
                            inmsg = inmsg.substring(0, inmsg.length() - 1);
                        }
                        if (I2PTunnelIRCClient.access$000().shouldLog(10)) {
                            I2PTunnelIRCClient.access$000().debug("out: [" + inmsg + "]");
                        }
                        if ((outmsg = I2PTunnelIRCClient.outboundFilter(inmsg, this.expectedPong)) != null) {
                            if (!inmsg.equals(outmsg)) {
                                if (I2PTunnelIRCClient.access$000().shouldLog(30)) {
                                    I2PTunnelIRCClient.access$000().warn("outbound FILTERED: " + outmsg);
                                    I2PTunnelIRCClient.access$000().warn(" - outbound was: " + inmsg);
                                }
                            } else if (I2PTunnelIRCClient.access$000().shouldLog(20)) {
                                I2PTunnelIRCClient.access$000().info("outbound: " + outmsg);
                            }
                            outmsg = outmsg + "\r\n";
                            output.write(outmsg.getBytes("ISO-8859-1"));
                            output.flush();
                            continue;
                        }
                        if (!I2PTunnelIRCClient.access$000().shouldLog(30)) continue;
                        I2PTunnelIRCClient.access$000().warn("outbound BLOCKED: \"" + inmsg + "\"");
                    }
                }
                var6_8 = null;
                if (this.remote != null) {
                    try {}
                    catch (IOException e) {}
                    this.remote.close();
                }
            }
            if (I2PTunnelIRCClient.access$000().shouldLog(10) == false) return;
            I2PTunnelIRCClient.access$000().debug("IrcOutboundFilter: Done.");
        }
    }

    public static class IrcInboundFilter
    implements Runnable {
        private Socket local;
        private I2PSocket remote;
        private StringBuffer expectedPong;

        public IrcInboundFilter(Socket _local, I2PSocket _remote, StringBuffer pong) {
            this.local = _local;
            this.remote = _remote;
            this.expectedPong = pong;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block25: {
                block24: {
                    try {
                        in = new BufferedReader(new InputStreamReader(this.remote.getInputStream(), "ISO-8859-1"));
                        output = this.local.getOutputStream();
                    }
                    catch (IOException e) {
                        if (I2PTunnelIRCClient.access$000().shouldLog(40) == false) return;
                        I2PTunnelIRCClient.access$000().error("IrcInboundFilter: no streams", e);
                        return;
                    }
                    if (I2PTunnelIRCClient.access$000().shouldLog(10)) {
                        I2PTunnelIRCClient.access$000().debug("IrcInboundFilter: Running.");
                    }
                    try {
                        try {
                            try {}
                            catch (IOException e1) {
                                if (!I2PTunnelIRCClient.access$000().shouldLog(30)) break block24;
                                I2PTunnelIRCClient.access$000().warn("IrcInboundFilter: disconnected", e1);
                                break block24;
                            }
                        }
                        catch (RuntimeException re) {
                            I2PTunnelIRCClient.access$000().error("Error filtering inbound data", re);
                            var6_9 = null;
                            if (this.local != null) {
                                try {
                                    this.local.close();
                                }
                                catch (IOException e) {}
                            }
                            break block25;
                        }
                    }
                    catch (Throwable var5_14) {
                        var6_10 = null;
                        if (this.local == null) throw var5_14;
                        ** try [egrp 4[TRYBLOCK] [7 : 420->430)] { 
lbl35:
                        // 1 sources

                        this.local.close();
                        throw var5_14;
lbl37:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var5_14;
                    }
                    while ((inmsg = in.readLine()) != null) {
                        if (inmsg.endsWith("\r")) {
                            inmsg = inmsg.substring(0, inmsg.length() - 1);
                        }
                        if (I2PTunnelIRCClient.access$000().shouldLog(10)) {
                            I2PTunnelIRCClient.access$000().debug("in: [" + inmsg + "]");
                        }
                        if ((outmsg = I2PTunnelIRCClient.inboundFilter(inmsg, this.expectedPong)) != null) {
                            if (!inmsg.equals(outmsg)) {
                                if (I2PTunnelIRCClient.access$000().shouldLog(30)) {
                                    I2PTunnelIRCClient.access$000().warn("inbound FILTERED: " + outmsg);
                                    I2PTunnelIRCClient.access$000().warn(" - inbound was: " + inmsg);
                                }
                            } else if (I2PTunnelIRCClient.access$000().shouldLog(20)) {
                                I2PTunnelIRCClient.access$000().info("inbound: " + outmsg);
                            }
                            outmsg = outmsg + "\r\n";
                            output.write(outmsg.getBytes("ISO-8859-1"));
                            output.flush();
                            continue;
                        }
                        if (!I2PTunnelIRCClient.access$000().shouldLog(30)) continue;
                        I2PTunnelIRCClient.access$000().warn("inbound BLOCKED: " + inmsg);
                    }
                }
                var6_8 = null;
                if (this.local != null) {
                    try {}
                    catch (IOException e) {}
                    this.local.close();
                }
            }
            if (I2PTunnelIRCClient.access$000().shouldLog(10) == false) return;
            I2PTunnelIRCClient.access$000().debug("IrcInboundFilter: Done.");
        }
    }
}

