/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;

public class I2PTunnelConnectClient
extends I2PTunnelClientBase
implements Runnable {
    private static final Log _log = new Log(I2PTunnelConnectClient.class);
    private final List<String> _proxyList = new ArrayList<String>();
    private static final byte[] ERR_DESTINATION_UNKNOWN = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. The host (or the outproxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>".getBytes();
    private static final byte[] ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel".getBytes();
    private static final byte[] ERR_BAD_PROTOCOL = "HTTP/1.1 405 Bad Method\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: METHOD NOT ALLOWED</H1>The request uses a bad protocol. The Connect Proxy supports CONNECT requests ONLY. Other methods such as GET are not allowed - Maybe you wanted the HTTP Proxy?.<BR>".getBytes();
    private static final byte[] ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>".getBytes();
    private static final byte[] SUCCESS_RESPONSE = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes();
    private static volatile long __clientId = 0L;
    private static final File _errorDir = new File(I2PAppContext.getGlobalContext().getBaseDir(), "docs");
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private static long __requestId = 0L;

    public I2PTunnelConnectClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTPHandler " + ++__clientId, tunnel);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openConnectClientResult", "error");
            return;
        }
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this._proxyList.add(tok.nextToken().trim());
            }
        }
        this.setName(this.getLocalPort() + " -> ConnectClient [Outproxy list: " + wwwProxy + "]");
        this.startRunning();
    }

    private String getPrefix(long requestId) {
        return "Client[" + this._clientId + "/" + requestId + "]: ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectProxy() {
        List<String> list = this._proxyList;
        synchronized (list) {
            int size = this._proxyList.size();
            if (size <= 0) {
                return null;
            }
            int index = this._context.random().nextInt(size);
            return this._proxyList.get(index);
        }
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "60000");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "60000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected void clientConnectionRun(Socket s) {
        InputStream in = null;
        OutputStream out = null;
        String targetRequest = null;
        boolean usingWWWProxy = false;
        String currentProxy = null;
        long requestId = ++__requestId;
        try {
            out = s.getOutputStream();
            in = s.getInputStream();
            String method = null;
            String host = null;
            String destination = null;
            String restofline = null;
            StringBuilder newRequest = new StringBuilder();
            boolean ahelper = false;
            while (true) {
                String line = DataHelper.readLine(in);
                line = line.trim();
                if (_log.shouldLog(10)) {
                    _log.debug(this.getPrefix(requestId) + "Line=[" + line + "]");
                }
                if (method == null) {
                    int pos = line.indexOf(" ");
                    if (pos == -1) break;
                    method = line.substring(0, pos);
                    String request = line.substring(pos + 1);
                    if ((pos = request.indexOf(":")) == -1) {
                        pos = request.indexOf(" ");
                    }
                    if (pos == -1) {
                        host = request;
                        restofline = "";
                    } else {
                        host = request.substring(0, pos);
                        restofline = request.substring(pos);
                    }
                    if (host.toLowerCase().endsWith(".i2p")) {
                        destination = host;
                    } else if (host.indexOf(".") != -1) {
                        currentProxy = this.selectProxy();
                        if (currentProxy == null) {
                            if (_log.shouldLog(30)) {
                                _log.warn(this.getPrefix(requestId) + "Host wants to be outproxied, but we dont have any!");
                            }
                            I2PTunnelConnectClient.writeErrorMessage(ERR_NO_OUTPROXY, out);
                            s.close();
                            return;
                        }
                        destination = currentProxy;
                        usingWWWProxy = true;
                        newRequest.append("CONNECT ").append(host).append(restofline).append("\r\n\r\n");
                    } else {
                        if (host.toLowerCase().equals("localhost")) {
                            I2PTunnelConnectClient.writeErrorMessage(ERR_LOCALHOST, out);
                            s.close();
                            return;
                        }
                        destination = host;
                    }
                    targetRequest = host;
                    if (!_log.shouldLog(10)) continue;
                    _log.debug(this.getPrefix(requestId) + "METHOD:" + method + ":");
                    _log.debug(this.getPrefix(requestId) + "HOST  :" + host + ":");
                    _log.debug(this.getPrefix(requestId) + "REST  :" + restofline + ":");
                    _log.debug(this.getPrefix(requestId) + "DEST  :" + destination + ":");
                    continue;
                }
                if (line.length() <= 0) break;
                line = null;
            }
            if (destination == null || !"CONNECT".equalsIgnoreCase(method)) {
                I2PTunnelConnectClient.writeErrorMessage(ERR_BAD_PROTOCOL, out);
                s.close();
                return;
            }
            Destination clientDest = I2PTunnel.destFromName(destination);
            if (clientDest == null) {
                String str = usingWWWProxy ? FileUtil.readTextFile(new File(_errorDir, "dnfp-header.ht").getAbsolutePath(), 100, true) : FileUtil.readTextFile(new File(_errorDir, "dnfh-header.ht").getAbsolutePath(), 100, true);
                byte[] header = str != null ? str.getBytes() : ERR_DESTINATION_UNKNOWN;
                I2PTunnelConnectClient.writeErrorMessage(header, out, targetRequest, usingWWWProxy, destination);
                s.close();
                return;
            }
            I2PSocket i2ps = this.createI2PSocket(clientDest, this.getDefaultOptions());
            byte[] data = null;
            byte[] response = null;
            if (usingWWWProxy) {
                data = newRequest.toString().getBytes("ISO-8859-1");
            } else {
                response = SUCCESS_RESPONSE;
            }
            OnTimeout onTimeout = new OnTimeout(s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelRunner runner = new I2PTunnelRunner(s, i2ps, this.sockLock, data, response, this.mySockets, onTimeout);
        }
        catch (SocketException ex) {
            _log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            I2PTunnelConnectClient.handleConnectClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
        catch (IOException ex) {
            _log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            I2PTunnelConnectClient.handleConnectClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
        catch (I2PException ex) {
            _log.info("getPrefix(requestId) + Error trying to connect", ex);
            I2PTunnelConnectClient.handleConnectClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
        catch (OutOfMemoryError oom) {
            IOException ex = new IOException("OOM");
            _log.info("getPrefix(requestId) + Error trying to connect", ex);
            I2PTunnelConnectClient.handleConnectClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
    }

    private static void writeErrorMessage(byte[] errMessage, OutputStream out) throws IOException {
        if (out == null) {
            return;
        }
        out.write(errMessage);
        out.write("\n</body></html>\n".getBytes());
        out.flush();
    }

    private static void writeErrorMessage(byte[] errMessage, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy) throws IOException {
        if (out != null) {
            out.write(errMessage);
            if (targetRequest != null) {
                out.write(targetRequest.getBytes());
                if (usingWWWProxy) {
                    out.write(("<br />WWW proxy: " + wwwProxy).getBytes());
                }
            }
            out.write("</div>".getBytes());
            out.write("\n</body></html>\n".getBytes());
            out.flush();
        }
    }

    private static void handleConnectClientException(Exception ex, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, long requestId) {
        if (out == null) {
            return;
        }
        try {
            String str = usingWWWProxy ? FileUtil.readTextFile(new File(_errorDir, "dnfp-header.ht").getAbsolutePath(), 100, true) : FileUtil.readTextFile(new File(_errorDir, "dnf-header.ht").getAbsolutePath(), 100, true);
            byte[] header = str != null ? str.getBytes() : ERR_DESTINATION_UNKNOWN;
            I2PTunnelConnectClient.writeErrorMessage(header, out, targetRequest, usingWWWProxy, wwwProxy);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private static class OnTimeout
    implements Runnable {
        private Socket _socket;
        private OutputStream _out;
        private String _target;
        private boolean _usingProxy;
        private String _wwwProxy;
        private long _requestId;

        public OnTimeout(Socket s, OutputStream out, String target, boolean usingProxy, String wwwProxy, long id) {
            this._socket = s;
            this._out = out;
            this._target = target;
            this._usingProxy = usingProxy;
            this._wwwProxy = wwwProxy;
            this._requestId = id;
        }

        public void run() {
            if (_log.shouldLog(10)) {
                _log.debug("Timeout occured requesting " + this._target);
            }
            I2PTunnelConnectClient.handleConnectClientException(new RuntimeException("Timeout"), this._out, this._target, this._usingProxy, this._wwwProxy, this._requestId);
            I2PTunnelClientBase.closeSocket(this._socket);
        }
    }
}

