/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.GZIPInputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

class HTTPResponseOutputStream
extends FilterOutputStream {
    private final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private final Log _log;
    protected ByteArray _headerBuffer;
    private boolean _headerWritten;
    private final byte[] _buf1;
    protected boolean _gzip;
    private long _dataWritten;
    private InternalGZIPInputStream _in;
    private static final int CACHE_SIZE = 8192;
    private static final ByteCache _cache = ByteCache.getInstance(8, 8192);
    private static final int MAX_HEADER_SIZE = 65536;
    private static final byte NL = 10;

    public HTTPResponseOutputStream(OutputStream raw) {
        super(raw);
        this._context.statManager().createRateStat("i2ptunnel.httpCompressionRatio", "ratio of compressed size to decompressed size after transfer", "I2PTunnel", new long[]{3600000L});
        this._context.statManager().createRateStat("i2ptunnel.httpCompressed", "compressed size transferred", "I2PTunnel", new long[]{3600000L});
        this._context.statManager().createRateStat("i2ptunnel.httpExpanded", "size transferred after expansion", "I2PTunnel", new long[]{3600000L});
        this._log = this._context.logManager().getLog(this.getClass());
        this._headerBuffer = _cache.acquire();
        this._buf1 = new byte[1];
    }

    public void write(int c) throws IOException {
        this._buf1[0] = (byte)c;
        this.write(this._buf1, 0, 1);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this._headerWritten) {
            this.out.write(buf, off, len);
            this._dataWritten += (long)len;
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.ensureCapacity();
            this._headerBuffer.getData()[this._headerBuffer.getValid()] = buf[off + i];
            this._headerBuffer.setValid(this._headerBuffer.getValid() + 1);
            if (!this.headerReceived()) continue;
            this.writeHeader();
            this._headerWritten = true;
            if (i + 1 < len) {
                this.out.write(buf, off + i + 1, len - i - 1);
                this._dataWritten += (long)(len - i - 1);
            }
            return;
        }
    }

    private void ensureCapacity() throws IOException {
        if (this._headerBuffer.getValid() >= 65536) {
            throw new IOException("Max header size exceeded: 65536");
        }
        if (this._headerBuffer.getValid() + 1 >= this._headerBuffer.getData().length) {
            int newSize = (int)((double)this._headerBuffer.getData().length * 1.5);
            ByteArray newBuf = new ByteArray(new byte[newSize]);
            System.arraycopy(this._headerBuffer.getData(), 0, newBuf.getData(), 0, this._headerBuffer.getValid());
            newBuf.setValid(this._headerBuffer.getValid());
            newBuf.setOffset(0);
            if (this._headerBuffer.getData().length == 8192) {
                _cache.release(this._headerBuffer);
            }
            this._headerBuffer = newBuf;
        }
    }

    private boolean headerReceived() {
        if (this._headerBuffer.getValid() < 3) {
            return false;
        }
        byte first = this._headerBuffer.getData()[this._headerBuffer.getValid() - 3];
        byte second = this._headerBuffer.getData()[this._headerBuffer.getValid() - 2];
        byte third = this._headerBuffer.getData()[this._headerBuffer.getValid() - 1];
        return HTTPResponseOutputStream.isNL(second) && HTTPResponseOutputStream.isNL(third) || HTTPResponseOutputStream.isNL(first) && HTTPResponseOutputStream.isNL(third);
    }

    protected static String filterResponseLine(String line) {
        return line;
    }

    private static boolean isNL(byte b) {
        return b == 10;
    }

    private void writeHeader() throws IOException {
        String responseLine = null;
        boolean connectionSent = false;
        boolean proxyConnectionSent = false;
        int lastEnd = -1;
        for (int i = 0; i < this._headerBuffer.getValid(); ++i) {
            if (!HTTPResponseOutputStream.isNL(this._headerBuffer.getData()[i])) continue;
            if (lastEnd == -1) {
                responseLine = new String(this._headerBuffer.getData(), 0, i + 1);
                responseLine = HTTPResponseOutputStream.filterResponseLine(responseLine);
                responseLine = responseLine.trim() + "\r\n";
                this.out.write(responseLine.getBytes());
            } else {
                for (int j = lastEnd + 1; j < i; ++j) {
                    if (this._headerBuffer.getData()[j] != 58) continue;
                    int keyLen = j - (lastEnd + 1);
                    int valLen = i - (j + 1);
                    if (keyLen <= 0 || valLen < 0) {
                        throw new IOException("Invalid header @ " + j);
                    }
                    String key = new String(this._headerBuffer.getData(), lastEnd + 1, keyLen);
                    String val = null;
                    val = valLen == 0 ? "" : new String(this._headerBuffer.getData(), j + 2, valLen).trim();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Response header [" + key + "] = [" + val + "]");
                    }
                    if ("Connection".equalsIgnoreCase(key)) {
                        this.out.write("Connection: close\r\n".getBytes());
                        connectionSent = true;
                        break;
                    }
                    if ("Proxy-Connection".equalsIgnoreCase(key)) {
                        this.out.write("Proxy-Connection: close\r\n".getBytes());
                        proxyConnectionSent = true;
                        break;
                    }
                    if ("Content-encoding".equalsIgnoreCase(key) && "x-i2p-gzip".equalsIgnoreCase(val)) {
                        this._gzip = true;
                        break;
                    }
                    this.out.write((key.trim() + ": " + val.trim() + "\r\n").getBytes());
                    break;
                }
            }
            lastEnd = i;
        }
        if (!connectionSent) {
            this.out.write("Connection: close\r\n".getBytes());
        }
        if (!proxyConnectionSent) {
            this.out.write("Proxy-Connection: close\r\n".getBytes());
        }
        this.finishHeaders();
        boolean shouldCompress = this.shouldCompress();
        if (this._log.shouldLog(20)) {
            this._log.info("After headers: gzip? " + this._gzip + " compress? " + shouldCompress);
        }
        if (this._headerBuffer.getData().length == 8192) {
            _cache.release(this._headerBuffer);
        } else {
            this._headerBuffer = null;
        }
        if (shouldCompress) {
            this.beginProcessing();
        }
    }

    protected boolean shouldCompress() {
        return this._gzip;
    }

    protected void finishHeaders() throws IOException {
        this.out.write("\r\n".getBytes());
    }

    public void close() throws IOException {
        this.out.close();
    }

    protected void beginProcessing() throws IOException {
        PipedInputStream pi = new PipedInputStream();
        PipedOutputStream po = new PipedOutputStream(pi);
        new I2PAppThread(new Pusher(pi, this.out), "HTTP decompressor").start();
        this.out = po;
    }

    public String toString() {
        return super.toString() + ": " + this._in;
    }

    private static class InternalGZIPInputStream
    extends GZIPInputStream {
        public InternalGZIPInputStream(InputStream in) throws IOException {
            super(in);
        }

        public long getTotalRead() {
            try {
                return this.inf.getTotalIn();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getTotalExpanded() {
            try {
                return this.inf.getTotalOut();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getRemaining() {
            try {
                return this.inf.getRemaining();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public boolean getFinished() {
            try {
                return this.inf.finished();
            }
            catch (Exception e) {
                return true;
            }
        }

        public String toString() {
            return "Read: " + this.getTotalRead() + " expanded: " + this.getTotalExpanded() + " remaining: " + this.getRemaining() + " finished: " + this.getFinished();
        }
    }

    private class Pusher
    implements Runnable {
        private InputStream _inRaw;
        private OutputStream _out;

        public Pusher(InputStream in, OutputStream out) {
            this._inRaw = in;
            this._out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block27: {
                IOException ioe2222;
                HTTPResponseOutputStream.this._in = null;
                long written = 0L;
                ByteArray ba = null;
                try {
                    block26: {
                        HTTPResponseOutputStream.this._in = new InternalGZIPInputStream(this._inRaw);
                        ba = _cache.acquire();
                        byte[] buf = ba.getData();
                        int read = -1;
                        while ((read = HTTPResponseOutputStream.this._in.read(buf)) != -1) {
                            if (HTTPResponseOutputStream.this._log.shouldLog(10)) {
                                HTTPResponseOutputStream.this._log.debug("Read " + read + " and writing it to the browser/streams");
                            }
                            this._out.write(buf, 0, read);
                            this._out.flush();
                            written += (long)read;
                        }
                        if (!HTTPResponseOutputStream.this._log.shouldLog(20)) break block26;
                        HTTPResponseOutputStream.this._log.info("Decompressed: " + written + ", " + HTTPResponseOutputStream.this._in.getTotalRead() + "/" + HTTPResponseOutputStream.this._in.getTotalExpanded());
                    }
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                        HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                    }
                    if (ba != null) {
                        _cache.release(ba);
                    }
                    if (this._out != null) {
                        try {
                            this._out.close();
                        }
                        catch (IOException ioe2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                    HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                }
                if (ba != null) {
                    _cache.release(ba);
                }
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe2222) {}
                }
                break block27;
                {
                    catch (IOException ioe3) {
                        if (HTTPResponseOutputStream.this._log.shouldLog(30)) {
                            HTTPResponseOutputStream.this._log.warn("Error decompressing: " + written + ", " + (HTTPResponseOutputStream.this._in != null ? HTTPResponseOutputStream.this._in.getTotalRead() + "/" + HTTPResponseOutputStream.this._in.getTotalExpanded() : ""), ioe3);
                        }
                        Object var7_9 = null;
                        if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                            HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                        }
                        if (ba != null) {
                            _cache.release(ba);
                        }
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe2222) {}
                        }
                        break block27;
                    }
                    catch (OutOfMemoryError oom) {
                        HTTPResponseOutputStream.this._log.error("OOM in HTTP Decompressor", oom);
                        Object var7_10 = null;
                        if (HTTPResponseOutputStream.this._log.shouldLog(30) && HTTPResponseOutputStream.this._in != null) {
                            HTTPResponseOutputStream.this._log.warn("After decompression, written=" + written + (HTTPResponseOutputStream.this._in != null ? " read=" + HTTPResponseOutputStream.this._in.getTotalRead() + ", expanded=" + HTTPResponseOutputStream.this._in.getTotalExpanded() + ", remaining=" + HTTPResponseOutputStream.this._in.getRemaining() + ", finished=" + HTTPResponseOutputStream.this._in.getFinished() : ""));
                        }
                        if (ba != null) {
                            _cache.release(ba);
                        }
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe2222) {}
                        }
                    }
                }
            }
            double compressed = HTTPResponseOutputStream.this._in != null ? HTTPResponseOutputStream.this._in.getTotalRead() : 0L;
            double expanded = HTTPResponseOutputStream.this._in != null ? HTTPResponseOutputStream.this._in.getTotalExpanded() : 0L;
            if (compressed > 0.0 && expanded > 0.0) {
                double ratio = compressed / expanded;
                HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpCompressionRatio", (int)(100.0 * ratio), 0L);
                HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpCompressed", (long)compressed, 0L);
                HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpExpanded", (long)expanded, 0L);
            }
        }
    }
}

