/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppConfiguration;
import net.i2p.util.FileUtil;
import net.i2p.util.SecureDirectory;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class WebAppStarter {
    static final Map<String, Long> warModTimes = new ConcurrentHashMap<String, Long>();

    static void startWebApp(I2PAppContext ctx, Server server, String appName, String warPath) throws Exception {
        SecureDirectory tmpdir = new SecureDirectory(ctx.getTempDir(), "jetty-work-" + appName + ctx.random().nextInt());
        WebApplicationContext wac = WebAppStarter.addWebApp(ctx, server, appName, warPath, tmpdir);
        wac.start();
    }

    static WebApplicationContext addWebApp(I2PAppContext ctx, Server server, String appName, String warPath, File tmpdir) throws IOException {
        try {
            WebAppStarter.stopWebApp(server, appName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        long newmod = new File(warPath).lastModified();
        if (newmod <= 0L) {
            throw new IOException("Web app " + warPath + " does not exist");
        }
        Long oldmod = warModTimes.get(warPath);
        if (oldmod == null) {
            warModTimes.put(warPath, new Long(newmod));
        } else if (oldmod < newmod) {
            SecureDirectory warTmpDir = new SecureDirectory(ctx.getTempDir(), "war-copy-" + appName + ctx.random().nextInt());
            ((File)warTmpDir).mkdir();
            String tmpPath = new File(warTmpDir, appName + ".war").getAbsolutePath();
            if (!FileUtil.copy(warPath, tmpPath, true)) {
                throw new IOException("Web app failed copy from " + warPath + " to " + tmpPath);
            }
            warPath = tmpPath;
        }
        WebApplicationContext wac = server.addWebApplication("/" + appName, warPath);
        tmpdir.mkdir();
        wac.setTempDirectory(tmpdir);
        RouterConsoleRunner.initialize(wac);
        String[] classNames = server.getWebApplicationConfigurationClassNames();
        String[] newClassNames = new String[classNames.length + 1];
        for (int j = 0; j < classNames.length; ++j) {
            newClassNames[j] = classNames[j];
        }
        newClassNames[classNames.length] = WebAppConfiguration.class.getName();
        wac.setConfigurationClassNames(newClassNames);
        return wac;
    }

    static void stopWebApp(Server server, String appName) {
        HttpContext wac = server.getContext('/' + appName);
        try {
            wac.stop(false);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            server.removeContext(wac);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static boolean isWebAppRunning(String appName) {
        Server server = WebAppStarter.getConsoleServer();
        if (server == null) {
            return false;
        }
        HttpContext wac = server.getContext('/' + appName);
        return wac.isStarted();
    }

    static Server getConsoleServer() {
        Collection c = Server.getHttpServers();
        for (int i = 0; i < c.size(); ++i) {
            Server s = (Server)c.toArray()[i];
            HttpListener[] hl = s.getListeners();
            for (int j = 0; j < hl.length; ++j) {
                if (hl[j].getPort() != 7657) continue;
                return s;
            }
        }
        return null;
    }
}

