/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.router.web.RouterConsoleRunner;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class WebAppConfiguration
implements WebApplicationContext.Configuration {
    private WebApplicationContext _wac;
    private static final String CLASSPATH = ".classpath";

    public void setWebApplicationContext(WebApplicationContext context) {
        this._wac = context;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._wac;
    }

    public void configureClassPath() throws Exception {
        String cp;
        String ctxPath = this._wac.getContextPath();
        if (ctxPath.equals("/")) {
            return;
        }
        String appName = ctxPath.substring(1);
        I2PAppContext i2pContext = I2PAppContext.getGlobalContext();
        File libDir = new File(i2pContext.getBaseDir(), "lib");
        File pluginDir = new File(i2pContext.getConfigDir(), "plugins" + ctxPath);
        File dir = libDir;
        if (ctxPath.equals("/susidns")) {
            cp = "jstl.jar,standard.jar";
        } else if (ctxPath.equals("/i2psnark")) {
            cp = "i2psnark.jar";
        } else if (pluginDir.exists()) {
            File consoleDir = new File(pluginDir, "console");
            Properties props = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            cp = props.getProperty("webapps." + appName + CLASSPATH);
            dir = pluginDir;
        } else {
            Properties props = RouterConsoleRunner.webAppProperties();
            cp = props.getProperty("webapps." + appName + CLASSPATH);
        }
        if (cp == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(cp, " ,");
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken().trim();
            String path = elem.startsWith("$I2P") ? i2pContext.getBaseDir().getAbsolutePath() + elem.substring(4) : (elem.startsWith("$PLUGIN") ? dir.getAbsolutePath() + elem.substring(7) : dir.getAbsolutePath() + '/' + elem);
            System.err.println("Adding " + path + " to classpath for " + appName);
            this._wac.addClassPath(path);
        }
    }

    public void configureDefaults() {
    }

    public void configureWebApp() {
    }
}

