/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NewsFetcher;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class UpdateHandler {
    protected static UpdateRunner _updateRunner;
    protected RouterContext _context;
    protected Log _log;
    protected String _updateFile;
    private static String _status;
    private String _action;
    private String _nonce;
    protected static final String SIGNED_UPDATE_FILE = "i2pupdate.sud";
    static final String PROP_UPDATE_IN_PROGRESS = "net.i2p.router.web.UpdateHandler.updateInProgress";
    protected static final String PROP_LAST_UPDATE_TIME = "router.updateLastDownloaded";

    public UpdateHandler() {
        this(ContextHelper.getContext(null));
    }

    public UpdateHandler(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UpdateHandler.class);
        this._updateFile = new File(ctx.getRouterDir(), SIGNED_UPDATE_FILE).getAbsolutePath();
    }

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(UpdateHandler.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setUpdateAction(String val) {
        this._action = val;
        this.checkUpdateAction();
    }

    public void setUpdateNonce(String nonce) {
        this._nonce = nonce;
        this.checkUpdateAction();
    }

    private void checkUpdateAction() {
        if (this._nonce == null || this._action == null) {
            return;
        }
        if (this._nonce.equals(System.getProperty("net.i2p.router.web.UpdateHandler.nonce")) || this._nonce.equals(System.getProperty("net.i2p.router.web.UpdateHandler.noncePrev"))) {
            if (this._action.contains("Unsigned")) {
                NewsFetcher fetcher = NewsFetcher.getInstance(this._context);
                fetcher.fetchUnsigned();
            } else {
                this.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if ("true".equals(System.getProperty(PROP_UPDATE_IN_PROGRESS))) {
            this._log.error("Update already running");
            return;
        }
        Class<UpdateHandler> clazz = UpdateHandler.class;
        synchronized (UpdateHandler.class) {
            if (_updateRunner == null) {
                _updateRunner = new UpdateRunner();
            }
            if (_updateRunner.isRunning()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.setProperty(PROP_UPDATE_IN_PROGRESS, "true");
            I2PAppThread update = new I2PAppThread(_updateRunner, "SignedUpdate");
            update.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getStatus() {
        return _status;
    }

    public boolean isDone() {
        return false;
    }

    protected void restart() {
        this._context.addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(5));
        this._context.router().shutdownGracefully(5);
    }

    private String selectUpdateURL() {
        String URLs = this._context.getProperty("router.updateURL", ConfigUpdateHandler.DEFAULT_UPDATE_URL);
        StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
        ArrayList<String> URLList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            URLList.add(tok.nextToken().trim());
        }
        int size = URLList.size();
        if (size <= 0) {
            this._log.log(50, "Update source list is empty - cannot download update");
            return null;
        }
        int index = I2PAppContext.getGlobalContext().random().nextInt(size);
        this._log.log(10, "Picked update source " + index + ".");
        return (String)URLList.get(index);
    }

    protected void updateStatus(String s) {
        _status = s;
    }

    protected String _(String s) {
        return Messages.getString(s, this._context);
    }

    protected String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    static {
        _status = "";
    }

    public class UpdateRunner
    implements Runnable,
    EepGet.StatusListener {
        protected boolean _isRunning = false;
        protected boolean done = false;
        protected EepGet _get;
        protected final DecimalFormat _pct = new DecimalFormat("0.0%");

        public UpdateRunner() {
            UpdateHandler.this.updateStatus("<b>" + UpdateHandler.this._("Updating") + "</b>");
        }

        public boolean isRunning() {
            return this._isRunning;
        }

        public boolean isDone() {
            return this.done;
        }

        public void run() {
            this._isRunning = true;
            this.update();
            System.setProperty(UpdateHandler.PROP_UPDATE_IN_PROGRESS, "false");
            this._isRunning = false;
        }

        protected void update() {
            UpdateHandler.this.updateStatus("<b>" + UpdateHandler.this._("Updating") + "</b>");
            String updateURL = UpdateHandler.this.selectUpdateURL();
            if (UpdateHandler.this._log.shouldLog(10)) {
                UpdateHandler.this._log.debug("Selected update URL: " + updateURL);
            }
            boolean shouldProxy = Boolean.valueOf(UpdateHandler.this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
            String proxyHost = UpdateHandler.this._context.getProperty("router.updateProxyHost", "127.0.0.1");
            int proxyPort = UpdateHandler.this._context.getProperty("router.updateProxyPort", 4444);
            try {
                this._get = shouldProxy ? new EepGet((I2PAppContext)UpdateHandler.this._context, proxyHost, proxyPort, 40, UpdateHandler.this._updateFile, updateURL, false) : new EepGet(UpdateHandler.this._context, 1, UpdateHandler.this._updateFile, updateURL, false);
                this._get.addStatusListener(this);
                this._get.fetch();
            }
            catch (Throwable t) {
                UpdateHandler.this._log.error("Error updating", t);
            }
        }

        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            if (UpdateHandler.this._log.shouldLog(10)) {
                UpdateHandler.this._log.debug("Attempt failed on " + url, cause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("<b>").append(UpdateHandler.this._("Updating")).append("</b> ");
            double pct = ((double)alreadyTransferred + (double)currentWrite) / ((double)alreadyTransferred + (double)currentWrite + (double)bytesRemaining);
            DecimalFormat decimalFormat = this._pct;
            synchronized (decimalFormat) {
                buf.append(this._pct.format(pct));
            }
            buf.append(":<br>\n");
            buf.append(UpdateHandler.this._("{0}B transferred", DataHelper.formatSize2((long)currentWrite + alreadyTransferred)));
            UpdateHandler.this.updateStatus(buf.toString());
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            UpdateHandler.this.updateStatus("<b>" + UpdateHandler.this._("Update downloaded") + "</b>");
            TrustedUpdate up = new TrustedUpdate(UpdateHandler.this._context);
            File f = new File(UpdateHandler.this._updateFile);
            File to = new File(UpdateHandler.this._context.getRouterDir(), "i2pupdate.zip");
            String err = up.migrateVerified("0.8.1", f, to);
            f.delete();
            if (err == null) {
                String policy = UpdateHandler.this._context.getProperty("router.updatePolicy");
                this.done = true;
                String lastmod = this._get.getLastModified();
                long modtime = 0L;
                if (lastmod != null) {
                    modtime = NewsFetcher.parse822Date(lastmod);
                }
                if (modtime <= 0L) {
                    modtime = UpdateHandler.this._context.clock().now();
                }
                UpdateHandler.this._context.router().setConfigSetting(UpdateHandler.PROP_LAST_UPDATE_TIME, "" + modtime);
                UpdateHandler.this._context.router().saveConfig();
                if ("install".equals(policy)) {
                    UpdateHandler.this._log.log(50, "Update was VERIFIED, restarting to install it");
                    UpdateHandler.this.updateStatus("<b>" + UpdateHandler.this._("Update verified") + "</b><br>" + UpdateHandler.this._("Restarting"));
                    UpdateHandler.this.restart();
                } else {
                    UpdateHandler.this._log.log(50, "Update was VERIFIED, will be installed at next restart");
                    StringBuilder buf = new StringBuilder(64);
                    buf.append("<b>").append(UpdateHandler.this._("Update downloaded")).append("<br>");
                    if (System.getProperty("wrapper.version") != null) {
                        buf.append(UpdateHandler.this._("Click Restart to install"));
                    } else {
                        buf.append(UpdateHandler.this._("Click Shutdown and restart to install"));
                    }
                    if (up.newVersion() != null) {
                        buf.append(' ').append(UpdateHandler.this._("Version {0}", up.newVersion()));
                    }
                    buf.append("</b>");
                    UpdateHandler.this.updateStatus(buf.toString());
                }
            } else {
                UpdateHandler.this._log.log(50, err + " from " + url);
                UpdateHandler.this.updateStatus("<b>" + err + ' ' + UpdateHandler.this._("from {0}", url) + " </b>");
            }
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
            UpdateHandler.this._log.log(50, "Update from " + url + " did not download completely (" + bytesRemaining + " remaining after " + currentAttempt + " tries)");
            UpdateHandler.this.updateStatus("<b>" + UpdateHandler.this._("Transfer failed") + "</b>");
        }

        public void headerReceived(String url, int attemptNum, String key, String val) {
        }

        public void attempting(String url) {
        }
    }
}

