/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.web.Messages;
import net.i2p.stat.RateStat;
import net.i2p.util.ObjectCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelRenderer {
    private RouterContext _context;

    public TunnelRenderer(RouterContext ctx) {
        this._context = ctx;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        out.write("<div class=\"wideload\"><h2><a name=\"exploratory\" ></a>" + this._("Exploratory tunnels") + " (<a href=\"/configtunnels.jsp#exploratory\">" + this._("configure") + "</a>)</h2>\n");
        this.renderPool(out, this._context.tunnelManager().getInboundExploratoryPool(), this._context.tunnelManager().getOutboundExploratoryPool());
        ArrayList<Hash> destinations = null;
        Map<Hash, TunnelPool> clientInboundPools = this._context.tunnelManager().getInboundClientPools();
        Map<Hash, TunnelPool> clientOutboundPools = this._context.tunnelManager().getOutboundClientPools();
        destinations = new ArrayList<Hash>(clientInboundPools.keySet());
        for (int i = 0; i < destinations.size(); ++i) {
            String name;
            Hash client = (Hash)destinations.get(i);
            TunnelPool in = null;
            TunnelPool outPool = null;
            in = clientInboundPools.get(client);
            outPool = clientOutboundPools.get(client);
            String string = name = in != null ? in.getSettings().getDestinationNickname() : null;
            if (name == null && outPool != null) {
                name = outPool.getSettings().getDestinationNickname();
            }
            if (name == null) {
                name = client.toBase64().substring(0, 4);
            }
            out.write("<h2><a name=\"" + client.toBase64().substring(0, 4) + "\" ></a>" + this._("Client tunnels for") + ' ' + this._(name));
            if (this._context.clientManager().isLocal(client)) {
                out.write(" (<a href=\"/configtunnels.jsp#" + client.toBase64().substring(0, 4) + "\">" + this._("configure") + "</a>)</h2>\n");
            } else {
                out.write(" (" + this._("dead") + ")</h2>\n");
            }
            this.renderPool(out, in, outPool);
        }
        List<HopConfig> participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        Collections.sort(participating, new TunnelComparator());
        out.write("<h2><a name=\"participating\"></a>" + this._("Participating tunnels") + "</h2><table>\n");
        out.write("<tr><th>" + this._("Receive on") + "</th><th>" + this._("From") + "</th><th>" + this._("Send on") + "</th><th>" + this._("To") + "</th><th>" + this._("Expiration") + "</th>" + "<th>" + this._("Usage") + "</th><th>" + this._("Rate") + "</th><th>" + this._("Role") + "</th></tr>\n");
        long processed = 0L;
        RateStat rs = this._context.statManager().getRate("tunnel.participatingMessageCount");
        if (rs != null) {
            processed = (long)rs.getRate(600000L).getLifetimeTotalValue();
        }
        int inactive = 0;
        for (int i = 0; i < participating.size(); ++i) {
            HopConfig cfg = participating.get(i);
            if (cfg.getProcessedMessagesCount() <= 0L) {
                ++inactive;
                continue;
            }
            out.write("<tr>");
            if (cfg.getReceiveTunnel() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + cfg.getReceiveTunnel().getTunnelId() + "</td>");
            } else {
                out.write("<td class=\"cells\" align=\"center\">n/a</td>");
            }
            if (cfg.getReceiveFrom() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + this.netDbLink(cfg.getReceiveFrom()) + "</td>");
            } else {
                out.write("<td class=\"cells\">&nbsp;</td>");
            }
            if (cfg.getSendTunnel() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + cfg.getSendTunnel().getTunnelId() + "</td>");
            } else {
                out.write("<td class=\"cells\">&nbsp;</td>");
            }
            if (cfg.getSendTo() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + this.netDbLink(cfg.getSendTo()) + "</td>");
            } else {
                out.write("<td class=\"cells\">&nbsp;</td>");
            }
            long timeLeft = cfg.getExpiration() - this._context.clock().now();
            if (timeLeft > 0L) {
                out.write("<td class=\"cells\" align=\"center\">" + DataHelper.formatDuration(timeLeft) + "</td>");
            } else {
                out.write("<td class=\"cells\" align=\"center\">(" + this._("grace period") + ")</td>");
            }
            out.write("<td class=\"cells\" align=\"center\">" + cfg.getProcessedMessagesCount() + " KB</td>");
            int lifetime = (int)((this._context.clock().now() - cfg.getCreation()) / 1000L);
            if (lifetime <= 0) {
                lifetime = 1;
            }
            if (lifetime > 600) {
                lifetime = 600;
            }
            int bps = 1024 * (int)cfg.getProcessedMessagesCount() / lifetime;
            out.write("<td class=\"cells\" align=\"center\">" + bps + " Bps</td>");
            if (cfg.getSendTo() == null) {
                out.write("<td class=\"cells\" align=\"center\">" + this._("Outbound Endpoint") + "</td>");
            } else if (cfg.getReceiveFrom() == null) {
                out.write("<td class=\"cells\" align=\"center\">" + this._("Inbound Gateway") + "</td>");
            } else {
                out.write("<td class=\"cells\" align=\"center\">" + this._("Participant") + "</td>");
            }
            out.write("</tr>\n");
            processed += cfg.getProcessedMessagesCount();
        }
        out.write("</table>\n");
        out.write("<div class=\"statusnotes\"><b>" + this._("Inactive participating tunnels") + ": " + inactive + "</b></div>\n");
        out.write("<div class=\"statusnotes\"><b>" + this._("Lifetime bandwidth usage") + ": " + DataHelper.formatSize2(processed * 1024L) + "B</b></div>\n");
        this.renderPeers(out);
    }

    private void renderPool(Writer out, TunnelPool in, TunnelPool outPool) throws IOException {
        List pending;
        TunnelInfo info;
        int i;
        List<TunnelInfo> tunnels = null;
        tunnels = in == null ? new ArrayList<TunnelInfo>() : in.listTunnels();
        if (outPool != null) {
            tunnels.addAll(outPool.listTunnels());
        }
        long processedIn = in != null ? in.getLifetimeProcessed() : 0L;
        long processedOut = outPool != null ? outPool.getLifetimeProcessed() : 0L;
        int live = 0;
        int maxLength = 1;
        for (i = 0; i < tunnels.size(); ++i) {
            info = tunnels.get(i);
            if (info.getLength() <= maxLength) continue;
            maxLength = info.getLength();
        }
        out.write("<table><tr><th>" + this._("In/Out") + "</th><th>" + this._("Expiry") + "</th><th>" + this._("Usage") + "</th><th>" + this._("Gateway") + "</th>");
        if (maxLength > 3) {
            out.write("<th align=\"center\" colspan=\"" + (maxLength - 2));
            out.write("\">" + this._("Participants") + "</th>");
        } else if (maxLength == 3) {
            out.write("<th>" + this._("Participant") + "</th>");
        }
        if (maxLength > 1) {
            out.write("<th>" + this._("Endpoint") + "</th>");
        }
        out.write("</tr>\n");
        for (i = 0; i < tunnels.size(); ++i) {
            info = tunnels.get(i);
            long timeLeft = info.getExpiration() - this._context.clock().now();
            if (timeLeft <= 0L) continue;
            ++live;
            if (info.isInbound()) {
                out.write("<tr> <td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"Inbound\"></td>");
            } else {
                out.write("<tr> <td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"Outbound\"></td>");
            }
            out.write(" <td class=\"cells\" align=\"center\">" + DataHelper.formatDuration(timeLeft) + "</td>\n");
            out.write(" <td class=\"cells\" align=\"center\">" + info.getProcessedMessagesCount() + " KB</td>\n");
            for (int j = 0; j < info.getLength(); ++j) {
                TunnelId id;
                Hash peer = info.getPeer(j);
                TunnelId tunnelId = id = info.isInbound() ? info.getReceiveTunnelId(j) : info.getSendTunnelId(j);
                if (this._context.routerHash().equals(peer)) {
                    out.write(" <td class=\"cells\" align=\"center\">" + (id == null ? "" : "" + id) + "</td>");
                } else {
                    String cap = this.getCapacity(peer);
                    out.write(" <td class=\"cells\" align=\"center\">" + this.netDbLink(peer) + (id == null ? "" : " " + id) + cap + "</td>");
                }
                if (info.getLength() >= maxLength || info.getLength() != 1 && j != info.getLength() - 2) continue;
                for (int k = info.getLength(); k < maxLength; ++k) {
                    out.write(" <td class=\"cells\" align=\"center\">&nbsp;</td>");
                }
            }
            out.write("</tr>\n");
            if (info.isInbound()) {
                processedIn += info.getProcessedMessagesCount();
                continue;
            }
            processedOut += info.getProcessedMessagesCount();
        }
        out.write("</table>\n");
        if (in != null && !(pending = in.listPending()).isEmpty()) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._("Build in progress") + ": " + pending.size() + " " + this._("inbound") + "</b></center></div>\n");
            live += pending.size();
        }
        if (outPool != null && !(pending = outPool.listPending()).isEmpty()) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._("Build in progress") + ": " + pending.size() + " " + this._("outbound") + "</b></center></div>\n");
            live += pending.size();
        }
        if (live <= 0) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._("No tunnels; waiting for the grace period to end.") + "</center></b></div>\n");
        }
        out.write("<div class=\"statusnotes\"><center><b>" + this._("Lifetime bandwidth usage") + ": " + DataHelper.formatSize2(processedIn * 1024L) + "B " + this._("in") + ", " + DataHelper.formatSize2(processedOut * 1024L) + "B " + this._("out") + "</b></center></div>");
    }

    private void renderPeers(Writer out) throws IOException {
        ObjectCounter<Hash> lc = new ObjectCounter<Hash>();
        int tunnelCount = this.countTunnelsPerPeer(lc);
        ObjectCounter<Hash> pc = new ObjectCounter<Hash>();
        int partCount = this.countParticipatingPerPeer(pc);
        HashSet<Hash> peers = new HashSet<Hash>(lc.objects());
        peers.addAll(pc.objects());
        ArrayList<Hash> peerList = new ArrayList<Hash>(peers);
        Collections.sort(peerList, new CountryComparator(this._context.commSystem()));
        out.write("<h2><a name=\"peers\"></a>" + this._("Tunnel Counts By Peer") + "</h2>\n");
        out.write("<table><tr><th>" + this._("Peer") + "</th><th>" + this._("Our Tunnels") + "</th><th>" + this._("% of total") + "</th><th>" + this._("Participating Tunnels") + "</th><th>" + this._("% of total") + "</th></tr>\n");
        for (Hash h : peerList) {
            out.write("<tr> <td class=\"cells\" align=\"center\">");
            out.write(this.netDbLink(h));
            out.write(" <td class=\"cells\" align=\"center\">" + lc.count(h));
            out.write(" <td class=\"cells\" align=\"center\">");
            if (tunnelCount > 0) {
                out.write("" + lc.count(h) * 100 / tunnelCount);
            } else {
                out.write(48);
            }
            out.write(" <td class=\"cells\" align=\"center\">" + pc.count(h));
            out.write(" <td class=\"cells\" align=\"center\">");
            if (partCount > 0) {
                out.write("" + pc.count(h) * 100 / partCount);
            } else {
                out.write(48);
            }
            out.write(10);
        }
        out.write("<tr class=\"tablefooter\"> <td align=\"center\"><b>" + this._("Totals") + "</b> <td align=\"center\"><b>" + tunnelCount);
        out.write("</b> <td>&nbsp;</td> <td align=\"center\"><b>" + partCount);
        out.write("</b> <td>&nbsp;</td></tr></table></div>\n");
    }

    private int countTunnelsPerPeer(ObjectCounter<Hash> lc) {
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>();
        this._context.tunnelManager().listPools(pools);
        int tunnelCount = 0;
        for (TunnelPool tp : pools) {
            for (TunnelInfo info : tp.listTunnels()) {
                if (info.getLength() <= 1) continue;
                ++tunnelCount;
                for (int j = 0; j < info.getLength(); ++j) {
                    Hash peer = info.getPeer(j);
                    if (this._context.routerHash().equals(peer)) continue;
                    lc.increment(peer);
                }
            }
        }
        return tunnelCount;
    }

    private int countParticipatingPerPeer(ObjectCounter<Hash> pc) {
        List<HopConfig> participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        for (HopConfig cfg : participating) {
            Hash to;
            Hash from = cfg.getReceiveFrom();
            if (from != null) {
                pc.increment(from);
            }
            if ((to = cfg.getSendTo()) == null) continue;
            pc.increment(to);
        }
        return participating.size();
    }

    private String getCapacity(Hash peer) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (info != null) {
            String caps = info.getCapabilities();
            for (char c = 'K'; c <= 'O'; c = (char)((char)(c + 1))) {
                if (caps.indexOf(c) < 0) continue;
                return " " + c;
            }
        }
        return "";
    }

    private String netDbLink(Hash peer) {
        return this._context.commSystem().renderPeerHTML(peer);
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountryComparator
    implements Comparator<Hash> {
        private CommSystemFacade comm;

        public CountryComparator(CommSystemFacade comm) {
            this.comm = comm;
        }

        @Override
        public int compare(Hash l, Hash r) {
            String lc = this.comm.getCountry(l);
            String rc = this.comm.getCountry(r);
            lc = lc == null ? "zzzz" : lc;
            rc = rc == null ? "zzzz" : rc;
            return lc.compareTo(rc);
        }
    }

    private static class HashComparator
    implements Comparator {
        private HashComparator() {
        }

        public int compare(Object l, Object r) {
            return ((Hash)l).toBase64().compareTo(((Hash)r).toBase64());
        }
    }

    private static class TunnelComparator
    implements Comparator {
        private TunnelComparator() {
        }

        public int compare(Object l, Object r) {
            return (int)(((HopConfig)r).getProcessedMessagesCount() - ((HopConfig)l).getProcessedMessagesCount());
        }
    }
}

